

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListToInstallPackagesForArchiveSolution.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetClientListToInstallPackagesForArchiveSolution')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientListToInstallPackagesForArchiveSolution <<<'
	drop procedure AppGetClientListToInstallPackagesForArchiveSolution
END
IF EXISTS (select * from GxQscripts where name='AppGetClientListToInstallPackagesForArchiveSolution')
	delete from GxQscripts where name = 'AppGetClientListToInstallPackagesForArchiveSolution'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListToInstallPackagesForArchiveSolution')
	delete from GXDBVersions where aliasname = 'AppGetClientListToInstallPackagesForArchiveSolution'
GO
print '... Creating Procedure: AppGetClientListToInstallPackagesForArchiveSolution'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetClientListToInstallPackagesForArchiveSolution
  @i_xml XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId INT = 0
DECLARE @appType INT = 0
DECLARE @appGroupId INT = 0
DECLARE @packageId INT
DECLARE @apptypes TABLE(apptype INT)
DECLARE @clusterType INT = 0
DECLARE @osInfo TABLE(osType NVARCHAR(256), basePackageId INT)
DECLARE @osType INT = 0 -- 0: All, 1: Windows, 2: Unix, 4 : NAS
DECLARE @groupName NVARCHAR(MAX)
IF OBJECT_ID('tempdb.dbo.#outputTable') IS NOT NULL
		DROP TABLE #outputTable
CREATE TABLE #outputTable (clientId INT, clientName NVARCHAR(MAX), clientDisplayName NVARCHAR(MAX), clientType INT NULL)
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS users
		FROM    @i_xml.nodes('//processinginstructioninfo/user') R ( ref )),0)
	SET @clusterType = (SELECT  ref.value('@clusterType', 'int') AS clusterType
		FROM    @i_xml.nodes('//extendedFilter') R ( ref ))
	SET @appType = (SELECT  ref.value('@appTypeId', 'int') AS AppType
		FROM    @i_xml.nodes('//filterOptions/packageInstallFilter/appType') R ( ref ))
	SET @appGroupId = (SELECT  ref.value('@appGroupId', 'int') AS AppGroup
		FROM    @i_xml.nodes('//filterOptions/packageInstallFilter/appGroup') R ( ref ))
	SET @osType = ISNULL((SELECT  ref.value('@osType', 'int') AS osType
		FROM    @i_xml.nodes('//filterOptions/packageInstallFilter') R ( ref )),0)
	SET @packageId = (SELECT  ref.value('@packageId', 'int') AS package
		FROM    @i_xml.nodes('//filterOptions/packageInstallFilter/packageInfo') R ( ref ))
	IF OBJECT_ID('tempdb.dbo.#sec_getClientList') IS NOT NULL
		DROP TABLE #sec_getClientList
	CREATE TABLE #sec_getClientList (clientID INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
	EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#sec_getClientList'
	IF @appType = 64
	BEGIN
		INSERT INTO #outputTable (clientId, clientName, clientDisplayName)
			SELECT DISTINCT
				Clients.ClientId,
				Clients.ClientName,
				Clients.displayName
			FROM
			(
				SELECT
					Client.id ClientId,
					Client.name ClientName,
					Client.displayName displayName
				FROM #sec_getClientList CList
					INNER JOIN APP_Client Client
						ON Client.id = CList.clientID
					INNER JOIN APP_Application innerApp
						ON Client.id = innerApp.clientId
					INNER JOIN APP_InstanceProp instanceProp
						ON innerApp.instance = instanceProp.componentNameId
						AND instanceProp.attrName = 'Distributed Cluster Type'
						AND instanceProp.attrVal = @clusterType
						AND instanceProp.modified = 0
					INNER JOIN APP_ClientProp CP		-- Get only those clients that have Indexing V2 property set.
						ON Client.id = CP.componentNameId
						AND CP.attrName = 'IndexingV2'
						AND CP.attrVal = '1'
						AND CP.modified = 0
						AND innerApp.appTypeId = @appType
			)Clients
			OUTER APPLY
			(
				(
					SELECT TOP 1 App.id as id FROM APP_Application App
					INNER JOIN APP_BackupSetProp BS
								ON App.clientId = Clients.ClientId
								AND App.appTypeId = @appType
								AND BS.componentNameId = App.backupSet
								AND BS.attrName = N'Is Archiving Enabled'
								AND BS.attrVal = N'1'
								AND BS.modified = 0
								AND App.subclientStatus & 8 = 8
				)
			)FSDefaultSubclient
			WHERE   FSDefaultSubclient.id IS NULL
	END
	IF @osType <> 4
	BEGIN
		INSERT INTO @osInfo
SELECT N'Windows', 1 WHERE @osType <> 2
		UNION
SELECT N'Unix', 1002 WHERE @osType <> 1
		IF @appType IS NOT NULL
		BEGIN
			INSERT INTO @apptypes
			SELECT @appType
		END
		ELSE IF @packageId IS NOT NULL
		BEGIN
			INSERT INTO @apptypes
			SELECT DISTINCT apptype FROM simPackageMap WHERE simPackageId = @packageId
		END
		ELSE IF @appGroupId IS NOT NULL
		BEGIN
			SELECT @groupName = groupName FROM App_AppTypeGroup WHERE groupName LIKE '%FileSystem%' AND NOT groupName LIKE '%OES%' AND appTypeGroupId = @appGroupId
			IF @groupName IS NOT NULL -- Special Handle for FS case
			BEGIN
				INSERT INTO @apptypes
				SELECT DISTINCT apptype FROM simPackageMap WHERE simPackageId IN
				(
SELECT 1101 WHERE @osType <> 1
					UNION
SELECT 702 WHERE  @osType <> 2
				)
			END
			ELSE
			BEGIN
				INSERT INTO @apptypes
				SELECT AppTypeID FROM App_AppTypeGroupAssoc WHERE appGroupId = @appGroupId
			END
		END
		;WITH PackageMap AS
		(
			SELECT DISTINCT PM.simPackageId packageId, PM.apptype apptype, OS.*
				FROM simPackageMap PM
			INNER JOIN simPackage P
				ON P.id = PM.simPackageId
				AND P.InstallableFromGUI <> 0
			INNER JOIN simOperatingSystem OS
				ON PM.simOSid = OS.id
			INNER JOIN @apptypes AppType
				ON AppType.apptype = PM.apptype
WHERE PM.simPackageId NOT IN (1, 1002, 1003)
				AND ((OS.type IN (SELECT osType FROM @osInfo)) OR OS.id = 0)
				AND ((@osType = 1 AND PM.simPackageId < 1001) OR (@osType = 2 AND PM.simPackageId > 1001) OR (@osType NOT IN (1,2)))
		)
		INSERT INTO #outputTable (clientId, clientName, clientDisplayName)
			SELECT DISTINCT
				Clients.ClientId,
				Clients.ClientName,
				Clients.displayName
			FROM (
				SELECT
					Client.id ClientId,
					Client.name ClientName,
					Client.displayName displayName,
					IP.simPackageID simPackageID,
					PM.apptype appType
				FROM #sec_getClientList CList
					INNER JOIN APP_Client Client
						ON Client.id = CList.clientID
					INNER JOIN simInstalledPackages BASE
						ON Client.id = BASE.ClientId
							AND BASE.simPackageID IN (SELECT basePackageId FROM @osInfo)
					INNER JOIN simOperatingSystem OS
						ON OS.id = Client.simOperatingSystemId
					INNER JOIN PackageMap PM
						ON (PM.id = OS.id
							OR( OS.Type = PM.Type
								AND OS.SubType = PM.SubType
								AND PM.Version IN ('new', 'any')
								AND PM.PlatformType IN ('Any', OS.PlatformType))
							OR PM.id = 0)
					INNER JOIN APP_ClientProp CP		-- Get only those clients that have Indexing V2 property set.
						ON Client.id = CP.componentNameId
						AND CP.attrName = 'IndexingV2'
						AND CP.attrVal = '1'
						AND CP.modified = 0
					LEFT JOIN simInstalledPackages IP
						ON Client.id = IP.ClientId
						AND PM.packageId = IP.simPackageID
			)Clients
			OUTER APPLY
			(
				-- This check is applicable only for FS Package
				SELECT CASE
					WHEN Clients.simPackageID IS NULL THEN NULL
WHEN Clients.simPackageID IN (702, 1101) THEN
					(SELECT
						2
					FROM APP_IDAName Ida
						WHERE Clients.appType = Ida.appTypeId
							AND Ida.clientId = Clients.ClientId
							AND status & 2 = 0) -- Only for deconfigured FS Agent
					ELSE 1 END FSConfigured
			)AgentStatus
			OUTER APPLY
			(
				SELECT CASE WHEN AgentStatus.FSConfigured IS NULL THEN NULL
				WHEN AgentStatus.FSConfigured = 2  THEN
				(
					SELECT TOP 1 App.id FROM APP_Application App
						INNER JOIN APP_BackupSetProp BS
							ON App.clientId = Clients.ClientId
							AND App.appTypeId = Clients.appType
							AND BS.componentNameId = App.backupSet
							AND BS.attrName = N'Is Archiving Enabled'
							AND BS.attrVal = N'1'
							AND BS.modified = 0
							AND App.subclientStatus & 8 = 8
				)
				ELSE 0 END id
			)FSDefaultSubclient
			WHERE simPackageID IS NULL
				OR FSConfigured IS NULL
				OR FSDefaultSubclient.id IS NULL
	END
	IF @osType = 4
	BEGIN
		INSERT INTO #outputTable (clientId, clientName, clientDisplayName, clientType)
			SELECT DISTINCT -- NAS client handling.
				Clients.ClientId,
				Clients.ClientName,
				Clients.displayName,
				Clients.clientType
			FROM
			(
				SELECT
					Client.id ClientId,
					Client.name ClientName,
					Client.displayName displayName,
					CASE
    					WHEN Client.simOperatingSystemId = 19 THEN 18 --NON_NDMP_CLIENT
    					ELSE 2  --NAS
					END AS clientType
				FROM #sec_getClientList CList
					INNER JOIN APP_Client Client
						ON Client.id = CList.clientID
					INNER JOIN SimOperatingSystem OS
						ON Client.simOperatingSystemId = OS.id
						AND OS.subType = 'NAS'
					INNER JOIN APP_ClientProp CP		-- Get only those clients that have Indexing V2 property set.
						ON Client.id = CP.componentNameId
						AND CP.attrName = 'IndexingV2'
						AND CP.attrVal = '1'
						AND CP.modified = 0
					INNER JOIN APP_Application App
						ON Client.id = App.clientId
						AND App.appTypeId = @appType
			)Clients
			OUTER APPLY
			(
				(
					SELECT TOP 1 App.id as id FROM APP_Application App
					INNER JOIN APP_BackupSetProp BS
								ON App.clientId = Clients.ClientId
								AND App.appTypeId = @appType
								AND BS.componentNameId = App.backupSet
								AND BS.attrName = N'Is Archiving Enabled'
								AND BS.attrVal = N'1'
								AND BS.modified = 0
								AND App.subclientStatus & 8 = 8
				)
			)FSDefaultSubclient
			OUTER APPLY
			(
				SELECT CASE WHEN FSDefaultSubclient.id IS NULL THEN NULL
				WHEN FSDefaultSubclient.id > 0 THEN
				(SELECT
						2
					FROM APP_IDAName Ida
					INNER JOIN APP_Application App ON Ida.appTypeId = App.appTypeId
						WHERE App.id = FSDefaultSubclient.id
							AND Ida.clientId = Clients.ClientId
							AND status & 2 = 0) -- Only for deconfigured FS Agent
				ELSE 1 END FSConfigured
			)AgentStatus
			WHERE   (FSConfigured IS NULL
					OR FSDefaultSubclient.id IS NULL)
	END
	SELECT @i_xml = (
		SELECT DISTINCT
			[client/clientEntity/@clientId] = clientId,
			[client/clientEntity/@clientName] = clientName,
			[client/clientEntity/@displayName] = clientDisplayName,
			[client/clientEntity/@_type_] = 3,
			[pseudoClientInfo/@clientType] = clientType
		FROM #outputTable
		FOR XML PATH('clientProperties'), TYPE, ROOT('App_GetClientPropertiesResponse')
	)
	IF @i_xml IS NULL
		SET @i_xml = '<App_GetClientPropertiesResponse/>'
	IF object_id('tempdb.dbo.#sec_getClientList') IS NOT NULL
		DROP TABLE #sec_getClientList
	IF object_id('tempdb.dbo.#outputTable') IS NOT NULL
		DROP TABLE #outputTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientListToInstallPackagesForArchiveSolution')
	delete from GxQscripts where name = 'AppGetClientListToInstallPackagesForArchiveSolution'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListToInstallPackagesForArchiveSolution')
	delete from GXDBVersions where aliasname = 'AppGetClientListToInstallPackagesForArchiveSolution'
GO

insert into GXDBVersions values(2, 'AppGetClientListToInstallPackagesForArchiveSolution',  '00000000000000000000', 'AppGetClientListToInstallPackagesForArchiveSolution', '00000000000000000000')
GO

