

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListToInstallPackages.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientListToInstallPackages.sp,v $ $Id: AppGetClientListToInstallPackages.sp,v 1.1.2.8 2020/10/04 00:33:43 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientListToInstallPackages')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientListToInstallPackages <<<'
	drop procedure AppGetClientListToInstallPackages
END
IF EXISTS (select * from GxQscripts where name='AppGetClientListToInstallPackages')
	delete from GxQscripts where name = 'AppGetClientListToInstallPackages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListToInstallPackages')
	delete from GXDBVersions where aliasname = 'AppGetClientListToInstallPackages'
GO
print '... Creating Procedure: AppGetClientListToInstallPackages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientListToInstallPackages
  @i_xml XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isArchiverClient INT
SET @isArchiverClient = ISNULL((SELECT  ref.value('@isArchiverClient', 'INT') AS isArchiverClient
		FROM    @i_xml.nodes('//filterOptions/packageInstallFilter') R ( ref )),0)
IF @isArchiverClient = 1
BEGIN
	EXEC AppGetClientListToInstallPackagesForArchiveSolution @i_xml OUTPUT
END
ELSE
BEGIN
	DECLARE @userId INT = 0
	DECLARE @appType INT = 0
	DECLARE @appGroupId INT = 0
	DECLARE @packageId INT
	DECLARE @apptypes TABLE(apptype INT)
	DECLARE @osInfo TABLE(osType NVARCHAR(256), basePackageId INT)
	DECLARE @osType INT = 0 -- 0: All, 1: Windows, 2: Unix
	DECLARE @groupName NVARCHAR(MAX)
		SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS users
			FROM    @i_xml.nodes('//processinginstructioninfo/user') R ( ref )),0)
		SET @appType = (SELECT  ref.value('@appTypeId', 'int') AS AppType
			FROM    @i_xml.nodes('//filterOptions/packageInstallFilter/appType') R ( ref ))
		SET @appGroupId = (SELECT  ref.value('@appGroupId', 'int') AS AppGroup
			FROM    @i_xml.nodes('//filterOptions/packageInstallFilter/appGroup') R ( ref ))
		SET @osType = ISNULL((SELECT  ref.value('@osType', 'int') AS osType
			FROM    @i_xml.nodes('//filterOptions/packageInstallFilter') R ( ref )),0)
		SET @packageId = (SELECT  ref.value('@packageId', 'int') AS package
			FROM    @i_xml.nodes('//filterOptions/packageInstallFilter/packageInfo') R ( ref ))
		DECLARE @epicClientFilter int = 0
		SET @epicClientFilter = ISNULL((SELECT  ref.value('@epicClientFilter', 'int') AS clientType
	                    FROM    @i_xml.nodes('//filterOptions') R ( ref )), 0)
		IF OBJECT_ID('tempdb.dbo.#sec_getClientList') IS NOT NULL
			DROP TABLE #sec_getClientList
		CREATE TABLE #sec_getClientList (clientID INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
		EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#sec_getClientList'
		IF @epicClientFilter=1
		BEGIN
			DELETE C
			FROM #sec_getClientList C
			LEFT JOIN APP_ClientProp cp on C.clientId = cp.componentNameId AND CP.attrName = 'Client App Type' and cp.attrVal = '11' AND cp.modified = 0
			WHERE cp.componentNameId is not null
		END
		INSERT INTO @osInfo
SELECT N'Windows', 1 WHERE @osType <> 2
		UNION
SELECT N'Unix', 1002 WHERE @osType <> 1
		IF @appType IS NOT NULL
		BEGIN
			INSERT INTO @apptypes
			SELECT @appType
		END
		ELSE IF @packageId IS NOT NULL
		BEGIN
			INSERT INTO @apptypes
			SELECT DISTINCT apptype FROM simPackageMap WHERE simPackageId = @packageId
		END
		ELSE IF @appGroupId IS NOT NULL
		BEGIN
			SELECT @groupName = groupName FROM App_AppTypeGroup WHERE groupName LIKE '%FileSystem%' AND NOT groupName LIKE '%OES%' AND appTypeGroupId = @appGroupId
			IF @groupName IS NOT NULL -- Special Handle for FS case
			BEGIN
				INSERT INTO @apptypes
				SELECT DISTINCT apptype FROM simPackageMap WHERE simPackageId IN
				(
SELECT 1101 WHERE @osType <> 1
					UNION
SELECT 702 WHERE  @osType <> 2
				)
			END
			ELSE
			BEGIN
				INSERT INTO @apptypes
				SELECT AppTypeID FROM App_AppTypeGroupAssoc WHERE appGroupId = @appGroupId
			END
		END
		IF(@epicClientFilter = 1)
DELETE from @apptypes WHERE apptype not in (21,29)
		;WITH PackageMap AS
		(
			SELECT DISTINCT PM.simPackageId packageId, PM.apptype apptype, OS.*
				FROM simPackageMap PM
			INNER JOIN simPackage P
				ON P.id = PM.simPackageId
				AND P.InstallableFromGUI <> 0
			INNER JOIN simOperatingSystem OS
				ON PM.simOSid = OS.id
			INNER JOIN @apptypes AppType
				ON AppType.apptype = PM.apptype
WHERE PM.simPackageId NOT IN (1, 1002, 1003)
				AND ((OS.type IN (SELECT osType FROM @osInfo)) OR OS.id = 0)
				AND ((@osType = 1 AND PM.simPackageId < 1001) OR (@osType = 2 AND PM.simPackageId > 1001) OR (@osType NOT IN (1,2)))
		)
		SELECT @i_xml = (
			SELECT DISTINCT
				[client/clientEntity/@clientId] = Clients.ClientId,
				[client/clientEntity/@clientName] = Clients.ClientName,
				[client/clientEntity/@displayName] = Clients.displayName,
				[client/clientEntity/@_type_] = 3
			FROM (
				SELECT
					Client.id ClientId,
					Client.name ClientName,
					Client.displayName displayName,
					IP.simPackageID simPackageID,
					PM.apptype appType
				FROM #sec_getClientList CList
					INNER JOIN APP_Client Client
						ON Client.id = CList.clientID
					INNER JOIN simInstalledPackages BASE
						ON Client.id = BASE.ClientId
							AND BASE.simPackageID IN (SELECT basePackageId FROM @osInfo)
					INNER JOIN simOperatingSystem OS
						ON OS.id = Client.simOperatingSystemId
					INNER JOIN PackageMap PM
						ON (PM.id = OS.id
							OR( OS.Type = PM.Type
								AND OS.SubType = PM.SubType
								AND PM.Version IN ('new', 'any')
								AND PM.PlatformType IN ('Any', OS.PlatformType))
							OR PM.id = 0)
					LEFT JOIN simInstalledPackages IP
						ON Client.id = IP.ClientId
						AND PM.packageId = IP.simPackageID
			)Clients
			OUTER APPLY
			(
				-- This check is applicable only for FS Package
				SELECT CASE
					WHEN Clients.simPackageID IS NULL THEN NULL
WHEN Clients.simPackageID IN (702, 1101) THEN
					(SELECT
						2
					FROM APP_IDAName Ida
						WHERE Clients.appType = Ida.appTypeId
							AND Ida.clientId = Clients.ClientId
							AND status & 2 = 0) -- Only for deconfigured FS Agent
					ELSE 1 END FSConfigured
			)AgentStatus
			OUTER APPLY
			(
				SELECT CASE WHEN AgentStatus.FSConfigured IS NULL THEN NULL
				WHEN AgentStatus.FSConfigured = 2  THEN
				(
					SELECT TOP 1 App.id FROM APP_Application App
						INNER JOIN APP_BackupSetName Bkp
							ON App.backupSet = Bkp.id
								AND App.subclientStatus & 8 = 8
								AND Bkp.status & 8 = 8
								AND App.clientId = Clients.ClientId
								AND App.appTypeId = Clients.appType
				)
				ELSE 0 END id
			)FSDefaultSubclient
			OUTER APPLY
			(
				SELECT CASE WHEN FSDefaultSubclient.id IS NULL THEN NULL
				WHEN FSDefaultSubclient.id > 0 THEN
				(SELECT TOP 1 1 FROM APP_SubClientProp SCP
					WHERE SCP.componentNameId = FSDefaultSubclient.id
						AND SCP.attrName = N'Associated Plan'
						AND SCP.modified = 0
				)
				ELSE 0 END PlanAssociated
			)PlanStatus
			WHERE simPackageID IS NULL
				OR FSConfigured IS NULL
				OR FSDefaultSubclient.id IS NULL
				OR PlanAssociated IS NULL
			FOR XML PATH('clientProperties'), TYPE, ROOT('App_GetClientPropertiesResponse')
		)
		IF @i_xml IS NULL
			SET @i_xml = '<App_GetClientPropertiesResponse/>'
		IF object_id('tempdb.dbo.#sec_getClientList') IS NOT NULL
			DROP TABLE #sec_getClientList
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientListToInstallPackages')
	delete from GxQscripts where name = 'AppGetClientListToInstallPackages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListToInstallPackages')
	delete from GXDBVersions where aliasname = 'AppGetClientListToInstallPackages'
GO

insert into GXDBVersions values(2, 'AppGetClientListToInstallPackages',  '00010001000200080000', 'AppGetClientListToInstallPackages', '00010001000200080000')
GO

