

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListForVApp.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientListForVApp.sp,v $ $Id: AppGetClientListForVApp.sp,v 1.1.2.20.8.3 2021/03/13 04:37:05 pktr Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetDataCenterList"
--	|	This Procedure is used to get the list of available data centers
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetClientListForVApp')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientListForVApp <<<'
	drop procedure AppGetClientListForVApp
END
IF EXISTS (select * from GxQscripts where name='AppGetClientListForVApp')
	delete from GxQscripts where name = 'AppGetClientListForVApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForVApp')
	delete from GXDBVersions where aliasname = 'AppGetClientListForVApp'
GO
print '... Creating Procedure: AppGetClientListForVApp'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetClientListForVApp
-- Input arguments
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
DECLARE		@userId AS INT
DECLARE		@entityType AS int
DECLARE     @source  INT
SET  @userId = isnull(@i_xmlText.value('(Ida_ClientListForVAppReq/user)[1]/@userId', 'int'), @i_xmlText.value('(Ida_ClientListForVAppReq/processinginstructioninfo/user)[1]/@userId', 'int'))
SET  @source = @i_xmlText.value('(Ida_ClientListForVAppReq)[1]/@source', 'int')
IF object_id('tempdb.dbo.#clientList') IS NOT null DROP TABLE #clientList
CREATE TABLE #clientList
(
	clientId   int
)
IF OBJECT_ID('tempdb.dbo.#idaClientList') IS NOT NULL DROP TABLE #idaClientList
CREATE TABLE #idaClientList
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#idaClientList'
IF object_id('tempdb.dbo.#respclients') IS NOT null DROP TABLE #respclients
CREATE TABLE #respclients
(
	clientId   int,
	clientName nvarchar(256),
	vmGUID	   nvarchar(256),
	destName   nvarchar(256),
	destvmGUID  nvarchar(256),
	lastSuccesfulJobId  int,
	lastbackuptime int,
	backupsetId int,
	backupsetName nvarchar(256),
	appTypeId int,
	instance    int,
	isVM		int,
	supportedOperation int,
	vendor      int,
	copyPrecedence int,
	scheduleName   nvarchar(256),
	lastSynctime   int,
	replicationId  int,
	syncStatus     int,
	failoverStatus int,
	instanceId  int,
	subclientId int,
	destinationClient int,
	destinationClientName nvarchar(256),
	destVendor   int,
	policyId	 int
)
-- user is requesting for list of backed up vms
if @i_xmlText.value('Ida_ClientListForVAppReq[1]/entity[1]/@_type_','int') = 88
BEGIN
INSERT INTO #clientList
select componentNameId
from app_clientprop
where attrName ='Virtual Server Discovered Clients'
and attrVal ='1'
and modified =0
END
ELSE if @i_xmlText.value('Ida_ClientListForVAppReq[1]/entity[1]/@_type_','int') = 4  -- windows file system clients
	    AND @i_xmlText.value('Ida_ClientListForVAppReq[1]/entity[1]/@applicationId','int') =33
BEGIN
INSERT INTO #clientList
select distinct clientid from app_application
where appTypeId = 33
END
insert into #clientList
select distinct r.value('@clientId', 'int')
from @i_xmlText.nodes('Ida_ClientListForVAppReq/entity')  R(r)
where r.value('@_type_', 'int') = 3
insert into #clientList
select distinct cga.clientId
from @i_xmlText.nodes('Ida_ClientListForVAppReq/entity')  R(r)
inner join app_clientgroup cg
on cg.id = r.value('@clientGroupId', 'int')
inner join app_clientgroupassoc cga
on cg.id = cga.clientGroupId
where r.value('@_type_', 'int') = 28
-- Backup source
IF ( @source = 0)
BEGIN
insert into #respclients
select vmclientid as clientid, C.name, '', '','',MAX( vmprop.jobId) as sJobid,
		max( J.servStartDate ) as lastJobEndTime, A.backupset, '',0,A.instance, 1, 0,1,0,'',0,0,0,0,0,0,0,NULL,0,0
from #clientList vd
inner join APP_VMProp vmProp with (nolock)
on vd.clientId = vmProp.VMclientId
inner join  JMBKPStats J with (nolock)
on vmProp.jobId = J.jobid
INNER Join app_application A with (nolock)
ON A.id = j.appId
and vmProp.attrName ='vmStatus'
and vmProp.attrVal in (0,3)
and j.status in (1,3,14)
inner join app_client c with (nolock)
on vmProp.VMclientId = c.id
group by VMClientId, A.backupset, A.instance, C.name
insert into #respclients
select vmclientid as clientid, C.name, '', '','',MAX( vmprop.jobId) as sJobid,
		max( J.servStartDate ) as lastJobEndTime, A.backupset,'',0, A.instance, 1, 0,1,0,'',0,0,0,0,0,0,0,NULL,0,0
from #clientList vd
INNER Join app_application A with (nolock)
on a.clientId = vd.clientId
inner join  JMBKPStats J with (nolock)
ON A.id = j.appId
inner join APP_VMProp vmProp with (nolock)
on vmProp.jobid = J.jobId
and vmProp.attrName ='vmStatus'
and vmProp.attrVal in (0,3)
and j.status in (1,3,14)
inner join app_client c with (nolock)
on vmProp.VMclientId = c.id
left join #respclients r2
on VMclientId = r2.clientId
where r2.clientId is  null
group by VMClientId, A.backupset, A.instance, C.name
update #respclients
set vmGUID = cp.attrVal
from APP_ClientProp cp
inner join #respClients c
on cp.componentNameId = c.clientid
and c.isvm =1
and cp.attrName ='Virtual Machine Instance UUID'
and cp.modified =0
--physical clients
insert into #respclients
select c.id as clientid, C.name, '', '','',MAX( J.jobId) as sJobid,
		max( J.servStartDate ) as lastJobEndTime, A.backupset, '',A.appTypeId,A.instance, 0, 0,1,0,'',0,0,0,0,0,0,0,NULL,0,0
from #clientList vd
INNER Join app_application A with (nolock)
ON A.clientid = vd.clientId
inner join JMBKPStats J with (nolock)
ON A.id = j.appId
and (bkpattributes & 0x100000) > 0  -- system state backup
and j.status in (1,3,14)
inner join app_client c with (nolock)
on c.id = vd.clientId
group by c.id, A.backupset, A.instance,A.appTypeId, C.name
END
--replication
IF ( @source = 1)
BEGIN
		insert into #respclients
		select  c.id,
				c.name,
				r.sourceGUID,
				r.destinationName,
				r.destinationGuid,
				0,
				r.lastBackupTime,
				A.backupset,
				'',
				0,
				a.instance,
				1,
				0,
				1,
				ISNULL(stx.xmlValue.value('(TMMsg_JobOption/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedence)[1]','int'),0),
				st.subTaskName,
				r.VMSyncedTillTime,
				r.replicationId,
				r.status,
				r.FailoverStatus,
				a.instance,
				r.subclientId,
			    stx.xmlValue.value('(TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance/@clientId)[1]','int'),
				stx.xmlValue.value('(TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance/@clientName)[1]','nvarchar(1024)'),
				prop.propertyValue,
				stx.xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','int')
		from #clientList vd
		inner join app_clientprop cp
		on cp.attrName ='Virtual Machine Instance UUID'
		and vd.clientId = cp.componentNameId
		and cp.modified =0
		inner join app_client c
		on c.id = cp.componentNameId
	    inner join APP_VSAReplication r
		on 	r.sourceGUID = cp.attrVal
		inner join app_application A
		on A.id = r.subclientId
		inner join tm_task t
		on r.taskid = t.taskid
		INNER JOIN TM_subtask  st
		on t.taskId = st.taskId
		INNER JOIN TM_SubTaskXMLOptions stx
		on stx.subtaskId = st.subtaskid
		INNER JOIN APP_VSAReplicationProp prop
on  prop.propertyTypeId = 2203
		and prop.replicationId= r.replicationId
		inner join #idaClientList cl
		on cl.t_clientId = cp.componentNameId
		-- Add V2.1 clients
		insert into #clientList
		select distinct( V.VMClientId)
		from APP_Application parent
		inner join APP_VMBackupSet V
		on V.ParentBackupSetId = parent.backupSet
		inner join APP_Application child
		on child.backupSet =V.ChildBackupSetId
		inner join #clientList vd
		on parent.clientId = vd.clientId
		insert into #respclients
		select  c.id,
				c.displayName,
				r.sourceGUID,
				r.destinationName,
				r.destinationGuid,
				0,
				r.lastBackupTime,
				A.backupset,
				'',
				0,
				a.instance,
				1,
				0,
				1,
				ISNULL(stx.xmlValue.value('(TMMsg_JobOption/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedence)[1]','int'),0),
				st.subTaskName,
				r.VMSyncedTillTime,
				r.replicationId,
				r.status,
				r.FailoverStatus,
				a.instance,
				r.subclientId,
				stx.xmlValue.value('(TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance/@clientId)[1]','int'),
				stx.xmlValue.value('(TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance/@clientName)[1]','nvarchar(1024)'),
				prop.propertyValue,
				stx.xmlValue.value('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','int')
		from #clientList vd
		inner join app_application A
		on A.clientid = vd.clientid
		inner join app_vsareplication r
		on r.subclientid = A.id
		inner join app_clientprop cp
		on cp.attrName ='Virtual Machine Instance UUID'
		and 	r.sourceGUID = cp.attrVal
		and cp.modified =0
		inner join app_client c
		on c.id = cp.componentNameId
		inner join tm_task t
		on r.taskid = t.taskid
		INNER JOIN TM_subtask  st
		on t.taskId = st.taskId
		INNER JOIN TM_SubTaskXMLOptions stx
		on stx.subtaskId = st.subtaskid
		INNER JOIN APP_VSAReplicationProp prop
on prop.propertyTypeId = 2203
		and prop.replicationId= r.replicationId
		inner join #idaClientList cl
		on cl.t_clientId = cp.componentNameId
		left join #respclients r2
		on c.id = r2.clientId
		where r2.clientId is  null
	update R
	 set R.instance = AC.attrVal
	 from #respclients R
	 inner join APP_ClientProp AC
	 on R.clientId = AC.componentNameId
	 where AC.attrName = 'Virtual Machine Instance ID'
	 and AC.modified =0
	  update R
	  set destinationClient = c.id,
	  destinationClientName = c.name
	  from #respclients R
	  inner join App_VmAllocationPolicyprop prop
	  on prop.componentNameId = R.policyId
      inner join app_client c
      on  attrName ='destinationHyperV' and prop.modified=0
      and c.id = prop.attrVal
	  UPDATE R
	  SET destinationClientName = c.name
	  FROM #respclients R
	  inner join app_client c with (nolock)
	  ON c.id= R.destinationClient
	  where R.destinationClientName IS NULL
END
update #respclients
set backupsetName = bs.name
from #respclients C
inner join APP_BackupSetName bs
on C.backupsetId  =bs.id
-- VSVendor enum  form Common.x has the definitions
UPDATE VD
SET vendor = case
				     when attrVal in ( 100,101) then 1
                     when attrVal = 102 then 2
					 when attrVal in ( 201,202) then 3
					 when attrVal in ( 301) then 4
					  when attrVal in (401) then 5
					  when attrVal in (402) then 7
					 when attrVal in (501) then 6
					 when attrVal in (601) then 9
                     when attrVal in (701) then 10
                     when attrVal in (801) then 14
                     when attrVal in (901) then 12
					 when attrVal in (1301) then 16
					 when attrVal in (403) then 17
			  END
FROM #respclients VD
INNER JOIN APP_InstanceProp I with (nolock)
on VD.instance = I.componentNameId
and I.attrName ='Virtual Server Instance Type'
and I.modified =0
-- Supported operation
-- Live Mount ->  VMWare
-- Restore   -> VMWare, Hyper-v
-- Live Sync  -> VMware
--enum VAppOperation
--{
--    LiveMount =1,
--    LiveSync  =2,
--    Restore   =4,
--    LiveRecovery =8
--}
-- For now only setting live mount
update #respclients
set supportedOperation = supportedOperation | 0x1
where vendor = 1
update #respclients
set supportedOperation = supportedOperation | 0x4
where vendor =2
SET @r_ReturnResult = (SELECT @source as '@source',
(
SELECT isVM as '@isVM',
	   supportedOperation as '@supportedOperation',
	   vendor as '@vendor',
	   scheduleName as '@scheduleName',
	   copyPrecedence as '@copyPrecedence',
		replicationId as '@replicationId',
		syncStatus as '@syncStatus',
		failoverStatus as '@failoverStatus',
		destVendor as '@destVendor',
	   ( select backupsetId as '@backupsetId',
	            backupSetName as '@backupsetName',
				appTypeId as '@applicationId'
	     for xml path ('backupSet'),TYPE),
	   (SELECT clientId as '@clientId',
		3 as '@_type_',
		clientName as '@clientName',
		vmGUID as '@GUID',
		instanceId as '@instanceId',
		subclientId as '@subclientId'
		for xml path('client'), TYPE
		),
	   (SELECT destinationClient as '@clientId',
		3 as '@_type_',
		destinationClientName as '@clientName'
		for xml path('destinationClient'), TYPE
		),
	   (SELECT
		3 as '@_type_',
		destName as '@clientName',
		destVMGuid as '@GUID'
		for xml path('destClient'), TYPE
		),
(SELECT ISNULL(lastbackuptime, 0) '@time', 55 '@_type_'
				FOR XML PATH ('lastbackuptime'), TYPE),
(SELECT ISNULL(lastSynctime, 0) '@time', 55 '@_type_'
				FOR XML PATH ('lastSyncTime'), TYPE)
FROM #respclients
FOR XML PATH ('client'),TYPE
)
FOR XML PATH('Ida_ClientListForVAppResp') )
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientListForVApp')
	delete from GxQscripts where name = 'AppGetClientListForVApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForVApp')
	delete from GXDBVersions where aliasname = 'AppGetClientListForVApp'
GO

insert into GXDBVersions values(2, 'AppGetClientListForVApp',  'v1.1.2.20.8.3', 'AppGetClientListForVApp', 'v1.1.2.20.8.3')
GO

