

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListForProxy.sp] ---------- 

----> input
	--userId
----> output
	--List of clients that can be configured as proxy.
/*
 This stored procedure is used to get list of proxy clients that can be configured on a commcell.
  */
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientListForProxy')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientListForProxy <<<'
	drop procedure AppGetClientListForProxy
END
IF EXISTS (select * from GxQscripts where name='AppGetClientListForProxy')
	delete from GxQscripts where name = 'AppGetClientListForProxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForProxy')
	delete from GXDBVersions where aliasname = 'AppGetClientListForProxy'
GO
print '... Creating Procedure: AppGetClientListForProxy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientListForProxy
  @userId INT 
AS
  DECLARE @XMLOUT XML
DECLARE @proxyClients table (clientId int,clientName nvarchar(max),displayName nvarchar(max))
DECLARE @ERRORCODE INT = 0
DECLARE @ERRORSTRING NVARCHAR(MAX) = 'SUCCESS'
DECLARE @ERRORXML XML
DECLARE @isUnixGatewayEnabled INT = 1 /*ENABLED BY DEFAULT*/
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
IF EXISTS (Select 1 from APP_AdvanceSettings where keyName='bEnableUnixClientGateway' and enabled = 1 and cast(value as nvarchar(16) )= 'false' and relativePath = 'CommServDB.Console')
BEGIN
SET @isUnixGatewayEnabled = 0
END
IF (@isUnixGatewayEnabled = 1)
BEGIN
	INSERT into @proxyClients(clientId,clientName,displayName)   (select distinct clientId,name,displayName from APP_Application APP inner join APP_AppTypeGroupAssoc ATGA on APP.appTypeId=ATGA.appTypeId inner join APP_Client AC on AC.id=APP.clientId inner join APP_AppTypeGroup ATG on ATG.appTypeGroupId=ATGA.appGroupId   where ATG.groupName  in ('APPGRP_W2KFileSystem','APPGRP_EZUnix') )
END
ELSE
BEGIN
	INSERT into @proxyClients(clientId,clientName,displayName)   (select distinct clientId,name,displayName from APP_Application APP inner join APP_AppTypeGroupAssoc ATGA on APP.appTypeId=ATGA.appTypeId inner join APP_Client AC on AC.id=APP.clientId inner join APP_AppTypeGroup ATG on ATG.appTypeGroupId=ATGA.appGroupId   where ATG.groupName  in ('APPGRP_W2KFileSystem') )
END
DELETE from @proxyClients where clientId in (select componentNameId from APP_ClientProp where attrName='PlatformDeleted 4' and attrVal=1)
DELETE from @proxyClients where clientId not in (select clientId from simInstalledPackages where simPackageID in (702,1101))
DELETE from @proxyClients where clientId in (SELECT CGA.clientId  FROM app_clientgroup CG INNER JOIN app_clientGroupAssoc CGA
												ON CG.id = CGA.clientGroupId
												WHERE ((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
											)
DELETE from @proxyClients where clientId in (select componentNameId from APP_ClientProp where attrName='Virtual Server Discovered Clients' and attrVal=1 )
DELETE from @proxyClients where clientId in (select componentNameId from APP_ClientProp where attrName='Mini SRM Agent' and attrVal=1 )
DELETE from @proxyClients where clientId in (select id from APP_Client where releaseId < 15)
DELETE from @proxyClients where clientId in (select clientId from APP_CommCell )
IF OBJECT_ID('tempdb.dbo.#brosweclientLst') IS NOT NULL DROP TABLE #brosweclientLst
CREATE TABLE #brosweclientLst
     (
         t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
     )
EXEC sec_getIdaObjectsForUser @userId, 3  /*CLIENT_ENTITY */ , 0 , 0, '#brosweclientLst'
DELETE from @proxyClients where clientId not in (select t_clientId from #brosweclientLst)
IF OBJECT_ID('tempdb.dbo.#brosweclientLst') IS NOT NULL DROP TABLE #brosweclientLst
Set @XMLOUT= (SELECT ( SELECT clientId as '@clientId',clientName as '@clientName', displayName as '@displayName' from @proxyClients for xml path('clients') ,Type) for Xml path ('EVGui_ClientListResp'),Type )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @ERRORCODE     = ERROR_NUMBER()
    SET @ERRORSTRING  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
PROC_EXIT:
SET @ERRORXML = (SELECT @ERRORCODE AS '@errorCode' , @ERRORSTRING as  '@errorMessage' for xml path ('error'))
SELECT @XMLOUT
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientListForProxy')
	delete from GxQscripts where name = 'AppGetClientListForProxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForProxy')
	delete from GXDBVersions where aliasname = 'AppGetClientListForProxy'
GO

insert into GXDBVersions values(2, 'AppGetClientListForProxy',  '00000000000000000000', 'AppGetClientListForProxy', '00000000000000000000')
GO

