

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListForNameControl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientListForNameControl.sp,v $ $Id: AppGetClientListForNameControl.sp,v 1.8.2.10 2020/12/02 11:34:21 kbora Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			SP: "AppGetClientListForNameControl"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetClientListForNameControl')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientListForNameControl <<<'
	drop procedure AppGetClientListForNameControl
END
IF EXISTS (select * from GxQscripts where name='AppGetClientListForNameControl')
	delete from GxQscripts where name = 'AppGetClientListForNameControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForNameControl')
	delete from GXDBVersions where aliasname = 'AppGetClientListForNameControl'
GO
print '... Creating Procedure: AppGetClientListForNameControl'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetClientListForNameControl
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
AS
  DECLARE @o_id integer
  DECLARE @o_name varchar(255)
  DECLARE @o_networkName varchar(255)
  DECLARE @o_csHostName varchar(255)
  DECLARE @o_domain varchar(255)
  DECLARE @o_cvdPort integer
  DECLARE @o_evMgrcPort integer
  DECLARE @o_grcMigratedClient integer
	SET NOCOUNT ON
DECLARE @tempVMList TABLE ( clientId int)
	INSERT	INTO @tempVMList
	SELECT	DISTINCT prop.componentNameId
	FROM	App_ClientProp prop INNER JOIN APP_Client CL ON prop.componentNameId = CL.id
			LEFT JOIN LicUsage Lic ON Prop.componentNameId = Lic.CId
	WHERE	prop.attrName IN (N'Virtual Server Discovered Clients' , N'Virtual Client') and prop.modified = 0 AND prop.attrVal = '1'
			-- If CCM client, then return the virtual client also so that we can atleast configure it.
			-- This issue was, migrated SQL cluster client is not being returned to name change because it is virtual client.
AND CL.specialClientFlags & 0x20 = 0
			AND Lic.id IS NULL
	INSERT	INTO @tempVMList
	SELECT	DISTINCT componentNameId
	FROM		App_ClientProp
	WHERE		attrName='Virtual Entity Flags' and modified = 0 AND
	(convert(int,attrVal) & 0x2 = 0x2)
	SELECT	CL.id, CL.name, CL.net_hostName, CL.csHostName,
			SUBSTRING(CL.net_hostName, CHARINDEX('.', CL.net_hostName)+1, LEN(CL.net_hostName)),
			CL.cvdPort, CL.evMgrcPort,
grcMigratedClient = (CASE (CL.specialClientFlags & 0x20)
WHEN 0x20 THEN 1
				ELSE 0
			END)
	FROM		App_Client CL
WHERE		CL.id > 1 AND ( CL.csHostName <> '' OR CL.specialClientFlags & 0x20 = 0 )
	-- Skip remote commcell clients.
AND ( 	CL.specialClientFlags & 0x200 = 0 OR
(EXISTS( SELECT 1 FROM ArchFile AF INNER JOIN APP_APPlication APP ON AF.appId = APP.id AND APP.clientId = CL.id AND (CL.specialClientFlags & 0x200) > 0 ))
		)
	-- Filter out the virtual client for now
	AND	NOT EXISTS (SELECT 1 FROM @tempVMList WHERE clientId = CL.id)
	-- Filter out Cluster CS Physical Nodes
	AND NOT EXISTS (SELECT 1 FROM APP_VMToPMMap WHERE VMClientId = 2 AND PMClientId = CL.id)
	-- Filter out index server clients
AND NOT EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = CL.id AND attrName = 'Index Server Type'  AND attrVal = 15 AND modified = 0)
	UNION
	SELECT	A.id, A.name, A.net_hostName, D.Net_HostName,
			SUBSTRING(A.net_hostName, CHARINDEX('.', A.net_hostName)+1, LEN(A.net_hostName)),
			A.cvdPort, A.evMgrcPort,
grcMigratedClient = (CASE (A.specialClientFlags & 0x20)
WHEN 0x20 THEN 1
				ELSE 0
			END)
	FROM	APP_Client A INNER JOIN APP_ClientProp B ON A.id = B.componentNameId AND B.attrName = 'OwnerCommCellId'
			INNER JOIN APP_CommCell C ON C.id = B.attrVal
			INNER JOIN APP_Client D ON D.id = C.clientId
	WHERE	A.id > 1
AND A.specialClientFlags & 0x20 > 0
		AND A.csHostName = ''
		-- Filter out Cluster CS Physical Nodes
		AND NOT EXISTS (SELECT 1 FROM APP_VMToPMMap WHERE VMClientId = 2 AND PMClientId = A.id)
		-- Filter out the virtual client for now
		AND	NOT EXISTS (SELECT 1 FROM @tempVMList WHERE clientId = A.id)
		-- Filter out index server clients
AND NOT EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = A.id AND attrName = 'Index Server Type'  AND attrVal = 15 AND modified = 0)
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientListForNameControl')
	delete from GxQscripts where name = 'AppGetClientListForNameControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForNameControl')
	delete from GXDBVersions where aliasname = 'AppGetClientListForNameControl'
GO

insert into GXDBVersions values(2, 'AppGetClientListForNameControl',  '00010008000200100000', 'AppGetClientListForNameControl', '00010008000200100000')
GO

