

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListForDomainChange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientListForDomainChange.sp,v $ $Id: AppGetClientListForDomainChange.sp,v 1.16.86.2 2018/03/27 08:11:34 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppGetClientListForDomainChange"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetClientListForDomainChange <<<'

IF EXISTS (select * from sysobjects where name='AppGetClientListForDomainChange')
	drop procedure AppGetClientListForDomainChange
IF EXISTS (select * from GxQscripts where name='AppGetClientListForDomainChange')
	delete from GxQscripts where name = 'AppGetClientListForDomainChange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForDomainChange')
	delete from GXDBVersions where aliasname = 'AppGetClientListForDomainChange'
GO
print '... Creating Procedure: AppGetClientListForDomainChange'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetClientListForDomainChange
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- 9.0 Changes:
--	1. (cluster) CS nodes can now have more than one client ID.
--
-- ---------------------------------------------------------------
  @i_commcellId integer,
  @i_oldDomainName varchar(255),
  @i_newDomainName varchar(255)
AS
  DECLARE @o_id integer
  DECLARE @o_name varchar(255)
  DECLARE @o_netHostName varchar(255)
  DECLARE @o_csHostName varchar(255)
  DECLARE @o_dupId integer
  DECLARE @o_newNetHostName varchar(255)
  DECLARE @o_newCsHostName varchar(255)
  DECLARE @o_isNasClient integer
  DECLARE @o_csHostClientId integer
	SET NOCOUNT ON
	DECLARE @commCellId		integer
DECLARE @oldDomainName		varchar(255)
DECLARE @newDomainName		varchar(255)
	SET			@commCellId = @i_commcellId
	SET			@oldDomainName = @i_oldDomainName
	SET			@newDomainname = @i_newDomainName
	DECLARE @tempVMList TABLE ( clientId int)
	INSERT	INTO @tempVMList
	SELECT	DISTINCT componentNameId
	FROM	App_ClientProp
	WHERE	attrName='Virtual Client' and modified = 0 AND attrVal = '1'
	DECLARE @tempClients TABLE (
		Id					integer,
		ClientName	varchar(255),
		NetHostName	varchar(255),
		CsHostName	varchar(255),
		isDup				integer,
		newNetHostName	varchar(255),
		newCsHostName	varchar(255),
		isNasClient	integer,
		csHostClientId	integer
	)
	INSERT	@tempClients
	SELECT	C.Id, C.Name, C.Net_HostName, C.CsHostName, 0, '', '', 0, 0
	FROM		App_Client C
	WHERE	C.id > 2 and (SUBSTRING(Net_HostName, CHARINDEX('.', Net_HostName)+1, LEN(Net_HostName)) = (case @oldDomainName
																								when '' then Net_HostName
																								else @oldDomainName
																								end))
	-- OR			(SUBSTRING(CsHostName, CHARINDEX('.', CsHostName)+1, LEN(CsHostName)) = (case @oldDomainName
	--																								when '' then CsHostName
	--																							else @oldDomainName
	--																							end)))
	UPDATE	@tempClients
	SET		csHostClientId = c.Id
	FROM	@tempClients as a, App_client as c
	WHERE	a.CsHostName = c.Name OR a.CsHostName = c.Net_HostName
IF @newDomainName <> ''
	UPDATE	@tempClients
	SET			newNetHostName = SUBSTRING(NetHostName, 0, CHARINDEX('.', NetHostName)) + '.' + @newDomainName
	WHERE		SUBSTRING(NetHostName, CHARINDEX('.', NetHostName)+1, LEN(NetHostName)) = (case @oldDomainName
																			when '' then NetHostName
																								else @oldDomainName
																								end)
	ELSE
		UPDATE	@tempClients
		SET			newNetHostName = SUBSTRING(NetHostName, 0, CHARINDEX('.', NetHostName))
		WHERE		SUBSTRING(NetHostName, CHARINDEX('.', NetHostName)+1, LEN(NetHostName)) = (case @oldDomainName
																								when '' then NetHostName
																								else @oldDomainName
																								end)
	UPDATE	@tempClients
	SET			newNetHostName = NetHostName + newNetHostName
	where CHARINDEX('.', NetHostName)= 0
	-- We don't allow domain name change for CS host name anymore
	-- UPDATE	@tempClients
	-- SET			newCsHostName = SUBSTRING(CsHostName, 0, CHARINDEX('.', CsHostName)) + '.' + @newDomainName
	-- WHERE		SUBSTRING(CsHostName, CHARINDEX('.', CsHostName)+1, LEN(CsHostName)) = @oldDomainName
	UPDATE	@tempClients
	SET			isDup = 1
	WHERE		EXISTS( SELECT a.id FROM App_Client as a
									WHERE a.Net_HostName = newNetHostName)
	UPDATE	@tempClients
	SET			isNasClient = 1
	WHERE		EXISTS( SELECT NDMPHostId FROM MMLibraryHostInfo as lh
									WHERE	Id = lh.NDMPHostId)
-- Filter out CS physical cluster nodes
	DELETE FROM @tempClients WHERE Id IN (SELECT PMClientID FROM APP_VMToPMMap WHERE VMClientID = 2)
	SELECT * FROM @tempClients
	-- Filter out the virtual client for now
	WHERE		id NOT IN (SELECT clientId FROM @tempVMList)
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientListForDomainChange')
	delete from GxQscripts where name = 'AppGetClientListForDomainChange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForDomainChange')
	delete from GXDBVersions where aliasname = 'AppGetClientListForDomainChange'
GO

insert into GXDBVersions values(2, 'AppGetClientListForDomainChange',  '00010016008600020000', 'AppGetClientListForDomainChange', '00010016008600020000')
GO

