

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListForClientGroups.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientListForClientGroups.sp,v $ $Id: AppGetClientListForClientGroups.sp,v 1.1.2.2 2020/02/04 17:14:55 kvinayak Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetClientListForClientGroups"
--	|	This procedure gets the list of clients for a given client group.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientListForClientGroups')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientListForClientGroups <<<'
	drop procedure AppGetClientListForClientGroups
END
IF EXISTS (select * from GxQscripts where name='AppGetClientListForClientGroups')
	delete from GxQscripts where name = 'AppGetClientListForClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForClientGroups')
	delete from GXDBVersions where aliasname = 'AppGetClientListForClientGroups'
GO
print '... Creating Procedure: AppGetClientListForClientGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientListForClientGroups
-- Input arguments
  @i_xmlText XML		OUTPUT
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @xmlText        XML
DECLARE @errorCode      INT
DECLARE @errorMessage   VARCHAR(MAX)
DECLARE @r_errors XML
DECLARE @r_clientGroupsList XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorMessage = ''
IF object_id('tempdb.dbo.#ClientGroupIds_Tbl') is not null
		DROP TABLE #ClientGroupIds_Tbl
create table #ClientGroupIds_Tbl
(
	  clientGroupId		integer
)
insert into #ClientGroupIds_Tbl
SELECT  ISNULL(ref.value('@clientGroupId', 'int'),'') AS clientGroupId
            FROM    @i_xmlText.nodes('App_GetClientsForClientGroupReq/clientGroup') R ( ref )
delete from #ClientGroupIds_Tbl where clientGroupId <= 0
SET @r_clientGroupsList = ( select
								(select(select 	A.id as '@clientId',
										A.name AS '@clientName',
										A.displayname AS '@displayName'
										for xml path('client'), type)
								from	App_Client A with (nolock) inner join APP_ClientGroupAssoc B on A.id = B.clientId
								where B.clientGroupId = D.clientGroupId
								for xml path('clientGroupNClientAssoc'), type)
							 from #ClientGroupIds_Tbl D
							FOR xml path('')
							)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SEND_RESPONSE:
SET @r_errors = (SELECT @errorCode   AS '@errorCode',
                        @errorMessage AS '@errorString'
                    FOR xml PATH('error'))
SET @xmlText = ( SELECT  ISNULL(@r_errors,'') , ISNULL(@r_clientGroupsList ,'')
                 FOR xml path(''),ROOT('App_GetClientsForClientGroupResp')
               )
SET NOCOUNT OFF
SELECT @xmlText as out_xml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientListForClientGroups')
	delete from GxQscripts where name = 'AppGetClientListForClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListForClientGroups')
	delete from GXDBVersions where aliasname = 'AppGetClientListForClientGroups'
GO

insert into GXDBVersions values(2, 'AppGetClientListForClientGroups',  '00010001000200020000', 'AppGetClientListForClientGroups', '00010001000200020000')
GO

