

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListByJobId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientListByJobId.sp,v $ $Id: AppGetClientListByJobId.sp,v 1.1.2.32.8.3 2021/02/20 03:03:11 msaiganta Exp $";
--
--  +========================================================================+
--  | Stored Precedure: AppGetClientListByJobId
--  |
--  | Description:
--  |  Get list of clients involved in job.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        bkharabe   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetClientListByJobId')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientListByJobId <<<'
	drop procedure AppGetClientListByJobId
END
IF EXISTS (select * from GxQscripts where name='AppGetClientListByJobId')
	delete from GxQscripts where name = 'AppGetClientListByJobId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListByJobId')
	delete from GXDBVersions where aliasname = 'AppGetClientListByJobId'
GO
print '... Creating Procedure: AppGetClientListByJobId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetClientListByJobId
  @jobId integer,
  @userId integer,
  @appId integer,
  @isGUI integer
AS
-- Following are the "columns" returned, in the order in which they are returned
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- These lines represent the actual SQL code that will get executed.
declare @ccId			INT
declare @id			INT
declare @user			INT
declare @pairId			INT
declare @jobAppTypeId		INT
declare @bkpOpType		INT
declare @isFLR 			INT
declare @isEdge			INT
declare @repSetId		INT
declare @jobTime		INT
declare @CIJobCloudId		INT
DECLARE @CDRPairId		INT
declare @webSvrClId		INT
declare @webSvrClName		NVARCHAR(128)
declare @proxyClId		INT
declare @isAdminClId		INT
declare @isPatchInstallJob	INT
declare @isWorkflowJob	INT
declare @isAnalyticsJob  INT
declare @jobType	INT
declare @dbClient	INT
DECLARE @xmlText	VARCHAR(MAX)
DECLARE @node		VARCHAR(1024)
DECLARE @handle		INT
DECLARE @type		INT
DECLARE @servStartTime INT
DECLARE @exchJobClientId INT = 0
DECLARE @aadJobClientId INT = 0
declare @physicalClientList	TABLE(	pmClId		integer )
declare @tempClientList		TABLE(	clientId	integer )
declare @CLIENT_ENTITY INT = 3
declare @EV_MANAGE_APPLICATION INT = 2
declare @tempBkp		TABLE(	t_subclientId	integer,
					t_appTypeId	integer,
					t_jobTime	integer,
					t_attributes	bigint,
					t_attributesex	bigint,
					t_cloudId	integer,
					t_bkpSetId	integer,
					t_optype	integer,
					t_instanceId integer,
                    t_targetClientId integer)
declare @tempRst		TABLE(	srcClientId	integer,
					destClientId	integer,
					t_bkpSetId	integer,
					t_jobTime	integer,
					t_instanceId	integer )
declare @vsaMerberSrvGroups	TABLE(	cgId		integer )
DECLARE @subClientId INT = 0
SET @ccId	=2
SET @id		= @jobId
SET @user	= @userId
SET @pairId	= @appId
DECLARE @jobStartTime INT = 0
DECLARE @jobEndTime INT = 0
DECLARE @distClusterType INT
DECLARE @xmlHandle INT
DECLARE @cloudAppsInstType INT
DECLARE @subclient INT
DECLARE @Instance INT
DECLARE @AppTypeId INT
DECLARE @dc_client VARCHAR(255)
DECLARE @IsCaseManagerReferenceCopyJob INT
SELECT	@CDRPairId = pairId
FROM	JMCDRJobs
WHERE	jobId = @id
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
	DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
(
    serverURL NVARCHAR(512),
	clientId INT,
	clientName NVARCHAR(256),
	cloudId INT,
	hostName NVARCHAR(256),
	basePort INT,
	engineName  NVARCHAR(256),
	serverType INT,
	indexServerClientId INT,
	internalCloudName NVARCHAR(256)
)
IF @pairId > 0
	SET	@CDRPairId = @pairId
IF EXISTS(SELECT * FROM    JMAdminJobStatsTable WHERE   jobId= @id)
BEGIN
	-- 35 install updates, 67 install software, need to get client list from JMQinetixUpdateStatus for both jobs
	SELECT  @isPatchInstallJob = jobId, @servStartTime = servStart
	FROM    JMAdminJobStatsTable
	WHERE   jobId = @id AND optype in (35, 67)
	SELECT  @isWorkflowJob = jobId
	FROM    JMAdminJobStatsTable
	WHERE   jobId = @id AND optype = 90
	SELECT  @isAnalyticsJob =
	CASE WHEN optype = 53 THEN jobId
	ELSE 0
	END
    FROM    JMAdminJobStatsTable
    WHERE   jobId = @id
    SET @subclient = (SELECT appId from JMAdminJobStatsTable where jobid = @jobId)
    -- SUBCLIENTCONTENTINDEX = 113, CASE_MGR_INDEX_COPY = 134
    SELECT @IsCaseManagerReferenceCopyJob =
    CASE WHEN optype in (113, 134) THEN jobid ELSE 0 END
    FROM JMAdminJobStatsTable WHERE   jobId = @id
END
ELSE IF EXISTS(SELECT * FROM    JMAdminJobInfoTable WHERE   jobId= @id)
BEGIN
	-- 35 install updates, 67 install software, need to get client list from JMQinetixUpdateStatus for both jobs
	SELECT  @isPatchInstallJob = jobId, @servStartTime = servStart
	FROM    JMAdminJobInfoTable
	WHERE   jobId = @id AND optype in (35, 67)
	SELECT  @isWorkflowJob = jobId
	FROM    JMAdminJobInfoTable
	WHERE   jobId = @id AND optype = 90
	SELECT  @isAnalyticsJob =
	CASE WHEN optype = 53 THEN jobId
	ELSE 0
	END
    FROM    JMAdminJobInfoTable
    WHERE   jobId = @id
    SET @subclient = (SELECT appId from JMAdminJobInfoTable where jobid = @jobId)
    -- SUBCLIENTCONTENTINDEX = 113, CASE_MGR_INDEX_COPY = 134
    SELECT @IsCaseManagerReferenceCopyJob =
    CASE WHEN optype in (113, 134) THEN jobid ELSE 0 END
    FROM JMAdminJobInfoTable WHERE   jobId = @id
END
IF @IsCaseManagerReferenceCopyJob > 0
BEGIN
	INSERT INTO @tempClientList
	select distinct HostClientId from archGroup AG
                INNER JOIN JMAdminJobStatsTable JM ON JM.jobId = @IsCaseManagerReferenceCopyJob AND JM.archGrpID = AG.id
				INNER JOIN MMDataPath DP ON DP.CopyId IN (AG.defaultCopy, AG.defaultSnapCopy) AND DP.Flag&1 = 1
    UNION ALL
    select distinct HostClientId from archGroup AG
                INNER JOIN JMAdminJobInfoTable JM ON JM.jobId = @IsCaseManagerReferenceCopyJob AND JM.archGrpID = AG.id
				INNER JOIN MMDataPath DP ON DP.CopyId IN (AG.defaultCopy, AG.defaultSnapCopy) AND DP.Flag&1 = 1
END
IF @isAnalyticsJob > 0
BEGIN
	INSERT INTO @tempClientList
	SELECT ClientId FROM DM2SearchServerCoreInfo WHERE CloudId IN
		( SELECT cloudId FROM jmadminjobstatstable WHERE jobid= @id )
	INSERT INTO @tempClientList
	SELECT distinct C.id from APP_Client C inner join APP_VMProp VMP
	on C.name = VMP.attrVal
	and VMP.attrName = 'vmAgent'
	and VMP.jobId = @id
	select @Instance = instance, @AppTypeId= appTypeId from APP_Application where id = @subclient
    INSERT INTO @tempBkp values( @subClient, @AppTypeId, 0, 0, 0, 0, 0, 0 ,@Instance, 0)
END
IF @CDRPairId > 0
BEGIN
	DECLARE @srcClId integer
	DECLARE @CDRRepSetId integer
	SELECT	@srcClId = clientId, @CDRRepSetId = backupset
	FROM	APP_Application
	WHERE	id=@CDRPairId
	INSERT INTO @tempClientList
	SELECT	convert(integer, attrVal)
	FROM	APP_BackupSetProp
	WHERE	componentNameId = @CDRRepSetId AND attrName = N'FLR Destination HostId' AND modified = 0
	INSERT INTO @tempClientList
	SELECT @srcClId
END
ELSE IF @isPatchInstallJob > 0
BEGIN
	INSERT INTO @tempClientList
	SELECT	clientId
	FROM	JMQinetixUpdateStatus
	WHERE	jobId = @id
    INSERT INTO @tempClientList
    SELECT P.clientID
    FROM PatchUpdateAgentInfo P, (    SELECT  DISTINCT attrval
                                      FROM App_ClientProp, @tempClientList WHERE attrName = 'UPDATE CACHE AGENT ID'
                                      AND componentNameId = clientId
                                      AND @servStartTime > created
                                      AND (modified = 0 OR @servStartTime < modified)) T
    WHERE T.attrval = P.id
END
ELSE IF @isWorkflowJob > 0
BEGIN
	INSERT INTO @tempClientList
	SELECT	cloudId
	FROM	JMAdminJobStatsTable
	WHERE	jobId = @id
END
ELSE
BEGIN
--get CC
INSERT INTO @tempBkp
SELECT	applicationId, appTypeId, 0, bkpAttributes, bkpAttributesEx, cloudId, backupset, 0, instance, targetClientId
FROM	JMBkpJobInfo, APP_Application
WHERE	commcellid=@ccId AND jobId=@id AND id = applicationId
UNION
SELECT	appId, appType, servStartDate, bkpAttributes, bkpAttributesEx, cloudId, backupset, optype, instance, targetClientId
FROM	JMBkpStats, APP_Application
WHERE	commcellid=@ccId AND jobId=@id AND id = appId
SELECT	@jobStartTime = servStartDate, @jobEndTime = servEndDate
FROM	JMBkpStats WHERE jobId = @id AND commcellId = @ccId
IF (@jobStartTime = 0)
	SELECT	@jobStartTime = jobStartTime, @jobEndTime = 0
	FROM	JMJobInfo WHERE jobId = @id AND commCellId = @ccId
SET @jobAppTypeId = ISNULL((select TOP 1 t_appTypeId from @tempBkp), 0)
SET @bkpOpType = ISNULL((select TOP 1 t_optype from @tempBkp), 0)
SET @isFLR = ISNULL((select TOP 1 (t_attributes & 524288) from @tempBkp), 0)
SET @isEdge = ISNULL((select TOP 1 (t_attributesex & 0x200) from @tempBkp), 0)
--check if exchange servers are needed
IF @jobAppTypeId = 137
BEGIN
	IF EXISTS(SELECT jobId FROM JMJobStats WHERE ((opType = 4 AND subOpType =98) OR opType = 109)  AND jobId = @id) OR
		EXISTS(SELECT jobId FROM JMJobInfo WHERE ((opType = 4 AND subOpType =98) OR opType = 109)  AND jobId = @id)
		SET @exchJobClientId = ISNULL((SELECT TOP 1 A.clientId FROM @tempBkp T INNER JOIN APP_Application A ON T.t_subclientId = A.id), 0)
	set @subClientId = (SELECT TOP 1 t_subclientId FROM @tempBkp)
END
ELSE IF EXISTS(SELECT jobId FROM JMJobStats WHERE opType = 113 AND jobId = @id)
BEGIN
	IF EXISTS(SELECT * FROM JMAdminJobStatsTable WHERE jobId = @id)
		SET @exchJobClientId = ISNULL((SELECT A.clientId FROM JMAdminJobStatsTable J INNER JOIN APP_Application A ON J.jobId = @id AND J.appID = A.id), 0)
	ELSE IF EXISTS(SELECT * FROM JmAdminJobInfoTable WHERE jobId = @id)
		SET @exchJobClientId = ISNULL((SELECT A.clientId FROM JmAdminJobInfoTable J INNER JOIN APP_Application A ON J.jobId = @id AND J.appID = A.id), 0)
END
DECLARE @ProxyClientXml XML = NULL
 DECLARE @cc_client VARCHAR(255)
IF @jobAppTypeId = 135
BEGIN
	INSERT into @tempClientList
	SELECT  DISTINCT S.Data
	FROM
			APP_Client C
			INNER JOIN APP_Application A ON A.clientId = C.id
			INNER JOIN APP_InstanceProp IP
				   ON A.instance = IP.componentNameId
			inner join jmbkpstats j on j.appid = A.id
			CROSS APPLY dbo.SplitString(IP.attrVal, '+') S
	WHERE IP.attrName = 'Database Clients' AND IP.modified = 0 AND j.jobid = @id
END
IF @jobAppTypeId>0
BEGIN
	SET @jobType = 1
	IF @jobAppTypeId IN (38)
		BEGIN
			INSERT INTO @tempClientList
			SELECT AttrVal FROM APP_ClientProp where componentNameId in (SELECT DISTINCT clientId
			FROM    APP_Application, @tempBkp
				WHERE   id = t_subclientId ) and AttrName = 'Open VMS proxy client' and modified = 0
		--get the IBM-ISeries client Id.
			INSERT INTO @tempClientList
			SELECT DISTINCT clientId
			FROM    APP_Application a
			INNER JOIN APP_Client c ON
			c.id = a.clientId
			WHERE  c.simOperatingSystemId IN(118,49) AND a.appTypeId = 38 --118 is the IBM-ISeries op id , 49 is OPEN VMS
			AND a.id IN (select t_subclientId from @tempBkp)
		END
	ELSE IF @jobAppTypeId IN (25, 40, 76, 87)
		INSERT INTO @tempClientList
		SELECT DISTINCT c.id
		FROM	APP_SubClientProp p, APP_Client C, @tempBkp
		WHERE	p.componentNameId=t_subclientId and p.attrname=N'proxy host' and p.attrVal=c.net_hostName and
			(t_jobTime=0 AND p.modified=0 OR (p.modified>t_jobTime OR p.modified=0) and p.created<=t_jobTime)
	ELSE IF @jobAppTypeId = 80
		INSERT INTO @tempClientList
		SELECT DISTINCT racHostId
		FROM	JMOracleRACClientsUsed
		WHERE	commcellid=@ccId AND jobId=@id
	ELSE IF @jobAppTypeId = 128	--Documentum: If the Backup/Restore job runs on multiple clients.
		BEGIN
			SET @xmlText = ISNULL((SELECT xmlJobInfo FROM JMjobStats WHERE jobId = @id), '')
			IF @xmlText is not null AND LEN(@xmlText) > 0
			BEGIN
				EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
				--backup jobs
					SET @node = 'JobManager_BkpJobDetailsXml/documentumJob/docInfo'
				INSERT INTO @tempClientList
				SELECT ISNULL(clientId,0) as clientId
				FROM OPENXML (@handle, @node, 1) WITH (clientId int)
				--for Distributed DB Documentum backup and restore
				SET @dbClient  = (SELECT TOP 1 ISNULL(CAST(attrval as INT),0)
									FROM APP_InstanceProp I, @tempBkp t
									where I.componentNameId = t.t_instanceId AND
									attrName like 'DOCUMENTUM DbClientId' AND modified = 0)
				IF @dbClient > 0 AND @dbClient NOT IN (select clientId from @tempClientList)
					INSERT INTO @tempClientList
					VALUES (@dbClient)
				EXEC sp_xml_removedocument @handle
			END
		END
	ELSE
		INSERT INTO @tempClientList
		SELECT DISTINCT clientId
		FROM	APP_Application, @tempBkp
		WHERE	id = t_subclientId
	-- CV APPTYPE : CV_APPTYPE_ORACLE8 = 22
	-- CVOpType : TURBO ARCHIVE = 98
	IF @jobAppTypeId = 22 AND @bkpOpType = 98
	BEGIN
		SET @jobStartTime = ISNULL(@jobStartTime,dbo.GetUnixTime(GETUTCDATE()))
		DECLARE @orclaeClientXml XML = ISNULL((select TOP 1 REPLACE(attrVal,'utf-8','utf-16')  from APP_SubClientProp ASP INNER JOIN @tempBkp T
					ON ASP.componentNameId = T.t_subclientId
					AND @jobStartTime BETWEEN created AND (CASE WHEN modified = 0 THEN dbo.GetUnixTime(GETUTCDATE()) ELSE modified END)
					AND attrName = 'Oracle DB Archive Config Options XML'), '')
		IF @orclaeClientXml.exist('(App_DatabaseArchiveOptions/client/@clientId)[1]') <> 0
		BEGIN
			INSERT INTO @tempClientList
			SELECT   @orclaeClientXml.value('(App_DatabaseArchiveOptions/client/@clientId)[1]','INT')
		END
	END
	IF @jobAppTypeId = 103
	BEGIN
		DECLARE @instanceId INT = (SELECT TOP 1 t_instanceId FROM @tempBkp)
		set @subClientId = (SELECT TOP 1 t_subclientId FROM @tempBkp)
		DECLARE @PhysicalNodeMapping Table (NodeId INT, PhysicalClientId INT)
		INSERT INTO @PhysicalNodeMapping
		SELECT SUBSTRING(value,0,CHARINDEX(',',value)),SUBSTRING(value,CHARINDEX(',',value)+1,LEN(value)) AS mapping
		FROM (select s.n.value('.','varchar(255)') AS value
					 FROM
							(select CAST('<r>'+REPLACE((
											SELECT attrVal FROM APP_InstanceProp
											WHERE
											componentNameId = @instanceId
											AND ISNULL(@jobStartTime,dbo.GetUnixTime(GETUTCDATE())) BETWEEN created AND (CASE WHEN modified = 0 THEN dbo.GetUnixTime(GETUTCDATE()) ELSE modified END)
											AND attrName like 'DB2 Partition Clients'
											),
											' ','</r><r>')+'</r>' AS XML) attr
							) split
							CROSS APPLY split.attr.nodes('r') s(n)
			 ) A
		IF NOT EXISTS (SELECT * FROM oracleTableSpaces OTS
				INNER JOIN (SELECT objId FROM oracleObjects O WHERE O.subClientId = @subClientId) T
				ON OTS.id = T.objId)
			OR
			  (SELECT ISNULL(attrVal,0) FROM APP_InstanceProp AIP WHERE AIP.componentNameId = @subClientId AND attrName = 'DB2 PureScaleInstance'
			   AND ISNULL(@jobStartTime,dbo.GetUnixTime(GETUTCDATE())) BETWEEN created AND (CASE WHEN modified = 0 THEN dbo.GetUnixTime(GETUTCDATE()) ELSE modified END)) = 1
		BEGIN
			INSERT	INTO @tempClientList
			SELECT DISTINCT PhysicalClientId
			FROM @PhysicalNodeMapping
		END
		ELSE
		BEGIN
			INSERT	INTO @tempClientList
			SELECT DISTINCT PhysicalClientId
			FROM @PhysicalNodeMapping PM INNER JOIN
			(SELECT  CAST(REPLACE(SUBSTRING(name,CHARINDEX('_NODE',name),LEN(name)),'_NODE','') AS INT) NodeId
				FROM oracleTableSpaces OTS
				INNER JOIN (SELECT objId FROM oracleObjects O WHERE O.subClientId = @subClientId) T
				ON OTS.id = T.objId) N
			ON PM.NodeId = N.NodeId
		END
	END
	INSERT	INTO @tempClientList
	SELECT	DISTINCT O.clientid
	FROM	APP_OracleRacInstance O, @tempBkp B
	WHERE	O.instaceId = B.t_instanceId
		AND	ISNULL(B.t_instanceId, 0) > 1
	--get destination host for FLR
	IF @jobAppTypeId IN (84, 107) OR @isFLR > 0
	BEGIN
		SET @jobTime=(	SELECT TOP 1 t_jobTime FROM @tempBkp)
		IF @isFLR > 0
			SET @repSetId=(	SELECT	TOP 1 convert(integer, p.attrVal)
					FROM	@tempBkp, APP_Application a, APP_BackupSetProp p
					WHERE	t_subclientId=a.id AND p.componentNameId=a.backupSet AND
						p.attrName = N'FS FileReplication RepSet' AND
						(@jobTime=0 AND p.modified=0 OR (p.modified>@jobTime OR p.modified=0) and
						p.created<=@jobTime)	)
		ELSE
			SET @repSetId=(	SELECT TOP 1 backupset FROM @tempBkp, APP_Application WHERE t_subclientId=id	)
		INSERT INTO @tempClientList
		SELECT convert(integer, attrVal)
		FROM	APP_BackupSetProp
		WHERE	componentNameId=@repSetId AND attrName = N'FLR Destination HostId' AND
			(@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
	END
	IF @bkpOpType IN (4, 59, 60, 65) AND @jobAppTypeId = 106 -- If streaming backup or snap back and apptype id VSA, check for VSA APP Aware  client id
	BEGIN
			INSERT INTO @tempClientList
			SELECT app.clientId
				FROM JMVSAAppJobLink jobvs WITH (NOLOCK)
				INNER JOIN JMBkpStats jb   WITH (NOLOCK) ON
					jb.jobid = jobvs.childJobId
				INNER JOIN APP_Application app WITH (NOLOCK) ON
					app.id = jb.appId
				WHERE jobvs.parentJobId = @id
		 END
	--get proxy server for snap bakp jobs: optype = SNAPBACKUP (59) OR appType = CV_APPTYPE_VIRTUAL_SERVER (106)
	IF @bkpOpType IN (59, 60, 65)
		SET @proxyClId = ISNULL((	SELECT	top 1 cast(attrVal as integer)
						FROM	APP_subclientProp JOIN @tempBkp ON componentNameId = t_subclientId
						WHERE	attrname = 'Snap copy : proxy to use' AND modified = 0), 0)
	IF @jobAppTypeId = 106
	BEGIN
		SET @proxyClId = ISNULL((	SELECT	top 1 cast(attrVal as integer)
						FROM	APP_subclientProp JOIN @tempBkp ON componentNameId = t_subclientId
						WHERE	attrname = 'Proxy Host' AND modified = 0), 0)
		--For virtual server iDA, get the member servers also
        DECLARE @i_xml XML
        DECLARE @clientId INT
        DECLARE @v_instanceId INT
        DECLARE @v_appId INT
        SELECT @clientId = clientId FROM APP_Application WHERE id = (SELECT TOP 1 t_subclientId FROM @tempBkp)
        SELECT @v_instanceId = instance FROM APP_Application WHERE id = (SELECT TOP 1 t_subclientId FROM @tempBkp)
        SELECT @v_appId = (SELECT TOP 1 t_subclientId FROM @tempBkp)
        SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempBkp)
		INSERT	INTO @tempClientList
		SELECT	top 1 cast(attrVal as integer) FROM APP_InstanceProp
		WHERE	componentNameId = @v_instanceId
		AND	attrName = 'FBR Unix MA'
		AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
        --From Client props
		SET    @i_xml =  CAST(REPLACE((select top 1 attrVal   FROM APP_ClientProp, @tempBkp WHERE componentNameId = @clientId AND attrName = 'Vs Member Servers' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)), 'UTF-8', 'UTF-16') AS XML)
        SET @handle = 0
        EXEC sp_xml_preparedocument @handle OUTPUT, @i_xml
        INSERT INTO @tempClientList
        SELECT clientId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientId INT)
        INSERT INTO @vsaMerberSrvGroups
        SELECT clientGroupId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientGroupId INT) where clientGroupId IS NOT NULL
        EXEC sp_xml_removedocument @handle
        --From Subclient props
        SELECT @i_xml = attrVal FROM APP_SubClientProp, @tempBkp WHERE componentNameId = @v_appId AND attrName = 'Virtual Server Proxy Client List' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
        SET @handle = 0
        EXEC sp_xml_preparedocument @handle OUTPUT, @i_xml
        INSERT INTO @tempClientList
        SELECT clientId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientId INT)
        INSERT INTO @vsaMerberSrvGroups
        SELECT clientGroupId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientGroupId INT) where clientGroupId IS NOT NULL
        EXEC sp_xml_removedocument @handle
        --From Instance props
        SELECT @i_xml = attrVal FROM APP_InstanceProp, @tempBkp WHERE componentNameId = @v_instanceId AND attrName = 'Vs Member Servers' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
        SET @handle = 0
        EXEC sp_xml_preparedocument @handle OUTPUT, @i_xml
        INSERT INTO @tempClientList
        SELECT clientId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientId INT)
        INSERT INTO @vsaMerberSrvGroups
        SELECT clientGroupId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientGroupId INT) where clientGroupId IS NOT NULL
        EXEC sp_xml_removedocument @handle
        INSERT INTO @tempClientList
        SELECT DISTINCT CG.clientId FROM @vsaMerberSrvGroups V
        INNER JOIN APP_ClientGroupAssoc CG
        ON V.cgId = CG.clientGroupId
    END
	ELSE IF @jobAppTypeId = 64 --Distributed iDA: Need to fetch Master Node and/or Data Access Nodes
	BEGIN
		SELECT @jobTime = t.t_jobTime FROM @tempBkp t
		SELECT @subClientId = t.t_subclientId FROM @tempBkp t
		SELECT	@distClusterType = attrVal FROM APP_InstanceProp
		WHERE	componentNameId = (SELECT TOP 1 t.t_instanceId FROM @tempBkp t)
			AND attrName = 'Distributed Cluster Type'
			AND modified = 0
		IF @distClusterType = 1 --GREENPLUM
		BEGIN
			INSERT	INTO @tempClientList
			SELECT	attrVal FROM APP_InstanceProp
			WHERE	componentNameId = (SELECT TOP 1 t.t_instanceId FROM @tempBkp t)
				AND	attrName = 'Greenplum Master Client Id'
				AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
		END
		ELSE --HADOOP, GPFS, UXFS
		BEGIN
			INSERT	INTO @tempClientList
			SELECT	attrVal FROM APP_InstanceProp
			WHERE	componentNameId = (SELECT TOP 1 t.t_instanceId FROM @tempBkp t)
				AND	attrName = 'Coordinator Node'
				AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
			DECLARE @xmlStr varchar(1024)
			SELECT @xmlStr = attrVal FROM APP_SubClientProp WHERE componentNameId = @subclientId AND attrName = 'Data Access Nodes' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
			SELECT @i_xml = @xmlStr
			SET @xmlHandle = 0
			EXEC sp_xml_preparedocument @xmlHandle OUTPUT, @i_xml
			INSERT	INTO @tempClientList
			SELECT	clientId
			FROM	OPENXML (@xmlHandle, 'App_DataAccessNodes/dataAccessNodes', 1) with (clientId INT)
			EXEC sp_xml_removedocument @xmlHandle
		END
    END
	ELSE IF @jobAppTypeId = 137 -- Exchange one pass agent
    BEGIN
          DECLARE @indexServerId INT
          SET @indexServerId = ISNULL((	SELECT	top 1 cast(attrVal as integer)
                   FROM APP_IDAProp P, APP_iDAName N, @tempClientList T
                   WHERE T.clientId = N.clientId AND N.apptypeId = @jobAppTypeId AND P.componentNameId = N.id AND
                   P.attrname = 'OnePass Index Server' AND P.modified = 0), 0)
          INSERT INTO @tempClientList VALUES (@indexServerId)
    END
    IF @jobAppTypeId = 53 --Exchange
    BEGIN
        DECLARE	@e_clId INTEGER
        SELECT @e_clId = clientId FROM APP_Application WHERE id = (SELECT TOP 1 t_subclientId FROM @tempBkp)
        SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempBkp)
        INSERT INTO @tempClientList
        SELECT C.id FROM APP_ClientProp P, APP_Client C WHERE P.attrName = C.net_hostname AND P.componentNameId = @e_clId AND P.attrType = 125 AND (@jobTime=0 AND P.modified=0 OR (P.modified>@jobTime OR P.modified=0) and P.created<=@jobTime)
    END
    ELSE IF @jobAppTypeId = 81 --MSSQL
    BEGIN
        DECLARE @sql_xml XML
        DECLARE @sql_instanceId INT
            SELECT @sql_instanceId = instance FROM APP_Application WHERE id = (SELECT TOP 1 t_subclientId FROM @tempBkp)
            SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempBkp)
        SELECT @sql_xml = attrVal FROM APP_InstanceProp WHERE componentNameId = @sql_instanceId AND attrName = 'Availability Replicas' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
        SET @handle = 0
        EXEC sp_xml_preparedocument @handle OUTPUT, @sql_xml
            INSERT INTO @tempClientList
        SELECT clientId FROM OPENXML (@handle, '/App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList/replicaClient', 1) with (clientId INT)
        EXEC sp_xml_removedocument @handle
    END
    ELSE IF @jobAppTypeId = 133
    BEGIN
        SELECT @clientId = clientId FROM APP_Application WHERE id = (SELECT TOP 1 t_subclientId FROM @tempBkp)
        SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempBkp)
        SELECT @cc_client = attrVal FROM APP_ClientProp WHERE componentNameId = @clientId AND attrName = 'Object Server Member Servers List' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
        IF LEN(@cc_client) > 0
        BEGIN
        INSERT INTO @tempClientList
                SELECT n.r.value('.', 'VARCHAR(255)') FROM (SELECT CAST('<r>'+replace(@cc_client, ':', '</r><r>')+'</r>' as XML)) as s(XMLCol) CROSS APPLY s.XMLCol.nodes('r') as n(r)
        END
    END
    ELSE IF @jobAppTypeId = 134 --CloudConnector
    BEGIN
        SELECT @clientId = clientId FROM APP_Application WHERE id = (SELECT TOP 1 t_subclientId FROM @tempBkp)
        SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempBkp)
		SET @instanceId = (SELECT TOP 1 t_instanceId FROM @tempBkp t)
		SELECT	@cloudAppsInstType = ISNULL(attrVal, 0) FROM APP_InstanceProp
		WHERE	componentNameId = @instanceId
			AND attrName = 'Cloud Apps Instance Type'
			AND modified = 0
        IF @cloudAppsInstType = 3 --Salesforce
        BEGIN
		--salesfornce is not having proxy xml
            INSERT  INTO @tempClientList
            SELECT  attrVal FROM APP_InstanceProp
            WHERE   componentNameId = @instanceId
                AND attrName = 'Salesforce backup client'
                AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
        END
		ELSE
        BEGIN
			SET @ProxyClientXml =ISNULL((select attrVal FROM APP_InstanceProp (NOLOCK)  WHERE componentNameId = @instanceId AND attrVal like '%App_GeneralCloudProperties%' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)), '<App_GeneralCloudProperties />')
			INSERT INTO @tempClientList
				SELECT @ProxyClientXml.value('(/App_GeneralCloudProperties/proxyServers/@clientId)[1]', 'int')
			INSERT INTO @tempClientList
				SELECT M.x.value('./@clientId', 'int') FROM @ProxyClientXml.nodes('/App_GeneralCloudProperties/memberServers/client') M(x)
			INSERT INTO @tempClientList
				SELECT clientId FROM APP_ClientGroupAssoc(NOLOCK)
				WHERE clientGroupId IN (SELECT M.x.value('./@clientGroupId', 'int') FROM @ProxyClientXml.nodes('/App_GeneralCloudProperties/memberServers/client') M(x))
			SET @ProxyClientXml =ISNULL((SELECT TOP 1 attrVal FROM APP_InstanceProp, @tempBkp WHERE componentNameId = @instanceId AND attrName = 'Vs Member Servers' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)), '<App_GeneralCloudProperties />')
			SET @handle = 0
			EXEC sp_xml_preparedocument @handle OUTPUT, @ProxyClientXml
			INSERT INTO @tempClientList
				SELECT clientId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientId INT)
			INSERT INTO @vsaMerberSrvGroups
				SELECT clientGroupId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientGroupId INT) where clientGroupId IS NOT NULL
			EXEC sp_xml_removedocument @handle
			INSERT INTO @tempClientList
				SELECT DISTINCT CG.clientId FROM @vsaMerberSrvGroups V
				INNER JOIN APP_ClientGroupAssoc CG ON V.cgId = CG.clientGroupId
		END
    END
ELSE IF @jobAppTypeId = 78 -- SharePoint
		BEGIN
			SELECT @clientId = clientId FROM APP_Application(NOLOCK) WHERE id = (SELECT TOP 1 t_subclientId FROM @tempBkp)
			SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempBkp)
			SET @ProxyClientXml = ISNULL((SELECT REPLACE(attrVal, 'UTF-8', 'UTF-16') FROM APP_IDAProp(NOLOCK) WHERE componentNameId IN (SELECT id FROM App_IdaName(NOLOCK) WHERE clientId = @clientId) AND attrName = 'Sharepoint Member Servers' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) AND created<=@jobTime)), '<App_MemberServers />')
			INSERT INTO @tempClientList
				SELECT M.x.value('./@clientId', 'int') FROM @ProxyClientXml.nodes('/App_MemberServers/memberServers/client') M(x)
			INSERT INTO @tempClientList
				SELECT clientId FROM APP_ClientGroupAssoc(NOLOCK)
				WHERE clientGroupId IN (SELECT M.x.value('./@clientGroupId', 'int') FROM @ProxyClientXml.nodes('/App_MemberServers/memberServers/client') M(x))
		END
ELSE IF @jobAppTypeId = 139 --Azure AD
	BEGIN
		SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempBkp)
		SELECT @aadJobClientId = clientId FROM APP_Application WHERE id = (SELECT TOP 1 t_subclientId FROM @tempBkp)
	END
	-- CV_APPTYPE_SRM_WINFS & CV_APPTYPE_SRM_ORACLE & CV_APPTYPE_SRM_SQL & CV_APPTYPE_SRM_NAS & CV_APPTYPE_SRM_NETWARE & CV_APPTYPE_SRM_UNIXFS & CV_APPTYPE_SRM_EXCHG & CV_APPTYPE_SRM_SHAREPOINT
	ELSE IF @jobAppTypeId >= 600 AND @jobAppTypeId <= 607
		SET @proxyClId = ISNULL((	SELECT	top 1 cast(attrVal as integer)
						FROM	APP_iDAProp P, APP_iDAName N, @tempClientList T
						WHERE	T.clientId = N.clientId AND N.apptypeId = @jobAppTypeId AND P.componentNameId = N.id AND P.attrname = 'SRM Proxy Client' AND P.modified = 0), 0)
	-- get source client for SILO jobs
	INSERT INTO @tempClientList
	SELECT	attributeValueInt
	FROM	JMJobOptions
	WHERE	jobId = @id AND attributeName = 'SILO Source Client ID'
	IF EXISTS(SELECT jobid FROM JMJobStats WHERE opType = 4 AND jobid = @id)
	BEGIN
		-- get proxy clients for netapp jobs
		INSERT INTO @tempClientList
		SELECT IDAP.attrVal FROM APP_Application App
			INNER JOIN APP_IDAName IDA
			ON App.clientId = IDA.clientId AND IDA.appTypeId = 33
			INNER JOIN APP_IDAProp IDAP
			ON IDAP.componentNameId = IDA.id
			AND IDAP.attrName IN ('FPOLICY PRIMARY CLIENT' , 'FPOLICY SECONDARY CLIENT' )
			AND IDAP.attrVal <> '0' AND IDAP.modified = 0
			WHERE App.id IN (SELECT appId FROM JMBkpStats WHERE jobid = @id)
		-- get proxy clients for bluearc/celerra one pass jobs
		INSERT INTO @tempClientList
		SELECT SP.attrVal FROM APP_Application App
		INNER JOIN APP_SubClientProp SP
		ON App.id = SP.componentNameId
		AND SP.attrName = 'Turbo NAS Proxy Client' and SP.modified = 0
		WHERE App.id IN (SELECT appId FROM JMBkpStats WHERE jobid = @id)
	END
    --Get Edge ClientId
    IF @isEdge > 0
		INSERT INTO @tempClientList
        SELECT t_targetClientId FROM @tempBkp
    --get indexing v2 Index server client id
	INSERT INTO @tempClientList
    SELECT IDX.currentIdxServer FROM @tempBkp J
    INNER JOIN APP_BackupsetName B
	ON J.t_bkpSetId = B.id
	INNER JOIN App_IndexDBInfo IDX
	ON B.GUID = IDX.backupSetGUID
END
ELSE
BEGIN
	INSERT INTO @tempRst
	SELECT srcClientId, destClientId, bkpsetId, (select I.jobStartTime from JMJobInfo I where I.jobId = R.jobId),instanceID FROM JMRstJobInfo R WHERE commcellid=@ccId AND jobId=@id
	UNION
	SELECT srcClientId, destClientId, bkpsetId, servStartTime,instanceID FROM JMRestoreStats WHERE commcellid=@ccId AND jobId=@id
	SELECT	@jobStartTime = servStartTime, @jobEndTime = servEndTime
	FROM	JMRestoreStats WHERE jobId = @id AND commcellId = @ccId
	IF (@jobStartTime = 0)
		SELECT	@jobStartTime = jobStartTime, @jobEndTime = 0
		FROM	JMJobInfo WHERE jobId = @id AND commCellId = @ccId
	IF EXISTS (select * from @tempRst)
	BEGIN
		SET @jobType = 2
		SET @jobAppTypeId = ISNULL((SELECT TOP 1 appTypeId FROM APP_Application JOIN @tempRst ON clientId=srcClientId AND backupset=t_bkpSetId), 0)
		--get destination host for FLR
		IF @jobAppTypeId IN (84, 107)
		BEGIN
			SET @jobTime=(	SELECT t_jobTime FROM @tempRst)
			INSERT INTO @tempClientList
			SELECT convert(integer, attrVal)
			FROM	APP_BackupSetProp, @tempRst
			WHERE	componentNameId=t_bkpSetId AND attrName = N'FLR Destination HostId' AND	(@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
		END
		ELSE IF @jobAppTypeId = 80
        BEGIN
			INSERT INTO @tempClientList
			SELECT DISTINCT racHostId
			FROM    JMOracleRACClientsUsed
			WHERE   commcellid=@ccId AND jobId=@id
		END
		ELSE IF @jobAppTypeId IN (128)
		BEGIN
			SET @xmlText = ISNULL((SELECT xmlJobInfo FROM JMjobStats WHERE jobId = @id), '')
			IF @xmlText is not null AND LEN(@xmlText) > 0
			BEGIN
				EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
				--restore
				SET @node = 'JobManager_RstJobDetailsXml/documentumJob/docInfo'
				INSERT INTO @tempClientList
				SELECT ISNULL(clientId,0) as clientId
				FROM OPENXML (@handle, @node, 1) WITH (clientId int)
				EXEC sp_xml_removedocument @handle
			END
		END
ELSE IF @jobAppTypeId = 137
		BEGIN
			--check if exchange servers are needed
			IF EXISTS(SELECT * FROM JMRestoreStats WHERE jobId = @id)
				SET @exchJobClientId = ISNULL((SELECT srcClientId FROM JMRestoreStats J WHERE jobId = @id), 0)
			ELSE IF EXISTS(SELECT * FROM JMRstJobInfo WHERE jobId = @id)
				SET @exchJobClientId = ISNULL((SELECT srcClientId FROM JMRstJobInfo J WHERE jobId = @id), 0)
		END
		ELSE IF @jobAppTypeId = 106
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#vmProp') IS NOT NULL
			DROP TABLE #vmProp
			CREATE TABLE #vmProp (jobid INT,  SourceVM NVARCHAR(255), destVM NVARCHAR(255), VMJobStatus INT, Proxy NVARCHAR(255), hostName NVARCHAR(255), vmRestoredSize bigINT, TransportMode NVARCHAR(255),VMfailureReason NVARCHAR(max))
			--FOR V1 INDEX
			INSERT INTO #vmProp(jobid,SourceVM,destVM,VMJobStatus,proxy,hostName,vmRestoredSize,TransportMode,VMfailureReason)
			SELECT jobid,sourceVMName,[vmDestinationVM],cast(isnull([vmStatus],0) as int),[vmAgent],[vmhost],cast(isnull([vmRestoredSize],0) as bigint),[vmTransportMode],[vmFailureReason]
			FROM
			(
			SELECT
				JM.jobId,
				attrName,
				VMP.vmclientid as clientId,
				sc.name as sourceVMName,
				attrVal
			FROM
				app_vmprop VMP
				INNER JOIN 	jmrestorestats JM WITH (nolock)
				ON VMP.jobid = JM.jobid
AND JM.apptype=106
				INNER JOIN app_client SC WITH (nolock)
				ON VMP.vmclientid = SC.id
			WHERE JM.jobid = @id
			) t
			PIVOT(
			MAX(attrVal)
			FOR attrName IN ([vmAgent],[vmhost],[vmRestoredSize],[vmTransportMode],[vmDestinatiONVM],[vmStatus],[vmFailureReasON])
			) AS pivot_table
			--FOR V2 INDEX
			INSERT INTO #vmProp(jobid,SourceVM,destVM,VMJobStatus,proxy,hostName,[vmRestoredSize],TransportMode,VMfailureReasON)
			SELECT jobid,sourceVMName,[vmDestinatiONVM],cast(isnull([vmStatus],0) as int),[vmAgent],[vmhost],cast(isnull([vmRestoredSize],0) as bigint),[vmTransportMode],[vmFailureReasON]
			FROM
			(
				SELECT
					JM.jobId,
					attrName,
					VMP.vmclientid as clientId,
					sc.name as sourceVMName,
					attrVal
				FROM
      				jmrestorestats JM WITH (nolock)
					INNER JOIN jmjobdatalink DL WITH (nolock)
					ON JM.jobId = DL.parentJobId
AND JM.APPTYPE=106
AND DL.linkType = 7
					INNER JOIN   app_vmprop VMP
					ON DL.childjobid = VMP.jobid
					inner join app_client SC WITH (nolock)
					ON VMP.vmclientid = SC.id
				WHERE JM.jobid = @id
			) t
			PIVOT(
				MAX(attrVal)
				FOR attrName IN ([vmAgent],[vmhost],[vmRestoredSize],[vmTransportMode],[vmDestinatiONVM],[vmStatus],[vmFailureReasON])
			) AS pivot_table
			UNION ALL
			SELECT jobid,sourceVMName,[vmDestinatiONVM],cast(isnull([vmStatus],0) as int),[vmAgent],[vmhost],cast(isnull([vmRestoredSize],0) as bigint),[vmTransportMode],[vmFailureReasON]
			FROM
			(
				SELECT
					JM.jobId,
					attrName,
					VMP.vmclientid as clientId,
					sc.name as sourceVMName,
					attrVal
				FROM
      				JMRstJobInfo JM WITH (nolock)
					INNER JOIN   app_vmprop VMP
					ON JM.jobId = VMP.jobid AND JM.APPTYPE=106
					inner join app_client SC WITH (nolock)
					ON VMP.vmclientid = SC.id
				WHERE JM.jobid = @id
			) t
			PIVOT(
				MAX(attrVal)
				FOR attrName IN ([vmAgent],[vmhost],[vmRestoredSize],[vmTransportMode],[vmDestinatiONVM],[vmStatus],[vmFailureReasON])
			) AS pivot_table
			INSERT INTO @tempClientList
			SELECT CAST(value AS INT) FROM TM_JobOptions where optionId = 162972553 and jobId = @id
			UNION
			SELECT DISTINCT C.Id FROM #vmProp VM
			INNER JOIN APP_Client C WITH (NOLOCK) ON C.name = VM.Proxy OR C.displayName = VM.Proxy
			IF OBJECT_ID('tempdb.dbo.#vmProp') IS NOT NULL
			DROP TABLE #vmProp
		END
		ELSE IF @jobAppTypeId = 103 AND EXISTS(select * from TM_JobXMLOptions where jobId = @id)
		BEGIN
			SET @instanceId = (SELECT t_instanceId FROM @tempRst)
			INSERT INTO @PhysicalNodeMapping
			SELECT SUBSTRING(value,0,CHARINDEX(',',value)),SUBSTRING(value,CHARINDEX(',',value)+1,LEN(value)) AS mapping
			FROM (select s.n.value('.','varchar(255)') AS value
						 FROM
								(select CAST('<r>'+REPLACE((
												SELECT attrVal FROM APP_InstanceProp
												WHERE
												componentNameId = @instanceId
												AND ISNULL(@jobStartTime,dbo.GetUnixTime(GETUTCDATE())) BETWEEN created AND (CASE WHEN modified = 0 THEN dbo.GetUnixTime(GETUTCDATE()) ELSE modified END)
												AND attrName like 'DB2 Partition Clients'
												),
												' ','</r><r>')+'</r>' AS XML) attr
								) split
								CROSS APPLY split.attr.nodes('r') s(n)
				 ) A
			INSERT INTO @tempClientList
			SELECT DISTINCT PhysicalClientId
			FROM @PhysicalNodeMapping PM INNER JOIN
			(SELECT CAST(REPLACE(SUBSTRING(name,CHARINDEX('_NODE',name),LEN(name)),'_NODE','') AS INT) NodeId
				FROM
				(
					SELECT S.N.value('@val','nvarchar(255)') name
						FROM (select CAST(xmlValue AS XML) val from TM_JobXMLOptions where jobId = @id) jobXML
						CROSS APPLY jobXML.val.nodes('TMMsg_JobOption/restoreOptions/fileOption/sourceItem') S(N)
				) A
			) NodeList
			ON PM.NodeId = NodeList.NodeId
		END
		ELSE IF @jobAppTypeId = 64 --Distributed iDA: Need to fetch Master Node and/or Data Access Nodes
		BEGIN
			SET @jobTime = (SELECT TOP 1 t_jobTime FROM @tempRst)
            IF EXISTS (SELECT * FROM JMJobOptions WHERE jobId = @id AND attributeName = 'SYB_DEST_INST_ID')
                SELECT @instanceId = CAST(attributeValue AS INT) FROM JMJobOptions WHERE jobId = @id AND attributeName = 'SYB_DEST_INST_ID'
            ELSE
                SET @instanceId = (SELECT TOP 1 t_instanceId FROM @tempRst)
			SELECT	@distClusterType = attrVal FROM APP_InstanceProp
			WHERE	componentNameId = @instanceId
				AND attrName = 'Distributed Cluster Type'
				AND modified = 0
			IF @distClusterType = 1 --GREENPLUM
			BEGIN
				INSERT	INTO @tempClientList
				SELECT	attrVal FROM APP_InstanceProp
				WHERE	componentNameId = @instanceId
					AND	attrName = 'Greenplum Master Client Id'
					AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
			END
			ELSE --HADOOP, GPFS, UXFS
			BEGIN
				INSERT	INTO @tempClientList
				SELECT	attrVal FROM APP_InstanceProp
				WHERE	componentNameId = @instanceId
					AND	attrName = 'Coordinator Node'
					AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
                IF EXISTS (SELECT * FROM TM_JobXMLOptions WHERE jobId = @id)
                BEGIN
                    SELECT @i_xml = xmlValue FROM TM_JobXMLOptions WHERE jobId = @id
                    SET @xmlHandle = 0
                    EXEC sp_xml_preparedocument @xmlHandle OUTPUT, @i_xml
                    INSERT	INTO @tempClientList
                    SELECT	clientId
                    FROM	OPENXML (@xmlHandle, 'TMMsg_JobOption/restoreOptions/distributedAppsRestoreOptions/dataAccessNodes/dataAccessNodes', 1) with (clientId INT)
                    EXEC sp_xml_removedocument @xmlHandle
                END
			END
		END
        ELSE IF @jobAppTypeId = 134 --CloudApps apptype
        BEGIN
			SELECT @clientId = (SELECT TOP 1 destClientId FROM @tempRst)
			SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempRst)
            SET @instanceId = (SELECT TOP 1 t_instanceId FROM @tempRst)
		    SELECT  @cloudAppsInstType = ISNULL(attrVal, 0) FROM APP_InstanceProp (NOLOCK)
            WHERE   componentNameId = @instanceId
                AND attrName = 'Cloud Apps Instance Type'
                AND modified = 0
			IF @cloudAppsInstType = 3 --Salesforce
            BEGIN
			--salesfornce is not having proxy xml
                INSERT  INTO @tempClientList
                SELECT  attrVal FROM APP_InstanceProp
                WHERE   componentNameId = @instanceId
                    AND attrName = 'Salesforce backup client'
                    AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)
            END
			ELSE
            BEGIN
				SET @ProxyClientXml =ISNULL((select attrVal FROM APP_InstanceProp (NOLOCK)  WHERE componentNameId = @instanceId AND attrVal like '%App_GeneralCloudProperties%' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)), '<App_GeneralCloudProperties />')
				INSERT INTO @tempClientList
					SELECT @ProxyClientXml.value('(/App_GeneralCloudProperties/proxyServers/@clientId)[1]', 'int')
				INSERT INTO @tempClientList
					SELECT M.x.value('./@clientId', 'int') FROM @ProxyClientXml.nodes('/App_GeneralCloudProperties/memberServers/client') M(x)
				INSERT INTO @tempClientList
					SELECT clientId FROM APP_ClientGroupAssoc(NOLOCK)
					WHERE clientGroupId IN (SELECT M.x.value('./@clientGroupId', 'int') FROM @ProxyClientXml.nodes('/App_GeneralCloudProperties/memberServers/client') M(x))
				SET @ProxyClientXml =ISNULL((SELECT TOP 1 attrVal FROM APP_InstanceProp, @tempRst WHERE componentNameId = @instanceId AND attrName = 'Vs Member Servers' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)), '<App_GeneralCloudProperties />')
				SET @handle = 0
				EXEC sp_xml_preparedocument @handle OUTPUT, @ProxyClientXml
				INSERT INTO @tempClientList
					SELECT clientId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientId INT)
				INSERT INTO @vsaMerberSrvGroups
					SELECT clientGroupId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientGroupId INT) where clientGroupId IS NOT NULL
				EXEC sp_xml_removedocument @handle
				INSERT INTO @tempClientList
					SELECT DISTINCT CG.clientId FROM @vsaMerberSrvGroups V
					INNER JOIN APP_ClientGroupAssoc CG ON V.cgId = CG.clientGroupId
			END
        END
ELSE IF @jobAppTypeId = 78 -- SharePoint
		BEGIN
			SELECT @clientId = clientId FROM APP_Application(NOLOCK) WHERE id = (SELECT TOP 1 destClientId FROM @tempRst)
			SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempRst)
			SET @ProxyClientXml = ISNULL((SELECT REPLACE(attrVal, 'UTF-8', 'UTF-16') FROM APP_IDAProp(NOLOCK) WHERE componentNameId IN (SELECT id FROM App_IdaName(NOLOCK) WHERE clientId = @clientId) AND attrName = 'Sharepoint Member Servers' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) AND created<=@jobTime)), '<App_MemberServers />')
			INSERT INTO @tempClientList
				SELECT M.x.value('./@clientId', 'int') FROM @ProxyClientXml.nodes('/App_MemberServers/memberServers/client') M(x)
			INSERT INTO @tempClientList
				SELECT clientId FROM APP_ClientGroupAssoc(NOLOCK)
				WHERE clientGroupId IN (SELECT M.x.value('./@clientGroupId', 'int') FROM @ProxyClientXml.nodes('/App_MemberServers/memberServers/client') M(x))
		END
		ELSE IF @jobAppTypeId = 135
		BEGIN
			SELECT @instanceId = (SELECT TOP 1 t_instanceId FROM @tempRst)
			INSERT into @tempClientList
			SELECT  DISTINCT S.Data
			FROM
					APP_InstanceProp IP
					CROSS APPLY dbo.SplitString(IP.attrVal, '+') S
			WHERE IP.attrName = 'Database Clients' AND IP.modified = 0 AND IP.componentNameId = @instanceId
		END
ELSE IF @jobAppTypeId = 139 --Azure AD
		BEGIN
			SELECT @aadJobClientId = (SELECT TOP 1 destClientId FROM @tempRst)
			SELECT @jobTime = (SELECT TOP 1 t_jobTime FROM @tempRst)
		END
		INSERT INTO @tempClientList
		SELECT CAST(attributeValue AS INT)
		FROM    JMJobOptions
WHERE   jobId = @id AND commcellId = @ccId AND attributeId = 46  AND attributeName = 'MediaAgent For Restore Job'
		INSERT INTO @tempClientList SELECT destClientId FROM @tempRst
	END
	ELSE
	BEGIN
		SET @jobType = 3
		SET @jobAppTypeId = 0
	END
END
IF (ISNULL(@jobStartTime, 0) = 0 AND ISNULL(@jobEndTime, 0) = 0)
BEGIN
	SELECT	@jobStartTime = servStart, @jobEndTime = servEnd
	FROM	JMAdminJobStatsTable WHERE jobId = @id AND commcellId = @ccId
	IF (@jobStartTime = 0)
		SELECT	@jobStartTime = jobStartTime, @jobEndTime = 0
		FROM	JMJobInfo WHERE jobId = @id AND commCellId = @ccId
END
IF (@jobStartTime IS NULL)
	SET @jobStartTime = 0
IF (@jobEndTime IS NULL)
	SET @jobEndTime = 0
-- get web server for Legal Hold
INSERT INTO @tempClientList
SELECT TOP 1 cast(attrVal as integer)
FROM	APP_BackupSetProp
WHERE	attrName = 'Prefered Web Server ClientId' AND modified = 0 AND
	(componentNameId IN (select t_bkpsetId from @tempBkp) OR componentNameId IN (select t_bkpsetId from @tempRst))
IF @proxyClId > 0
	INSERT INTO @tempClientList VALUES (@proxyClId)
-- get CI engine
SET @CIJobCloudId = (CASE	WHEN @jobAppTypeId = 93								-- 93 = CV_APPTYPE_CONTENT_INDEXING_IDA
					THEN (select t_cloudId from @tempBkp)
				WHEN EXISTS (select * from JMAdminJobStatsTable where jobId=@id and optype=53)	-- 53 = OFFLINECONTENTINDEX
					THEN (select cloudId from JMAdminJobStatsTable where jobId=@id and optype=53)
				WHEN EXISTS (select * from JMAdminJobInfoTable where jobId=@id and optype=53)	-- 53 = OFFLINECONTENTINDEX
					THEN (select cloudId from JMAdminJobInfoTable where jobId=@id and optype=53)
				ELSE 0 END)
-- get client ID for tagging jobs
IF	EXISTS (select * from JMAdminJobStatsTable where jobId=@id and optype=64)	-- 64 = INFOMGMT
	OR
	EXISTS (select * from JMAdminJobInfoTable where jobId=@id and optype=64)
BEGIN
	DECLARE	@xmlJobInfo	varchar(MAX)
	DECLARE @iDoc		int
	SELECT @xmlJobInfo = xmlJobInfo FROM JMjobStats WHERE jobId=@id
	IF @xmlJobInfo is not null AND LEN(@xmlJobInfo) > 0
	BEGIN
		EXEC sp_xml_preparedocument @iDoc OUTPUT, @xmlJobInfo
		SET @CIJobCloudId = (select * from OPENXML(@iDoc, '/JobManager_AdminJobDetailsXml/compPolicyJobInfo/taggingPhaseInfo', 0) WITH (cloudId nvarchar(128) '@cloudId'))
		SET @webSvrClName = (select * from OPENXML(@iDoc, '/JobManager_AdminJobDetailsXml/compPolicyJobInfo/compliancePolicyInfo', 0) WITH (webServerClientName nvarchar(128) '@webServerClientName'))
		EXEC sp_xml_removedocument @idoc
		IF @webSvrClName is not null and @webSvrClName <> ''
		BEGIN
			SET @webSvrClId = ISNULL((select id from APP_Client where net_hostname = @webSvrClName), 0)
			IF @webSvrClId = 0
				SET @webSvrClId = ISNULL((select id from APP_Client where name = @webSvrClName), 0)
		END
		IF @webSvrClId > 0
			INSERT INTO @tempClientList SELECT @webSvrClId
		SET @isAdminClId = 1
	END
END
--get dr orchestration client
IF	EXISTS (SELECT 1 FROM jmadminjobstatstable WHERE jobid =@id and optype=126)	-- 126 = DRORCHESTRATION
	OR
	EXISTS (SELECT 1 from jmjobstats where jobId=@id and optype=126)
BEGIN
		DECLARE @repId INT = 0
		SELECT @repId = csInfo.n.value('@val','INT')
				FROM TM_JobXMLOptions TM
				CROSS APPLY xmlValue.nodes('TMMsg_JobOption/adminOpts/drOrchestrationOption/replicationInfo/replicationId') AS csInfo(n)
		WHERE jobId = @Id
	IF OBJECT_ID('tempdb..#RepGroupList') IS NOT NULL
		DROP TABLE #RepGroupList
	CREATE TABLE #RepGroupList (groupList xml)
	INSERT INTO #RepGroupList
	EXEC AppGetReplicationGroupList @user, 0
	IF OBJECT_ID('tempdb..#tempRepDetails') IS NOT NULL
	DROP TABLE #tempRepDetails
	CREATE TABLE #tempRepDetails (sourceClientId INT, destProxyClientId INT, destClientId INT)
	INSERT INTO #tempRepDetails
	SELECT
	csInfo.n.value('(taskDetail/associations/@clientId)[1]','int'),
	csInfo.n.value('(taskDetail/subTasks/options/restoreOptions/destination/destClient/@clientId)[1]','int'),
	csInfo.n.value('(taskDetail/subTasks/options/restoreOptions/virtualServerRstOption/vCenterInstance/@clientId)[1]','int')
	FROM #RepGroupList AS R
	CROSS APPLY R.groupList.nodes('TMMsg_ReplicationGroupListResp/replicationGroups') csInfo(n)
	INNER JOIN APP_VSAReplication ASSOC WITH(NOLOCK)  ON csInfo.n.value('(taskDetail/task/@taskId)[1]','int') = ASSOC.taskId
	where ASSOC.replicationId = @repId
	IF OBJECT_ID('tempdb.dbo.#tmpProxyClientInput') IS NOT NULL
		DROP TABLE #tmpProxyClientInput
	CREATE TABLE #tmpProxyClientInput (
		clientId        INTEGER,
		instance        INTEGER DEFAULT 0,
		appTypeId       INTEGER DEFAULT 0,
		subclientId     INTEGER DEFAULT 0,
	)
	INSERT INTO #tmpProxyClientInput (clientId)
	select sourceClientId from #tempRepDetails
	UNION
	select destClientId from #tempRepDetails
	IF OBJECT_ID('tempdb.dbo.#tmpProxyClientOutput') IS NOT NULL
		DROP TABLE #tmpProxyClientOutput
	CREATE TABLE #tmpProxyClientOutput(
		ClientId        INTEGER,
		instanceId      INTEGER,
		proxyClientId   INTEGER,
		ClientAppType   INTEGER,
		isIndexServer       INTEGER DEFAULT 0,  --0 meaning proxyclient, 1 meaning INDEX server
		iscloudindexServer  INTEGER DEFAULT 0,    -- 1 meaning cloud INDEX server
		cloudindexServer    INTEGER DEFAULT 0,
		isproxyclientGroup  INTEGER DEFAULT 0 , -- 1 meaning client Group
		clientGroup         INTEGER DEFAULT 0,
		subclientId         INTEGER DEFAULT 0
	)
	EXEC AppGetPRoxyClientInfo '#tmpProxyClientInput', '#tmpProxyClientOutput', 1
	INSERT INTO @tempClientList
	select proxyClientId from #tmpProxyClientOutput
	UNION
	select destProxyClientId from #tempRepDetails
	IF OBJECT_ID('tempdb.dbo.#tmpProxyClientOutput') IS NOT NULL
		DROP TABLE #tmpProxyClientOutput
	IF OBJECT_ID('tempdb.dbo.#tmpProxyClientInput') IS NOT NULL
		DROP TABLE #tmpProxyClientInput
	IF OBJECT_ID('tempdb..#tempRepDetails') IS NOT NULL
		DROP TABLE #tempRepDetails
	IF OBJECT_ID('tempdb..#RepGroupList') IS NOT NULL
		DROP TABLE #RepGroupList
END
-- get client ID for Log Monitoring jobs
IF	EXISTS (select * from JMAdminJobStatsTable where jobId=@id and optype=86)	-- 86  LOG MONITORING
BEGIN
	DECLARE @xmlvalue nvarchar(MAX)
	DECLARE @xml XML
	SELECT @xmlvalue = xmlJobinfo FROM JMJobStats WHERE jobId = @id
	----Column is of type nvarchar and not xml, on the fly cast will complain about encodig. You can merge replace and cast in one setp for easy usage.
	SELECT @xmlvalue = REPLACE(@xmlvalue,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?>','')
	SELECT @xml = CAST (@xmlvalue AS xml)
	INSERT INTO @tempClientList
	SELECT N.client.value('@clientId', 'Integer')
		FROM @xml.nodes('/JobManager_AdminJobDetailsXml/patchUpdateInfo/lmClientStatus')  AS N(client)
END
IF @CIJobCloudId > 0
BEGIN
	DECLARE	@CIClList	TABLE (t_clId int)
	INSERT INTO @CIClList
	SELECT	longval FROM APP_ComponentProp
	WHERE	componentType = 2 AND propertyTypeId = 1008 AND componentId = @CIJobCloudId
	DELETE	@CIClList
	FROM	APP_ComponentProp
	WHERE	@isAdminClId > 0 AND componentId = t_clId AND componentType = 3 AND propertyTypeId = 1009 AND
			(longVal & 4) = 0
	INSERT INTO @tempClientList SELECT t_clId FROM @CIClList
END
--UPDATE @tempClientList
--SET clientId=(select tc.id from APP_Client tc, APP_ClientProp cp
--	where cp.componentNameId=T.clientId and cp.attrName='proxy host name' and cp.modified=0 and cp.attrVal=tc.net_hostName)
--FROM @tempClientList T, APP_Platform P, APP_Client C
--WHERE C.simSystemOSId in (55, 56, 57, 58, 77, 166) AND C.id=P.clientId and C.id=T.clientId AND P.platformType=4
--get MA
INSERT INTO @tempClientList
SELECT	M.clientId FROM JMJobResourceHistory J JOIN MMHost M ON J.ClientId=M.ClientId  AND jobId=@id
-- get MA for running jobs
INSERT INTO @tempClientList
SELECT DISTINCT Id
FROM	APP_client
WHERE	net_hostName in (select CAST(mediaAgent AS nvarchar(255)) from JMRstJobInfo where jobId=@id)
	OR
	net_hostName in (select CAST(mediaAgentName AS nvarchar(255)) from JMBkpJobInfo where jobId=@id)
END
-- get MA for DDB Reconstruction job DEDUPDBSYNC_DASH
IF EXISTS(SELECT * from JMJobStats where opType = 80 and subOpType = 131 and jobId = @id)
BEGIN
INSERT INTO @tempClientList
		SELECT DISTINCT srcMaId FROM ArchJobStreamStatusHistory (NOLOCK) WHERE jobId = @id
END
--get source and destination MA for dash copy job
IF EXISTS(SELECT jobId FROM JMJobStats WHERE (opType = 104 OR (opType = 31 AND subOpType = 106)) AND jobId = @id)
BEGIN
	--Add MAs for running jobs
	INSERT INTO @tempClientList
		SELECT DISTINCT srcMaId FROM ArchJobStreamStatusHistory (NOLOCK) WHERE jobId = @id
	--Add MAs for completed jobs
	IF EXISTS(SELECT * FROM JMMisc WHERE jobId = @id AND itemType = 31)
	BEGIN
		SELECT @dc_client = data FROM JMMisc WHERE jobId = @id AND itemType = 31
		INSERT INTO @tempClientList
			SELECT n.r.value('.', 'VARCHAR(255)') FROM (SELECT CAST('<r>'+replace(@dc_client, ',', '</r><r>')+'</r>' as XML)) as s(XMLCol) CROSS APPLY s.XMLCol.nodes('r') as n(r)
	END
END
--get sidb engine ma for aux copy/dash /data verification jobs
IF EXISTS(SELECT jobId FROM JMjobStats WHERE opType IN (13, 104)AND jobId = @id)
BEGIN
	INSERT INTO @tempClientList
		 SELECT SS.clientId from JMDataCopiedStatsTable DC
              INNER JOIN archCopySIDBStore CS
ON DC.archGrpCopyId = CS.CopyId AND ((CS.Flags & 4) > 0)
              INNER JOIN IdxSIDBSubStore SS
              ON CS.SIDBStoreID = SS.SIDBStoreID
              WHERE DC.jobId = @id
END
--get sidb engine for Data verification job op type ARCHIVECHECK 31
IF EXISTS(SELECT jobId FROM JMAdminJobInfoTable WHERE opType = 31 AND cloudId > 0 AND jobId = @id) OR
	EXISTS(SELECT jobId FROM JMAdminJobStatsTable WHERE opType = 31 AND cloudId > 0 AND jobId = @id)
BEGIN
	INSERT INTO @tempClientList
		SELECT ClientId
		FROM IdxSIDBSubStore I,
			(	SELECT cloudId SIDBStoreId FROM JMAdminJobInfoTable WHERE opType = 31 AND cloudId > 0 AND jobId = @id
				UNION
				SELECT cloudId SIDBStoreId FROM JMAdminJobStatsTable WHERE opType = 31 AND cloudId > 0 AND jobId = @id) T
		WHERE I.SIDBStoreId = T.SIDBStoreId
END
--get remote MA JM_NAS_REMOTE_MA
INSERT INTO @tempClientList
	SELECT intData FROM JMMisc where jobId = @id AND itemType = 37
--get MultiNode participating nodes JM_MULTINDOE_PARTICIPATEDNODES
IF EXISTS(SELECT * FROM JMMisc WHERE jobId = @id AND itemType = 42)
BEGIN
	SELECT @dc_client = data FROM JMMisc WHERE jobId = @id AND itemType = 42
	INSERT INTO @tempClientList
		SELECT n.r.value('.', 'VARCHAR(255)') FROM (SELECT CAST('<r>'+replace(@dc_client, ',', '</r><r>')+'</r>' as XML)) as s(XMLCol) CROSS APPLY s.XMLCol.nodes('r') as n(r)
END
--get persistant recovery MA JM_PERSISTANT_RECOVERY_JOB_MA
INSERT INTO @tempClientList
	SELECT C.id FROM JMMisc J
		INNER JOIN APP_Client C
		ON J.jobId = @id AND J.itemType = 43 AND J.data = C.name
--get VAIO filter driver JM_JOB_CLIENT_USED_BY_JOB for job optype VSA_BLOCK_REPLICATION
IF EXISTS(SELECT jobId FROM JMJobStats WHERE opType = 119 AND jobId = @id)
BEGIN
	INSERT INTO @tempClientList
		SELECT intData FROM JMMisc where jobId = @id AND itemType = 69
END
--get ddb move MA list, job optype MOVEDDB = 99,  -- Move Partition, Move mount path = 125
IF EXISTS(SELECT jobId FROM JMJobStats WHERE opType in (125, 99) AND jobId = @id)
BEGIN
	INSERT INTO @tempClientList
	SELECT SourceMAClientId FROM MMDataTransferRequest R, MMDataTransferStreams S
	WHERE R.TransferId = S.TransferId AND R.JobId = @id
	INSERT INTO @tempClientList
	SELECT TargetMAClientId FROM MMDataTransferRequest R, MMDataTransferStreams S
	WHERE R.TransferId = S.TransferId AND R.JobId = @id
END
-- Add Remote Snap MA for snap related jobs
IF EXISTS(SELECT jobId FROM JMJobStats WHERE jobId = @id)
BEGIN
	IF EXISTS(SELECT jobId FROM JMMisc WHERE jobId = @id AND itemType = 32)			-- JM_SNAP_MA
	BEGIN
		INSERT INTO @tempClientList
			SELECT intData FROM JMMisc WHERE jobId = @id AND itemType = 32			-- JM_SNAP_MA
	END
END
-- Get the proxyClientId for BlrOperation Job.
-- As of now, only one proxy is suported for BlrOperation Job. So pick it directly from jobOptionsXml
-- Support for multiple proxy may come up in the future, which will require changes in the way proxyClientId is fetched.
IF EXISTS(SELECT jobId FROM JMJobStats WHERE opType = 135 AND jobId = @id)
BEGIN
	INSERT INTO @tempClientList
	SELECT xmlValue.value('(/TMMsg_JobOption/adminOpts/blockOperation/operations/@dstProxyClientId)[1]', 'int') from TM_JobXMLOptions where jobId = @id
END
--get exchange one pass proxy clients
IF @exchJobClientId > 0
BEGIN
	DECLARE @exchInput XML = '<App_GetExchangeMemberClientsReq jobId="' + CAST(@id as varchar(max)) + '" clientId="' + CAST(@exchJobClientId as varchar(max)) + '"></App_GetExchangeMemberClientsReq>'
	DECLARE @exchOutput TABLE (val XML)
	DECLARE @exchClientXml XML
	INSERT INTO @exchOutput EXEC	AppGetExchangeMemberClients @exchInput
	SELECT TOP 1 @exchClientXml = val FROM @exchOutput
    SET @handle = 0
    EXEC sp_xml_preparedocument @handle OUTPUT, @exchClientXml
	INSERT INTO @tempClientList SELECT clientId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientId INT)
    EXEC sp_xml_removedocument @handle
END
--get Azure AD memeber servers
IF @aadJobClientId > 0
BEGIN
	DECLARE @aadMemberServerXML XML
	SET @aadMemberServerXML = CAST(REPLACE((SELECT top 1 attrVal FROM APP_IDAProp WITH(NOLOCK) WHERE componentNameId = (SELECT id FROM APP_IDAName WITH(NOLOCK) WHERE clientId = @aadJobClientId AND appTypeId = @jobAppTypeId)
                                                                                                       AND attrName = 'Azure AD Member Servers' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)), 'UTF-8', 'UTF-16') AS XML)
	SET @handle = 0
	EXEC sp_xml_preparedocument @handle OUTPUT, @aadMemberServerXML
	INSERT INTO @tempClientList
	SELECT clientId FROM OPENXML (@handle, 'App_MemberServers/memberServers/client', 1) with (clientId INT)
	DECLARE @aadIndexServerId INT
	SET @aadIndexServerId = ISNULL((SELECT top 1 cast(attrVal as integer) FROM APP_IDAProp WITH(NOLOCK) WHERE componentNameId = (SELECT id FROM APP_IDAName WITH(NOLOCK) WHERE clientId = @aadJobClientId AND appTypeId = @jobAppTypeId)
                                                                                                        AND attrName = 'Azure AD Index Server' AND (@jobTime=0 AND modified=0 OR (modified>@jobTime OR modified=0) and created<=@jobTime)),0)
	INSERT INTO @tempClientList VALUES (@aadIndexServerId)
END
--get CS
INSERT INTO @tempClientList SELECT clientId FROM APP_Platform where PlatformType=1
--Ignore physical clients for CS cluster
INSERT INTO @physicalClientList
SELECT DISTINCT pmClientId
FROM	@tempClientList, APP_VMToPMMap
WHERE	(vmClientId = clientId OR PMClientId = clientId) AND VMClientId NOT IN (SELECT clientId FROM APP_Platform where PlatformType=1)
INSERT INTO @physicalClientList
SELECT	clientId
FROM	@tempClientList
WHERE	clientId NOT IN (SELECT DISTINCT vmClientId FROM APP_VMToPMMap WHERE VMClientId NOT IN (SELECT clientId FROM APP_Platform where PlatformType=1))
IF @user > 0
 BEGIN
	IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
    CREATE TABLE #clientList
    (
        t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
    )
	EXEC sec_getIdaObjectsForUser @user, @CLIENT_ENTITY , @EV_MANAGE_APPLICATION, 0, '#clientList'
	IF OBJECT_ID('tempdb.dbo.#clientListCollectDiag') IS NOT NULL
		DROP TABLE #clientListCollectDiag
	CREATE TABLE #clientListCollectDiag
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	declare @EV_COLLECT_DIAGNOSTICS INT = 264
	EXEC sec_getIdaObjectsForUser @user, @CLIENT_ENTITY , @EV_COLLECT_DIAGNOSTICS, 0, '#clientListCollectDiag'
	insert into #clientList
	select CLCD.* from #clientListCollectDiag as CLCD
	left join #clientList as CL
	on CLCD.t_clientId = CL.t_clientId
	where CL.t_clientId is null
	IF OBJECT_ID('tempdb.dbo.#clientListCollectDiag') IS NOT NULL
		DROP TABLE #clientListCollectDiag
	delete	@physicalClientList
	WHERE NOT EXISTS (select * from #clientList where t_clientId IN (PMClId))
	IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
END
IF (@jobAppTypeId IN (137, 29, 134, 78))
begin
	declare @indexServerClientid Int = 0
IF @jobAppTypeId = 137
BEGIN
	/*To get index server client associated with the subclient*/
	select @indexServerClientid = C.id From App_IdaName(NOLOCK) A, App_Idaprop(NOLOCK) B, App_client(NOLOCK) C
	Where A.appTypeId = 137 And A.clientId = (SELECT clientId FROM App_Application WHERE id = @subclientId)
	AND A.id = B.componentNameId AND B.attrName = 'OnePass Index Server' AND B.modified = 0
	AND C.id = CAST(B.attrVal AS INT)
	exec DM2GetIndexServers 'Exchange Index', @indexServerClientid
	/*Physical client associated with the index server pseudo client where the indexserver.log is available.*/
	insert into @physicalClientList
	select clientId From #getIndexServers
 END
IF @jobAppTypeId =  134
BEGIN
	/*Get OneDrive index server associated with the client*/
	SELECT @indexServerClientid = CAST(attrVal AS INT)
	FROM APP_InstanceProp(NOLOCK)
	WHERE componentNameId IN (SELECT t_instanceId FROM @tempBkp) and attrName IN ('OneDrive Index Server', 'V2CloudApps Index Server') AND modified = 0
	/*Get physical clients */
	EXEC DM2GetIndexServers 'OneDrive Index', @indexServerClientid
	INSERT INTO @physicalClientList
	SELECT clientId FROM #getIndexServers
END
IF @jobAppTypeId = 78
BEGIN
	/*Get SharePoint index server associated with the client*/
	SELECT @indexServerClientid = CAST(attrVal AS INT)
	FROM APP_IDAProp(NOLOCK)
	WHERE componentNameId IN (SELECT id FROM APP_IDAName(NOLOCK) WHERE clientId = (SELECT clientId FROM APP_Application(NOLOCK) WHERE id = (SELECT TOP 1 t_subclientId FROM @tempBkp)))
	AND attrName = 'Sharepoint Index Server' AND modified = 0
	/*Get physical clients*/
	EXEC DM2GetIndexServers 'SharePoint Index', @indexServerClientid
	INSERT INTO @physicalClientList
	SELECT clientId FROM #getIndexServers
END
IF @jobAppTypeId = 29
 BEGIN
  set @subClientId = (SELECT TOP 1 t_subclientId FROM @tempBkp)
	SELECT @indexServerClientid =   D.pseudoClientId from APP_SubclientProp SubP  WITH (NOLOCK)
            INNER JOIN APP_CLIENT AC  WITH (NOLOCK) on AC.name = SubP.attrVal
            INNER JOIN (
                    SELECT sp.attrVal, APP.appTypeId, APP.INSTANCE, APP.ClientId
                    FROM APP_SubClientProp SP  WITH (NOLOCK)
                         INNER JOIN APP_Application APP  WITH (NOLOCK)  ON SP.componentNameId = APP.ID AND SP.modified = 0 AND attrName like 'Associated subclient Policy'
                         where (APP.subclientStatus & 6) = 0 and App.Id = @subclientId
                       ) subquery on SubP.componentNameId  = subquery.attrVal AND attrName = '3dfs NFS Servers' AND SubP.modified = 0
                       INNER JOIN App_EdgeDriveAssociation WITH (NOLOCK) ON subquery.clientId = App_EdgeDriveAssociation.clientId
                                        INNER JOIN DM2Cloud D WITH (NOLOCK) ON D.pseudoClientId = App_EdgeDriveAssociation.entityId
                                        and entityType = 3
			exec DM2GetIndexServers 'NFS Index', @indexServerClientid
insert into @physicalClientList
	select clientId From #getIndexServers
	UNION
	SELECT DISTINCT  AC.id from APP_SubclientProp SubP
		INNER JOIN APP_CLIENT AC on AC.name = SubP.attrVal
		INNER JOIN (
				SELECT sp.attrVal, App.appTypeId, App.INSTANCE, App.ClientId
				FROM APP_SubClientProp SP
						INNER JOIN APP_Application APP ON SP.componentNameId = APP.ID AND SP.modified = 0 AND attrName like 'Associated subclient Policy'
					where APP.Id = @subclientId
				) subquery on SubP.componentNameId  = subquery.attrVal AND attrName = '3dfs NFS Servers' AND SubP.modified = 0
 END
end
-- Delete all clients on which we don't have simpana packages installed
DELETE @physicalClientList
	WHERE pmClId NOT in (SELECT DISTINCT ClientId FROM simInstalledPackages)AND
	pmClId NOT in (select DISTiNCT clientid from APP_Application where appTypeId=38)
DELETE @physicalClientList
WHERE pmClId in (
	select C.id as indexServerClientId
	from APP_InstanceProp I (NOLOCK)
	join app_application S (NOLOCK) on I.componentNameId = S.instance
	join app_client C (NOLOCK) on C.id = s.clientid
where attrname ='Distributed Cluster Type' and attrval = 7
)
delete from #getIndexServers
EXEC DM2GetIndexServers ''
declare @analysisIndexServerMap	TABLE(	indexserverId integer, physicalId integer )
insert into @analysisIndexServerMap
select A.indexServerClientId, A.clientId
from #getIndexServers as A
join @physicalClientList as B
on A.indexServerClientId = B.pmClId
DELETE @physicalClientList
WHERE pmClId in (
select distinct indexserverId from @analysisIndexServerMap
)
insert into @physicalClientList
select distinct physicalId from @analysisIndexServerMap
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
	DROP TABLE #getIndexServers
SELECT DISTINCT C.id, C.Name, C.net_hostname, P.platformType,
	(select OS.type from simOperatingSystem OS where C.simOperatingSystemId=OS.id),
	(select OS.subType from simOperatingSystem OS where C.simOperatingSystemId=OS.id),
	dbo.getClientOSName(C.id, NULL),
	(select attrVal from APP_ClientProp
	 where componentNameId=C.id and attrName=('platformdeleted '+convert(char(10), platformType)) and modified=0),
	(select attrVal from APP_ClientProp where componentNameId=C.id and attrName='timezone' and modified =0),
	C.releaseId, CVDPort, EvMgrCPort, @jobAppTypeId, @jobType,
    CASE @jobStartTime WHEN 0 THEN @jobStartTime ELSE (@jobStartTime + C.clientSkewTime - 5*60) END,
    CASE @jobEndTime WHEN 0 THEN @jobEndTime ELSE (@jobEndTime + C.clientSkewTime + 5*60) END,
    C.clientDescription
FROM APP_Client C, @physicalClientList T, APP_Platform P
WHERE C.id=P.clientId and C.id=T.PMClId
ORDER BY C.id, P.platformType
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientListByJobId')
	delete from GxQscripts where name = 'AppGetClientListByJobId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListByJobId')
	delete from GXDBVersions where aliasname = 'AppGetClientListByJobId'
GO

insert into GXDBVersions values(2, 'AppGetClientListByJobId',  'v1.1.2.32.8.3', 'AppGetClientListByJobId', 'v1.1.2.32.8.3')
GO

