

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListByCSHostName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientListByCSHostName.sp,v $ $Id: AppGetClientListByCSHostName.sp,v 1.6.2.10 2020/12/02 11:34:24 kbora Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppGetClientListByCsHostName"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetClientListByCsHostName')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientListByCsHostName <<<'
	drop procedure AppGetClientListByCsHostName
END
IF EXISTS (select * from GxQscripts where name='AppGetClientListByCsHostName')
	delete from GxQscripts where name = 'AppGetClientListByCsHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListByCsHostName')
	delete from GXDBVersions where aliasname = 'AppGetClientListByCsHostName'
GO
print '... Creating Procedure: AppGetClientListByCsHostName'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetClientListByCsHostName
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @i_commcellId integer,
  @i_csHostName varchar(255),
  @i_filterGRCClients int
AS
  DECLARE @o_id integer
  DECLARE @o_name varchar(255)
  DECLARE @o_netHostName varchar(255)
  DECLARE @o_csHostName varchar(255)
  DECLARE @o_isNasClient integer
  DECLARE @o_isCsHostClient integer
  DECLARE @o_basePackageInstalled integer
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @short_csHostName	varchar(255)
	SET		@short_csHostName = (SELECT Name FROM App_Client C JOIN APP_COMMCELL CC ON C.id = CC.clientId WHERE C.Net_HostName = @i_csHostName )
	DECLARE @MM TABLE (
		cId INT PRIMARY KEY
	)
	INSERT INTO @MM
	SELECT DISTINCT NDMPHostId
	FROM MMLibraryHostInfo AS lh
	DECLARE @Pkg TABLE (
		cId INT PRIMARY KEY
	)
	INSERT INTO @Pkg
	SELECT DISTINCT ClientId
	FROM SimInstalledPackages
	WHERE simPackageID = 1 OR simPackageID = 1002
	DECLARE @VM TABLE (
		cId INT PRIMARY KEY
	)
	INSERT INTO @VM
	SELECT DISTINCT PMClientID
	FROM APP_VMToPMMap vm
	WHERE vm.VMClientId = 2
	INSERT INTO @VM
	SELECT Prop.componentNameId
	FROM APP_ClientProp Prop
		LEFT JOIN LicUsage Lic ON Prop.componentNameId = Lic.CId
	WHERE Prop.attrName = N'Virtual Server Discovered Clients' AND Prop.attrVal = '1' AND Prop.modified = 0
		AND Lic.id IS NULL
	DECLARE @ownCC TABLE (
		cId	INT,
		ccId	INT
	)
	INSERT INTO @ownCC
	SELECT cp.componentNameId, CAST(cp.attrVal AS INT)
	FROM APP_ClientProp cp
	WHERE cp.attrName = 'OwnerCommCellId' AND cp.modified = 0
	SELECT	C.id, C.Name, C.Net_HostName, C.CsHostName,
		ISNULL(mm.cid, 0),
		1,
		CASE WHEN p.cid IS NOT NULL THEN 1 ELSE 0 END
	FROM	App_Client C JOIN APP_COMMCELL CC ON C.id = CC.clientId
		LEFT OUTER JOIN @MM mm ON mm.cid = c.id
		LEFT OUTER JOIN @Pkg p ON p.cid = c.id
	WHERE	C.Net_HostName = @i_csHostName
AND (@i_filterGRCClients=0 OR (C.specialClientFlags & 0x20) = 0)	--GRC_MIGRATED_CLIENT = 0x20 flag shldnt be set for cs host name change
	UNION
	SELECT CL.Id, CL.Name, CL.Net_HostName, CL.CsHostName,
		ISNULL(mm.cid, 0),
		CASE WHEN cc.clientId IS NOT NULL THEN 1 ELSE 0 END,
		CASE WHEN p.cid IS NOT NULL THEN 1 ELSE 0 END
	FROM App_Client CL
		LEFT OUTER JOIN @MM mm ON
			mm.cid = CL.id
		LEFT OUTER JOIN App_CommCell cc ON
			cc.clientId = CL.id
		LEFT OUTER JOIN @Pkg p ON
			p.cid = CL.id
		LEFT OUTER JOIN @VM vm ON
			vm.cid = CL.Id
	WHERE ( CL.CsHostName = @i_csHostName OR CL.CsHostName = @short_csHostName OR CL.Net_HostName =  @i_csHostName)
		AND vm.cid IS NULL
AND (@i_filterGRCClients=0 OR (CL.specialClientFlags & 0x20) = 0)			--GRC_MIGRATED_CLIENT = 0x20 flag shldnt be set for cs host name change
	UNION
	SELECT	A.Id, A.Name, A.Net_hostName, '',
		ISNULL(mm.cid, 0),
		0,
		CASE WHEN p.cid IS NOT NULL THEN 1 ELSE 0 END
	FROM	APP_Client A
		INNER JOIN @ownCC cc ON cc.cid = A.id
		INNER JOIN APP_CommCell C ON cc.ccId  = C.id
		INNER JOIN APP_Client D ON D.id = C.clientId
		LEFT OUTER JOIN @MM mm ON mm.cid = A.id
		LEFT OUTER JOIN @Pkg p ON p.cid = A.id
		LEFT OUTER JOIN @VM vm ON vm.cid = A.Id
		LEFT OUTER JOIN APP_ClientProp cp ON cp.componentNameId = A.id
			AND cp.attrName = N'Index Server Type'
			AND cp.attrVal = N'15'
			AND cp.modified = 0
	WHERE	A.id > 1
AND A.specialClientFlags & 0x20 > 0
		AND A.csHostName = ''
		AND @i_filterGRCClients = 0
		AND ( D.Net_HostName = @i_csHostName OR D.Net_HostName = @short_csHostName)
		AND vm.cid IS NULL
		-- Filter out index server clients
		AND cp.id IS NULL
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientListByCSHostName')
	delete from GxQscripts where name = 'AppGetClientListByCSHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListByCSHostName')
	delete from GXDBVersions where aliasname = 'AppGetClientListByCSHostName'
GO

insert into GXDBVersions values(2, 'AppGetClientListByCSHostName',  '00010006000200100000', 'AppGetClientListByCSHostName', '00010006000200100000')
GO

