

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListByAppType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientListByAppType.sp,v $ $Id: AppGetClientListByAppType.sp,v 1.21.14.16 2020/09/11 17:01:01 sravanan Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetClientListByAppType()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Returns client list by the given appType ID
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        Xuemei   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientListByAppType')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientListByAppType <<<'
	drop procedure AppGetClientListByAppType
END
IF EXISTS (select * from GxQscripts where name='AppGetClientListByAppType')
	delete from GxQscripts where name = 'AppGetClientListByAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListByAppType')
	delete from GXDBVersions where aliasname = 'AppGetClientListByAppType'
GO
print '... Creating Procedure: AppGetClientListByAppType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientListByAppType
  @userIdParam integer,
  @apptypeParam integer,
  @inClientId integer,
  @flag integer	
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName char(255)
  DECLARE @o_appTypeId integer
  DECLARE @o_clientDisplayName NVARCHAR(255)
 SET NOCOUNT ON
 set transaction isolation level read uncommitted
DECLARE	@clientTbl	TABLE (t_id INT, t_appTypeId INT)
DECLARE	@appTypeTbl	TABLE (t_id INT)
DECLARE @releaseNo integer
DECLARE @includeRestoreOnlyClients integer = 0
DECLARE @nodeTypeForSecurityCheck integer = 2009
IF ((@flag & 0x80) = 0x80) OR
((@flag & 0x200) = 0x200) OR
((@flag & 0x800) = 0x800)
	SET @includeRestoreOnlyClients = 1
SELECT @releaseNo = releaseId FROM APP_CLIENT WHERE id = @inClientId
-- From 9.0 onwards send the FS AppTypes . If the Source Client is >= 9.0
IF @releaseNo >= 14 AND (@apptypeParam =  84 OR @apptypeParam =  50
OR @apptypeParam = 47 OR @apptypeParam = 107 OR @apptypeParam = 106)
BEGIN
IF (@flag & 0x20) = 0x20
	BEGIN
		-- Windows File Replication
IF @apptypeParam =  84 OR @apptypeParam = 107
		BEGIN
			INSERT INTO @appTypeTbl
			SELECT appTypeId FROM APP_AppTypeGroupAssoc
			WHERE appGroupId in (select appTypeGroupId FROM APP_AppTypeGroup WHERE groupName = 'APPGRP_WindowsFileSystemIDA')
		END
		-- UNIX File Replication
ELSE IF @apptypeParam =  50 OR @apptypeParam = 47
		BEGIN
			INSERT INTO @appTypeTbl
			SELECT appTypeId FROM APP_AppTypeGroupAssoc
			WHERE appGroupId in (select appTypeGroupId FROM APP_AppTypeGroup WHERE groupName = 'APPGRP_UnixFileSystem')
		END
	END
IF (@flag & 0x40) = 0x40
	BEGIN
IF @apptypeParam = 107
		BEGIN
			INSERT INTO @appTypeTbl
VALUES (84)
		END
		INSERT INTO @appTypeTbl
		SELECT appTypeId FROM APP_AppTypeGroupAssoc
		WHERE appGroupId in (select appTypeGroupId FROM APP_AppTypeGroup WHERE groupName = 'APPGRP_WindowsFileSystemIDA')
	END
	-- Adding separate @flag as they might require windows list in other cases.
	-- Virtual Server
IF (@flag & 0x80) = 0x80
	BEGIN
		-- Requirement to VS+WINDOWS  as before + IMAge IDa + Restore Only Clients during File level restore .
		-- The clients should be of version 9.0 or more.
IF @apptypeParam = 106
		BEGIN
INSERT INTO @appTypeTbl values (75)
INSERT INTO @appTypeTbl values (106)
				INSERT INTO @appTypeTbl
				SELECT  distinct AC.destAppType
                from  APP_Application  as AP, APP_AppCompat as AC
				WHERE AC.srcAppType = @appTypeParam
				AND AP.apptypeId = AC.destAppType
IF (@flag & 0x400) = 0x400
				-- Unix File System clients
				INSERT INTO @appTypeTbl
				SELECT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId = 34
				--groupName = 'APPGRP_UnixFileSystem'
				INSERT INTO @clientTbl
				SELECT  DISTINCT SIP.ClientId, SP.apptype
				From simInstalledPackages SIP,simPackageMap SP
				WHERE	SP.apptype in(SELECT t_id from @appTypeTbl)
				and SP.simPackageId = SIP.simPackageID
		END
	END
	IF @includeRestoreOnlyClients = 0
	BEGIN
		INSERT INTO @clientTbl
		SELECT  DISTINCT clientId, appTypeId
		FROM	APP_iDAName
		WHERE	appTypeId in(SELECT t_id from @appTypeTbl) AND (Status & 2) = 0 AND (Status & 4) = 0
	END
	-- Delete the FS Client that are not greater than or equal to 9.0
	Delete FROM @clientTbl WHERE NOT EXISTS (SELECT id FROM APP_CLIENT WHERE id in (SELECT t_id from @clientTbl)
AND releaseId >= 14)
END
IF @includeRestoreOnlyClients = 0
BEGIN
	INSERT INTO @clientTbl
	SELECT  DISTINCT clientId ,appTypeId
	FROM	APP_iDAName
	WHERE	appTypeId = @apptypeParam AND (Status & 2) = 0 AND (Status & 4) = 0
END
ELSE
BEGIN
				DECLARE @tempAppId INT = @apptypeParam
IF ((@flag & 0x200 ) = 0x200 )
				BEGIN
IF @apptypeParam = 80
					BEGIN
SET @tempAppId = 22
					END
				END
IF (@appTypeParam = 5 AND (@flag & 0x2000) = 0x2000)
				BEGIN
					INSERT INTO @clientTbl
					SELECT  DISTINCT clientId, appTypeId
					FROM	APP_iDAName
					WHERE	appTypeId = @apptypeParam AND (Status & 2) = 0
				END
IF (@appTypeParam = 135 AND (@flag & 0x200 ) = 0x200 )
				BEGIN
					DECLARE @primaryNodesInfo TABLE(instanceId INT, val NVARCHAR(256), primaryNodeId INT)
					INSERT INTO @primaryNodesInfo(instanceId, val)
					SELECT componentNameId AS instanceId, attrVal AS val
					FROM APP_InstanceProp ip WITH (NOLOCK)
					WHERE attrName = 'Database Clients' AND modified = 0
					UPDATE pn
					SET primaryNodeId = S.Data
					FROM @primaryNodesInfo pn
					CROSS APPLY dbo.SplitString(pn.val, '+') S
					WHERE S.Id = 1
					INSERT INTO @clientTbl
					SELECT DISTINCT ida.clientId, ida.appTypeId FROM APP_IDAName ida WITH (NOLOCK)
					INNER JOIN APP_Application app WITH (NOLOCK) ON app.clientId = ida.clientId
					INNER JOIN @primaryNodesInfo pn ON pn.instanceId = app.instance
					INNER JOIN simInstalledPackages sim WITH (NOLOCK) ON sim.ClientId = pn.primaryNodeId
					WHERE simPackageID IN (51, 1301) AND ida.appTypeId = @appTypeParam
					AND (ida.status & 2) = 0 AND (ida.status & 4) = 0
				END
IF @apptypeParam <> 106
				BEGIN
					INSERT INTO @clientTbl
					SELECT  DISTINCT SIP.ClientId, SP.apptype
					From simInstalledPackages SIP,simPackageMap SP
					WHERE	SP.apptype = @tempAppId
					and SP.simPackageId = SIP.simPackageID
				END
END
IF @apptypeParam =  84 OR @apptypeParam = 107
BEGIN
DECLARE	@clOSList	TABLE (clId int, osType varchar(255))
	INSERT INTO @clOSList
	SELECT	T.t_id, S.Type
		FROM	@clientTbl T, simOperatingSystem S, APP_client C
		WHERE	T.t_id = C.id and C.simOperatingSystemId = S.id
	DECLARE @srcOS varchar(255)
    SET	@srcOS = (select S.Type from simOperatingSystem S, APP_client C where C.id=@inClientId and C.simOperatingSystemId=S.id)
		delete	@clientTbl
		FROM	@clientTbl T, @clOSList O
		WHERE	T.t_id = O.clId AND
		(
			 @srcOS <> O.osType	OR
			 (
			 @srcOS = 'Windows' AND O.osType <> 'Windows' OR @srcOS <> 'Windows' AND O.osType = 'Windows'
			 )
		)
END
-- Filter Case manager clients when apptype = 137
IF @apptypeParam = 137
DELETE @clientTbl where t_appTypeId = 137 AND t_id in (select componentNameId from APP_ClientProp NOLOCK WHERE attrName = 'Case Manager Pseudo Client' AND attrVal = 1 )
-- For SQL, (GET_SQL_RESTORE_CLIENTS - 0x8000) @flag will be set to
-- include restore-only clients and exclude AG clients.
IF ((@flag & 0x8000) = 0x8000)
BEGIN
	-- Include restore only clients
	INSERT INTO @clientTbl
		SELECT  DISTINCT SIP.ClientId, SP.apptype
			FROM simInstalledPackages SIP,simPackageMap SP
				WHERE SP.apptype = @apptypeParam  AND
					SP.simPackageId = SIP.simPackageID AND
					SIP.ClientId NOT IN (SELECT t_id FROM @clientTbl)
	-- Include restore-only cluster clients
	-- For Cluster clients, SIM package mapping will not be found.
	INSERT INTO @clientTbl
		SELECT AP.clientId, AP.appTypeId
			FROM APP_Application AP
				JOIN APP_VMToPMMap VM
					ON AP.clientId = VM.VMClientId
AND AP.appTypeId = 81
						AND AP.subclientStatus & 4 /*DELETED*/ = 0
				JOIN simInstalledPackages SP
					ON SP.ClientId = VM.PMClientId
						AND SP.simPackageID IN (353 /* N_WIN_PACKAGE_MSSQL */, 1212 /* N_UNIX_PACKAGE_SQLSERVER */)
			WHERE AP.clientId NOT IN (SELECT t_id FROM @clientTbl)
		GROUP BY AP.clientId, AP.appTypeId
	-- Remove all SQL AG clients using @flag CV_STATUS_MSSQLAG as they cannot be restore clients.
	DELETE FROM @clientTbl where t_id in (select id from APP_Client where status & 0x20000000 = 0x20000000)
	-- For SQL, pass the value for nodeType parameter as 2013 similar to how AppGetSqlInstances.sp does to ensure all applicable destination clients are displayed for restricted user
	SET @nodeTypeForSecurityCheck = 2013
END
--security check
IF @userIdParam > 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getIdaObjectsForUserV2OutputTbl') IS NOT NULL
            DROP TABLE #getIdaObjectsForUserV2OutputTbl
    CREATE TABLE #getIdaObjectsForUserV2OutputTbl
        (
            clientId INT,
            appTypeID INT,
            instanceID INT,
            backupsetId INT,
            subclientID INT,
            capabilities BIGINT
        )
	EXEC sec_getIdaObjectsForUserV2 @userIdParam, 3
	DELETE C FROM @clientTbl C
		LEFT JOIN #getIdaObjectsForUserV2OutputTbl S ON C.t_id = S.clientId
			WHERE S.clientId IS NULL
	DROP TABLE #getIdaObjectsForUserV2OutputTbl
END
IF (@flag & 0x80) = 0x80
SELECT t_id,
	clientName = (select name from APP_client where id = t_id),
	Max(t_appTypeId),
	clientDisplayName = (select displayName from APP_client where id = t_id)
FROM	@clientTbl group by t_id
ELSE
	SELECT DISTINCT t_id, clientName = client.name,  t_appTypeId, clientDisplayName = client.displayName
	FROM @clientTbl
	INNER JOIN APP_Client client ON client.id = t_id
 SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'AppGetClientListByAppType')
	delete from GxQscripts where name = 'AppGetClientListByAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListByAppType')
	delete from GXDBVersions where aliasname = 'AppGetClientListByAppType'
GO

insert into GXDBVersions values(2, 'AppGetClientListByAppType',  '00010021001400160000', 'AppGetClientListByAppType', '00010021001400160000')
GO

