

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientGroupOffice365Members.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===========================================================================+
--  |			AppGetClientGroupOffice365Members									|
--  |   Procedure to get Office365 Members list from given client group				|
--  +===========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientGroupOffice365Members')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientGroupOffice365Members <<<'
	drop procedure AppGetClientGroupOffice365Members
END
IF EXISTS (select * from GxQscripts where name='AppGetClientGroupOffice365Members')
	delete from GxQscripts where name = 'AppGetClientGroupOffice365Members'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientGroupOffice365Members')
	delete from GXDBVersions where aliasname = 'AppGetClientGroupOffice365Members'
GO
print '... Creating Procedure: AppGetClientGroupOffice365Members'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientGroupOffice365Members
-----------------------------------------------------------
---    PARAMETERS				                         ---
  @inXmlReq XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
    DECLARE @errorCode              INT = 0
    DECLARE @errorString            NVARCHAR(1024) = ''
	DECLARE @i_userId				INT = 0
	DECLARE @OutXmlReq				XML = NULL
	DECLARE @i_clientGrpId			INT = 0
	IF OBJECT_ID('tempdb.dbo.#tmpOffice365Members') IS NOT NULL
		DROP TABLE #tmpOffice365Members
	CREATE TABLE #tmpOffice365Members (clientId INT , clientName NVARCHAR(MAX))
	CREATE CLUSTERED INDEX #tmpOffice365Members_clientId_Idx1 ON #tmpOffice365Members (clientId)
	SET @i_userId = ISNULL((select @inXmlReq.value('(App_GetClientGroupMemberListReq/processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
	SET @i_clientGrpId = ISNULL((select @inXmlReq.value('(App_GetClientGroupMemberListReq/@clientGroupId)[1]', 'INT')), 0)
	IF @i_userId!=0
	BEGIN
		--Security
		IF OBJECT_ID('tempdb.dbo.#tempclientSecurityObjects') IS NOT Null DROP TABLE #tempclientSecurityObjects
		create table  #tempclientSecurityObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
		CREATE CLUSTERED INDEX #tempclientSecurityObjects_clientId_Idx1 ON #tempclientSecurityObjects (clientId)
EXEC sec_getIdaObjectsForUser @i_userId,3,0,0,'#tempclientSecurityObjects'
		INSERT INTO #tmpOffice365Members ( clientId, clientName)
		SELECT C.id as clientId, C.name as clientName
		FROM APP_ClientGroupAssoc (NOLOCK) CG
		JOIN simInstalledPackages (NOLOCK) S ON S.ClientId = CG.clientId
		JOIN APP_Client (NOLOCK) C ON C.id = S.ClientId
		JOIN #tempclientSecurityObjects TMP ON TMP.clientId = S.ClientId
AND S.simPackageID = 734 and  CG.clientGroupId = @i_clientGrpId
AND C.status & 0x00002 != 0x00002 /*UNINSTALLED*/
AND C.status & 0x00004 != 0x00004 /*DELETE*/
AND C.status & 0x00020 != 0x00020 /*Hidden*/
	END
	ELSE
	BEGIN
		INSERT INTO #tmpOffice365Members ( clientId, clientName)
		SELECT C.id as clientId, C.name as clientName
		FROM APP_ClientGroupAssoc (NOLOCK) CG
		JOIN simInstalledPackages (NOLOCK) S ON S.ClientId = CG.clientId
		JOIN APP_Client (NOLOCK) C ON C.id = S.ClientId
AND S.simPackageID = 734 and  CG.clientGroupId = @i_clientGrpId
AND C.status & 0x00002 != 0x00002 /*UNINSTALLED*/
AND C.status & 0x00004 != 0x00004 /*DELETE*/
AND C.status & 0x00020 != 0x00020 /*Hidden*/
	END
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	DECLARE @clientList table(clientId int , clientName nvarchar (max))
	INSERT INTO @clientList SELECT DISTINCT clientId , clientName FROM #tmpOffice365Members
	SET @OutXmlReq = (
						SELECT
							(
								SELECT  clientId as '@clientId' , clientName as '@clientName' FROM @clientList C
								FOR XML PATH ('clients'), type
							)
						FOR XML PATH('App_GetClientGroupMemberListResp')
					 )
ERROR_EXIT:
    IF @errorCode <> 0
        SET @OutXmlReq = (SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
								AS '@errorMessage' FOR XML PATH('App_GetClientGroupMemberListResp'))
	IF @OutXmlReq IS NULL
		SET @OutXmlReq = '<App_GetClientGroupMemberListResp />'
	SELECT @OutXmlReq
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientGroupOffice365Members')
	delete from GxQscripts where name = 'AppGetClientGroupOffice365Members'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientGroupOffice365Members')
	delete from GXDBVersions where aliasname = 'AppGetClientGroupOffice365Members'
GO

insert into GXDBVersions values(2, 'AppGetClientGroupOffice365Members',  '00000000000000000000', 'AppGetClientGroupOffice365Members', '00000000000000000000')
GO

