

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientGroupList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientGroupList.sp,v $ $Id: AppGetClientGroupList.sp,v 1.1.2.8 2020/05/01 06:30:09 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientGroupList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientGroupList <<<'
	drop procedure AppGetClientGroupList
END
IF EXISTS (select * from GxQscripts where name='AppGetClientGroupList')
	delete from GxQscripts where name = 'AppGetClientGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientGroupList')
	delete from GXDBVersions where aliasname = 'AppGetClientGroupList'
GO
print '... Creating Procedure: AppGetClientGroupList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientGroupList
  @userId INT, 
  @hide_SCGFilter INT 
AS
  DECLARE @o_clientGroupID INT
  DECLARE @o_clientGroupName NVARCHAR(255)
-- added to prevent extra result sets from
-- interfering with SELECT statements.
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF (@userId=0)
	BEGIN
		IF @hide_SCGFilter =0 -- Give All include SCG
		BEGIN
					SELECT
									a.id ,a.name
					FROM
								APP_ClientGroup A
					ORDER BY a.name
		END
		ELSE
		BEGIN
				SELECT
								a.id ,a.name
					FROM
								APP_ClientGroup A
					WHERE
a.flag & 0x1000 <> 0x1000
					ORDER BY a.name
		END
	END
	ELSE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#sec_CMClientGroups') IS NULL
		BEGIN
			CREATE TABLE #sec_CMClientGroups ( entityId INT  PRIMARY KEY)
		END
		ELSE
		BEGIN
			--if already created, start with clean table
			TRUNCATE TABLE   #sec_CMClientGroups
		END
	 	EXEC sec_getNonIdaObjectsForThisUser @userid, 28 /*CLIENT_GROUP_ENTITY (28) */ , 0 /* Any Permission */ ,'#sec_CMClientGroups'
		--When call is nested via stored procedures, caller is just interested to collect groups into temp table
		--so no need to return another data table by sorting and paging in that case.
	 	IF @hide_SCGFilter =0 -- Give All include SCG
	 	BEGIN
					SELECT
									a.id,a.name
					FROM
								APP_ClientGroup A
					INNER JOIN  #sec_CMClientGroups B
							ON	A.id = B.entityId
					ORDER BY a.name
		 END
	 	ELSE IF @hide_SCGFilter =1
	 	BEGIN							--Exclude SCG
					SELECT
								a.id,a.name
					FROM
								APP_ClientGroup A
					INNER JOIN  #sec_CMClientGroups B
							ON	A.id = B.entityId
					WHERE
a.flag & 0x1000 <> 0x1000	 --CV_FLAG_SMART_CLIENT_GROUP              0x1000
					ORDER BY a.name
	 	END
        DROP TABLE #sec_CMClientGroups
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientGroupList')
	delete from GxQscripts where name = 'AppGetClientGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientGroupList')
	delete from GXDBVersions where aliasname = 'AppGetClientGroupList'
GO

insert into GXDBVersions values(2, 'AppGetClientGroupList',  '00010001000200080000', 'AppGetClientGroupList', '00010001000200080000')
GO

