

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientGroupInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientGroupInfo.sp,v $ $Id: AppGetClientGroupInfo.sp,v 1.24.46.52 2020/09/26 02:44:48 pwang Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetClientGroupInfo"
--	|	This Procedure is used to get properties of a ClientGroup.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientGroupInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientGroupInfo <<<'
	drop procedure AppGetClientGroupInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetClientGroupInfo')
	delete from GxQscripts where name = 'AppGetClientGroupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientGroupInfo')
	delete from GXDBVersions where aliasname = 'AppGetClientGroupInfo'
GO
print '... Creating Procedure: AppGetClientGroupInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientGroupInfo
-- Input arguments
  @i_userLocale INT,
  @i_userId INT,
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- DECLARE 	@localVar	 dataType
DECLARE @locale					INT = 0;
DECLARE @clientGroupId			INT = 0;
DECLARE @clientGroupName		NVARCHAR(MAX);
DECLARE @xmlTextClientGroup		XML
DECLARE @xmlTextClientList		XML
DECLARE @xmlSCGRule				XML
DECLARE @xmlSCGScope			XML
DECLARE @scgRuleId				INT = NULL
DECLARE @errorString			NVARCHAR(MAX);
DECLARE @errorCode				INT = 0;
DECLARE @enableDLP INT = 0
DECLARE @dlpStolen INT = 0
DECLARE @dlpEnableClientKeys INT = 0
DECLARE @dlpScanIntervalMins INT = 0
DECLARE @dlpMinFileAgeMins INT = 0
DECLARE @dlpContent NVARCHAR(MAX) = ''
DECLARE @dlpFilter NVARCHAR(MAX) = ''
DECLARE @DLPContentTbl TABLE ( dlpContents NVARCHAR(MAX) )
DECLARE @DLPFilterTbl TABLE ( dlpFilters NVARCHAR(MAX) )
DECLARE @dlpEnableAutomaticDecryption INT = 0
DECLARE @dlpUnlockMethod INT = 0
DECLARE @enableRmDLP INT = 0
DECLARE @dlpRmOfflineDays INT = 0
DECLARE @dlpRmNow INT = 0
DECLARE @dlpRmContent NVARCHAR(MAX) = ''
DECLARE @dlpRmFilter NVARCHAR(MAX) = ''
DECLARE @DLPRmContentTbl TABLE ( dlpRmContents NVARCHAR(MAX) )
DECLARE @DLPRmFilterTbl TABLE ( dlpRmFilters NVARCHAR(MAX) )
DECLARE @quotaLimit BIGINT = 0
DECLARE @cvAccountsSSOLoginEnabled INT
DECLARE @cvAccountsSSOLoginUrl varchar(max)
DECLARE @powerManagementEnabled INT
DECLARE @selectCloudController INT
DECLARE @isPowerManagementAllowed INT
DECLARE @isPowerManagementSupported INT
DECLARE @powerMgmtInfoXML XML
DECLARE @selectedCloudcontrollerName NVARCHAR(MAX)
DECLARE @revision VARCHAR(255)
DECLARE @showDLP INT = 0
DECLARE @appMgrLiteClientName NVARCHAR(MAX)
DECLARE @appMgrLiteHostName NVARCHAR(MAX)
DECLARE @appMgrLiteClientId INT
DECLARE @useClientGroupGlobalFilter INT
DECLARE @userHasAgentManagementPermission INT = 0
DECLARE @enableClientSideCaching INT = 0
	-- create the client list temporary table
	IF object_id('tempdb.dbo.#ClientGroupPropTbl') IS NOT null DROP TABLE #ClientGroupPropTbl
	IF object_id('tempdb.dbo.#dlpPropTbl') IS NOT null DROP TABLE #dlpPropTbl
	CREATE TABLE #ClientGroupPropTbl
	(
		 cvAccountsSSOLoginEnabled INT DEFAULT 0
		,powerManagementEnabled INT DEFAULT 0
		,selectCloudController INT DEFAULT 0
		,isPowerManagementAllowed INT DEFAULT 0
		,powerMgmtInfoXML XML
		,enableClientSideCaching INT DEFAULT 0
		,showDLP INT DEFAULT 0
		,useClientGroupGlobalFilter INT DEFAULT 0
		,userHasAgentManagementPermission INT DEFAULT 0
		,overrideGlobalAuthentication INT DEFAULT 0
		,useLocalSystemAccount INT DEFAULT 0
		,webServerClientId INT DEFAULT 0
		,excludeFromSLA INT DEFAULT 0
		,slaInterval INT DEFAULT 0
		,systemDefaultSLA INT DEFAULT 0
		,reEnableSLAInterval INT DEFAULT 0
		,slaCopyRedundancy INT DEFAULT 0
		,slaCopyFallenBehindDays INT DEFAULT 0
		,rpoMinutes INT DEFAULT 0
		,rtoMinutes INT DEFAULT 0
		,ownerName nvarchar(max)
		,ownerId INT DEFAULT 0
		,allowJobsToRunPastOperationWindowEnabled INT DEFAULT 0
		,forceClientSideDownload INT DEFAULT 0
		,jobThrottleEnabled INT DEFAULT 0
		,dataThreshold INT DEFAULT 0
		,logThreshold INT DEFAULT 0
		,isHtmlDescription BIT DEFAULT 0
		,jobPriority INT DEFAULT 0
		,jobStartTime INT DEFAULT -1
	)
	CREATE TABLE #dlpPropTbl
	(
		 enableDLP INT DEFAULT 0
		,dlpStolen INT DEFAULT 0
		,dlpEnableClientKeys INT DEFAULT 0
		,dlpScanIntervalMins INT DEFAULT 0
		,dlpMinFileAgeMins INT DEFAULT 0
		,dlpContents NVARCHAR(MAX) DEFAULT 0
		,dlpFilters NVARCHAR(MAX) DEFAULT 0
		,dlpEnableAutomaticDecryption INT DEFAULT 0
		,dlpUnlockMethod INT DEFAULT 0
		,enableRmDLP INT DEFAULT 0
		,dlpRmOfflineDays INT DEFAULT 0
		,dlpRmNow INT DEFAULT 0
		,dlpRmContents NVARCHAR(MAX) DEFAULT ''
		,dlpRmFilters NVARCHAR(MAX) DEFAULT ''
	)
-- Write the logic
SET @locale = @i_userLocale;
SET @clientGroupId = ( SELECT ref.value ('@clientGroupId', 'INT') FROM @i_xmlText.nodes('App_PerformClientGroupReq/clientGroupDetail/clientGroup') R ( ref ))
SET @clientGroupName = (SELECT APP_ClientGroup.id FROM APP_ClientGroup WHERE APP_ClientGroup.id = @clientGroupId);
IF @clientGroupName is NULL
BEGIN
SET @errorCode = 100;
SET @errorString = dbo.fn_EvFormatEventMsgText(0,@locale, (1034 | (CAST(POWER(2, 24) AS BIGINT) * 83)), 0,2);
SET @r_ReturnResult = (	SELECT	1				as TAG,
								NULL			as Parent,
								@errorCode		as [App_GenericResp!1!errorCode],
								@errorString	as [App_GenericResp!1!errorMessage]
								FOR XML EXPLICIT
						);
	SELECT @r_ReturnResult;
	return;
END
SET @xmlTextClientGroup = ( SELECT APP_ClientGroup.id as '@clientGroupId', APP_ClientGroup.name as '@clientGroupName',APP_ClientGroup.GUID as '@GUID'
					FROM         [dbo].[APP_ClientGroup]
					WHERE     (APP_ClientGroup.id = @clientGroupId)
					FOR XML PATH('clientGroup'), TYPE);
DECLARE @associationEntity XML
SET @associationEntity = (select @clientGroupId as '@clientGroupId'
							FOR XML PATH('entity'))
DECLARE @ClientGroupActivityControl XML
SET @ClientGroupActivityControl = @associationEntity
--'<entity clientGroupId="' + STR(@clientGroupId) + '"/>'
EXEC [dbo].[APPGetActivityControlXML]
			@xmlText = @ClientGroupActivityControl OUTPUT
DECLARE @ClientGroupSecurity XML
SET @ClientGroupSecurity = @associationEntity
--'<entity clientGroupId="' + STR(@clientGroupId) + '"/>'
EXEC [dbo].[APPGetEntitySecurityXML]
			@xmlText = @ClientGroupSecurity OUTPUT
DECLARE @clientGroupSecurityNewXML XML
EXEC [dbo].[sec_getSecurityForEntity] @i_userId, @clientGroupSecurityNewXML OUTPUT, 28, @clientGroupId
-- Support for SCG Scope
SELECT
	@scgRuleId = id,
	@xmlSCGRule = ruleXml.query('scgRule')
FROM App_SCGRule
WHERE
	scgId=@clientGroupId
SET @xmlSCGScope = (
	SELECT
		s.entityType '@_type_',
		(
			CASE s.entityType
				WHEN 13 THEN s.entityId		-- USER_ENTITY
				ELSE NULL
			END
		) '@userId',
		(
			CASE s.entityType
				WHEN 15 THEN s.entityId		-- USERGROUP_ENTITY
				ELSE NULL
			END
		) '@userGroupId',
		(
			CASE s.entityType
				WHEN 61 THEN s.entityId		-- PROVIDER_ENTITY
				ELSE NULL
			END
		) '@providerId',
		(
			CASE s.entityType
				WHEN 1 THEN s.entityId		-- COMMCELL_ENTITY
				ELSE NULL
			END
		) '@commCellId',
		(
			CASE s.entityType
				WHEN 13 THEN (		-- USER_ENTITY
						SELECT
							u.login '@entityName'
						FROM UMUsers u WITH(NOLOCK)
						WHERE
							u.id = s.entityId
					)
				ELSE NULL
			END
		) '@userName',
		(
			CASE s.entityType
				WHEN 15 THEN (		-- USERGROUP_ENTITY
						SELECT
							CASE
								WHEN p.id IS NULL THEN g.name
								ELSE p.domainName + '\' + g.name
							END '@entityName'
						FROM UMGroups g WITH(NOLOCK)
							LEFT OUTER JOIN UMDSProviders p ON
								p.id = g.umdsProviderId
								AND g.umdsProviderId > 0
						WHERE
							g.id = s.entityId
					)
				ELSE NULL
			END
		) '@userGroupName',
		(
			CASE s.entityType
				WHEN 61 THEN (		-- PROVIDER_ENTITY
						SELECT
							p.domainName
						FROM UMDSProviders p WITH(NOLOCK)
						WHERE
							p.id = s.entityId
					)
				ELSE NULL
			END
		) '@providerDomainName',
		(
			CASE s.entityType
				WHEN 1 THEN (		-- COMMCELL_ENTITY
						SELECT
							cc.aliasName
						FROM APP_Commcell cc WITH(NOLOCK)
						WHERE
							cc.id = s.entityId
					)
				ELSE NULL
			END
		) '@commCellName'
	FROM APP_SCGScope s
	WHERE
		s.scgRuleId = @scgRuleId
	FOR XML PATH('entity'), ROOT('scgScope'), TYPE
)
SET @xmlTextClientList =  (
                    SELECT     APP_Client.id AS '@clientId', APP_Client.name AS '@clientName', APP_Client.net_hostname AS '@hostName', APP_Client.displayname AS '@displayName'
					FROM         [dbo].[APP_Client] INNER JOIN
										  APP_ClientGroupAssoc ON APP_Client.id = APP_ClientGroupAssoc.clientId
					WHERE     (APP_ClientGroupAssoc.clientGroupId = @clientGroupId)
					FOR XML PATH('associatedClients'), TYPE
					);
DECLARE @overrideHigherLevelSettings XML
DECLARE @overrideGlobalAuthentication INT
DECLARE @useLocalSystemAccount INT
DECLARE	@userName NVARCHAR(MAX) = ''
DECLARE @webServerClientId INT
DECLARE @excludeFromSLA INT = 0
DECLARE @slaInterval INT = 0
DECLARE @systemDefaultSLA INT = 0
DECLARE @excludeSLAReason NVARCHAR(MAX) =''
DECLARE @reEnableSLAInterval INT = 0
DECLARE @slaCopyRedundancy INT = 0
DECLARE @slaCopyFallenBehindDays INT = 0
DECLARE @rpoMinutes INT = 0
DECLARE @rtoMinutes INT = 0
DECLARE @ownerName nvarchar(max)
DECLARE @ownerId INT = 0
DECLARE @allowJobsToRunPastOperationWindowEnabled INT = 0
DECLARE @forceClientSideDownload INT = 0
DECLARE @jobThrottleEnabled INT = 0
DECLARE @dataThreshold INT = 0
DECLARE @logThreshold INT = 0
DECLARE @jobPriority INT = 0
DECLARE @jobStartTime INT = -1
DECLARE @CV_PROP_JOB_THROTTLE_ENABLED INT = 1
DECLARE @CV_PROP_JOB_THROTTLE_EXCLUDE_IMMD_JOBS INT = 2
DECLARE @isHtmlDescription BIT = 0
	INSERT INTO #ClientGroupPropTbl
	(overrideGlobalAuthentication, useLocalSystemAccount, webServerClientId, powerManagementEnabled, selectCloudController, excludeFromSLA, slaInterval,systemDefaultSLA, reEnableSLAInterval, slaCopyRedundancy, slaCopyFallenBehindDays,
	rpoMinutes, rtoMinutes, allowJobsToRunPastOperationWindowEnabled, isHtmlDescription, forceClientSideDownload, useClientGroupGlobalFilter,enableClientSideCaching, showDLP, jobThrottleEnabled,
	dataThreshold, logThreshold, cvAccountsSSOLoginEnabled, jobPriority, jobStartTime)
SELECT 	[1200] AS overrideGlobalAuthentication,
[1201] AS useLocalSystemAccount,
[1029] AS webServerClientId,
[3501] AS powerManagementEnabled,
[3502] AS selectCloudController,
[3301] AS excludeFromSLA,
[3300] AS slaInterval,
[3327] AS systemDefaultSLA,
[3325] AS reEnableSLAInterval,
[3304] AS slaCopyRedundancy,
[3305] AS slaCopyFallenBehindDays,
[3306] AS rpoMinutes,
[3307] AS rtoMinutes,
[1038] AS allowJobsToRunPastOperationWindowEnabled,
[3311] AS isHtmlDescription,
[3700] AS forceClientSideDownload,
[3622] AS useClientGroupGlobalFilter,
[3600] AS enableClientSideCaching,
[3623] AS showDLP,
[3650] AS jobThrottleEnabled,
[3651] AS dataThreshold,
[3652] AS logThreshold,
[1035] AS cvAccountsSSOLoginEnabled,
[3660] AS jobPriority,
[1303] AS jobStartTime
	FROM
	(
		SELECT longVal,
		propertyTypeId
		FROM APP_componentProp
WHERE componentType = 8
		AND componentId =  @clientGroupId
		AND modified = 0
		AND propertyTypeId IN
		(
1200, 1201, 1029, 3501, 3502,
3301, 3300,3327,3325,  3304, 3305, 3306,
3307, 1038, 3311, 3700, 3622, 3600, 3623,
3650, 3651, 3652, 1035, 3660, 1303
		)
	)
	AS cgProp
	PIVOT
	(
		MAX(longVal) FOR propertyTypeId IN
		(
[1200], [1201], [1029], [3501], [3502],
[3301], [3300],[3327],[3325], [3304], [3305], [3306],
[3307], [1038], [3311], [3700], [3622], [3600], [3623],
[3650], [3651], [3652], [1035], [3660], [1303]
		)
	) AS P
SELECT @quotaLimit = [3400]
	FROM
	(
		SELECT longlongval,
		propertyTypeId
		FROM APP_componentProp
WHERE componentType = 8
		AND componentId =  @clientGroupId
		AND modified = 0
		AND propertyTypeId IN
		(
3400
		)
	)
	AS cgProp
	PIVOT
	(
		MAX(longlongval) FOR propertyTypeId IN
		(
[3400]
		)
	) AS P
SELECT @userName = [1202],
@revision = [3316],
@excludeSLAReason = [3326] ,
@cvAccountsSSOLoginUrl = [1035]
	FROM
	(
		SELECT stringVal,
		propertyTypeId
		FROM APP_componentProp
WHERE componentType = 8
		AND componentId =  @clientGroupId
		AND modified = 0
		AND propertyTypeId IN
		(
1202, 3316,3326, 1035
		)
	)
	AS cgProp
	PIVOT
	(
		MAX(stringVal) FOR propertyTypeId IN
		(
[1202], [3316], [3326], [1035]
		)
	) AS P
	INSERT INTO #dlpPropTbl
	(enableDLP, dlpStolen, dlpEnableClientKeys, dlpScanIntervalMins, dlpMinFileAgeMins, dlpContents, dlpFilters, dlpEnableAutomaticDecryption,
			dlpUnlockMethod, enableRmDLP, dlpRmOfflineDays, dlpRmNow, dlpRmContents, dlpRmFilters)
	SELECT [enableDLP],
		[dlpStolen] AS dlpStolen,
		[dlpEnableClientKeys] AS dlpEnableClientKeys,
		[dlpScanIntervalMins] AS dlpScanIntervalMins,
		[dlpMinFileAgeMins] AS dlpMinFileAgeMins,
		[dlpContents] AS dlpContents,
		[dlpFilters] AS dlpFilters,
		[dlpEnableAutomaticDecryption] AS dlpEnableAutomaticDecryption,
		[dlpUnlockMethod] AS dlpUnlockMethod,
		[enableRmDLP] AS enableRmDLP,
		[dlpRmOfflineDays] AS dlpRmOfflineDays,
		[dlpRmNow] AS dlpRmNow,
		[dlpRmContents] AS dlpRmContents,
		[dlpRmFilters] AS dlpRmFilters
	FROM
	(
		SELECT attrVal,
		attrName
		FROM DlpGroupProp
		WHERE groupId =  @clientGroupId
		AND modified = 0
		AND attrName IN
		(
			'enableDLP', 'dlpStolen', 'dlpEnableClientKeys', 'dlpScanIntervalMins', 'dlpMinFileAgeMins', 'dlpContents', 'dlpFilters', 'dlpEnableAutomaticDecryption',
			'dlpUnlockMethod', 'enableRmDLP', 'dlpRmOfflineDays', 'dlpRmNow', 'dlpRmContents', 'dlpRmFilters'
		)
	)
	AS dlpProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN
		(
			[enableDLP], [dlpStolen], [dlpEnableClientKeys], [dlpScanIntervalMins], [dlpMinFileAgeMins], [dlpContents], [dlpFilters], [dlpEnableAutomaticDecryption],
			[dlpUnlockMethod], [enableRmDLP], [dlpRmOfflineDays], [dlpRmNow], [dlpRmContents], [dlpRmFilters]
		)
	) AS P
	SELECT 	@overrideGlobalAuthentication = overrideGlobalAuthentication,
			@webServerClientId = webServerClientId,
			@powerManagementEnabled = powerManagementEnabled,
			@selectCloudController = selectCloudController,
			@excludeFromSLA = excludeFromSLA,
			@slaInterval = slaInterval,
			@systemDefaultSLA = systemDefaultSLA,
			@reEnableSLAInterval = reEnableSLAInterval,
			@slaCopyRedundancy = slaCopyRedundancy,
			@slaCopyFallenBehindDays = slaCopyFallenBehindDays,
			@rpoMinutes = rpoMinutes,
			@rtoMinutes = rtoMinutes,
			@allowJobsToRunPastOperationWindowEnabled = allowJobsToRunPastOperationWindowEnabled,
			@isHtmlDescription = isHtmlDescription,
			@forceClientSideDownload = forceClientSideDownload,
			@useClientGroupGlobalFilter = useClientGroupGlobalFilter,
			@enableClientSideCaching = enableClientSideCaching,
			--@showDLP = showDLP,
			@jobThrottleEnabled = ISNULL(jobThrottleEnabled, 0),
			@dataThreshold = ISNULL(dataThreshold, 0),
			@logThreshold = ISNULL(logThreshold, 0),
			@cvAccountsSSOLoginEnabled = cvAccountsSSOLoginEnabled,
			@jobPriority = jobPriority,
			@jobStartTime = jobStartTime
	FROM #ClientGroupPropTbl
	IF @jobStartTime = -1
	BEGIN
		SET @jobStartTime = NULL
	END
	SELECT
	@enableDLP = enableDLP,
	@dlpStolen = dlpStolen,
	@dlpEnableClientKeys = dlpEnableClientKeys,
	@dlpScanIntervalMins = dlpScanIntervalMins,
	@dlpMinFileAgeMins = dlpMinFileAgeMins,
	@dlpContent = dlpContents,
	@dlpFilter = dlpFilters,
	@dlpEnableAutomaticDecryption = dlpEnableAutomaticDecryption,
	@dlpUnlockMethod = dlpUnlockMethod,
	@enableRmDLP = enableRmDLP,
	@dlpRmOfflineDays = dlpRmOfflineDays,
	@dlpRmNow = dlpRmNow,
	@dlpRmContent = dlpRmContents,
	@dlpRmFilter = dlpRmFilters
	FROM #dlpPropTbl
	if(@overrideGlobalAuthentication < 0) SET @overrideGlobalAuthentication = 0;
	if(@overrideGlobalAuthentication > 0)
	BEGIN
		SET @overrideGlobalAuthentication = 1;
SET @useLocalSystemAccount =  (select longVal from APP_componentProp where componentType = 8 and componentId =  @clientGroupId and propertyTypeId = 1201  and dataType = 10 and modified = 0)
		if(@useLocalSystemAccount = 0)
		BEGIN
set @userName = (select stringVal from APP_componentProp where componentType = 8 and componentId =  @clientGroupId and propertyTypeId = 1202  and dataType = 1 and modified = 0)
		END
		ELSE
			set @useLocalSystemAccount = 1
	END
	SET @overrideHigherLevelSettings = (
			select @overrideGlobalAuthentication as '@overrideGlobalAuthentication'
				, @useLocalSystemAccount as '@useLocalSystemAccount'
				, (SELECT @userName as '@userName'
				 FOR XML PATH('userAccount'), TYPE)
			FOR XML PATH('overrideHigherLevelSettings'), TYPE
			)
SET @isPowerManagementSupported = (select value from MMConfigs WITH (NOLOCK) where name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG')
SET @selectedCloudcontrollerName = (select name from APP_Client where id = @selectCloudController )
DECLARE @tmpPowerMgmtRetTbl TABLE(powerMgmtAllowed INT)
INSERT INTO @tmpPowerMgmtRetTbl
EXEC MMIsPowerManagementAllowed @clientGroupId, 28, 0
SELECT top 1 @isPowerManagementAllowed = powerMgmtAllowed FROM @tmpPowerMgmtRetTbl
set @powerMgmtInfoXML = (  SELECT
							@powerManagementEnabled as '@isPowerManagementEnabled',
							@isPowerManagementAllowed as '@isPowerMgmtAllowed',
							@isPowerManagementSupported as '@isPowerMgmtSupported',
							@selectCloudController as 'selectedCloudController/@clientId',
							@selectedCloudcontrollerName as 'selectedCloudController/@clientName'
							FOR XML PATH('powerManagementInfo'),TYPE
						)
declare @ownerUserGroupId int
exec sec_getCreatorForEntity  @ownerId OUTPUT, @ownerUserGroupId output, 0, 28, @clientGroupId
SET  @ownerName = (select login from UMUsers where id = @ownerId )
DECLARE @registryKeys XML
set @registryKeys = (	SELECT
						CR.keyName as '@keyName',
						CR.type as '@type',
						(CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE CR.value END) as '@value',
						CR.relativepath as '@relativepath',
						CR.deleted as '@deleted',
						CR.enabled as '@enabled',
						ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
						0 as '@isInheritedFromClientGroup'
						FROM APP_AdvanceSettings as CR
						LEFT OUTER JOIN APP_AdvanceSettingsEX AdvEx
						ON CR.id = AdvEX.keyId
						WHERE CR.entityId =@clientGroupId AND CR.entityType = 28 --CLIENT_GROUP_ENTITY
								AND deleted = 0 AND ISNULL(AdvEx.hidden,0)=0
						FOR XML PATH('registryKeys'),TYPE
						);
SET @appMgrLiteClientName = ISNULL((SELECT CR.value FROM APP_AdvanceSettings as CR WHERE CR.keyName = 'sAPPMGRCLIENTNAME' AND CR.entityId = @clientGroupId AND deleted = 0 AND CR.entityType = 28),'')
SET @appMgrLiteHostName = ISNULL((SELECT CR.value FROM APP_AdvanceSettings as CR WHERE CR.keyName = 'sAPPMGRHOSTNAME' AND CR.entityId = @clientGroupId AND deleted = 0 AND CR.entityType = 28),'')
SET @appMgrLiteClientId = ISNULL((SELECT AC.id FROM APP_Client as AC WHERE AC.name = @appMgrLiteClientName),0)
IF LEN(@dlpContent) > 0
INSERT INTO @DLPContentTbl SELECT data FROM dbo.SplitString(@dlpContent, ';')
IF LEN(@dlpFilter) > 0
INSERT INTO @DLPFilterTbl SELECT data FROM dbo.SplitString(@dlpFilter, ';')
IF LEN(@dlpRmContent) > 0
INSERT INTO @DLPRmContentTbl SELECT data FROM dbo.SplitString(@dlpRmContent, ';')
IF LEN(@dlpRmFilter) > 0
INSERT INTO @DLPRmFilterTbl SELECT data FROM dbo.SplitString(@dlpRmFilter, ';')
DECLARE @companyGlobalFiler TABLE (o_filterStr VARCHAR(MAX),
									o_filterXml XML,
									o_errorCode INT,
									o_errorMessage VARCHAR(MAX))
--28 : CLIENT_GROUP_ENTITY
INSERT @companyGlobalFiler
EXEC AppGetCompanyGlobalFilter @clientGroupId, 28, 0
DECLARE @filterxml XML
SELECT @filterxml = o_filterXml FROM @companyGlobalFiler
SET @filterxml = REPLACE(CAST(@filterxml AS NVARCHAR(MAX)), '+1', ' ')
SET @filterxml = @filterxml.query('/App_GlobalFiltersInfo/globalFiltersInfoList')
EXEC sec_checkPermissionOnEntity @i_userId, 2, @userHasAgentManagementPermission OUTPUT, 28, @clientGroupId
DECLARE @createAsInfo XML
DECLARE @createAsUserID INT
DECLARE @createAsUSerGroupID INT
EXEC sec_getCreatorForEntity @createAsUserID OUTPUT, @createAsUSerGroupID OUTPUT, 0, 28, @clientGroupId
IF @createAsUserID > 0
	SET @createAsInfo = (SELECT
						(SELECT
							(SELECT @createAsUserID AS '@userId',
									login AS '@userName'
							 FROM UMUsers (NOLOCK)
							 WHERE id = @createAsUserID
							 FOR XML PATH ('user'), TYPE)
						 FOR XML PATH ('user'), TYPE)
					 FOR XML PATH ('createAs'))
ELSE
	SET @createAsInfo = (SELECT
						 (SELECT @createAsUSerGroupID AS '@userGroupId',
								 CASE WHEN G.umdsProviderID = 0 THEN G.name ELSE P.domainName + '\' + G.name END AS '@userGroupName'
						  FROM UMGroups G (NOLOCK) LEFT OUTER JOIN UMDSProviders P (NOLOCK)
						  ON G.umdsProviderID = P.id
						  WHERE G.id = @createAsUSerGroupID
						  FOR XML PATH ('userGroup'), TYPE)
					  FOR XML PATH ('createAs'))
DECLARE @associatedStoragePolicies XML = ''
DECLARE @storagePolicyId INT = 0
SELECT @storagePolicyId = archGroupId
FROM ArchGroupClientGroupAssociation WITH (NOLOCK)
WHERE	clientGroupId = @clientGroupId
AND		archGroupId > 0
AND		attributes & 1 = 1 /*Region based client group backup*/
AND		enabled = 1
IF @storagePolicyId > 0
BEGIN
	SET @associatedStoragePolicies = (
			SELECT Id   AS '@storagePolicyId', Name AS '@storagePolicyName'
			FROM ArchGroup WITH (NOLOCK)
			WHERE Id = @storagePolicyId
			FOR XML PATH('associatedStoragePolicies'),TYPE
		)
END
-- Check if showDLP is enabled at client group level
IF EXISTS(SELECT 1 FROM #ClientGroupPropTbl WITH(NOLOCK) WHERE showDLP = 1)
	SET @showDLP = 1
-- Get enableAutoDiscovery client group property STARTS
DECLARE @autoDiscoveryKeyValue nvarchar
DECLARE @enableAutoDiscovery bit = 0
SET @autoDiscoveryKeyValue = (SELECT TOP 1 value FROM APP_AdvanceSettings WHERE entityId = @clientGroupId AND entityType = 28 AND keyName = 'nEnableAutoDetectApp' AND type = 'INTEGER' AND relativePath = 'iDataAgent' AND enabled = 1 AND deleted <> 1)
IF @autoDiscoveryKeyValue IS NOT NULL AND @autoDiscoveryKeyValue = '2'
BEGIN
	SET @enableAutoDiscovery = 1
END
-- Get enableAutoDiscovery client group property ENDS
SET @r_ReturnResult = (
					SELECT    APP_ClientGroup.description as '@description'
, (CASE APP_ClientGroup.flag & 0x0100	WHEN 0 THEN 0 ELSE 1 END) as '@isEDCInstanceAssociated'
, (CASE APP_ClientGroup.flag & 0x0200		WHEN 0 THEN 0 ELSE 1 END) as '@isEDCInstanceDeleted'
, (CASE APP_ClientGroup.flag & 0x0400		WHEN 0 THEN 0 ELSE 1 END) as '@isAddinClientGroup'
, (CASE APP_ClientGroup.flag & 0x0800 WHEN 0 THEN 0 ELSE 1 END) as '@isNetworkThrottleEnabled'
, (CASE APP_ClientGroup.flag & 0x1000		WHEN 0 THEN 0 ELSE 1 END) as '@isSmartClientGroup'
, (CASE APP_ClientGroup.flag & 0x4000000	WHEN 0 THEN 0 ELSE 1 END) as '@isDiscoveredClientGroup'
					, APP_ClientGroup.flag & 0x00FF as '@edcSupportedInstanceType'
					, @revision as '@revision'
, (CASE APP_ClientGroup.flag & 0x40000		WHEN 0 THEN 0 ELSE 1 END) as '@isCommCellGroup'
					, @cvAccountsSSOLoginEnabled AS '@isCvAccountsSSOenabled'
					, @cvAccountsSSOLoginUrl AS '@CvAccountsSSOUrl'
					, @powerManagementEnabled AS '@powerManagementEnabled'
					, @slaInterval as '@slaInterval'
					, @excludeFromSLA as '@excludeFromSLA'
					, @systemDefaultSLA as '@useSystemDefaultSLA'
					, @excludeSLAReason as '@excludeSLAReason'
					, @reEnableSLAInterval as '@reEnableSLAInterval'
					, @slaCopyRedundancy as '@slaCopyRedundancy'
					, @slaCopyFallenBehindDays as '@slaCopyFallenBehindDays'
					, @enableClientSideCaching as '@enableClientSideCaching'
					, @rpoMinutes as '@rpoMinutes'
					, @rtoMinutes as '@rtoMinutes'
					, @quotaLimit AS '@claQuota'
					, @allowJobsToRunPastOperationWindowEnabled as '@allowJobsToRunPastOperationWindowEnabled'
					, @isHtmlDescription as '@isHtmlDescription'
					, @enableAutoDiscovery AS '@enableAutoDiscovery'
					, @forceClientSideDownload as '@forceClientSideDownload'
					, @useClientGroupGlobalFilter AS '@useClientGroupGlobalFilter'
					, @userHasAgentManagementPermission AS '@userHasAgentManagementPermission'
					, @jobPriority AS '@JobPriority'
					, @jobStartTime AS '@jobStartTime'
					, @showDLP AS '@showDLP'
					, @xmlTextClientGroup
					, @xmlTextClientList
					, @xmlSCGRule
					, @overrideHigherLevelSettings
					, @registryKeys
					, (SELECT @filterxml FOR XML PATH ('globalFiltersInfo'), TYPE)
					, (SELECT @ClientGroupActivityControl FOR XML PATH ('clientGroupActivityControl'), TYPE)
					, (SELECT @ClientGroupSecurity FOR XML PATH ('clientGroupSecurity'), TYPE)
					, (SELECT @clientGroupSecurityNewXML FOR XML PATH ('securityAssociations'),TYPE)
					, (SELECT @ownerId as '@userId', @ownerName as '@userName' FOR XML PATH('owner'),TYPE)
, (SELECT  id as '@clientId', name as '@clientName', 3 '@_type_' FROM APP_CLIENT WHERE id = @webServerClientId FOR XML PATH('webSearchServer'),TYPE)
					, (SELECT @appMgrLiteClientId as '@clientId', @appMgrLiteClientName as '@clientName', @appMgrLiteHostName as '@hostName' FOR XML PATH('appMgrServiceLiteNode'),TYPE)
					, (SELECT @createAsInfo.query('.') FOR XML PATH (''), TYPE)
					, (SELECT
							@enableDLP AS '@enableDLP',
							@dlpStolen AS '@dlpStolen',
							@dlpEnableClientKeys AS '@dlpEnableClientKeys',
							@dlpScanIntervalMins AS '@dlpScanIntervalMins',
							@dlpMinFileAgeMins AS '@dlpMinFileAgeMins',
							@dlpEnableAutomaticDecryption AS '@dlpEnableAutomaticDecryption',
							@dlpUnlockMethod AS '@dlpUnlockMethod',
							(SELECT dlpContents AS 'dlpContents'
								FROM @DLPContentTbl
							FOR XML PATH(''), TYPE),
							(SELECT dlpFilters AS 'dlpFilters'
								FROM @DLPFilterTbl
							FOR XML PATH(''), TYPE),
							(SELECT
								@enableRmDLP AS '@enableRmDLP',
								@dlpRmOfflineDays AS '@dlpRmOfflineDays',
								@dlpRmNow AS '@dlpRmNow',
								(SELECT dlpRmContents AS 'dlpRmContents'
									FROM @DLPRmContentTbl
								FOR XML PATH(''), TYPE),
								(SELECT dlpRmFilters AS 'dlpRmFilters'
									FROM @DLPRmFilterTbl
							FOR XML PATH(''), TYPE)
							FOR XML PATH('dlpRMProperties'),TYPE)
						FOR XML PATH('dlpPropertise'),TYPE)
					, @associatedStoragePolicies, @powerMgmtInfoXML,
					(SELECT CASE @jobThrottleEnabled & @CV_PROP_JOB_THROTTLE_ENABLED WHEN 0 THEN 0 ELSE 1 END AS '@isJobThrottleEnabled',
						CASE @jobThrottleEnabled & @CV_PROP_JOB_THROTTLE_EXCLUDE_IMMD_JOBS WHEN 0 THEN 0 ELSE 1 END AS '@excludeImmidiateJobs',
						@dataThreshold AS '@dataThreshold',
						@logThreshold AS '@logThreshold'
						FOR XML PATH('jobThrottleSettings'), TYPE),
					(SELECT R.Id as '@regionId', r.Name as '@regionName' , r.displayName AS '@displayName'
					FROM APP_REGION R
INNER JOIN APP_AdvanceSettings aas ON aas.entityId=@clientGroupId AND aas.entityType=28 AND aas.keyName='Region Id' AND CAST(aas.value AS VARCHAR(20))=CAST(r.id AS VARCHAR(20)) and aas.enabled=1 and aas.deleted=0 FOR XML PATH('region'),TYPE)
					, @xmlSCGScope.query('.')		-- only want scgScope nodes
					FROM         [dbo].[APP_ClientGroup]
					WHERE     (APP_ClientGroup.id = @clientGroupId)
					FOR XML PATH('clientGroupDetail'), ROOT('App_PerformClientGroupResp')
				)
SELECT @r_ReturnResult;
	IF object_id('tempdb.dbo.#dlpPropTbl') IS NOT null DROP TABLE #dlpPropTbl
	IF object_id('tempdb.dbo.#ClientGroupPropTbl') IS NOT null DROP TABLE #ClientGroupPropTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientGroupInfo')
	delete from GxQscripts where name = 'AppGetClientGroupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientGroupInfo')
	delete from GXDBVersions where aliasname = 'AppGetClientGroupInfo'
GO

insert into GXDBVersions values(2, 'AppGetClientGroupInfo',  '00010024004600520000', 'AppGetClientGroupInfo', '00010024004600520000')
GO

