

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientFileSystemUsage.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2014  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientFileSystemUsage.sp,v $ $Id: AppGetClientFileSystemUsage.sp,v 1.12.2.9 2019/12/02 22:25:38 nramalingam Exp $";
-- =========================================================
-- Author: Jatin Sanghvi
-- Description: Get the effective quota limit and space consumption of input client computer
-- =========================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientFileSystemUsage')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientFileSystemUsage <<<'
	drop procedure AppGetClientFileSystemUsage
END
IF EXISTS (select * from GxQscripts where name='AppGetClientFileSystemUsage')
	delete from GxQscripts where name = 'AppGetClientFileSystemUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientFileSystemUsage')
	delete from GXDBVersions where aliasname = 'AppGetClientFileSystemUsage'
GO
print '... Creating Procedure: AppGetClientFileSystemUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientFileSystemUsage
  @xmlText XML
AS
SET NOCOUNT ON;
--
BEGIN TRY
	--
	-- get client id for rest of the stored procedure
	DECLARE @clientId int =
		(SELECT TOP(1) id
		FROM APP_Client C WITH (NOLOCK)
		WHERE C.id =
			(SELECT N.value(N'@clientId', N'nvarchar(max)')
			FROM @xmlText.nodes (N'App_FSClientUsage') AS T(N)));
	--
	IF @clientId IS NULL
		RAISERROR(N'Error fetching the client information.', 16, 1);
	--
	-- Check first whether or not to do quota check.
	-- If quota is not set at commcell, just return with empty reponse immediately
	IF NOT EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'DoFSQuotaCheck' AND value = '1' AND modified = 0)
	BEGIN
		SET @xmlText =
			(SELECT
				@clientId AS N'@clientId',
				0 AS N'@quotaLimit',
				0 AS N'@spaceConsumed'
			FOR XML PATH(N'App_FSClientUsage'), TYPE);
		GOTO ALL_DONE
	END
	-- get subclient id whose space-consumed value be read from input instead of from database
	DECLARE @replaceAppId int =
		(SELECT TOP(1) id
		FROM APP_Application A WITH (NOLOCK)
		WHERE A.id =
			(SELECT N.value(N'@replaceAppId', N'int')
			FROM @xmlText.nodes (N'App_FSClientUsage') AS T(N)));
	--
	-- space-consumed by subclient in bytes, to replace the one in database
	DECLARE @replaceSpaceConsumed bigint =
		(SELECT N.value(N'@replaceSpaceConsumed', N'bigint')
		FROM @xmlText.nodes (N'App_FSClientUsage') AS T(N));
	--
	-- get space consumed by client stored as subclient property
	DECLARE @spaceConsumedSubclient bigint =
		(SELECT SUM(CASE A.id WHEN @replaceAppId THEN @replaceSpaceConsumed ELSE CAST(SP.attrVal as bigint) END)
		FROM APP_Application A WITH (NOLOCK)
		LEFT JOIN APP_SubClientProp SP WITH (NOLOCK) ON A.id = SP.componentNameId AND SP.attrName = N'Application Size' AND SP.modified = 0
WHERE A.subclientStatus & (0 | 0x00002 | 0x00004 | 0x00010 | 0x00020) = 0 -- only non-deleted, non-hidden subclients
		AND A.clientId = @clientId); -- only subclients belonging to input client
	--
	-- get space consumed by client stored as backupset property
	DECLARE @spaceConsumedBackupSet bigint = 0
	-- only backupsets belonging to input client
	SELECT @spaceConsumedBackupSet = SUM(CAST(BP.attrVal as bigint)) FROM
	APP_BackupSetName C WITH (NOLOCK)
	JOIN APP_BackupSetProp BP WITH (NOLOCK) ON BP.componentNameId = C.id
	WHERE BP.attrName = N'Application Size'	AND BP.modified = 0
AND C.status & (0 | 0x00002 | 0x00004 | 0x00010 | 0x00020) = 0 -- only non-deleted, non-hidden backupsets
	AND C.id IN	(SELECT A.backupSet	FROM APP_Application A WITH (NOLOCK) WHERE A.clientId = @clientId)
	--
	DECLARE @spaceConsumed bigint = ISNULL(@spaceConsumedSubclient, 0) + ISNULL(@spaceConsumedBackupSet, 0);
	--
	-- get list of users for this client
	IF OBJECT_ID(N'tempdb..#userList', N'U') IS NOT NULL
		DROP TABLE #userList;
	CREATE TABLE #userList (userId INT PRIMARY KEY, name nvarchar(max), login nvarchar(max), email nvarchar(max), userGuid nvarchar(max));
	INSERT INTO #userList
	SELECT CO.userId, U.name, U.login, U.email, U.userGuid
	FROM UMUsers U WITH (NOLOCK) cross apply
	sec_getClientOwnersWithParam(@clientId, 0, 0) CO
WHERE CO.userId = U.id AND U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0; -- only enabled, non-deleted, non-hidden users
	IF OBJECT_ID(N'tempdb..#usageData', N'U') IS NOT NULL
		DROP TABLE #usageData;
	--
	CREATE TABLE #usageData
	(
		id int,
		name nvarchar(max),
		login nvarchar(max),
		email nvarchar(max),
		userGuid nvarchar(max),
		quotaLimit bigint,
		spaceConsumed bigint
	);
	INSERT INTO #usageData
	SELECT  userId, name, login, email, userGuid, ISNULL([FSQuotaLimit], 0) as QL, ISNULL([FSQuotaUsage], 0) as QU
	FROM
		(
			SELECT A.userId, A.name, A.login, A.email, A.userGuid, attrName, CAST(attrVal AS BIGINT) AS attrVal
			FROM #userList A JOIN UMUsersProp UP WITH (NOLOCK) ON A.userId = UP.componentNameId
WHERE UP.attrName IN ('FSQuotaLimit','FSQuotaUsage')
		) as T
	PIVOT   ( MAX(attrVal) FOR attrName IN ( [FSQuotaLimit], [FSQuotaUsage]) ) AS P
	--
	IF @replaceAppId > 0
	BEGIN
		DECLARE @oldSubclientUsage BIGINT = 0
		SELECT @oldSubclientUsage = CAST(SP.attrVal as bigint)
		FROM APP_Application A WITH (NOLOCK)
		LEFT JOIN APP_SubClientProp SP WITH (NOLOCK) ON A.id = SP.componentNameId AND SP.attrName = N'Application Size' AND SP.modified = 0
WHERE A.subclientStatus & (0 | 0x00002 | 0x00004 | 0x00010 | 0x00020) = 0 -- only non-deleted, non-hidden subclients
		AND A.id = @replaceAppId
		-- If replaceAppId is passed, we need to use the @replaceSpaceConsumed for that subclient. @oldSubclientUsage is already incorporated in #usageData table, so subtract that.
		UPDATE #usageData SET spaceConsumed = spaceConsumed + (@replaceSpaceConsumed - @oldSubclientUsage)
	END
	DECLARE @warningNeeded INT = 0
	-- compute the quota limit of client
	-- quota limit = (space consumed by client) + (maximum of remaining balance of all client owners)
	DECLARE @quotaLimit bigint = NULL;
	IF NOT EXISTS (SELECT * FROM #usageData U WHERE U.quotaLimit IS NULL OR U.quotaLimit = 0)
	BEGIN
		SELECT @quotaLimit = @spaceConsumed + MAX(U.quotaLimit - U.spaceConsumed) FROM #usageData U;
	END
	ELSE
	BEGIN
		--MR 190134
		--Send warning if all 3 conditions are met
		--1. At least one of the owners has no quota set. We are in else if this is true
		--2. Client has more than one owners
		--If all the owners are with no quota limit set we don't have to send warning
		IF EXISTS(SELECT 1 FROM #usageData WHERE quotaLimit > 0)
		BEGIN
			--3. Client owners with quota set have exceeded their limit
			-- (@spaceConsumed + quotaLimit - (spaceConsumed)) is the remaining quota
			IF NOT EXISTS(SELECT 1 FROM #usageData WHERE (@spaceConsumed + quotaLimit - (spaceConsumed)) >  @spaceConsumed)
				SET @warningNeeded = 1
		END
	END
	--
	-- return the xml response
	SET @xmlText =
		(SELECT
			@clientId AS N'@clientId',
			ISNULL(@quotaLimit, 0) AS N'@quotaLimit',
			ISNULL(@spaceConsumed, 0) AS N'@spaceConsumed',
			@warningNeeded AS '@warningNeeded',
			(SELECT
				U.id AS N'@userId',
				U.name AS N'@name',
				U.login AS N'@login',
				U.email AS N'@email',
				U.userGuid AS N'@userGuid',
				ISNULL(U.quotaLimit, 0) AS N'@quotaLimit',
				ISNULL(U.spaceConsumed, 0) AS N'@spaceConsumed'
			FROM #usageData U
			FOR XML PATH(N'usageData'), TYPE)
		FOR XML PATH(N'App_FSClientUsage'), TYPE);
	--
	DROP TABLE #usageData;
	--
ALL_DONE:
	IF OBJECT_ID(N'tempdb..#clientUsageDataXML', N'U') IS NOT NULL
		INSERT INTO #clientUsageDataXML(usage) VALUES (@xmlText);
	ELSE
		SELECT @xmlText;
--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	--
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS N'@errorCode', ERROR_MESSAGE() AS N'@errorString' FOR XML PATH(N'App_GenericEntityResponse'), TYPE);
	IF OBJECT_ID(N'tempdb..#clientUsageDataXML', N'U') IS NOT NULL
		INSERT INTO #clientUsageDataXML(usage) VALUES (@xmlText);
	ELSE
		SELECT @xmlText;
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientFileSystemUsage')
	delete from GxQscripts where name = 'AppGetClientFileSystemUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientFileSystemUsage')
	delete from GXDBVersions where aliasname = 'AppGetClientFileSystemUsage'
GO

insert into GXDBVersions values(2, 'AppGetClientFileSystemUsage',  '00010012000200090000', 'AppGetClientFileSystemUsage', '00010012000200090000')
GO

