

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientDefaultPlanSummary.sp] ---------- 

--  +===================================================================================================+
--  |		 		 Name:  AppGetClientDefaultPlanSummary()
--  | Description:  Fetches applicable Plan for the entity provided from any where in the hierarchy
--  +===================================================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientDefaultPlanSummary.sp,v $ $Id: AppGetClientDefaultPlanSummary.sp,v 1.1.4.3 2018/03/22 00:59:45 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientDefaultPlanSummary')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientDefaultPlanSummary <<<'
	drop procedure AppGetClientDefaultPlanSummary
END
IF EXISTS (select * from GxQscripts where name='AppGetClientDefaultPlanSummary')
	delete from GxQscripts where name = 'AppGetClientDefaultPlanSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientDefaultPlanSummary')
	delete from GXDBVersions where aliasname = 'AppGetClientDefaultPlanSummary'
GO
print '... Creating Procedure: AppGetClientDefaultPlanSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientDefaultPlanSummary
  @i_userId INT,
  @i_localeId INT,
  @i_clientID INT,
  @i_propertyLevel INT,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET @o_errCode = 0
	SET @o_errString = ''
	-- generate output XML
	-- No Security Check. That is currently done by webserver layer calling this SP.
	-- If anyone want to use it make it more generic, then introduce this security check over here also
	-- Also, we are not honoring property flags right now. We will have support. we can honor as per requirement later.
	SET @o_xmlText = ( SELECT(
							SELECT  P.type          AS '@type',
									P.subType       AS '@subtype',
									P.description   AS '@description',
									P.flag			AS '@planStatusFlag',
									(
									  SELECT P.id           AS '@planId',
											 P.name	        AS '@planName',
											 158            AS '@_type_'    -- defined in CVEntities.x
									  FOR XML PATH('plan'), TYPE
									)
									FROM
										(SELECT AP.subType, MAX(AP.id) AS id FROM APP_ClientProp ACP  WITH(NOLOCK)
											INNER JOIN App_Plan AP  WITH(NOLOCK)
ON CONVERT(NVARCHAR(64), ISNULL(AP.id, 0))=ACP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ((ACP.attrName='Associated Plan') OR (ACP.attrName LIKE 'Default % Plan')) AND ACP.modified=0 AND ACP.componentNameId=@i_clientID
											GROUP BY AP.subType) CT
										INNER JOIN APP_PLAN P
										ON P.id=CT.id
									FOR	XML PATH('plans'), TYPE )
								FOR XML PATH(''), ROOT('Api_GetPlanSummaryResp'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errCode = ERROR_NUMBER()
    SET @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientDefaultPlanSummary')
	delete from GxQscripts where name = 'AppGetClientDefaultPlanSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientDefaultPlanSummary')
	delete from GXDBVersions where aliasname = 'AppGetClientDefaultPlanSummary'
GO

insert into GXDBVersions values(2, 'AppGetClientDefaultPlanSummary',  '00010001000400030000', 'AppGetClientDefaultPlanSummary', '00010001000400030000')
GO

