

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCheckPointJobDetails.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   [AppGetCheckPointJobDetails   - Add content in the AppGetCheckPointJobDetails
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCheckPointJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCheckPointJobDetails <<<'
	drop procedure AppGetCheckPointJobDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetCheckPointJobDetails')
	delete from GxQscripts where name = 'AppGetCheckPointJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCheckPointJobDetails')
	delete from GXDBVersions where aliasname = 'AppGetCheckPointJobDetails'
GO
print '... Creating Procedure: AppGetCheckPointJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCheckPointJobDetails
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXML xml
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  DECLARE @outXML xml
DECLARE @nthToLast int = @inXML.value('(/Indexing_GetCheckPointJobDetails/@nthToLastJob)[1]', 'int')
IF object_id('tempdb.dbo.#dbCheckPointTimeTbl') IS NOT NULL
   DROP TABLE #dbCheckPointTimeTbl
CREATE TABLE #dbCheckPointTimeTbl(dbName varchar(4096), jobStartTime int)
INSERT INTO #dbCheckPointTimeTbl
SELECT name dbIdentifier, servStartDate jobServStartTime FROM
	(SELECT AF.name, JM.servStartDate, JM.appType, ROW_NUMBER() OVER (PARTITION BY AF.cs_afname ORDER BY AF.cTime DESC) AS AFCount
	FROM @inXML.nodes('Indexing_GetCheckPointJobDetails/checkPointJobDetails') AS DBIDS(ATTRIBUTES)
	JOIN archFile AF WITH (NOLOCK) ON AF.cs_afname = CHECKSUM('IdxCheckPoint_' + DBIDS.ATTRIBUTES.value('@dbIdentifier','NVARCHAR(256)')) AND
	AF.NAME = 'IdxCheckPoint_' + DBIDS.ATTRIBUTES.value('@dbIdentifier','VARCHAR(256)')
	JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId
	JOIN JMBkpStats JM WITH (NOLOCK) ON AF.jobId = JM.jobId
	WHERE AF.isValid = 1 AND AFC.isValid = 1 AND (AFC.flags & 256 = 0)) TAF
WHERE TAF.AFCount = @nthToLast
--
--For Exchange Lucene Engine type, return the last playedback job time instead of the checkpoint backup time.
--This should be enhanced once the SOLR backup is configured with default schedule.
INSERT INTO #dbCheckPointTimeTbl
SELECT
	B.backupSetGUID,
	ISNULL(C.properties.value('(/Indexing_DbStats/@lastPlayedBkpTime)[1]', 'int'), 0)
FROM @inXML.nodes('Indexing_GetCheckPointJobDetails/checkPointJobDetails') as Tbl(Col),
App_IndexDBInfo(NOLOCK) B,
IdxDbState(NOLOCK) C
WHERE
Tbl.Col.value('@dbIdentifier','NVARCHAR(256)') = B.backupsetGUID
AND B.Type in ( 137 , 139 , 200127, 200128)
AND CAST(B.backupSetGUID AS VARCHAR(256)) NOT IN (SELECT dbName FROM #dbCheckPointTimeTbl)
AND B.id = C.dbId
SET @outXML = ISNULL((
						SELECT dbName dbIdentifier,
							   jobStartTime jobServStartTime
						FROM #dbCheckPointTimeTbl
                        FOR XML path('checkPointJobDetails'),
                        ROOT('Indexing_GetCheckPointJobDetails')
                     ), '<Indexing_GetCheckPointJobDetails/>'
					)
DROP TABLE #dbCheckPointTimeTbl
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT @outXML
SET NOCOUNT ON
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCheckPointJobDetails')
	delete from GxQscripts where name = 'AppGetCheckPointJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCheckPointJobDetails')
	delete from GXDBVersions where aliasname = 'AppGetCheckPointJobDetails'
GO

insert into GXDBVersions values(2, 'AppGetCheckPointJobDetails',  '00000000000000000000', 'AppGetCheckPointJobDetails', '00000000000000000000')
GO

