

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCaseManagerClientProperties.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCaseManagerClientProperties.sp,v $ $Id: AppGetCaseManagerClientProperties.sp,v 1.1.2.12 2020/12/16 20:43:09 ssivananthan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetCaseManagerClientProperties"
--	|	This Procedure is used to get all properties of a client.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCaseManagerClientProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCaseManagerClientProperties <<<'
	drop procedure AppGetCaseManagerClientProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetCaseManagerClientProperties')
	delete from GxQscripts where name = 'AppGetCaseManagerClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCaseManagerClientProperties')
	delete from GXDBVersions where aliasname = 'AppGetCaseManagerClientProperties'
GO
print '... Creating Procedure: AppGetCaseManagerClientProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCaseManagerClientProperties
  @i_clientId INT,
  @i_userId INT,
  @o_xmlText XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
IF object_id('tempdb.dbo.#EDiscoveryClientListTbl') IS NOT null DROP TABLE #EDiscoveryClientListTbl
CREATE TABLE #EDiscoveryClientListTbl (
    [cid]              INT PRIMARY KEY,
    [cname]            NVARCHAR(255),
    [cdisplayName]     NVARCHAR(255),
	[cguid]            uniqueidentifier,
	[installdate] int default null,
	[noOfCustodians] int default 0,
	[status] int default 0,
	[description]	NVARCHAR(MAX)
	)
	IF object_id('tempdb.dbo.#EDiscoveryClientPropTbl') IS NOT null DROP TABLE #EDiscoveryClientPropTbl
CREATE TABLE #EDiscoveryClientPropTbl (
    [cid]              INT PRIMARY KEY,
	[planId]   int default null,
	[serverPlanId]	INT default null
	)
 IF object_id('tempdb.dbo.#FinalXMLList') IS NOT null DROP TABLE #FinalXMLList
CREATE TABLE #FinalXMLList
    (
        c_id             INT,
        entitySecurityAssociation XML
    )
IF OBJECT_ID('tempdb.dbo.#tmpbkpsetlist') IS NOT NULL DROP TABLE #tmpbkpsetlist
CREATE TABLE #tmpbkpsetlist ( instanceId INT, instanceName NVARCHAR(128), backupsetId INT , backupsetName NVARCHAR(128), backupSetGUID varchar(128), agentType INT, clientId INT , clientName NVARCHAR(255), agentId INT, subclientId INT, subclientName NVARCHAR(128), metrics NVARCHAR(MAX), appTypeId INT)
CREATE CLUSTERED INDEX #tmpExchangeClientList_instanceId_backupsetId_clientId_agentId_SubclientId_Idx1 ON #tmpbkpsetlist (instanceId, backupsetId, clientId, agentId, subclientId)
	--subclient Security for metrics
	IF OBJECT_ID('tempdb.dbo.#tempSubclientSecurityObjects') IS NOT Null DROP TABLE #tempSubclientSecurityObjects
CREATE TABLE #tempSubclientSecurityObjects ( [clientId] INT, [appTypeId] INT DEFAULT 0, [instanceId] INT DEFAULT 0, [backupsetId] INT DEFAULT 0,  [subclientId ] INT DEFAULT 0 )
EXEC sec_getIdaObjectsForUser @i_userId, 2013, 0, 1 , '#tempSubclientSecurityObjects'
IF object_id('tempdb.dbo.#UserTable') IS NOT null DROP TABLE #UserTable
CREATE TABLE #UserTable
	(
		c_id             INT,
		userId INT,
		userName nvarchar(255),
		capabilities BIGINT
	)
CREATE CLUSTERED INDEX UserTable_c_id_UserId_Idx on #UserTable(c_id, userId);
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
    DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
EXEC sec_getIdaObjectsForUser @i_userId,3,0,1,'#getIdaObjects' --3
IF @i_clientId = 0
BEGIN
	INSERT  INTO #EDiscoveryClientListTbl (cid, cname, cdisplayName, installdate, cguid, status, description)
	(SELECT distinct c.id, c.name, c.displayName, c.refTime, c.GUID, c.status, c.clientDescription
	FROM [dbo].[APP_Client] c INNER JOIN #getIdaObjects ON clientId=C.id
	INNER JOIN APP_ClientProp cp ON componentNameId = C.id AND attrname = 'Case Manager Pseudo Client'	AND attrVal = 1)
END
ELSE
BEGIN
	INSERT INTO #EDiscoveryClientListTbl (cid, cname, cdisplayName, installdate, cguid, status, description)
	SELECT distinct c.id, c.name, c.displayName, c.refTime, c.GUID, c.status, c.clientDescription
	FROM #getIdaObjects sec
	INNER JOIN APP_Client c on  c.id = sec.clientId
	INNER JOIN APP_ClientProp cp on componentNameId = c.id AND attrname = 'Case Manager Pseudo Client'	AND attrVal = 1
	WHERE sec.clientId  = @i_clientId
END
UPDATE #EDiscoveryClientListTbl SET noOfCustodians = (select count(C.id) from CMDefinition D
INNER JOIN CMCustodian C on C.definitionId = D.id AND C.modified = 0
WHERE D.clientId = cid)
INSERT INTO #EDiscoveryClientPropTbl (cid, planId, serverPlanId)
SELECT  componentNameId                 AS cId,
		[Default Data classification Plan] AS planId,
		[Default Server Plan]	AS serverPlanId
	FROM (
        SELECT
            componentNameId,
            attrName,
            attrVal
        FROM #EDiscoveryClientListTbl cl INNER JOIN  App_ClientProp cp ON cp.componentNameId=cl.cid
        WHERE
            cp.componentNameId = cl.cid
            AND cp.modified = 0
            AND attrName IN (   'Default Data classification Plan',
								'Default Server Plan')
		) AS clients
	PIVOT   (   MAX(attrVal) FOR attrName IN (  [Default Data classification Plan],
											[Default Server Plan]
			)
    ) AS P
	BEGIN
        --security
        DECLARE @clientcur CURSOR
		DECLARE @cliID INT
		DECLARE @t_clientId INTEGER
		DECLARE @entitySecurityAssociation XML
		SET @clientcur = CURSOR FOR SELECT DISTINCT cid FROM #EDiscoveryClientListTbl
		OPEN @clientcur
        FETCH NEXT FROM @clientcur INTO @cliID
        WHILE @@FETCH_STATUS = 0
        BEGIN
            SET @t_clientId = @cliID
		   EXEC [dbo].[sec_getSecurityForEntity]
                                                @i_userId,
                                                @entitySecurityAssociation OUTPUT,
3,
												 @t_clientId
		  INSERT INTO #FinalXMLList(c_id, entitySecurityAssociation) VALUES
		 (@t_clientId, @entitySecurityAssociation )
		BEGIN
			--Populate Exchange\FS backupsets
			INSERT INTO #tmpbkpsetlist ( instanceId, instanceName, backupsetId, backupsetName, backupSetGUID, agentType, clientId, clientName, agentId, subclientId, subclientName, metrics, appTypeId)
				SELECT distinct SC.instance as instanceId, I.name as instanceName, BK.id as backupsetId, BK.name as backupsetName, BK.GUID as backupSetGUID,
CASE WHEN EXISTS (select attrval from APP_BackupSetProp WITH (NOLOCK) where componentNameId = BK.id AND attrname = 'Case Manager Hold Type') THEN ISNULL((select attrval from APP_BackupSetProp WITH (NOLOCK) where componentNameId = BK.id AND attrname = 'Case Manager Hold Type'),0)
					--old cases /* Exchange(1, 2, 3), WInFS(4), UnixFs(5)*/
WHEN SC.appTypeId = 137 THEN ISNULL((select attrval from APP_BackupSetProp WITH (NOLOCK) where componentNameId = BK.id AND attrname = 'Exchange OnePass Backupset Type' AND attrval IN (1, 2, 3)),0)
WHEN SC.appTypeId = 33 THEN 4
WHEN SC.appTypeId = 29 THEN 5
					ELSE 0
					END as agentType,
				C.id as clientId, C.displayName as clientName, A.id as agentId,SC.id as subclientId, SC.subclientName as subclientName, '' as metrics, A.appTypeId
				FROM APP_Application SC
				INNER JOIN APP_Client(NOLOCK) C ON C.id = SC.clientId
				INNER JOIN APP_BackupSetName(NOLOCK) BK ON SC.backupSet = BK.id
				INNER JOIN APP_IDAName(NOLOCK) A ON C.id = A.clientId	AND A.appTypeId = SC.appTypeId
				INNER JOIN APP_InstanceName (NOLOCK) I ON I.id= SC.instance
WHERE C.id = @t_clientId AND SC.subclientName <> 'Do Not Backup' AND (SC.subclientStatus & 0x00004) <> 0x00004
					AND  (SC.id IN (SELECT DISTINCT [subclientId ] FROM #tempSubclientSecurityObjects))
			UPDATE t
			 SET metrics = P.attrVal
			 FROM APP_SubclientProp P (NOLOCK)
			 INNER JOIN #tmpbkpsetlist t (NOLOCK) ON  t.subclientId = P.componentNameId
			 AND t.ClientId = @t_clientId AND P.attrName = 'Case Manager Metrics' AND p.modified = 0
		END
		FETCH NEXT FROM @clientcur INTO @cliID
		END
        CLOSE @clientcur
		DEALLOCATE @clientcur
	END
SET @o_xmlText =(
	SELECT
(SELECT '3' as '@_type_', ctbl.cid as  '@clientId', ctbl.cdisplayName as '@clientName', ctbl.cguid as '@clientGUID' FOR XML PATH('eDiscoveryClient'), type),-- CLIENT_ENTITY
	(SELECT ctbl.description as '@description', ctbl.status as '@status', ctbl.installDate as '@installDate',
ISNULL((SELECT attrVal FROM APP_ClientProp (NOLOCK) Where componentNameId = ctbl.cId AND attrname = 'Case Manager Case Type' AND modified = 0),0) as '@caseType',
		ctbl.noOfCustodians as 'numberOfCustodians',
--appTypeIds
	(SELECT ida.appTypeId as '@val' FROM APP_IDAName ida INNER JOIN #EDiscoveryClientListTbl clientList ON ida.clientId = clientList.cid  AND clientList.cid = ctbl.cid FOR XML PATH('appTypeIds'),type),
--owners
(SELECT  '158' as '@_type_', planId as  '@planId', p.name as '@planName' FROM app_plan p where cp.planId=p.id   FOR XML PATH('plan'), type),--PLAN_ENTITY
(SELECT  '158' as '@_type_', p.id as  '@planId', p.name as '@planName' FROM app_plan p where cp.serverPlanId=p.id   FOR XML PATH('additionalPlans'), type),
(SELECT entitySecurityAssociation AS 'securityAssociations' FROM #FinalXMLList AS TmpXmlList WHERE TmpXmlList.c_id = cid FOR XML PATH(''), TYPE),
(SELECT capabilities AS '@capabilities', (SELECT userId AS '@userId',  userName AS '@userName' FOR XML PATH('user'), type)   FROM #UserTable usersList WHERE usersList.c_id=cid FOR XML PATH('userCapabilities') ,type)
	FROM #EDiscoveryClientPropTbl cp where cp.cid=ctbl.cid
	FOR xml path('eDiscoveryClientInfo'), TYPE),
( SELECT agentType as '@type',
	metrics as '@metrics',
		( SELECT appTypeId as '@applicationId', instanceId as '@instanceId', instanceName as '@instanceName', backupsetId as '@backupsetId', backupsetName as '@backupsetName', backupSetGUID as '@backupsetGUID',
			clientId as '@clientId', clientName '@clientName',	agentId  as '@agentId', subclientId as '@subclientId',
			subclientName as '@subclientName' FOR XML PATH ('subclient'), type)
			FROM #tmpbkpsetlist T where T.clientId = ctbl.cid
	FOR XML PATH('metricsBackupSetList'), TYPE)
FROM #EDiscoveryClientListTbl ctbl
ORDER BY ctbl.installDate DESC
FOR XML PATH('eDiscoveryClientProp'), TYPE)
EXIT_SCRIPT:
	 SET @o_xmlText = (select @o_xmlText FOR XML PATH(''),ROOT('App_GetEDiscoveryClientPropertiesResponse'))
	IF object_id('tempdb.dbo.#EDiscoveryClientPropTbl') IS NOT NULL
		DROP TABLE #EDiscoveryClientPropTbl
	IF object_id('tempdb.dbo.#EDiscoveryClientListTbl') IS NOT NULL
		DROP TABLE #EDiscoveryClientListTbl
	IF OBJECT_ID('tempdb.dbo.#usersAndGroupsVisible ') IS NOT NULL
        DROP TABLE #usersAndGroupsVisible
	IF object_id('tempdb.dbo.#FinalXMLList') IS NOT NULL
		DROP TABLE #FinalXMLList
	IF object_id('tempdb.dbo.#UserTable') IS NOT NULL
		DROP TABLE #UserTable
	IF object_id('tempdb.dbo.#tmpbkpsetlist') IS NOT NULL
		DROP TABLE #tmpbkpsetlist
	IF object_id('tempdb.dbo.#tempSubclientSecurityObjects') IS NOT NULL
		DROP TABLE #tempSubclientSecurityObjects
	 SELECT @o_xmlText o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCaseManagerClientProperties')
	delete from GxQscripts where name = 'AppGetCaseManagerClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCaseManagerClientProperties')
	delete from GXDBVersions where aliasname = 'AppGetCaseManagerClientProperties'
GO

insert into GXDBVersions values(2, 'AppGetCaseManagerClientProperties',  '00010001000200120000', 'AppGetCaseManagerClientProperties', '00010001000200120000')
GO

