

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCachingParams.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCachingParams <<<'

IF EXISTS (select * from sysobjects where name='AppGetCachingParams')
	drop procedure AppGetCachingParams
IF EXISTS (select * from GxQscripts where name='AppGetCachingParams')
	delete from GxQscripts where name = 'AppGetCachingParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCachingParams')
	delete from GXDBVersions where aliasname = 'AppGetCachingParams'
GO
print '... Creating Procedure: AppGetCachingParams'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCachingParams
  @xmlText XML OUTPUT
AS
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
DECLARE @clientId INT = 0
DECLARE @clientName nvarchar(256)
DECLARE @enableClientSideCaching INT = 0
SET @clientId     =  ISNULL((SELECT  ref.value('@clientId', 'int') AS client
                            FROM    @xmlText.nodes('App_GetCachingParams/client') R ( ref )),0)
IF @clientId = 0
BEGIN
	SET @clientName     =  ISNULL((SELECT  ref.value('@clientName', 'nvarchar(128)') AS client
							FROM    @xmlText.nodes('App_GetCachingParams/client') R ( ref )),'')
	SET @clientId = ISNULL((SELECT id from APP_Client where name = @clientName),0)
END
-- SElect the max value, this ensures even if one clientgroup has the property set, we enable it on the clients.
SET @enableClientSideCaching = ISNULL((SELECT MAX(longVal) FROM App_ComponentProp CP
												JOIN App_ClientGroupAssoc CGA
												ON CP.componentId = CGA.clientGroupId
												and CGA.clientId = @clientId
where CP.componentType = 8
and CP.propertyTypeId = 3600
and CP.dataType = 10 and CP.modified = 0),0)
SET @xmlText =  (SELECT @enableClientSideCaching as '@enableClientSideCaching',
						(SELECT @clientId as '@clientId',
								@clientName as '@clientName'
								FOR XML PATH('client'),TYPE)
				FOR XML PATH('App_GetCachingParams'))
IF @xmlText IS NULL
    SET @xmlText = '<App_GetCachingParams/>'
END
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCachingParams')
	delete from GxQscripts where name = 'AppGetCachingParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCachingParams')
	delete from GXDBVersions where aliasname = 'AppGetCachingParams'
GO

insert into GXDBVersions values(2, 'AppGetCachingParams',  '00000000000000000000', 'AppGetCachingParams', '00000000000000000000')
GO

