

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCSVersionInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCSVersionInfo.sp,v $ $Id: AppGetCSVersionInfo.sp,v 1.1.2.5 2019/03/28 23:01:19 kvankadaru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetEDiscoveryClientProperties"
--	|	This Procedure is used to get all properties of a client.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCSVersionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCSVersionInfo <<<'
	drop procedure AppGetCSVersionInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetCSVersionInfo')
	delete from GxQscripts where name = 'AppGetCSVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCSVersionInfo')
	delete from GXDBVersions where aliasname = 'AppGetCSVersionInfo'
GO
print '... Creating Procedure: AppGetCSVersionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCSVersionInfo
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @o_xmlText xml
DECLARE @installedSPVersion  INT
DECLARE @currentSPVersion    INT
DECLARE @clientPropInstalledSP INT
DECLARE @defaultCCId int = 2
DECLARE @timeZoneStdName varchar(255) = dbo.GetClientTimeZone(@defaultCCId)
DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @csVersionInfo NVARCHAR (512)
SET @clientPropInstalledSP = (SELECT attrVal FROM App_ClientProp WHERE ComponentNameId = @defaultCCId AND attrName = 'Installed SP' AND modified = 0)
IF EXISTS(SELECT * FROM APP_ComponentProp WHERE propertyTypeId =  3624 AND componentId = @defaultCCId)
	SET @installedSPVersion = (SELECT TOP 1 InstallHistory.C.value('@sp', 'int') AS sp
	FROM (SELECT componentId, CAST(stringVal AS XML) AS historyXml
		FROM APP_ComponentProp
WHERE propertyTypeId =  3624 AND componentId = @defaultCCId ) AS results
	CROSS APPLY results.historyXml.nodes('/PatchInstallHistory/SPVer') AS InstallHistory(C)
	ORDER BY InstallHistory.C.value('@installTime','int'))
ELSE
	SET @installedSPVersion = (SELECT TOP 1 HighestSP FROM PatchInstallHistory WHERE ClientId = @defaultCCId ORDER BY OpTime)
SET @currentSPVersion = (SELECT TOP 1 HighestSP FROM PatchInstallHistory WHERE ClientId = @defaultCCId ORDER BY OpTime DESC)
--csVersionInfo = 11 SP15, 11 SP15+, 11 SP15 HPK5+ ...
SET @csVersionInfo = ISNULL((SELECT attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @defaultCCId and attrName = 'SP Version Info' AND modified = 0), '')
IF @clientPropInstalledSP IS NULL OR  @clientPropInstalledSP <> @installedSPVersion
BEGIN
IF NOT EXISTS(SELECT 1 FROM App_ClientProp WHERE ComponentNameId = @defaultCCId AND attrName = 'Installed SP' AND modified = 0)
	BEGIN
		INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT @defaultCCId, 'Installed SP', 7, @installedSPVersion, @nowTime, 0
	END
	ELSE
	BEGIN
UPDATE App_ClientProp SET attrVal = @installedSPVersion, created = @nowTime WHERE componentNameId = @defaultCCId AND attrName = 'Installed SP' AND modified = 0
	END
END
SET @o_xmlText=	(SELECT(
	SELECT
	@installedSPVersion as '@installedSPVersion', @currentSPVersion as '@currentSPVersion',
	releaseId as '@releaseId', net_hostname '@hostName', timeZone  '@timeZone', @csVersionInfo '@csVersionInfo'
	,(select aliasName as '@commCellName' ,csGUID as '@csGUID', @defaultCCId as '@commCellId' FOR XML PATH('commcell'), type)
	,(SELECT TimeZoneId AS '@TimeZoneID', TimeZoneStdName '@TimeZoneName'  FROM SchedTimeZone  WHERE TimeZoneStdName = @timeZoneStdName FOR XML PATH('csTimeZone'), type)
	FROM APP_CommCell CC
	INNER JOIN APP_Client C ON C.id=CC.ID
	WHERE CC.id=@defaultCCId
	FOR XML PATH('Api_CommCellProperties'), TYPE))
SELECT @o_xmlText o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCSVersionInfo')
	delete from GxQscripts where name = 'AppGetCSVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCSVersionInfo')
	delete from GXDBVersions where aliasname = 'AppGetCSVersionInfo'
GO

insert into GXDBVersions values(2, 'AppGetCSVersionInfo',  '00010001000200050000', 'AppGetCSVersionInfo', '00010001000200050000')
GO

