

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCSFailoverLastSyncTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCSFailoverLastSyncTime')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCSFailoverLastSyncTime <<<'
	drop procedure AppGetCSFailoverLastSyncTime
END
IF EXISTS (select * from GxQscripts where name='AppGetCSFailoverLastSyncTime')
	delete from GxQscripts where name = 'AppGetCSFailoverLastSyncTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCSFailoverLastSyncTime')
	delete from GXDBVersions where aliasname = 'AppGetCSFailoverLastSyncTime'
GO
print '... Creating Procedure: AppGetCSFailoverLastSyncTime'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCSFailoverLastSyncTime
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString	XML
	DECLARE @csSecondInstanceClientID 		INT = 0
	SELECT	@csSecondInstanceClientID = CONVERT(INT, attrval)
	FROM	APP_ClientProp
	WHERE	componentnameID = 2
		AND	attrName = 'Failover Instance ClientID'
		AND modified = 0
	IF OBJECT_ID('tempdb.dbo.#failoverNodesInfo') IS NOT NULL
	DROP TABLE #failoverNodesInfo
	CREATE TABLE #failoverNodesInfo (
		clientId		INT,
		subTaskId		INT,
		lastSyncTime	INT,
		scheduleCreatedTime INT
	)
	INSERT INTO #failoverNodesInfo(clientId)
	SELECT DISTINCT PKG.ClientId
	FROM SimInstalledPackages PKG
INNER JOIN App_application AP ON PKG.SimpackageId IN (24, 1024)
		AND PKG.ClientId <> @csSecondInstanceClientID
		AND PKG.clientId = AP.clientId
		AND AP.appTypeId = 81 -- CV_APPTYPE_MSSQL
	LEFT JOIN App_Clientprop CP ON CP.componentnameId = AP.clientId
		AND CP.attrname = 'Failover RecoveryType' --CV_PROP_FAILOVER_RECOVERYTYPE
	DECLARE @csTimezone NVARCHAR(1204) = ''
	SELECT @csTimezone = dbo.getClientTimezone(2)
	UPDATE F
	SET subTaskId = ST.subTaskId,
	scheduleCreatedTime = dbo.getunixtime(dbo.LocalToUTCDateTimeConversionManaged((DATEADD(SS,T.Created,'19700101')),@csTimezone))
	FROM #failoverNodesInfo F
	INNER JOIN APP_Application A ON A.clientId = @csSecondInstanceClientID
	INNER JOIN TM_AssocEntity AE ON AE.instanceId = A.instance
		AND AE.apptypeId = A.appTypeId
		AND AE.clientId = A.clientId
	INNER JOIN TM_Task T ON T.taskId = AE.taskId
		AND T.deleted = 0
	INNER JOIN TM_SubTask ST ON ST.taskId = T.taskId
AND (ST.flags & 0x200000) > 0
		AND ST.operationType = 1007 -- SITE_REPLICATION
INNER JOIN TM_SubTaskOptions STO ON STO.optionId = 293753447
		AND STO.subTaskId = ST.subTaskId
		AND STO.value = CONVERT(NVARCHAR(100), F.clientId)
	WHERE A.appTypeId = 81 -- CV_APPTYPE_MSSQL
		AND dbo.IsSubClientValid(A.appTypeId, subclientStatus, 0) = 1
	UPDATE F
	SET lastSyncTime = ISNULL(SUB2.lastSyncTime, servStartDate)
	FROM #failoverNodesInfo F
	JOIN (SELECT SUB.subTaskId, BS.servStartDate, MAX(DBI.backup_finish_Date) lastSyncTime
	FROM (
		SELECT NI.subTaskId, LSR.subClientId, MAX(LSR.lastBackupTime) lastBackupTime
		FROM #failoverNodesInfo NI
		JOIN APP_LiveSyncReplication LSR ON LSR.subTaskId = NI.subtaskId
		GROUP BY NI.subtaskId, LSR.subclientId) SUB
	JOIN JMBkpStats BS ON BS.servEndDate = SUB.lastBackupTime
		AND BS.appId = SUB.subclientId
	LEFT JOIN sqlDbBackupInfo DBI ON DBI.jobId = BS.jobId
	WHERE BS.status IN (1,3,14)
		AND BS.commCellId = 2
	GROUP BY SUB.subtaskId, BS.servStartDate) SUB2 ON SUB2.subtaskId = F.subtaskId
	DECLARE @XML XML;
	SET @XML =(
		SELECT lastSyncTime '@lastSyncTime',
		scheduleCreatedTime '@scheduleCreatedTime',
		clientId AS 'client/@clientId'
	FROM #failoverNodesInfo
	FOR XML PATH('lastSyncTimeList'),ROOT('App_CSFailoverLastSycTimesResp')
	)
	SELECT @XML
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCSFailoverLastSyncTime')
	delete from GxQscripts where name = 'AppGetCSFailoverLastSyncTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCSFailoverLastSyncTime')
	delete from GXDBVersions where aliasname = 'AppGetCSFailoverLastSyncTime'
GO

insert into GXDBVersions values(2, 'AppGetCSFailoverLastSyncTime',  '00000000000000000000', 'AppGetCSFailoverLastSyncTime', '00000000000000000000')
GO

