

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCSFailoverInstallStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCSFailoverInstallStatus.sp,v $ $Id: AppGetCSFailoverInstallStatus.sp,v 1.1.2.1 2020/12/31 00:27:23 kbora Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE   :   "AppGetCSFailoverInstallStatus"                            |
--  |       Author      :    kbora                                          |
--  |                                   |
--  +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCSFailoverInstallStatus')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCSFailoverInstallStatus <<<'
	drop procedure AppGetCSFailoverInstallStatus
END
IF EXISTS (select * from GxQscripts where name='AppGetCSFailoverInstallStatus')
	delete from GxQscripts where name = 'AppGetCSFailoverInstallStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCSFailoverInstallStatus')
	delete from GXDBVersions where aliasname = 'AppGetCSFailoverInstallStatus'
GO
print '... Creating Procedure: AppGetCSFailoverInstallStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCSFailoverInstallStatus
AS
  DECLARE @ErrorCode INTEGER
  DECLARE @ErrStr VARCHAR(1024)
SET @ErrorCode = 0
SET @ErrStr = 'LiveSync install is valid.'
IF NOT EXISTS(  SELECT 1 FROM APP_ClientProp A
				INNER JOIN APP_ClientProp B ON A.attrVal = B.attrVal
				AND A.attrName = 'Active CS Client' AND A.modified = 0 AND A.componentNameId = 2
				AND B.attrName = 'Linked CS Client' AND B.modified = 0
				)
BEGIN
	SET @ErrorCode = 1
	SET @ErrStr = 'Active CS Client is not configured.'
END
IF EXISTS (	SELECT 1
			FROM simInstalledPackages  Pkg
			LEFT JOIN APP_ClientProp CL ON Pkg.ClientId = CL.componentNameId
				AND CL.attrName = 'Linked CS Client' AND CL.modified = 0
WHERE simPackageID IN (24, 1024)
				AND CL.id IS NULL
			)
BEGIN
	SET @ErrorCode = 1
	SET @ErrStr = 'Linked CS Client is not configured for some of the stand by nodes.'
END
ERROR_EXIT:
SELECT @ErrorCode, @ErrStr
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCSFailoverInstallStatus')
	delete from GxQscripts where name = 'AppGetCSFailoverInstallStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCSFailoverInstallStatus')
	delete from GXDBVersions where aliasname = 'AppGetCSFailoverInstallStatus'
GO

insert into GXDBVersions values(2, 'AppGetCSFailoverInstallStatus',  '00010001000200010000', 'AppGetCSFailoverInstallStatus', '00010001000200010000')
GO

