

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCSFailoverConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCSFailoverConfig')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCSFailoverConfig <<<'
	drop procedure AppGetCSFailoverConfig
END
IF EXISTS (select * from GxQscripts where name='AppGetCSFailoverConfig')
	delete from GxQscripts where name = 'AppGetCSFailoverConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCSFailoverConfig')
	delete from GXDBVersions where aliasname = 'AppGetCSFailoverConfig'
GO
print '... Creating Procedure: AppGetCSFailoverConfig'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCSFailoverConfig
  @i_xmlString XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
	-- Output xml string.
	DECLARE	@o_xmlString	XML
	-- Error handlers.
	DECLARE	@errorCode		INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = N''
	DECLARE @userId			INT = 0
	DECLARE @isAdminUser	INT = 0
	DECLARE @sendAlertInfo	INT = 0
	DECLARE @getMonitoredClientsInfo INT = 0
	DECLARE @getMiscSettings INT = 0
	DECLARE @getFailoverNodesInfo INT = 0
	DECLARE @getScheduleDetails INT = 0
	DECLARE @getNetworkDetails INT = 0
	DECLARE @getMonitoringNodesInfo INT = 0
	DECLARE @miscSettings XML = null
	DECLARE @monitoringClients XML = null
	DECLARE @failoverNodes XML = null
	DECLARE @failoverScheduleDetails XML = null
	DECLARE @monitoringNodes XML = null
	DECLARE @networkInfo XML = null
	DECLARE @i_localeId int = 0
	DECLARE @liveSyncStoragePolicy int = 0
	DECLARE @liveSyncSPName nvarchar(max) = ''
	DECLARE @isFailoverPackageConfigured int = 0
	DECLARE @isDRCSConfigured  int = 0
	DECLARE @backupScheduleTaskId INT = 0
	DECLARE @backupScheduleTaskName NVARCHAR(MAX) = ''
	DECLARE @tlScheduleId INT = 0
	DECLARE @tlScheduleName NVARCHAR(MAX) = ''
	DECLARE @alertIDCSFailover	INT = 0
	DECLARE @alertNameCSFailover NVARCHAR(MAX) = ''
	DECLARE @cvFailoverConfigStatus INT = 0 -- Keep it off by default
	DECLARE @isAutomaticFailoverEnabled INT = 0 -- Keep it off by default
	DECLARE @isDRInstanceConfigurationPending INT = 0
	DECLARE @isActiveInstanceConfigurationPending INT = 0
	DECLARE @failoverNodeVersion XML = null
	DECLARE @testFailoverNode XML = null
	DECLARE @readOnlyProductionFailoverNode XML = null
	DECLARE @isAutoScaleEnabled INT = 0 -- Keep it off by default
	DECLARE @hypervisorClientId INT = 0
	-- Reading from xml.
	-- First get whether we need to send miscSettings from Gxglobalparam
	SET @i_localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
      FROM    @i_xmlString.nodes('App_GetMonitoredNodesFailoverReq/processinginstructioninfo/locale') R ( ref )),0)
	SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
              FROM @i_xmlString.nodes('App_GetMonitoredNodesFailoverReq/processinginstructioninfo/user') R(ref)), 0)
	select @sendAlertInfo = ref.value('@sendAlertInfo', 'int'),
		@getMonitoredClientsInfo = ref.value('@getMonitoredClientsInfo', 'int'),
		@getMiscSettings = ref.value('@getMiscSettings', 'int'),
		@getFailoverNodesInfo = ref.value('@getFailoverNodesInfo', 'int'),
		@getScheduleDetails = ref.value('@getScheduleDetails', 'int'),
		@getNetworkDetails = ref.value('@getNetworkDetails', 'int'),
		@getMonitoringNodesInfo = ref.value('@getMonitoringNodesInfo', 'int')
		FROM @i_xmlString.nodes('App_GetMonitoredNodesFailoverReq') R(ref)
	-- First get clientId for second Instance of CS client.
	-- get other second instance client Ids and check whether there is any row for this in App_Virtualapp
	DECLARE @csSecondInstanceClientID INT = 0
	--const string CV_PROP_FAILOVER_CLIENTID = "Failover Instance ClientID";
	SELECT @csSecondInstanceClientID = CONVERT(INT, attrval) FROM App_clientprop
	WHERE componentnameID=2 AND attrname = N'Failover Instance ClientID' AND modified=0
	--Check if failover package is installed
	IF @csSecondInstanceClientID <> 0
	BEGIN
		IF NOT EXISTS(SELECT 1
					FROM simInstalledPackages(NOLOCK)
					WHERE clientId = @csSecondInstanceClientID
AND simPackageID IN (24, 1024))
			SET @csSecondInstanceClientID = 0
	END
	SELECT @backupScheduleTaskId = TM_Task.TaskId, @backupScheduleTaskName = TM_Task.TaskName,
		@tlScheduleId = TM_Subtask.subtaskId, @tlScheduleName = TM_Subtask.subtaskName
		FROM TM_Subtask
INNER JOIN TM_Task ON TM_Subtask.taskId = TM_task.taskId AND TM_task.deleted=0 and (TM_Subtask.flags & 0x80000)>0
	SELECT @alertIDCSFailover = id , @alertNameCSFailover = notificationName FROM
NTNotificationRule (NOLOCK) where alertTypeId = 74
	AND revision = 1
AND (status & 2 )=0 -- it should not be deleted.
AND (status & 524288 )>0 -- we should return alert here created from config wizard
	-- Ensure sql second instance clientId has sql server subclient
	IF NOT EXISTS(select 1 from App_application where clientId=@csSecondInstanceClientID and appTypeId=81) -- CV_APPTYPE_MSSQL
	begin
		-- Check if CS Second instance wasnt configured then we check whether instance discovery is pending.
IF EXISTS(SELECT 1 FROM SimInstalledPackages PKG INNER JOIN App_Client on PKG.SimpackageId IN (24, 1024)
			AND App_Client.Id=@csSecondInstanceClientID
			and PKG.clientId=App_Client.Id)
		BEGIN
			SET @isActiveInstanceConfigurationPending = 1
		END
		set @csSecondInstanceClientID = 0
	end
	if (@csSecondInstanceClientID>0)
	begin
		set @isFailoverPackageConfigured = 1
	end
	DECLARE @defaultScName NVARCHAR(MAX) = ''
	DECLARE @defaultScId INT = 0
	DECLARE @dataSP INT = 1
	DECLARE @logSP INT = 1
	SELECT TOP 1 @defaultScName = App_application.subclientname, @defaultScId = App_application.id , @dataSP = App_Application.dataArchGrpId , @logSP = App_Application.logArchGrpId
	FROM App_Application
	INNER JOIN app_instancename on App_InstanceName.Id = App_Application.instance --and App_InstanceName.name like '%commvault%'
	INNER JOIN CvFailoverLogShippingScInfo ON CvFailoverLogShippingScInfo.LogshippingSubclientId = App_application.Id
	WHERE App_Application.clientId = @csSecondInstanceClientID
	AND App_Application.appTypeId=81 -- CV_APPTYPE_MSSQL
	AND dbo.issubclientvalid(App_Application.appTypeId,subclientStatus,0)=1
	AND App_application.subclientname = 'CvFailoverLogShipping'
AND (App_application.subclientStatus & 0x00004) = 0
	ORDER BY App_InstanceName.Id DESC
SELECT @cvFailoverConfigStatus = CONVERT(INT,value) FROM GxGlobalparam WHERE name='nCSFailoverConfigStatus' AND modified = 0
SELECT @isAutomaticFailoverEnabled = CONVERT(INT,value) FROM GxGlobalparam WHERE name='nCSAutoFailoverConfigStatus' AND modified = 0
SELECT @isAutoScaleEnabled = CONVERT(INT,value) FROM GxGlobalparam WHERE name='nCSFailoverAutoScaleConfigStatus' AND modified = 0
SELECT @hypervisorClientId = CONVERT(INT,value) FROM GxGlobalparam WHERE name = 'nCSFailoverHyperVisorClientId' AND modified = 0
	-- check whether DR CS is configured
	if exists(select 1
from SimInstalledPackages PKG inner join App_application on PKG.SimpackageId IN (24, 1024)
			and PKG.ClientId<>@csSecondInstanceClientID
			and PKG.clientId=App_application.clientId
			and App_application.appTypeId=81 -- CV_APPTYPE_MSSQL
		)
		begin
			set @isDRCSConfigured = 1
		end
		-- Check if DR CS wasnt configured then we check whether instance discovery is pending.
IF (@isDRCSConfigured = 0 AND EXISTS(SELECT 1 FROM SimInstalledPackages PKG INNER JOIN App_Client on PKG.SimpackageId IN (24, 1024)
			AND App_Client.Id<>@csSecondInstanceClientID
			and PKG.clientId=App_Client.Id) )
		BEGIN
			SET @isDRInstanceConfigurationPending = 1
		END
	-- check whether user has administrative management at CS level.Else dont return these details.
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
	IF(@isAdminUser = 0)
	BEGIN
		SET @errorCode  = 1
SET @errorString = ( SELECT message FROM EvLocaleMsgs WITH(nolock) WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId )
		GOTO ERROR_EXIT
	END
	SELECT @liveSyncStoragePolicy = dataArchGrpID, @liveSyncSPName=archgroup.name FROM App_application
		INNER JOIN Archgroup on dataArchGrpID=Archgroup.id
		WHERE App_application.id=@defaultScId
	-- If its not configured, then default it to DR policy
	IF (@liveSyncStoragePolicy=1)
	BEGIN
		SELECT @liveSyncStoragePolicy = id, @liveSyncSPName=name FROM Archgroup (NOLOCK) WHERE type=2 -- CVA_COMMSERVE_ER_SP
	END
	DECLARE @activeNodeHwConfig XML
	IF @isAutoScaleEnabled > 0
	BEGIN
		SELECT @activeNodeHwConfig = CONVERT(XML,value) FROM GXGlobalParam
WHERE name = 'CSFailoverActiveNodeHwConfig'
	END
	-- Fill misc Settings if needed
	if @getMiscSettings <> 0
	begin
		DECLARE @monitoringInterval int = 5 -- default to 5 mins
		DECLARE @criticalFailOverStrikeCount int = 4 -- default to 1 hour
		DECLARE @failOverType int = 0 -- default to manual failover
		DECLARE @csSupportedDBs XML
		DECLARE @csDefaultSupportedDBs XML
		DECLARE @backupMetadataFolder NVARCHAR(2048) = ''
		DECLARE @networkUserName NVARCHAR(256) = (SELECT userName FROM APP_CommCell WHERE id = 2)
		DECLARE @networkPasswd NVARCHAR(2048) = (SELECT userPassword FROM APP_CommCell WHERE id = 2)
		DECLARE @csTestFailoverCG int
		DECLARE @csTestFailoverProxyCG int
		DECLARE @floatingCSHostName INT = 0
		-- if user name isnt set then dont set passwd
		if (@networkUserName is null Or len(@networkUserName)=0)
		begin
			set @networkUserName = null
			set @networkPasswd = null
		end
		SELECT @backupMetadataFolder = value FROM GXGlobalParam WHERE NAME = N'DRDumpLocation' AND modified = 0
		-- CV_APPTYPE_MSSQL
		SELECT @monitoringInterval = value FROM Gxglobalparam
WHERE name='CSMonitoringInterval'
		AND modified=0
		SELECT @criticalFailOverStrikeCount = value FROM Gxglobalparam
WHERE name='CSCriticalFailOverTimeOutCount'
		AND modified=0
		SELECT @failOverType = value FROM Gxglobalparam
WHERE name='CSFailoverType'
		AND modified=0
		SELECT @csSupportedDBs = convert(xml,value) FROM Gxglobalparam
WHERE name='CSSupportedDBForFailover'
		AND modified=0
		SELECT @csTestFailoverCG = convert(int,value) FROM Gxglobalparam
WHERE name='CSTestFailoverClientGroup'
		AND modified=0
		SELECT @csTestFailoverProxyCG = convert(int,value) FROM Gxglobalparam
WHERE name='CSTestFailoverProxyClientGroup'
		AND modified=0
		SELECT @csDefaultSupportedDBs = convert(xml,value) FROM Gxglobalparam
WHERE name='CSDefaultSupportedDBForFailover'
		AND modified=0
		SELECT @floatingCSHostName = CONVERT(INT,value) FROM Gxglobalparam
WHERE name='nCvFailoverFloatingHostName'
		AND modified=0
		-- get live sync storage policy from subclient
		set @miscSettings = ( select @monitoringInterval '@monitoringInterval', @criticalFailOverStrikeCount '@criticalFailOverStrikeCount', @failOverType '@failOverType' , @floatingCSHostName '@floatingCommserveHostName',
			(
				select	(
							SELECT dbName '@val' from
							(
								select ref.value('@val', 'nvarchar(100)') as dbName
								from @csSupportedDBs.nodes('App_CSFailoverDatabases/supportedDatabases') R(ref)
								intersect
								SELECT name FROM sys.databases
							)  t
							for xml path('supportedDatabases'),type
						),
						(
							SELECT ScContent.attrname '@val' FROM
							(
								SELECT DISTINCT App_subclientprop.attrname
								FROM App_subclientprop WHERE ComponentNameId = @defaultScId
								AND attrType=118 -- PROPERTY_MSSQL_DB
								AND App_subclientprop.modified=0
								UNION
								SELECT DefaultDBs.dbName FROM
								-- IF subclient content isnt set return all Dbs except History
								(
									select ref.value('@val', 'nvarchar(100)') as dbName
									from @csDefaultSupportedDBs.nodes('App_CSFailoverDatabases/supportedDatabases') R(ref)
									INTERSECT
									SELECT name FROM sys.databases
								) DefaultDBs
								wHERE NOT EXISTS
								(
									SELECT 1 FROM App_subclientprop WHERE ComponentNameId = @defaultScId
									AND attrType=118 -- PROPERTY_MSSQL_DB
									AND App_subclientprop.modified=0
								)
							) ScContent
							inner join
							(
								select ref.value('@val', 'nvarchar(100)') as dbName
								from @csSupportedDBs.nodes('App_CSFailoverDatabases/supportedDatabases') R(ref)
								intersect
								SELECT name FROM sys.databases
							) SupportedDB on
							SupportedDB.dbName=ScContent.attrname
							for xml path('selectedDatabases'),type
						)
					for xml path('csFailoverDatabases'),type
				),
			(
				(SELECT @backupMetadataFolder '@backupMetadataFolder',
					(SELECT @networkUserName AS '@userName',
							@networkPasswd As '@password'
							FOR XML PATH('networkUserAccount'),TYPE)
					for xml path('drDumpSettings'),type
				)
			),
			(
				select id '@clientGroupId',name '@clientGroupName' from app_clientgroup
				where id = @csTestFailoverCG
				for xml path('testFailoverClientGroup'),type
			),
			(
				select id '@clientGroupId',name '@clientGroupName' from app_clientgroup
				where id = @csTestFailoverProxyCG
				for xml path('testFailoverProxyGroup'),type
			),
			(
				SELECT id '@clientGroupId',name '@clientGroupName' FROM APP_ClientGroup
WHERE name = 'Monitoring Clients'
				FOR XML PATH('MonitoringClients'),TYPE
			)
			for xml path('miscSettings') )
	end
	if (@getMonitoredClientsInfo<>0)
	begin
			set @monitoringClients = (
				select
					(select App_client.id '@clientId', App_client.name '@clientName' from
					(
						-- Get list of clients which have High Availability package installed. And exclude clients which are selected.
--SELECT PKG.ClientId clientId from SimInstalledPackages PKG WHERE PKG.SimpackageId = 725
						--intersect
						--select componentNameId from app_clientprop where attrname = N'CS Failover Monitoring' and attrVal = N'0'
						-- Get list of clients. And exclude clients which are selected.
						SELECT PKG.ClientId clientId from SimInstalledPackages PKG
						except
						(
							-- Exclude clients which are selected.
SELECT PKG.ClientId clientId from SimInstalledPackages PKG WHERE PKG.SimpackageId = 725
							except
							select componentNameId from app_clientprop where attrname = N'CS Failover Monitoring' and attrVal = N'0'
						)
						--select componentNameId from app_clientprop where attrname = N'CS Failover Monitoring' and attrVal = N'0'
					) t
					inner join App_client on t.clientId = App_client.id
					for xml path('availableClients'),type),
					(select App_client.id '@clientId', App_client.name '@clientName' from
					(
						-- Get list of clients which have High Availability package installed. And exclude clients which are selected.
SELECT PKG.ClientId clientId from SimInstalledPackages PKG WHERE PKG.SimpackageId = 725
						except
						select componentNameId from app_clientprop where attrname = N'CS Failover Monitoring' and attrVal = N'0'
					) t
					inner join App_client on t.clientId = App_client.id
					for xml path('selectedClients'),type)
					for xml path('monitoringClients')
				)
	end
	if ( @isAutomaticFailoverEnabled > 0 AND @getMonitoringNodesInfo > 0 )
	begin
			IF OBJECT_ID('TEMPDB..#FilteredClientList') IS NOT NULL
				DROP TABLE #FilteredClientList
			CREATE TABLE #FilteredClientList(clientId INT Primary Key(clientId))
			INSERT INTO #FilteredClientList
			SELECT id FROM App_Client
			WHERE id > 1
AND (status & 0x00002) = 0
				AND csHostName <> ''
AND specialClientFlags & (CAST(0x20 AS INT) | CAST(0x200 AS INT)) = 0
			-- Filter out CommServ clients, Failover clients.
			DELETE T FROM #FilteredClientList T
WHERE EXISTS (SELECT 1 FROM SimInstalledPackages A WHERE T.clientId = A.clientId AND A.SimpackageId IN ( 1020, 20, 24, 1024))
			-- Filter out any pseudo clients, they do not have packags.
			DELETE T FROM #FilteredClientList T
			WHERE NOT EXISTS (SELECT 1 FROM SimInstalledPackages A WHERE T.clientId = A.clientId)
			-- Filter out Index server clients.
			DELETE T FROM #FilteredClientList T
WHERE EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = T.clientId AND attrName = N'Index Server Type'  AND CAST(attrVal AS INT) = 15 AND modified = 0)
			-- Filter out Cluster clients.
			DELETE T FROM #FilteredClientList T
			WHERE EXISTS(SELECT 1 FROM APP_VMToPMMap WHERE VMClientId = T.clientId OR PMClientId = T.clientId)
			-- Filter out Un supported OS types.
			DELETE T
			FROM #FilteredClientList T
			WHERE NOT EXISTS(SELECT 1 FROM APP_ClientProp
						WHERE componentNameId  = T.clientId AND attrName LIKE 'Binary Set ID'
AND CAST(attrVal AS INT) IN (3, 18) AND modified = 0
						)
			-- Filter out already monitoring nodes.
			DELETE T FROM #FilteredClientList T
WHERE EXISTS (SELECT 1 FROM App_ClientProp C WHERE C.componentNameId = T.clientId AND C.attrName = N'CSLiveSync Monitoring Client' AND C.attrVal = N'1' AND C.modified = 0)
			SET @monitoringNodes = (
			SELECT
				(SELECT 0 '@lastSyncTime', 0 '@status', A.id 'node/@clientId', A.name 'node/@clientName'
				FROM APP_Client A INNER JOIN #FilteredClientList T ON T.clientId = A.id
				FOR XML PATH('availableClients'),type),
				(SELECT  0 '@lastSyncTime', 0 '@status', A.id 'node/@clientId', A.name 'node/@clientName'
FROM APP_Client A INNER JOIN App_ClientProp B ON B.componentNameId = A.id AND B.attrName = N'CSLiveSync Monitoring Client' AND B.attrVal = N'1' AND B.modified = 0
				FOR XML PATH('selectedClients'),type)
				FOR XML PATH('monitoringNodes')
				)
	END
	set @failoverNodeVersion = (
		select
			ac.id '@clientId'
			,cp.attrVal 'versionInfo/@version'
			,gr.release 'versionInfo/GalaxyRelease/@ReleaseString'
		from (
			SELECT PKG.ClientId clientId from SimInstalledPackages PKG WHERE PKG.SimpackageId = 725
			except
			select componentNameId from app_clientprop where attrname = N'CS Failover Monitoring' and attrVal = N'0'
		) t inner join App_client ac on t.clientId = ac.id
		left join simAllGalaxyRel gr on gr.id = ac.releaseId
		left join APP_ClientProp cp on cp.componentNameId = ac.id
		where cp.attrName = N'SP Version and Patch Info'
		for xml path('failoverNodeVersion')
	)
	if (@getFailoverNodesInfo <> 0)
	begin
		-- if secondinstance client is not configured, then dont send failover nodes.
		if (@csSecondInstanceClientID>0)
		begin
			if object_id('tempdb.dbo.#failoverNodesInfo') is not null
			BEGIN
				DROP TABLE #failoverNodesInfo
			END
			CREATE TABLE #failoverNodesInfo (sourceClientID integer, destinationclientID int, recoveryMode int, taskId int, subtaskId INT
											, subTaskName NVARCHAR(255), lastSyncTime INT, lastRestoreTime INT, destinationInstanceId INT DEFAULT 0
											, primary key(sourceClientID,destinationclientID ) )
			Insert into #failoverNodesInfo
			select distinct @csSecondInstanceClientID, PKG.ClientId,App_Clientprop.attrval ,0, 0, '', 0, 0, 0
from SimInstalledPackages PKG inner join App_application on PKG.SimpackageId IN (24, 1024)
			and PKG.ClientId<>@csSecondInstanceClientID
			and PKG.clientId=App_application.clientId
			and App_application.appTypeId=81 -- CV_APPTYPE_MSSQL
			left join App_Clientprop on App_Clientprop.componentnameId=App_application.clientId
			and App_Clientprop.attrname = N'Failover RecoveryType' --CV_PROP_FAILOVER_RECOVERYTYPE
			Update failoverNodesInfo
			set taskId = TM_subtask.taskId,
			subTaskId = TM_subtask.subTaskId,
			subTaskName = TM_subtask.subTaskName
			from #failoverNodesInfo failoverNodesInfo
			inner join App_Application on App_Application.clientId = failoverNodesInfo.sourceClientID
			inner join TM_AssocEntity on TM_AssocEntity.instanceId = App_Application.instance
			and TM_AssocEntity.apptypeId = App_Application.appTypeId
			and TM_AssocEntity.clientId = App_Application.clientId
			inner join TM_Task on TM_Task.taskId = TM_AssocEntity.taskId
			and TM_Task.deleted=0
inner join TM_Subtask on TM_Subtask.taskId = tm_task.taskId and (TM_subtask.flags & 0x200000)>0
			and TM_subtask.operationType = 1007 -- SITE_REPLICATION
inner join TM_subtaskOptions on TM_subtaskOptions.optionId = 293753447 and TM_subtaskoptions.subtaskid = TM_subtask.subtaskId
			and TM_subtaskOptions.value=convert(nvarchar(100),  failoverNodesInfo.destinationclientID)
			where  App_Application.appTypeId=81 -- CV_APPTYPE_MSSQL
			and dbo.issubclientvalid(App_Application.appTypeId,subclientStatus,0)=1
			-- Identify Destination instance ID
			UPDATE failoverNodesInfo
			SET destinationInstanceId = App_Application.instance
			FROM #failoverNodesInfo failoverNodesInfo
			INNER JOIN App_Application ON App_Application.clientId = failoverNodesInfo.destinationclientID and appTypeId=81 -- CV_APPTYPE_MSSQL
			INNER JOIN App_InstanceName on App_InstanceName.Id = App_Application.instance
			INNER JOIN
			(
				SELECT INNERTbl.clientId,count(DISTINCT instance) instanceCount FROM APP_Application (NOLOCK) INNERTbl
					INNER JOIN #failoverNodesInfo failoverNodesInfo ON failoverNodesInfo.destinationclientID = INNERTbl.clientId
					AND INNERTbl.appTypeId = 81 -- CV_APPTYPE_MSSQL
					AND dbo.issubclientvalid(INNERTbl.appTypeId,INNERTbl.subclientStatus,0)=1
					GROUP BY INNERTbl.clientId
			) FailoverInstancesCount ON FailoverInstancesCount.clientId = App_Application.clientId
			-- Ensure when DB Instance property DatabaseSInstance is set, use that and match instance.
			LEFT JOIN App_ClientProp DBInstance WITH (NOLOCK) ON DBInstance.componentnameID=App_application.clientId AND DBInstance.attrname = N'DatabaseSInstance' AND DBInstance.modified=0		 -- CV_PROP_FAILOVER_DB_INSTANCE
			where dbo.issubclientvalid(appTypeId,subclientStatus,0)=1
			AND (DBInstance.componentnameID IS NULL OR  DBInstance.attrVal = App_InstanceName.name OR FailoverInstancesCount.instanceCount =1 )
			;with restoreInfo as
			(select ni.subTaskId, max(lsr.lastRestoreTime) lastRestoreTime
			from #failoverNodesInfo ni
			join app_livesyncreplication(nolock) lsr on lsr.subTaskId = ni.subtaskId
			group by ni.subTaskId)
			update ni
			set lastRestoreTime = ri.lastRestoreTime
			from #failoverNodesInfo ni
			join restoreInfo ri on ri.subtaskId = ni.subtaskId
			--Last sync time is the latest backup which ran before the last successful replication
			;with backupFinishDates as
			(select dbi.backup_finish_Date
			from JMBkpStats(nolock) bs
			join sqlDbBackupInfo(NOLOCK) dbi on dbi.jobId = bs.jobId
			where status in (1,3,14)
			and commcellID = 2
			and dbi.appId = @defaultScId)
			update ni
			set lastSyncTime = ISNULL((select MAX(backup_finish_Date)
								from backupFinishDates
								where backup_finish_Date < ni.lastRestoreTime), 0)
			from #failoverNodesInfo ni
			DECLARE @sourceConfigStatus INT = 0
			DECLARE @defaultRecoveryMode INT = 0 ---LIVE_SYNC
			if @dataSP = 1 OR @logSP = 1
			BEGIN
				SET @sourceConfigStatus = @sourceConfigStatus | 2 -- SUBCLIENT_NOT_CONFIGURED
			END
if not exists(select 1 from GxGlobalParam where name='CSFailoverNetworkConnectivity' and modified=0)
			BEGIN
				SET @sourceConfigStatus = @sourceConfigStatus | 4 -- CONNECTION_NOT_CONFIGURED
			END
if exists(select 1 from GxGlobalParam where name='CSFailoverRecoveryMode' and modified=0)
			BEGIN
				select @failoverScheduleDetails = value from Gxglobalparam
where name='CSFailoverRecoveryMode'
				and modified=0
				select @defaultRecoveryMode = ISNULL(@failoverScheduleDetails.value('(failoverScheduleDetails/@defaultRecoveryMode)[1]','int'),0) -- set it to live sync by default
			END
			set @failoverNodes = ( select CASE WHEN taskId>0 OR @defaultRecoveryMode = 1 THEN @sourceConfigStatus -- If node has live sync schedule or default recovery mode is DR
						ELSE @sourceConfigStatus | 1 -- RESTORE_NOT_CONFIGURED
						END '@configStatus',
					recoveryMode '@recoveryMode',
					sourceClient.cvdport '@sourceClientPort',
					destinationClient.cvdport '@destinationClientPort',
					sourceClient.jobResultDir '@sourceJobResultsDir',
					destinationClient.jobResultDir '@destinationJobResultsDir',
					sourceClientProp.attrVal '@sourceHyperVisorType',
					destinationClientProp.attrVal '@destinationHyperVisorType',
					lastSyncTime '@lastSyncTime',
					(
						SELECT CASE WHEN COUNT(DISTINCT App_Application.instance)>1 THEN 1 ELSE NULL END
							FROM App_Application (NOLOCK) INNER JOIN App_InstanceName (NOLOCK) on App_InstanceName.Id = App_Application.instance
							AND App_application.clientId = failoverNodesInfo.destinationclientID and appTypeId=81 -- CV_APPTYPE_MSSQL
							-- Ensure when DB Instance property DatabaseSInstance is set, use that and match instance.
							LEFT JOIN App_ClientProp DBInstance WITH (NOLOCK) ON DBInstance.componentnameID=App_application.clientId AND DBInstance.attrname = N'DatabaseSInstance' AND DBInstance.modified=0		 -- CV_PROP_FAILOVER_DB_INSTANCE
							WHERE dbo.issubclientvalid(appTypeId,subclientStatus,0)=1
							AND (DBInstance.componentnameID IS NULL OR  DBInstance.attrVal = App_InstanceName.name)
							GROUP BY App_application.clientId
					)'@isDRDBInstanceNeeded',
					taskId 'taskEntity/@taskId',
					subTaskId 'taskEntity/@subtaskId',
					failoverNodesInfo.subTaskName  'taskEntity/@subTaskName',
				(
					select App_Application.Id AS '@subclientId',
								App_Application.subclientName AS '@subclientName',
								App_Application.backupset AS '@backupsetId',
								APP_BackupSetName.Name AS '@backupsetName',
								App_Application.instance AS '@instanceId',
								dbo.EncodeInvalidXMLChar(APP_InstanceName.Name) AS '@instanceName',
								App_Application.appTypeId AS '@applicationId',
								App_idaType.displayName AS '@appName',
								App_Application.clientId AS '@clientId',
								App_client.name AS '@clientName',
								App_client.net_hostname AS '@hostName'
					from App_Application inner join App_client on App_Application.clientId = App_client.id
					inner join APP_BackupSetName on App_Application.backupset = APP_BackupSetName.id
					inner join App_InstanceName on App_InstanceName.Id = App_Application.instance
					inner join App_IdaType on App_IdaType.type = App_Application.appTypeId
					where clientID = failoverNodesInfo.sourceClientID and appTypeId=81 -- CV_APPTYPE_MSSQL
					AND App_Application.id = @defaultScId
					and dbo.issubclientvalid(appTypeId,subclientStatus,0)=1
					--and App_InstanceName.name like '%commvault%'
					and App_application.subclientname = @defaultScName
					for xml path('sourceEntity'),type
				),
				(
					select	distinct App_Application.instance AS '@instanceId',
								dbo.EncodeInvalidXMLChar(APP_InstanceName.Name) AS '@instanceName',
								App_Application.appTypeId AS '@applicationId',
								App_idaType.displayName AS '@appName',
								App_Application.clientId AS '@clientId',
								App_client.name AS '@clientName',
								App_client.net_hostname AS '@hostName'
					from App_Application inner join App_client on App_Application.clientId = App_client.id AND App_Application.instance = failoverNodesInfo.destinationInstanceId
					inner join App_InstanceName on App_InstanceName.Id = App_Application.instance
					inner join App_IdaType on App_IdaType.type = App_Application.appTypeId
					where clientID = failoverNodesInfo.destinationclientID and appTypeId=81 -- CV_APPTYPE_MSSQL
					and dbo.issubclientvalid(appTypeId,subclientStatus,0)=1
					FOR XML PATH('destinationEntity'),TYPE
				)
				from #failoverNodesInfo failoverNodesInfo
				inner join App_client sourceClient on failoverNodesInfo.sourceClientID = sourceClient.id
				inner join App_client destinationClient on failoverNodesInfo.destinationclientID = destinationClient.id
				LEFT JOIN App_ClientProp sourceClientProp on failoverNodesInfo.sourceClientID = sourceClientProp.componentNameId
					AND sourceClientProp.attrName = N'VSA HyperVisor Type' AND sourceClientProp.modified = 0
				LEFT JOIN App_ClientProp destinationClientProp on failoverNodesInfo.destinationclientID = destinationClientProp.componentNameId
					AND destinationClientProp.attrName = N'VSA HyperVisor Type' AND destinationClientProp.modified = 0
				for xml path('failoverNodes')
			)
			--Populate test node information
			declare @testFailoverNodeId INT = 0;
			select @testFailoverNodeId = ISNULL(TRY_CONVERT(INT, value), 0)
			from Gxglobalparam
where name='CSTestFailoverNodeId'
			and modified=0
			if @testFailoverNodeId > 0
			begin
				set @testFailoverNode =
				(
					select
					(
						select	distinct App_Application.instance AS '@instanceId',
								dbo.EncodeInvalidXMLChar(APP_InstanceName.Name) AS '@instanceName',
								App_Application.appTypeId AS '@applicationId',
								App_idaType.displayName AS '@appName',
								App_Application.clientId AS '@clientId',
								App_client.name AS '@clientName',
								App_client.net_hostname AS '@hostName'
						from App_Application inner join App_client on App_Application.clientId = App_client.id
						inner join App_InstanceName on App_InstanceName.Id = App_Application.instance
						inner join App_IdaType on App_IdaType.type = App_Application.appTypeId
						-- Ensure when DB Instance property DatabaseSInstance is set, use that and match instance.
						LEFT JOIN App_ClientProp DBInstance WITH (NOLOCK) ON DBInstance.componentnameID=App_application.clientId AND DBInstance.attrname = N'DatabaseSInstance' AND DBInstance.modified=0		 -- CV_PROP_FAILOVER_DB_INSTANCE
						where clientID = @testFailoverNodeId and appTypeId=81 -- CV_APPTYPE_MSSQL
						and dbo.issubclientvalid(appTypeId,subclientStatus,0)=1
						AND (DBInstance.componentnameID IS NULL OR  DBInstance.attrVal = App_InstanceName.name)
						--and App_InstanceName.name like '%commvault%'
						for xml path('destinationEntity'), type
					)
					for xml path('testFailoverNode')
				)
			end
			--Populate maintenance node information
			declare @isReadOnlyCommServe INT = 0;
			select @isReadOnlyCommServe = ISNULL(TRY_CONVERT(INT, value), 0)
			from Gxglobalparam
where name='ReadOnlyCommServe'
			and modified=0
			if @isReadOnlyCommServe > 0
			begin
				set @readOnlyProductionFailoverNode =
				(
					select
					(
						select	distinct App_Application.instance AS '@instanceId',
								dbo.EncodeInvalidXMLChar(APP_InstanceName.Name) AS '@instanceName',
								App_Application.appTypeId AS '@applicationId',
								App_idaType.displayName AS '@appName',
								App_Application.clientId AS '@clientId',
								App_client.name AS '@clientName',
								App_client.net_hostname AS '@hostName'
						from App_Application inner join App_client on App_Application.clientId = App_client.id
						inner join App_InstanceName on App_InstanceName.Id = App_Application.instance
						inner join App_IdaType on App_IdaType.type = App_Application.appTypeId
						-- Ensure when DB Instance property DatabaseSInstance is set, use that and match instance.
						LEFT JOIN App_ClientProp DBInstance WITH (NOLOCK) ON DBInstance.componentnameID=App_application.clientId AND DBInstance.attrname = N'DatabaseSInstance' AND DBInstance.modified=0		 -- CV_PROP_FAILOVER_DB_INSTANCE
						where clientID = @csSecondInstanceClientID and appTypeId=81 -- CV_APPTYPE_MSSQL
						and dbo.issubclientvalid(appTypeId,subclientStatus,0)=1
						AND (DBInstance.componentnameID IS NULL OR  DBInstance.attrVal = App_InstanceName.name)
						--and App_InstanceName.name like '%commvault%'
						for xml path('destinationEntity'), type
					)
					for xml path('readOnlyProductionFailoverNode')
				)
			end
		end
	end
	if (@getNetworkDetails <>0 )
	begin
		-- If its there pick from GxGlobalParam
		select @networkInfo = value from Gxglobalparam
where name='CSFailoverNetworkConnectivity'
		and modified=0
		-- else frame default string
		if (@networkInfo is null)
		begin
			set @networkInfo = (select 0 '@connectivityMode',
									(select 28 '@_type_',
										id '@clientGroupId',
										name '@clientGroupName'
									from APP_ClientGroup(nolock)
where name = 'Failover clients'
									for xml path('proxyEntity'),type)
								for xml path('networkInfo'))
		end
	end
	if (@getScheduleDetails <> 0)
	begin
		DECLARE @liveSyncRPO int = 15 -- Default it to 15 mins.
		-- Also verify pattern is there. If pattern expires, then pattern is marked deleted but schedule isnt.
		SELECT @liveSyncRPO = TM_pattern.freq_subday_interval*1.0/60 FROM TM_pattern INNER JOIN TM_Patternassoc ON
		TM_Patternassoc.patternId = TM_pattern.patternId INNER JOIN TM_Subtask
		ON TM_Patternassoc.subTaskId = TM_subtask.subtaskId
INNER JOIN TM_Task ON TM_Subtask.taskId = TM_task.taskId AND TM_task.deleted=0 and (TM_Subtask.flags & 0x80000)>0
		select @failoverScheduleDetails = value from Gxglobalparam
where name='CSFailoverRecoveryMode'
		and modified=0
		-- else frame default string
		if (@failoverScheduleDetails is null)
		begin
			set @failoverScheduleDetails = '<failoverScheduleDetails defaultRecoveryMode="0"/>'
		end
		SET @failoverScheduleDetails.modify('delete (//failoverScheduleDetails/@liveSyncRPO)[1]')
		SET @failoverScheduleDetails.modify('insert (attribute liveSyncRPO {sql:variable("@liveSyncRPO")}) into (//failoverScheduleDetails)[1]')
	end
	DECLARE @testFailoverFlag INT = 0
	SELECT @testFailoverFlag = ISNULL(TRY_CAST(value AS INT), 0)
	FROM GxGlobalParam(NOLOCK)
WHERE name =  'nCSEnableTestFailoverGUI'
	and modified=0
	SET @o_xmlString = ( select @isFailoverPackageConfigured '@isFailoverPackageConfigured',
			@cvFailoverConfigStatus '@configStatus',
			@isAutomaticFailoverEnabled '@isAutomaticFailoverEnabled',
			@isAutoScaleEnabled '@isAutoScaleEnabled',
			@hypervisorClientId '@selectedHyperVisorClient',
			@testFailoverFlag '@enableTestFailoverGUI',
			@isDRCSConfigured '@isDRCSConfigured',
			@isDRInstanceConfigurationPending '@isDRInstanceConfigurationPending',
			@isActiveInstanceConfigurationPending '@isActiveInstanceConfigurationPending',
			@monitoringClients.query('.') ,
			@activeNodeHwConfig.query('.'),
			@monitoringNodes.query('.') ,
			@failoverNodeVersion.query('.'),
			@miscSettings.query('.'),
			@failoverNodes.query('.'),
			@testFailoverNode.query('.'),
			@readOnlyProductionFailoverNode.query('.'),
			@networkInfo.query('.'),
			@failoverScheduleDetails.query('.'),
			@liveSyncStoragePolicy 'backupStoragePolicy/@storagePolicyId',
			@liveSyncSPName 'backupStoragePolicy/@storagePolicyName',
			@backupScheduleTaskId 'backupSchedulePolicyInfo/@taskId',
			@backupScheduleTaskName 'backupSchedulePolicyInfo/@taskName',
			(
				SELECT @tlScheduleId '@subtaskId', @tlScheduleName '@subtaskName', @backupScheduleTaskId '@taskId', @backupScheduleTaskName '@taskName'
				FOR XML PATH('tlSchedule'),TYPE
			),
			(
				SELECT @alertIDCSFailover '@alertId', @alertNameCSFailover '@alertName'
				FOR XML PATH('alertEntity'),TYPE
			)
			for xml path('csFailoverConfigInfo'),root('App_GetMonitoredNodesFailoverResp')
	)
	ERROR_EXIT:
		IF @errorCode <> 0
			SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
								FOR XML PATH('genericResp'),Root('App_GetMonitoredNodesFailoverResp'), Type)
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<App_GetMonitoredNodesFailoverResp/>'
		SELECT @o_xmlString as o_xmlText
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCSFailoverConfig')
	delete from GxQscripts where name = 'AppGetCSFailoverConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCSFailoverConfig')
	delete from GXDBVersions where aliasname = 'AppGetCSFailoverConfig'
GO

insert into GXDBVersions values(2, 'AppGetCSFailoverConfig',  '00000000000000000000', 'AppGetCSFailoverConfig', '00000000000000000000')
GO

