

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCIPreviewLocDetails.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCIPreviewLocDetails.sp,v $ $Id: AppGetCIPreviewLocDetails.sp,v 1.1.4.5 2020/11/17 12:27:48 smukherjee Exp $";
-- =========================================================
-- Author: JayaRam
-- Description: Get the Preview location details for a given user.
-- =========================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCIPreviewLocDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCIPreviewLocDetails <<<'
	drop procedure AppGetCIPreviewLocDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetCIPreviewLocDetails')
	delete from GxQscripts where name = 'AppGetCIPreviewLocDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCIPreviewLocDetails')
	delete from GXDBVersions where aliasname = 'AppGetCIPreviewLocDetails'
GO
print '... Creating Procedure: AppGetCIPreviewLocDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCIPreviewLocDetails
  @i_appId INT,
  @i_userGUID varchar(1024)
AS
  DECLARE @outXml XML
--
SET NOCOUNT ON;
--
BEGIN TRY
	IF @i_appId = 0
	BEGIN
		-- If the appId is not sent
		-- i) use the subclient that was created first
		-- ii) use the subclient that has content indexing enabled with preview path set.
		SELECT TOP 1 @i_appId = A.subClientId
		FROM APP_EmailConfigPolicyAssoc A, APP_EmailConfigPolicies B, APP_ConfigurationPolicyDetails C
		WHERE
		A.userGuid = @i_userGUID AND
		A.assocId = B.componentNameId And B.policyType In (1/*Archive*/, 4/*Journal*/) AND
		C.componentNameId = B.policyId AND
		A.modified = 0 AND B.modified = 0 And C.modified = 0
		AND
		(
		(B.policyType = 1/*Archive*/ AND C.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/@enableContentIndex)[1]', 'int') = 1 AND C.policyDetails.exist('/emailPolicy/archivePolicy/contentIndexProps/previewPathDir') = 1)
		OR
		(B.policyType = 4/*Journal*/ AND C.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/@enableContentIndex)[1]', 'int') = 1 AND C.policyDetails.exist('/emailPolicy/journalPolicy/contentIndexProps/previewPathDir') = 1)
		)
		ORDER BY A.created
	END
	SET @outXml=  (
	select
	CASE
		WHEN B.policyType = 4/*Journal*/ THEN C.policyDetails.query('/emailPolicy/journalPolicy/contentIndexProps')
		ELSE C.policyDetails.query('/emailPolicy/archivePolicy/contentIndexProps')
	END
	From APP_EmailConfigPolicyAssoc A, APP_EmailConfigPolicies B, APP_ConfigurationPolicyDetails C
	Where A.userGUID = @i_userGUID AND A.subClientId = @i_appId AND A.assocId = B.componentNameId AND A.modified = 0 AND B.modified = 0 AND B.policyType IN(1/*Archive*/,4/*Journal*/)
	AND C.componentNameId = B.policyId AND C.modified = 0
	)
	--FOR XML PATH('Ida_EmailContentIndexingProps'))
	set @outXml = REPLACE (cast(@outXml as nvarchar(1024)) ,'contentIndexProps', 'Ida_EmailContentIndexingProps')
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
	--
	-- return error response
	SET @outXml = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
END CATCH
	SELECT @outXml;
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCIPreviewLocDetails')
	delete from GxQscripts where name = 'AppGetCIPreviewLocDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCIPreviewLocDetails')
	delete from GXDBVersions where aliasname = 'AppGetCIPreviewLocDetails'
GO

insert into GXDBVersions values(2, 'AppGetCIPreviewLocDetails',  '00010001000400050000', 'AppGetCIPreviewLocDetails', '00010001000400050000')
GO

