

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCCSXMLTableRowOutput.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCCSXMLTableRowOutput.sp,v $ $Id: AppGetCCSXMLTableRowOutput.sp,v 1.9.2.10 2018/10/06 03:02:38 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCCSXMLTableRowOutput <<<'

IF EXISTS (select * from sysobjects where name='AppGetCCSXMLTableRowOutput')
	drop procedure AppGetCCSXMLTableRowOutput
IF EXISTS (select * from GxQscripts where name='AppGetCCSXMLTableRowOutput')
	delete from GxQscripts where name = 'AppGetCCSXMLTableRowOutput'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCCSXMLTableRowOutput')
	delete from GXDBVersions where aliasname = 'AppGetCCSXMLTableRowOutput'
GO
print '... Creating Procedure: AppGetCCSXMLTableRowOutput'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCCSXMLTableRowOutput
-- Input arguments
  @tableInfo XML,
  @outputXml XML OUTPUT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @xmlText XML = NULL;
	SET NOCOUNT ON
	--SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @xmlOut2 XML = NULL
	DECLARE @complexType INT = 0
	SET @complexType = @tableInfo.exist('/TMMsg_CCSTableRowUpdates')
	IF (@complexType = 1)
	BEGIN
		DECLARE @TableRowUpdates TABLE (rowEntry XML)
		INSERT INTO @TableRowUpdates
			SELECT
				c.query('.')
			FROM
				@tableInfo.nodes('/TMMsg_CCSTableRowUpdates/TMMsg_ClientConfigTableChangeInfo') t(c)
		DECLARE @xmlString NVARCHAR(MAX) = ''
		DECLARE @rue XML
		DECLARE ru_cursor CURSOR FOR SELECT rowEntry FROM @TableRowUpdates
		OPEN ru_cursor
		-- fetch each row from table and create where a clause entry for it
		FETCH NEXT FROM ru_cursor INTO @rue
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DECLARE @out XML
			EXEC AppGetCCSXMLTableRowOutput @rue, @out OUTPUT
			DECLARE @err INT = 0
			SELECT @err = @out.exist('/clientConfigStoreUpdate/tableLookupError')
			IF (@err = 0)
			BEGIN
				SET @xmlString = @xmlString + CAST(@out AS NVARCHAR(MAX))
			END
			FETCH NEXT FROM ru_cursor INTO @rue
		END
		CLOSE ru_cursor
		DEALLOCATE ru_cursor
		SET @xmlOut2 = NULL
		IF (@xmlString != '')
		BEGIN
			SET @xmlString = '<ccsTableUpdates>' + @xmlString + '</ccsTableUpdates>'
			SET @xmlOut2 = @xmlString
		END
		-- is there a response?
		IF (@xmlOut2 IS NULL)
		BEGIN
			-- found no data
			SET @xmlOut2 = (SELECT
								100 AS 'tableLookupError/@errorCode',
								'No data found for table request. ' AS 'tableLookupError/@errorMessage'
							FOR XML PATH('ccsTableUpdates'), TYPE)
		END
		SET @outputXml = @xmlOut2
		RETURN
	END
	-- inputted XML data values
	DECLARE @errMsg VARCHAR(1024) = ''
	DECLARE @seqNum INT = 0
	DECLARE @tableOpCode INT = 0
	DECLARE @tableType INT = 0
	DECLARE @tableRowID INT = NULL		-- changed from 0 to NULL so that row Ids of 0 can be looked up
	DECLARE @tableRowIDVC	VARCHAR(20) = NULL
	DECLARE @tableRowKeyName VARCHAR(MAX) = ''
	DECLARE @tableWhereClause VARCHAR(MAX) = ''
	DECLARE @tableKeysExist INT
	DECLARE @ResponseType INT = 0	-- 0 - Unknown, 1 - RowID, 2 - PrimaryKey Id List, 3 - RowNameKey
	--PRINT 'TableXML: ' + CAST(@tableInfo AS VARCHAR(MAX))
	-- parse inputted XML document
	SELECT @tableKeysExist = @tableInfo.exist(('//tableKeys'))
	SELECT
		@seqNum = attr.value('@sequenceNumber', 'INT'),
		@tableOpCode = ISNULL(attr.value('@tableOpCode', 'INT'), 0),	-- not used, assume a get opcode
		@tableType = ISNULL(attr.value('@tableType', 'INT'), 0),
		@tableRowIDVC = attr.value('@tableRowID', 'VARCHAR(20)'),		-- ISNULL(attr.value('@tableRowID', 'INT'), 0),	needed the capability to look up rows with id=0 so set it to NULL
		@tableWhereClause = ISNULL(attr.value('@tableWhereClause', 'VARCHAR(MAX)'), ''),
		@tableRowKeyName = ISNULL(attr.value('@tableRowKeyName', 'VARCHAR(MAX)'), '')
	FROM
		@tableInfo.nodes('TMMsg_ClientConfigTableChangeInfo') tci(attr)
	IF (@tableRowIDVC IS NULL OR @tableRowIDVC = '')
	BEGIN
		SET @tableRowID = NULL
	END
	ELSE
	BEGIN
		SET @tableRowID = CAST(@tableRowIDVC AS INT)
	END
	-- If delete operation, re-format and return XML output
	IF (@tableOpCode = 2)
	BEGIN
		DECLARE @xmlKeys XML = NULL
		IF (@tableKeysExist = 1)
		BEGIN
			SET @xmlKeys = (SELECT
								a.value('@columnName', 'VARCHAR(MAX)') as '@columnName',
								a.value('@columnType', 'VARCHAR(MAX)') as '@columnType',
								a.value('@columnValue', 'VARCHAR(MAX)') as '@columnValue'
							FROM @tableInfo.nodes('/TMMsg_ClientConfigTableChangeInfo/tableKeys') tk(a)
							FOR XML PATH('tableKeys'), TYPE)
		END
		SET @outputXml = (SELECT
			(SELECT
				@seqNum AS '@sequenceNumber',
				@tableOpCode AS '@tableOpCode',
				@tableRowID AS '@tableRowID',
				@tableType AS '@tableType',
				@tableRowKeyName AS '@tableRowKeyName',
				@xmlKeys
			FOR XML PATH('tableInfo'), TYPE)
		FOR XML PATH('clientConfigStoreUpdate'), TYPE)
		RETURN
	END
	-- MR132157 - workaround for Component Property rows that can have special characters embedded in data
	-- (which are illegal characters in XML data type) for attrType >= 100.
	DECLARE @wcPropertyAttrTypeL100		NVARCHAR(128) = ''
	DECLARE @wcPropertyAttrTypeGE100	NVARCHAR(128) = ''
	DECLARE @isPropertyTable			INT = 0
	IF (@tableType IN (2, 5, 10, 12, 14, 21))		-- If one of these component property table types add where clause conditional
	BEGIN
		-- Generic property rows have attrType < 100 is the only rows being transferred for now
		-- In the future CCS will be expanded to handle the other special types of rows.
		SET @wcPropertyAttrTypeL100 = '  AND attrType < 100  '
		SET @wcPropertyAttrTypeGE100 = '  AND attrType >= 100  '
		SET @isPropertyTable = 1
	END
	-- Determine lookup response type
	IF (@tableRowID IS NOT NULL AND @tableRowID >= 0)
	BEGIN
		SET @ResponseType = 1
	END
	ELSE IF (@tableKeysExist = 1)
	BEGIN
		SET @ResponseType = 2
	END
	ELSE IF (@tableRowKeyName IS NOT NULL AND @tableRowKeyName <> '')
	BEGIN
		SET @ResponseType = 3
	END
	ELSE IF (@tableWhereClause IS NOT NULL AND @tableWhereClause <> '')
	BEGIN
		SET @ResponseType = 4
	END
	-- variables for CCSTableSelectInfo query
	DECLARE @tid			INT
	DECLARE @tname			VARCHAR(MAX)
	DECLARE @primaryId		VARCHAR(MAX)
	DECLARE @primaryName	VARCHAR(MAX)
	DECLARE @xmlNodeName	VARCHAR(MAX)
	DECLARE @columnOverride	VARCHAR(2048)
	DECLARE @filterXML		XML
	-- get info about the table query to dynamically generate
	SELECT
		@tid = id,
		@tname = tableName,
		@primaryId = primaryId,
		@primaryName = primaryName,
		@xmlNodeName = xmlNodeName,
		@columnOverride = columnSchema,
		@filterXML =  (CASE filters.exist('/Filters') WHEN 1 THEN filters ELSE NULL END)
	FROM
		APP_CCSXMLMapping WITH(NOLOCK)
	WHERE
		id = @tableType
	-- make sure table data found for table type
	IF (@tid IS NULL)
	BEGIN
		-- found no data
		SET @xmlOut2 = (SELECT
							1014 AS '@errorCode',
							'Method is not supported for this request, no XML Table Configuration. ' AS '@errorMessage'
						FOR XML PATH('tableLookupError'), TYPE)
		GOTO FORMAT_XMLOUTPUT
	END
	-- Setup Include and Exclude Filtering for data rows that should or should not be shipped to the CCS Client
	DECLARE @wcFilters			NVARCHAR(MAX) = N''
	DECLARE @filterColName		VARCHAR(128) = ''
	DECLARE @filterDType		VARCHAR(16) = ''
	DECLARE @filterOpType		VARCHAR(16) = ''
	DECLARE @filterSqlCmd		TINYINT = 0
	DECLARE @addQuote			TINYINT = 0
	DECLARE @quoteStartStr		NVARCHAR(4) = ''
	DECLARE @quoteEndStr		NVARCHAR(4) = ''
	DECLARE @addComma			TINYINT = 0
	DECLARE @addUnion			TINYINT = 0
	DECLARE @likeFilter			NVARCHAR(MAX) = ''
	IF (@filterXML IS NOT NULL)
	BEGIN
		-- get basic filter data
		SELECT
			@filterColName = c.value('@name', 'VARCHAR(128)'),
			@filterDType = c.value('@dataType', 'VARCHAR(16)'),
			@filterOpType = c.value('@opType', 'VARCHAR(16)'),
			@filterSqlCmd = ISNULL(c.value('@SQLCMD', 'TINYINT'), 0)
		FROM @filterXML.nodes('/Filters/Column') f(c)
		WHERE
			c.value('@opType', 'VARCHAR(16)') IN ('INCLUDE', 'EXCLUDE')		-- Do not want to pickup LIKE / NOT LIKE Column Filters
		DECLARE @isLike TINYINT = 0		-- and type of operation LIKE:1 / NOT LIKE:2
		-- note should only expect 1 node and written for processing on 1 node
		SELECT TOP 1
			@isLike = CASE c.value('@opType', 'VARCHAR(16)')
							WHEN 'LIKE' THEN 1
							WHEN 'NOT LIKE' THEN 2
							ELSE 0
						END
		FROM @filterXML.nodes('/Filters/Column') f(c)
		WHERE
			c.value('@opType', 'VARCHAR(16)') IN ('LIKE', 'NOT LIKE')
		IF (
			@isLike > 0
			AND (
				-- LIKE Operatons only support on primary id or name lookups.
				-- Where clause support introduces too many issues.  SO assume the application
				-- is looking for valid data that would normally exist in the CCSDb when a local NODATA
				-- is processed / forwarded to the CSDb to resolve.
				@tableRowID IS NOT NULL
				--OR @tableWhereClause <> ''		-- not possible to determine if good or bad effect on the conditionals specified
				OR @tableRowKeyName <> ''
			)
		)
		BEGIN
			-- converted to generic processing
			IF (@primaryId <> '')
			BEGIN
				-- LIKE / NOT LIKE Filtering is somewhat hardcoded
				SET @likeFilter = ' AND ' + @primaryId + ' ' + (CASE @isLike WHEN 1 THEN 'IN' ELSE 'NOT IN' END) + ' ( '
				SET @likeFilter += (
					SELECT
						(CASE WHEN q.rn > 1 THEN ' UNION ' ELSE ' ' END)
						+ 'SELECT t.' + @primaryId + ' FROM '
						+ @tname
						+ ' t WITH(NOLOCK) WHERE '
						+ CASE
							WHEN @tableRowID IS NOT NULL THEN ' t.' + @primaryId + ' = ' + CAST(@tableRowID AS NVARCHAR(12)) + ' '
							--WHEN @tableWhereClause <> '' THEN ' ' + @tableWhereClause + ' '		-- not possible to determine if good or bad effect on the conditionals specified
							WHEN @tableRowKeyName <> '' THEN ' t.' + @primaryName + ' = ''' + @tableRowKeyName + ''' '
						END
						+ ' AND t.'
						+ q.name
						+ (CASE q.opType WHEN 'NOT LIKE' THEN ' LIKE ' ELSE ' NOT LIKE ' END)  -- opposite for use of NOT IN (NOT LIKE) / IN (LIKE) above
						+ '''' + q.filter + ''''
					FROM (
							SELECT
								f.value('../@name', 'NVARCHAR(128)') name,
								f.value('../@opType', 'NVARCHAR(128)') opType,
								f.value('@value', 'NVARCHAR(128)') filter,		-- LIKE / NOT LIKE text string
								ROW_NUMBER() OVER (ORDER BY f.value('@value', 'NVARCHAR(1024)')) rn
							FROM APP_CCSXMLMapping WITH(NOLOCK)
								CROSS APPLY filters.nodes('/Filters/Column/Filter') n(f)
							WHERE
								id = @tableType
				--				AND f.value('../@name', 'NVARCHAR(128)') = 'attrName'
								AND f.value('../@opType', 'NVARCHAR(128)') IN ('NOT LIKE', 'LIKE')
						) q
					FOR XML PATH('')
				)
				SET @likeFilter += ' ) '
			END
			ELSE
			BEGIN
				-- XML Key Filter that needs to be implemented
				SET @errMsg = 'ERROR: Missing CCS XML LIKE / NOT LIKE Row Filter Implementation! Table[' + @tname + ':' + CAST(@tid AS VARCHAR(12)) + ']'
				RAISERROR(@errMsg, 16, 1)
			END
		END
		-- Is string handling required
		IF (@filterDType = 'NSTRING')
		BEGIN
			SET @addQuote = 1
			SET @quoteStartStr = 'N'''
			SET @quoteEndStr = ''''
		END
		ELSE IF (@filterDType = 'STRING')
		BEGIN
			SET @addQuote = 1
			SET @quoteStartStr = ''''
			SET @quoteEndStr = ''''
		END
		-- Type of operation to test filter data against
		IF (@filterOpType = 'INCLUDE')
		BEGIN
			SET @wcFilters += ' AND ' + @filterColName + ' IN ( '
		END
		ELSE IF (@filterOpType = 'EXCLUDE')
		BEGIN
			SET @wcFilters += ' AND ' + @filterColName + ' NOT IN ( '
		END
		ELSE
		BEGIN
			-- bad filter data in the database
			SET @xmlOut2 = (SELECT
								1015 AS '@errorCode',
								'Bad filter data in the APP_CCSXMLMapping table. ' AS '@errorMessage'
							FOR XML PATH('tableLookupError'), TYPE)
			GOTO FORMAT_XMLOUTPUT
		END
		IF (@filterSqlCmd = 0)
		BEGIN
			SELECT
				@wcFilters += (CASE @addComma  WHEN 1 THEN ', ' ELSE '' END)
								+ (CASE @addQuote WHEN 1 THEN @quoteStartStr ELSE '' END)
								+ f.value('@value', 'NVARCHAR(1024)')
								+ (CASE @addQuote WHEN 1 THEN @quoteEndStr ELSE '' END),
				@addComma = 1
			FROM @filterXML.nodes('/Filters/Column/Filter') c(f)
			WHERE
				f.value('../@opType', 'VARCHAR(16)') IN ('INCLUDE', 'EXCLUDE')		-- Do not want to pickup LIKE / NOT LIKE Column Filters
		END
		ELSE
		BEGIN
			SELECT
				@wcFilters += (CASE @addUnion  WHEN 1 THEN ' UNION ' ELSE '' END)
								+ f.value('@value', 'NVARCHAR(MAX)'),
				@addUnion = 1
			FROM @filterXML.nodes('/Filters/Column/Filter') c(f)
			WHERE
				f.value('../@opType', 'VARCHAR(16)') IN ('INCLUDE', 'EXCLUDE')		-- Do not want to pickup LIKE / NOT LIKE Column Filters
		END
		SET @wcFilters += ' ) '
		-- Add LIKE / NOT LIKE Filtering
		IF (@likeFilter <> '')
		BEGIN
			SET @wcFilters += @likeFilter
		END
	END
	DECLARE @ColOverride INT = 0
	DECLARE	@columnNameSet VARCHAR(MAX) = '*'	-- default
	IF (@columnOverride <> '' AND @isPropertyTable = 0)
	BEGIN
		-- Table has override column set for a reasons:
		--	Lotus Notes: can have invalid XML Characters in Instance Name column - so encode all instance names by default
		--SET @columnNameSet = @columnOverride
		SET @ColOverride = 1
	END
	-- On demand generate ordered column schema formatted list
	--DECLARE @tbl SYSNAME = 'APP_InstanceName'
	--DECLARE @comma VARCHAR(4) = ''
	--DECLARE @size INT = 0
	--DECLARE @cols VARCHAR(2048) = ''
	--SELECT
	--	@cols = @cols + @comma + c.name,
	--	@comma = ', ',
	--	@size = @size + LEN(c.name) + 2 -- ', '
	--FROM
	--	sys.tables t
	--	INNER JOIN sys.columns c ON
	--		t.object_id = c.object_id
	--WHERE
	--	t.name = @tbl
	--ORDER BY
	--	c.column_id ASC
	--SELECT @size formatSize, @cols columnSchema
	-- Generate Dynamic Select Statement
	DECLARE @sqlstmt NVARCHAR(MAX)
	DECLARE @sqlstmtColSpec NVARCHAR(MAX) = ''
	DECLARE @xmlOut XML
	DECLARE @isQueryBad INT = 0
	SET @sqlstmt = ' SET @xmlOut = ( '
	IF (@ColOverride = 1) SET @sqlstmtColSpec = ' SET @xmlOut = ( '
	IF ( @ResponseType = 1)
	BEGIN
		-- Query by using key row id
		--PRINT 'ID Query'
		IF ( @primaryId IS NULL OR @primaryId = '' )
		BEGIN
			SET @isQueryBad = 1
		END
		ELSE
		BEGIN
			IF ( @isPropertyTable = 0)
			BEGIN
				SET @sqlstmt += ' SELECT ' + @columnNameSet + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryId + ' = ' + CAST(@tableRowID AS VARCHAR(MAX)) + @wcFilters + ' FOR XML AUTO, TYPE ) '
				IF (@ColOverride = 1) SET @sqlstmtColSpec += ' SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryId + ' = ' + CAST(@tableRowID AS VARCHAR(MAX)) + @wcFilters + ' FOR XML AUTO, TYPE ) '
			END
			ELSE
			BEGIN
				IF (@tableType = 21)		-- APP_ExtendedProperties has an ntext column that is not supportted in UNION clauses, run all data thru the encoder for invalid characters
				BEGIN
					SET @sqlstmt += ' SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryId + ' = ' + CAST(@tableRowID AS VARCHAR(MAX)) + @wcFilters + ' FOR XML AUTO, TYPE ) '
				END
				ELSE
				BEGIN
					SET @sqlstmt += ' SELECT * FROM ( '
					SET @sqlstmt += 'SELECT * FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryId + ' = ' + CAST(@tableRowID AS VARCHAR(MAX)) + @wcPropertyAttrTypeL100 + @wcFilters
					IF ( @columnOverride <> '')
					BEGIN
						SET @sqlstmt += ' UNION SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryId + ' = ' + CAST(@tableRowID AS VARCHAR(MAX)) + @wcPropertyAttrTypeGE100 + @wcFilters
					END
					SET @sqlstmt += ' ) ' + @xmlNodeName + ' FOR XML AUTO, TYPE ) '
				END
			END
		END
	END
	ELSE IF ( @ResponseType = 2)
	BEGIN
		-- Query by the inputted table columns and associated values
		-- Generate a whereClause for columns and values
		DECLARE @wc VARCHAR(MAX) = ' '
		SELECT @wc +=
			CASE
				WHEN @wc <> '' THEN ' AND '
				ELSE ''
			END +
			CASE
				WHEN c.columnType = 1 then
					-- integer value
					c.columnName + ' = ' + c.columnValue + ' '
				ELSE
					-- string value
					c.columnName + ' = ''' + c.columnValue + ''' '
			END
		FROM
			(SELECT
				k.value('@columnType', 'INT') AS columnType,
				k.value('@columnValue', 'VARCHAR(MAX)') AS columnValue,
				k.value('@columnName', 'VARCHAR(MAX)') AS columnName
			FROM @tableInfo.nodes('/TMMsg_ClientConfigTableChangeInfo/tableKeys') tkey(k)) AS c
		IF ( @isPropertyTable = 0)
		BEGIN
			SET @sqlstmt += ' SELECT ' + @columnNameSet + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @wc + @wcFilters + ' FOR XML AUTO, TYPE ) '
			IF (@ColOverride = 1) SET @sqlstmtColSpec += ' SELECT ' + @columnNameSet + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @wc + @wcFilters + ' FOR XML AUTO, TYPE ) '
		END
		ELSE
		BEGIN
			IF (@tableType = 21)		-- APP_ExtendedProperties has an ntext column that is not supportted in UNION clauses, run all data thru the encoder for invalid characters
			BEGIN
				SET @sqlstmt += ' SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @wc + @wcFilters + ' FOR XML AUTO, TYPE ) '
			END
			ELSE
			BEGIN
				SET @sqlstmt += ' SELECT * FROM ( '
				SET @sqlstmt += 'SELECT * FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @wc + @wcPropertyAttrTypeL100 + @wcFilters
				IF ( @columnOverride <> '')
				BEGIN
					SET @sqlstmt += ' UNION SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @wc + @wcPropertyAttrTypeGE100 + @wcFilters
				END
				SET @sqlstmt += ' ) ' + @xmlNodeName + ' FOR XML AUTO, TYPE ) '
			END
		END
		--PRINT @sqlstmt
	END
	ELSE IF ( @ResponseType = 3)
	BEGIN
		-- Query by using key row name
		--PRINT 'NAME Query'
		IF ( @primaryName IS NULL OR @primaryName = '' )
		BEGIN
			SET @isQueryBad = 1
		END
		ELSE
		BEGIN
			IF ( @isPropertyTable = 0)
			BEGIN
				SET @sqlstmt += ' SELECT ' + @columnNameSet + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryName + ' = ''' + @tableRowKeyName + '''' + @wcFilters + ' FOR XML AUTO, TYPE ) '
				IF (@ColOverride = 1) SET @sqlstmtColSpec += ' SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryName + ' = ''' + @tableRowKeyName + '''' + @wcFilters + ' FOR XML AUTO, TYPE ) '
			END
			ELSE
			BEGIN
				IF (@tableType = 21)		-- APP_ExtendedProperties has an ntext column that is not supportted in UNION clauses, run all data thru the encoder for invalid characters
				BEGIN
					SET @sqlstmt += ' SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryName + ' = ''' + @tableRowKeyName + '''' + @wcFilters + ' FOR XML AUTO, TYPE ) '
				END
				ELSE
				BEGIN
					SET @sqlstmt += ' SELECT * FROM ( '
					SET @sqlstmt += 'SELECT * FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryName + ' = ''' + @tableRowKeyName + '''' + @wcPropertyAttrTypeL100 + @wcFilters
					IF ( @columnOverride <> '')
					BEGIN
						SET @sqlstmt += ' UNION SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @primaryName + ' = ''' + @tableRowKeyName + '''' + @wcFilters + @wcPropertyAttrTypeGE100
					END
					SET @sqlstmt += ' ) ' + @xmlNodeName + ' FOR XML AUTO, TYPE ) '
				END
			END
		END
	END
	ELSE IF ( @ResponseType = 4)
	BEGIN
		-- Query by using received where clause
		--PRINT 'WHERECLAUSE Query'
		IF ( @isPropertyTable = 0)
		BEGIN
			SET @sqlstmt += ' SELECT ' + @columnNameSet + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @tableWhereClause + @wcFilters + ' FOR XML AUTO, TYPE ) '
			IF (@ColOverride = 1) SET @sqlstmtColSpec += ' SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @tableWhereClause + @wcFilters + ' FOR XML AUTO, TYPE ) '
		END
		ELSE
		BEGIN
			IF (@tableType = 21)		-- APP_ExtendedProperties has an ntext column that is not supportted in UNION clauses, run all data thru the encoder for invalid characters
			BEGIN
				SET @sqlstmt += ' SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @tableWhereClause + @wcFilters + ' FOR XML AUTO, TYPE ) '
			END
			ELSE
			BEGIN
				SET @sqlstmt += ' SELECT * FROM ( '
				SET @sqlstmt += 'SELECT * FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @tableWhereClause + @wcPropertyAttrTypeL100 + @wcFilters
				IF ( @columnOverride <> '')
				BEGIN
					SET @sqlstmt += ' UNION SELECT ' + @columnOverride + ' FROM ' + @tname + ' ' + @xmlNodeName + ' WHERE ' + @tableWhereClause + @wcPropertyAttrTypeGE100 + @wcFilters
				END
				SET @sqlstmt += ' ) ' + @xmlNodeName + ' FOR XML AUTO, TYPE ) '
			END
		END
	END
	-- Exeucte the generated query to get the XML Row Document
	DECLARE @parm NVARCHAR(MAX) = '@xmlOut XML OUTPUT'
	DECLARE @rc INT = 0
	IF ( @isQueryBad = 0 AND @sqlstmt IS NOT NULL AND @sqlstmt <> '' )
	BEGIN
		--PRINT 'sp_executesql SQLStmt: ' + @sqlstmt
		-- Requested table may have rows that contain invalid xml characters that cannot be encoded by SQL
		-- use try catch block to trap and re-try with column spec with encode function if defined.
		BEGIN TRY
			IF (@tableType IN (25))		-- hardcoded tables that need to execute with override column that contain XML column data types
			BEGIN
				--PRINT 'sp_executesql SQLStmt: ' + @sqlstmt
				EXEC @rc = sp_executesql @stmt = @sqlstmtColSpec, @params = @parm, @xmlOut=@xmlOut2 OUTPUT
			END
			ELSE
			BEGIN
				EXEC @rc = sp_executesql @stmt = @sqlstmt, @params = @parm, @xmlOut=@xmlOut2 OUTPUT
			END
		END TRY
		BEGIN CATCH
			IF (ERROR_NUMBER() = 6841 AND @ColOverride = 1 AND @sqlstmtColSpec <> '')	-- invalid XML character error, try again with column spec
			BEGIN
				--PRINT 'sp_executesql TrySQLStmt: ' + @sqlstmtColSpec
				EXEC @rc = sp_executesql @stmt = @sqlstmtColSpec, @params = @parm, @xmlOut=@xmlOut2 OUTPUT
			END
			ELSE
			BEGIN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
				SET @xmlOut2 = (SELECT
									ERROR_NUMBER() AS '@errorCode',
									ERROR_MESSAGE() AS '@errorMessage'
								FOR XML PATH('tableLookupError'), TYPE)
				GOTO FORMAT_XMLOUTPUT
			END
		END CATCH
	END
	IF ( @rc <> 0 AND @xmlOut2 IS NULL)
	BEGIN
		SET @xmlOut2 = (SELECT
							1 AS '@errorCode',
							'Dynamic query failure. ' AS '@errorMessage'
						FOR XML PATH('tableLookupError'), TYPE)
	END
	IF ( @isQueryBad = 1)
	BEGIN
		SET @xmlOut2 = (SELECT
							2 AS '@errorCode',
							'Bad input for dynamic query generation. ' AS '@errorMessage'
						FOR XML PATH('tableLookupError'), TYPE)
	END
FORMAT_XMLOUTPUT:
	-- is there a response?
	IF (@xmlOut2 IS NULL)
	BEGIN
		-- found no data
		SET @xmlOut2 = (SELECT
							100 AS '@errorCode',
							'No data found for table request. ' AS '@errorMessage'
						FOR XML PATH('tableLookupError'), TYPE)
	END
	-- output / return XML Document
	DECLARE @outXML XML
	IF (@ResponseType = 1)
	BEGIN
		SET @outXML = (SELECT
			(SELECT
				@seqNum AS '@sequenceNumber',
				@tableOpCode AS '@tableOpCode',
				@tableRowID AS '@tableRowID',
				@tableType AS '@tableType',
				@tableRowKeyName AS '@tableRowKeyName'
			FOR XML PATH('tableInfo'), TYPE),
			@xmlOut2
		FOR XML PATH('clientConfigStoreUpdate'), TYPE)
	END
	ELSE
	BEGIN
		if (@ResponseType = 2)
		BEGIN
			SET @outXML = (SELECT
				(SELECT
					k.value('@sequenceNumber', 'VARCHAR(MAX)') AS '@sequenceNumber',
					k.value('@tableOpCode', 'VARCHAR(MAX)') AS '@tableOpCode',
					k.value('@tableRowID', 'VARCHAR(MAX)') AS '@tableRowID',
					k.value('@tableType', 'VARCHAR(MAX)') AS '@tableType',
					k.value('@tableRowKeyName', 'VARCHAR(MAX)') AS '@tableRowKeyName',
					(SELECT
						a.value('@columnName', 'VARCHAR(MAX)') as '@columnName',
						a.value('@columnType', 'VARCHAR(MAX)') as '@columnType',
						a.value('@columnValue', 'VARCHAR(MAX)') as '@columnValue'
					FROM @tableInfo.nodes('/TMMsg_ClientConfigTableChangeInfo/tableKeys') tk(a)
					FOR XML PATH('tableKeys'), TYPE)
				FROM @tableInfo.nodes('/TMMsg_ClientConfigTableChangeInfo') tci(k)
				FOR XML PATH('tableInfo'), TYPE),
				@xmlOut2
			FOR XML PATH('clientConfigStoreUpdate'), TYPE)
		END
		ELSE
		BEGIN
			SET @outXML = (SELECT
				(SELECT
					@seqNum AS '@sequenceNumber',
					@tableOpCode AS '@tableOpCode',
					@tableRowID AS '@tableRowID',
					@tableType AS '@tableType',
					@tableRowKeyName AS '@tableRowKeyName'
				FOR XML PATH('tableInfo'), TYPE),
				@xmlOut2
			FOR XML PATH('clientConfigStoreUpdate'), TYPE)
		END
	END
	-- Set return output
	SET @outputXml = @outXML
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCCSXMLTableRowOutput')
	delete from GxQscripts where name = 'AppGetCCSXMLTableRowOutput'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCCSXMLTableRowOutput')
	delete from GXDBVersions where aliasname = 'AppGetCCSXMLTableRowOutput'
GO

insert into GXDBVersions values(2, 'AppGetCCSXMLTableRowOutput',  '00010009000200100000', 'AppGetCCSXMLTableRowOutput', '00010009000200100000')
GO

