

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCCDiscoveryContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCCDiscoveryContent.sp,v $ $Id: AppGetCCDiscoveryContent.sp,v 1.4.48.1 2018/03/27 09:12:49 jiechen Exp $";
--
--  +====================================================================================+
--  |   Procedure:  AppGetCCDiscoveryContent()
--  |
--  | Description:  SP for content discovery for Cloud Connector Subclient Creation
--  |
--  |       Input:  XML input containing content discovery criteria (userGroup, provider, user)
--  |      Output:  XML Output containing content based on the discovery criteria
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |
--  +====================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCCDiscoveryContent <<<'

IF EXISTS (select * from sysobjects where name='AppGetCCDiscoveryContent')
	drop procedure AppGetCCDiscoveryContent
IF EXISTS (select * from GxQscripts where name='AppGetCCDiscoveryContent')
	delete from GxQscripts where name = 'AppGetCCDiscoveryContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCCDiscoveryContent')
	delete from GXDBVersions where aliasname = 'AppGetCCDiscoveryContent'
GO
print '... Creating Procedure: AppGetCCDiscoveryContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCCDiscoveryContent
  @i_xml XML	
AS
DECLARE @userId INT
DECLARE @localeId INT
DECLARE @r_capabilityId int
DECLARE @r_error XML
DECLARE @r_allErrors XML
DECLARE @errorCode INT
DECLARE @errorString nvarchar(max)
DECLARE @userLogin nvarchar(max)
DECLARE @isGroupTypeSelected INT
DECLARE @isProviderTypeSelected INT
DECLARE @IsUserTypeSelected INT
DECLARE @IsALLUserTypeSelected INT
DECLARE @isUserAccountTypeSelected INT
DEClARE @inputUserGroupId INT
DEClARE @inputProviderId INT
DEClARE @getValidContentFlag INT
DEClARE @isUserRegExFlag INT
DEClARE @IsAllProviderSelected INT
DEClARE @inputUserId INT
DEClARE @inputUserAccountId INT
DEClARE @inputUserGroupName nvarchar(MAX)
DEClARE @inputUserName nvarchar(MAX)
DEClARE @inputUserAccount nvarchar(MAX)
DECLARE @discoveryType INT
DECLARE @cnt INT
DECLARE @combinationCursor CURSOR
DECLARE @userGroupsXML XML
DECLARE @usersXML 	   XML
DECLARE @providersXML  XML
DECLARE @userAccountsXML  XML
DECLARE @dicoveryTypeXML XML
DECLARE @discoveredContent XML
DECLARE @all_DiscoveredContent XML
DECLARE @userGroupList TABLE
(
userGroupId 	INT,
userGroupName 	nvarchar(max)
)
DECLARE @providerList TABLE
(
providerId 	INT
)
DECLARE @userList TABLE
(
userId 		INT,
userName 	nvarchar(max)
)
DECLARE @userAccountList TABLE
(
accountId 	nvarchar(max),
BSId 		INT,
SCId 		INT
)
DECLARE @CombinationTbl TABLE
(
userGroupId INT,
providerId INT,
userId INT
)
DECLARE @servicesAvailable TABLE
(
	enumVal INT,
	isSelected INT
)
DECLARE @discoveryTypeTbl TABLE
(
  enumVal INT
)
--------------------declaration part over-------------------------------------------------------------
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS col1
                         FROM    @i_xml.nodes('App_CCContentDisoveryReq/processinginstructioninfo/user') R ( ref )),1)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS col1
                         FROM    @i_xml.nodes('App_CCContentDisoveryReq/processinginstructioninfo/locale') R ( ref )),0)
SET @errorCode = 0
SET @errorString = ''
INSERT INTO @discoveryTypeTbl
SELECT  IsNull(ref.value('@val', 'int'),0)
FROM    @i_xml.nodes('App_CCContentDisoveryReq/discoverySentTypes') R ( ref )
--Just a precaution
DELETE FROM @discoveryTypeTbl
WHERE enumVal IS NULL OR enumVal = 0
------------------------------------------------------------------------------------------------------
IF (NOT EXISTS(SELECT 1 FROM UMUsers WHERE id = @userId))
BEGIN
	SET @errorCode = -1
	SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId=(475 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @localeId)
	SET @errorString = REPLACE(@errorString, '^1%s', @userId)
	SET @r_error = (select @errorCode as '@errorCode',@errorString as '@errorString'
					for xml path('response'))
	SET @r_allErrors = CONVERT(nvarchar(MAX),@r_error)
	GOTO GENERATE_OUTPUT
END
----------------------------------------------------------------------------------------------------------
SET @userLogin = (SELECT Login FROM UMUsers WHERE id = @userId)
--------------------------------------------------------------------------------------------------------
SET @getValidContentFlag  =   ISNULL((SELECT  ref.value('@getValidContent', 'int') AS col1
									FROM    @i_xml.nodes('App_CCContentDisoveryReq') R ( ref )),0)
SET @isUserRegExFlag      =   ISNULL((SELECT  ref.value('@isUserRegEx', 'int') AS col1
									FROM    @i_xml.nodes('App_CCContentDisoveryReq') R ( ref )),0)
SELECT  @isGroupTypeSelected     	= (SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END FROM @discoveryTypeTbl WHERE enumVal = 1),
		@isProviderTypeSelected  	= (SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END FROM @discoveryTypeTbl WHERE enumVal = 2),
		@IsUserTypeSelected      	= (SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END FROM @discoveryTypeTbl WHERE enumVal = 3),
		@IsUserAccountTypeSelected  = (SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END FROM @discoveryTypeTbl WHERE enumVal = 4),
		@IsALLUserTypeSelected      = (SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END FROM @discoveryTypeTbl WHERE enumVal = 7)
		IF(@isGroupTypeSelected = 1)
		BEGIN
			INSERT INTO @userGroupList(userGroupId,userGroupName)
				SELECT  ISNULL(ref.value('@userGroupId', 'int'),0),''
				FROM    @i_xml.nodes('App_CCContentDisoveryReq/discoveryContent/userGroups') R ( ref )
			--Delete all invalid user groups
			DELETE FROM @userGroupList
			WHERE userGroupId NOT IN (SELECT id FROM UMGroups)
		END
		IF(@isProviderTypeSelected = 1)
		BEGIN
			INSERT INTO @providerList(providerId)
					SELECT  ISNULL(ref.value('@val', 'int'),0)
					FROM    @i_xml.nodes('App_CCContentDisoveryReq/discoveryContent/services') R ( ref )
			--Delete all invalid provider Ids that are invalid.
			--Valid provider Ids picked from Message CCAccountType in App.x
			DELETE FROM @providerList
			WHERE providerId NOT IN (1,2,4,8,16,32,64,128)
		END
		IF(@IsUserTypeSelected = 1)
		BEGIN
			INSERT INTO @userList(userId , userName)
			SELECT  ISNULL(ref.value('@userId', 'int'),0),ISNULL(ref.value('@userName', 'nvarchar(MAX)'),'')
			FROM    @i_xml.nodes('App_CCContentDisoveryReq/discoveryContent/users') R ( ref )
			--Delete all entries where both userId and username are invalid.
			DELETE FROM @userList
			WHERE userId = 0 AND userName = ''
		END
		IF(@IsUserAccountTypeSelected = 1)
		BEGIN
			INSERT INTO @userAccountList(accountId,BSId,SCId)
			SELECT  ISNULL(ref.value('@email', 'nvarchar'),0),0,0
			FROM    @i_xml.nodes('App_CCContentDisoveryReq/discoveryContent/userAccounts') R ( ref )
			--Delete all empty email accounts
			DELETE FROM @userAccountList
			WHERE accountId = ''
		END
--------------------Find out as to what all criteria for discovery were sent in the request--------
IF( @getValidContentFlag = 1 )
BEGIN
	IF (@isProviderTypeSelected <> 1 OR @IsUserTypeSelected <> 1)
	BEGIN
		SET @errorCode = -1
		SET @errorString = 'Apporpriate Flags are not Set for getting valid content'
		SET @r_error = (
				select @errorCode as '@errorCode',@errorString as '@errorString'
				for xml path('response')
			)
		SET @r_allErrors = CONVERT(nvarchar(MAX),@r_error)
		GOTO GENERATE_OUTPUT
	END
	DECLARE @validComboTbl TABLE
	(
	userId INT,
	userName nvarchar(MAX),
	userGroupId INT,
	userGroupName nvarchar(MAX),
	providerId INT,
	userAccount nvarchar(MAX)
	)
	IF @isUserRegExFlag = 1
	BEGIN
		IF @isGroupTypeSelected <> 1
		BEGIN
			INSERT INTO @CombinationTbl
				SELECT UMG.id, providerId,0
				FROM  UMGroups UMG, @providerList
		END
		ELSE
		BEGIN
			INSERT INTO @CombinationTbl
				SELECT userGroupId, providerId,0
				FROM  @userGroupList, @providerList
		END
	END
	ELSE
	BEGIN
		INSERT INTO @CombinationTbl
			SELECT userGroupId, providerId, userId
			FROM   @userGroupList, @providerList, @userList
	END
		--here if we have userAccountset as well, we send back filtered data of form USERGROUP-PROVIDER-USER-USERACCOUNT
		--Else we have filtered data of the form USERGROUP-PROVIDER-USER .
	    IF @IsUserAccountTypeSelected =1
			BEGIN
				INSERT INTO @validComboTbl
				SELECT DISTINCT UMU.Id ,
								UMU.login ,
								--UMU.userGuid AS '@userGuid',
								UMG.id ,
								UMG.name ,
								CMB.providerId,
								CCUA.userAccount
				FROM   UMUsers UMU  INNER JOIN UMUserGroup UUG  ON UMU.Id = UUG.userId
									INNER JOIN UMGroups UMG ON UUG.groupId = UMG.id
									INNER JOIN App_CCUserServices CCUS ON UUG.groupId = CCUS.id
									INNER JOIN @CombinationTbl CMB ON UMG.id = CMB.userGroupId
									INNER JOIN App_CCUserAccounts CCUA ON CMB.providerId = CCUA.accountType
				WHERE CCUS.entityType = 15 AND (CCUS.servicesSelected & CMB.providerId)>0 AND CMB.userId = UMU.id AND CCUA.userId = CMB.userId AND CCUA.userId = UMU.id
			END
		ELSE IF @isUserRegExFlag = 1
			BEGIN
				UPDATE @userList
				SET userName = REPLACE(userName , '*', '%')
				INSERT INTO @validComboTbl
				SELECT DISTINCT 0,
								'',
								UMG.id ,
								UMG.name ,
								CMB.providerId,
								''
				FROM         UMGroups UMG INNER JOIN App_CCUserServices CCUS ON UMG.id = CCUS.id
							 INNER JOIN @CombinationTbl CMB ON UMG.id = CMB.userGroupId
				WHERE CCUS.entityType = 15 AND (CCUS.servicesSelected & CMB.providerId)>0
				UPDATE @validComboTbl SET userName = ISNULL((SELECT TOP 1 userName FROM @userList),'')
			END
			--SELECT * FROM @validComboTbl
			SET @combinationCursor = CURSOR FOR
							 SELECT DISTINCT userId,userName,userGroupId,userGroupName, providerId,userAccount
							 FROM  @validComboTbl
			OPEN @combinationCursor
			FETCH NEXT FROM @combinationCursor INTO @inputUserId,@inputUserName,@inputUserGroupId,@inputUserGroupName,@inputProviderId,@inputUserAccount
				WHILE @@FETCH_STATUS = 0
					BEGIN
						IF @IsUserAccountTypeSelected =1
						BEGIN
						SET @userAccountsXML = 	( SELECT @inputUserAccount as '@email'
												FOR XML PATH('userAccounts')
							)
						END
						SET @discoveredContent = (SELECT --1. User Group List
														(SELECT @inputUserGroupId AS '@userGroupId',
																@inputUserGroupName AS '@userGroupName'
														FOR XML PATH('userGroups'), type),
														--2. User List
														(SELECT @inputUserId AS '@userId',
																@inputUserName AS '@userName'
														FOR XML PATH('users'), type),
														--3.Provider List
														(SELECT @inputProviderId AS '@val'
														 FOR XML PATH('services'), type),
														--4.User account(if exists)
														 isnull(@userAccountsXML,'')
													FOR XML PATH('discoveryContent'))
						print convert(nvarchar(max),@discoveredContent)
						SET @all_DiscoveredContent = (SELECT @all_DiscoveredContent, @discoveredContent FOR XML PATH(''))
						FETCH NEXT FROM @combinationCursor INTO @inputUserId,@inputUserName,@inputUserGroupId,@inputUserGroupName,@inputProviderId,@inputUserAccount
					END
			DEALLOCATE @combinationCursor
		DELETE FROM @discoveryTypeTbl
		INSERT INTO @discoveryTypeTbl
		VALUES (1),(2),(3),(4)
		GOTO  SEND_OUTPUT
END
ELSE IF(@isProviderTypeSelected =1 AND (@isUserTypeSelected =1 OR @IsALLUserTypeSelected = 1) )           --handle both case for providing all user accounts for providers OR for providers & users combined.
BEGIN
	DELETE FROM @userAccountList
	INSERT INTO @CombinationTbl
			SELECT 0, providerId, userId
			FROM   @userList, @providerList
	IF @IsALLUserTypeSelected = 1
		BEGIN
			SET @userAccountsXML = 	( SELECT userAccount AS '@email', accountType AS '@providerId'
									  FROM App_CCUserAccounts CCUA INNER JOIN @providerList CMB ON CCUA.accountType =CMB.providerId
									  FOR XML PATH('userAccounts')
									)
		END
	ELSE IF @isUserRegExFlag = 1
		BEGIN
		--replace '*' in the username with '%' for SQL engine for regular expression based discovery
		UPDATE @userList
		SET userName = REPLACE(userName , '*', '%')
			SET @userAccountsXML = 	( SELECT userAccount AS '@email', accountType AS '@providerId'
									 FROM App_CCUserAccounts CCUA
												  INNER JOIN @CombinationTbl CMB ON CCUA.accountType = CMB.providerId
												  INNER JOIN UMUsers 		 UMU ON CCUA.userId = UMU.id
												  INNER JOIN @userList UL 		 ON UMU.login LIKE UL.userName
										FOR XML PATH('userAccounts')
									)
		END
	ELSE
		BEGIN
			SET @userAccountsXML = 	( SELECT userAccount AS '@email', accountType AS '@providerId'
									FROM App_CCUserAccounts CCUA INNER JOIN @CombinationTbl CMB ON (CCUA.userId=CMB.userId AND CCUA.accountType =CMB.providerId )
									WHERE CMB.userId=CCUA.userId
									FOR XML PATH('userAccounts')
									)
		END
	DELETE FROM @discoveryTypeTbl
	INSERT INTO @discoveryTypeTbl
	VALUES (4)
	GOTO GENERATE_OUTPUT
END
ELSE IF(@isGroupTypeSelected =1  AND @isProviderTypeSelected =1)
BEGIN
		INSERT INTO @CombinationTbl
			SELECT userGroupId, providerId, 0
			FROM   @userGroupList, @providerList
			DELETE FROM @userList
    SET @combinationCursor = CURSOR FOR
							 SELECT DISTINCT userGroupId, providerId
							 FROM  @CombinationTbl
	OPEN @combinationCursor
	FETCH NEXT FROM @combinationCursor INTO @inputUserGroupId,@inputProviderId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				  INSERT INTO @userList
				         SELECT DISTINCT Id , login
						 FROM   UMUsers
						 WHERE Id IN ( SELECT UGU.userId
										FROM UMUserGroup UGU JOIN App_CCUserServices CCUS ON UGU.groupId = CCUS.id
										WHERE CCUS.entityType = 15 AND UGU.groupId = @inputUserGroupId AND (CCUS.servicesSelected & @inputProviderId)>0
						 )
				FETCH NEXT FROM @combinationCursor INTO @inputUserGroupId,@inputProviderId
			END
	DEALLOCATE @combinationCursor
	SET @usersXML = ( SELECT DISTINCT userId AS '@userId'  ,  userName AS '@userName'
					  FROM  @userList
					  FOR XML PATH('users')
					)
	DELETE FROM @discoveryTypeTbl
	INSERT INTO @discoveryTypeTbl
	VALUES (3)
	GOTO GENERATE_OUTPUT
END
ELSE IF(@isGroupTypeSelected =1)
BEGIN
	SET @cnt = 1
	WHILE (1>0)
	BEGIN
		IF EXISTS(SELECT 1 FROM App_CCUserServices
			WHERE ((servicesSelected & @cnt)>0))
		BEGIN
			INSERT INTO @servicesAvailable
			SELECT @cnt,0
		END
		ELSE
		BEGIN
			-- This means there are no more services selected
			if (NOT EXISTS(select 1 from App_CCUserServices
				WHERE servicesSelected > @cnt))
			BEGIN
				break
			END
		END
		SET @cnt = @cnt * 2
	END
	 DELETE FROM @providerList
	INSERT INTO @providerList
					SELECT CCUS.servicesSelected
					FROM App_CCUserServices CCUS INNER JOIN @userGroupList UGList
					ON (CCUS.id = UGList.userGroupId AND CCUS.entityType = 15)
	UPDATE @servicesAvailable
	SET isSelected = 0
	UPDATE @servicesAvailable
	SET isSelected = 1
	FROM @providerList PL
	WHERE ((enumVal & PL.providerId) > 0)
	SET @providersXML =( SELECT DISTINCT enumVal as '@val'
						 FROM @servicesAvailable
						 WHERE isSelected=1
						for xml path('services'))
	SET @usersXML    =( SELECT DISTINCT id AS '@userId',
							   login AS '@userName'
						FROM UMUsers UU INNER JOIN UMUserGroup UUG ON UU.id = UUG.userId
						WHERE UUG.groupId IN ( SELECT userGroupId
											   FROM @userGroupList)
						FOR XML PATH('users')
						)
	DELETE FROM @discoveryTypeTbl
	INSERT INTO @discoveryTypeTbl
	VALUES (2),(3)
	GOTO GENERATE_OUTPUT
END
ELSE IF(@isProviderTypeSelected =1)
BEGIN
	DELETE FROM @userGroupList
	SET @combinationCursor = CURSOR FOR
							 SELECT DISTINCT providerId
							 FROM  @providerList
	OPEN @combinationCursor
	FETCH NEXT FROM @combinationCursor INTO @inputProviderId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @userGroupList
					SELECT DISTINCT UGU.id ,name
					FROM  UMGroups UGU INNER JOIN App_CCUserServices CCUS ON (UGU.id = CCUS.id AND CCUS.entityType = 15)
					WHERE (@inputProviderId & CCUS.servicesSelected) > 0
			FETCH NEXT FROM @combinationCursor INTO @inputProviderId
		END
		DEALLOCATE @combinationCursor
			SET @userGroupsXML = ( SELECT DISTINCT userGroupId AS '@userGroupId' , userGroupName as '@userGroupName'
								FROM @userGroupList
								FOR XML PATH('userGroups')
								)
			SET @usersXML    =( SELECT DISTINCT id AS '@userId',
							   login AS '@userName'
							   --userGuid AS '@userGUID'
								FROM UMUsers UU INNER JOIN UMUserGroup UUG ON UU.id = UUG.userId
								WHERE UUG.groupId IN ( SELECT userGroupId
													   FROM @userGroupList)
								FOR XML PATH('users')
						)
	DELETE FROM @discoveryTypeTbl
	INSERT INTO @discoveryTypeTbl
	VALUES (1),(3)
	GOTO GENERATE_OUTPUT
END
ELSE
BEGIN
		SET @errorCode = -1
		SET @errorString = 'No Flags were set'
		SET @r_error = (
				select @errorCode as '@errorCode',@errorString as '@errorString'
				for xml path('response')
			)
		SET @r_allErrors = CONVERT(nvarchar(MAX),@r_error)
		GOTO GENERATE_OUTPUT
END
GENERATE_OUTPUT:
	SET @discoveredContent = ( SELECT @userGroupsXML ,
									  @usersXML,
									  @providersXML,
									  @userAccountsXML
								FOR XML PATH('discoveryContent')
							  )
	print convert(nvarchar(max),@discoveredContent)
	SET @all_DiscoveredContent = (SELECT @all_DiscoveredContent, @discoveredContent FOR XML PATH(''))
SEND_OUTPUT:
	SET @dicoveryTypeXML  = ( SELECT DISTINCT enumVal AS '@val'
							  FROM @discoveryTypeTbl
							  FOR XML PATH('discoveryRecievedTypes')
							 )
	SET @r_error = ( SELECT @errorCode AS '@errorCode',
							@errorString AS '@errorString'
							FOR XML PATH('response')
					)
	SET @r_allErrors = (SELECT @r_error FOR XML PATH('errors'))
	SET @all_DiscoveredContent = ( SELECT @r_allErrors , @dicoveryTypeXML, @all_DiscoveredContent  FOR XML PATH(''),root('App_CCContentDisoveryResp'))
	SELECT @all_DiscoveredContent o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCCDiscoveryContent')
	delete from GxQscripts where name = 'AppGetCCDiscoveryContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCCDiscoveryContent')
	delete from GXDBVersions where aliasname = 'AppGetCCDiscoveryContent'
GO

insert into GXDBVersions values(2, 'AppGetCCDiscoveryContent',  '00010004004800010000', 'AppGetCCDiscoveryContent', '00010004004800010000')
GO

