

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetBlockReplicationInfoWrapper.sp] ---------- 

--  +=============================================================================================+
--  |                       Name: AppGetBlockReplicationInfoWrapper()
--  | Description: Fetches replication monitor details for continuous pairs
--  |
--  |       Input: XML (contains list of replication groups which are to be enabled or disabled).
--  |      Output: List of pairs(siteInfo) which are to be stopped or started.
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetBlockReplicationInfoWrapper')
BEGIN
	print '>>> Drop Stored Procedure: AppGetBlockReplicationInfoWrapper <<<'
	drop procedure AppGetBlockReplicationInfoWrapper
END
IF EXISTS (select * from GxQscripts where name='AppGetBlockReplicationInfoWrapper')
	delete from GxQscripts where name = 'AppGetBlockReplicationInfoWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBlockReplicationInfoWrapper')
	delete from GXDBVersions where aliasname = 'AppGetBlockReplicationInfoWrapper'
GO
print '... Creating Procedure: AppGetBlockReplicationInfoWrapper'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetBlockReplicationInfoWrapper
  @localeId INT,
  @i_xmlText XML,
  @userId INT
AS
  DECLARE @o_xml XML 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
    IF OBJECT_ID('tempdb.dbo.#GetBlockReplicationInfoExtXmlTbl') IS NOT NULL
        DROP TABLE #GetBlockReplicationInfoExtXmlTbl
    IF OBJECT_ID('tempdb.dbo.#continuousPairs') IS NOT NULL
        DROP TABLE #continuousPairs
    CREATE TABLE #GetBlockReplicationInfoExtXmlTbl (continuous XML)
    CREATE TABLE #continuousPairs (pairXML XML)
    DECLARE @tempStr NVARCHAR(MAX) = '<BlockReplication_GetBlockReplicationInfoReq localeID="' + CONVERT(NVARCHAR(10),@localeId) + '"><siteInfo id="0"><entity subclientId="0"/><processinginstructioninfo> <user userId= "'+ CONVERT(NVARCHAR(50),@userId)+ '" /></processinginstructioninfo></siteInfo></BlockReplication_GetBlockReplicationInfoReq>'
    DECLARE @fetchBlrInpXML XML = CAST(@tempStr AS XML)
    EXEC DBO.GetBlockReplicationInfo @fetchBlrInpXML
    INSERT INTO #continuousPairs
            SELECT x.XmlCol.query('.')
                from #GetBlockReplicationInfoExtXmlTbl b cross apply b.continuous.nodes('/BlockReplication_GetBlockReplicationInfoResp/siteInfo') AS x(XmlCol)
                    inner join App_replicationGroupAssociation REP on REP.blrpairId = x.XmlCol.value('(@id)[1]','INT')
					inner join @i_xmlText.nodes('//replicationGroups') R(ref) ON ref.value('@replicationGroupId','INT') = REP.componentNameId
    SET @o_xml = (SELECT CAST( CAST(STUFF(
					(SELECT ' ' + CONVERT(NVARCHAR(MAX),pairXML) FROM #continuousPairs FOR XML PATH('')),1, 1, '') AS XML).value('.[1]','NVARCHAR(MAX)') AS XML)
						FOR XML PATH(''), ROOT('BlockReplication_GetBlockReplicationInfoResp'))
    SELECT @o_xml as o_xml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetBlockReplicationInfoWrapper')
	delete from GxQscripts where name = 'AppGetBlockReplicationInfoWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBlockReplicationInfoWrapper')
	delete from GXDBVersions where aliasname = 'AppGetBlockReplicationInfoWrapper'
GO

insert into GXDBVersions values(2, 'AppGetBlockReplicationInfoWrapper',  '00000000000000000000', 'AppGetBlockReplicationInfoWrapper', '00000000000000000000')
GO

