

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetBakupSetWithNoJobs.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetBakupSetWithNoJobs
--  | Description:
--  |
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/Attic/AppGetBakupSetWithNoJobs.sp,v $ $Id: AppGetBakupSetWithNoJobs.sp,v 1.1.4.2 2021/03/12 11:35:18 rkulkarni Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetBakupSetWithNoJobs')
BEGIN
	print '>>> Drop Stored Procedure: AppGetBakupSetWithNoJobs <<<'
	drop procedure AppGetBakupSetWithNoJobs
END
IF EXISTS (select * from GxQscripts where name='AppGetBakupSetWithNoJobs')
	delete from GxQscripts where name = 'AppGetBakupSetWithNoJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBakupSetWithNoJobs')
	delete from GXDBVersions where aliasname = 'AppGetBakupSetWithNoJobs'
GO
print '... Creating Procedure: AppGetBakupSetWithNoJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetBakupSetWithNoJobs
  @i_dataSourceId INT = 0
AS
DECLARE @drInstanceID INTEGER
SET @drInstanceID  =  ISNULL((SELECT TOP 1 instance FROM APP_Application (NOLOCK) WHERE appTypeId= 1000),1)
--get associated backupset with input datasourceId
	IF object_id('tempdb.dbo.#backupSetList') is not null DROP TABLE #backupSetList
	CREATE TABLE #backupSetList (backupSetId INT, dataSourceId INT)
	INSERT INTO #backupSetList
	SELECT S.backupSet, dsp.DataSourceId
	FROM APP_Application S (NOLOCK)
	JOIN SEDataSourceProperty DSP (NOLOCK) on S.id = CAST(DSP.PropertyValue AS INT)
	JOIN SEProperty SEP (NOLOCK) on DSP.PropertyId = SEP.PropertyId
	WHERE  DSP.DataSourceId = @i_dataSourceId
		AND SEP.PropertyName = 'subclientid'		--subclientid
--get associated subclient for backupsetId
	IF object_id('tempdb.dbo.#SubClientIdList') is not null DROP TABLE #SubClientIdList
	CREATE TABLE #SubClientIdList (id INT, backupSetId INT, dataSourceId INT)
	INSERT into #SubClientIdList
	SELECT MAX(S.id), S.backupSet , MAX(B.dataSourceId)
	FROM APP_Application S (NOLOCK)
	JOIN #backupSetList B ON S.backupSet =B.backupSetId
	GROUP by s.backupSet
	HAVING count(*) =1									--only one subclients should present
	IF NOT EXISTS(SELECT TOP 1 1  FROM #SubClientIdList)
		GOTO PROC_EXIT
--Check if any backup job is present then do not include
	DELETE S
	FROM  #SubClientIdList S
	JOIN JMBkpStats JB (NOLOCK) ON S.id = JB.appId AND JB.status IN (1, 3, 14) --JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
	IF NOT EXISTS(SELECT TOP 1 1  FROM #SubClientIdList)
		GOTO PROC_EXIT
-- backup activity must be disabled
	DELETE FROM  #SubClientIdList
	WHERE id NOT IN (
	-- disable at subclient level
	SELECT JMJA.appId FROM JMJobAction JMJA (NOLOCK)
		JOIN APP_Application AP (NOLOCK) ON JMJA.appId = AP.id
		JOIN #SubClientIdList SC ON AP.ID = SC.id
WHERE AP.appTypeId <> 1030
		AND JMJA.clientId = 1
		AND JMJA.mediaAgentID = 1
		AND JMJA.opType = 4  -- BACKUP
		AND JMJA.action = 1 -- DISABLEACTIVITY
		AND JMJA.clientGroupId = 0
		AND JMJA.instanceID = 1
	UNION
	-- disable at client level
	SELECT AP.id FROM APP_Application AP WITH(NOLOCK)
		JOIN #SubClientIdList SC ON AP.ID = SC.id
		JOIN JMJobAction JMJA (NOLOCK) ON JMJA.clientId = AP.clientId
		WHERE JMJA.clientId <> 1
		AND JMJA.mediaAgentID = 1
		AND JMJA.opType = 4  -- BACKUP
		AND JMJA.action = 1 -- DISABLEACTIVITY
		AND JMJA.clientGroupId = 0
		AND JMJA.instanceID = 1
	UNION
	-- disable at client computer group level
	SELECT AP.id FROM APP_Application AP WITH(NOLOCK)
		JOIN #SubClientIdList SC ON AP.ID = SC.id
		JOIN APP_ClientGroupAssoc ACGA (NOLOCK) ON ACGA.clientId = AP.clientId
			INNER JOIN JMJobAction JMJA (NOLOCK) ON JMJA.clientGroupId  = ACGA.clientGroupId
		WHERE JMJA.clientId = 1
			AND JMJA.clientGroupId <> 0
			AND JMJA.mediaAgentID = 1
			AND opType = 4  -- BACKUP
			AND action = 1 -- DISABLEACTIVITY
			AND instanceID = 1
	UNION
	--all activity or data management disabled at commcell level
	SELECT AP.id FROM APP_Application AP (NOLOCK)
		JOIN #SubClientIdList SC ON AP.ID = SC.id
		WHERE EXISTS
		(SELECT 1 FROM JMJobAction JMJA (NOLOCK) WHERE JMJA.clientId = 1 AND opType IN (1,4) AND action = 1 and appId = 1 and clientGroupId = 0 AND instanceID = @drInstanceID)
	 )
PROC_EXIT:
SELECT S.dataSourceId, backupSetId , b.name
FROM #SubClientIdList S
JOIN APP_BackupSetName b on s.backupSetId = b.id
IF object_id('tempdb.dbo.#backupSetList') is not null  DROP TABLE #backupSetList
IF object_id('tempdb.dbo.#SubClientIdList') is not null DROP TABLE #SubClientIdList
--OUTPUT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetBakupSetWithNoJobs')
	delete from GxQscripts where name = 'AppGetBakupSetWithNoJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBakupSetWithNoJobs')
	delete from GXDBVersions where aliasname = 'AppGetBakupSetWithNoJobs'
GO

insert into GXDBVersions values(2, 'AppGetBakupSetWithNoJobs',  '00010001000400020000', 'AppGetBakupSetWithNoJobs', '00010001000400020000')
GO

