

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetBackupsetsInIndexServer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetBackupsetsInIndexServer.sp,v $ $Id: AppGetBackupsetsInIndexServer.sp,v 1.1.2.2 2018/04/13 17:47:19 alokkumar Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetBackupsetsInIndexServer <<<'

IF EXISTS (select * from sysobjects where name='AppGetBackupsetsInIndexServer')
	drop procedure AppGetBackupsetsInIndexServer
IF EXISTS (select * from GxQscripts where name='AppGetBackupsetsInIndexServer')
	delete from GxQscripts where name = 'AppGetBackupsetsInIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupsetsInIndexServer')
	delete from GXDBVersions where aliasname = 'AppGetBackupsetsInIndexServer'
GO
print '... Creating Procedure: AppGetBackupsetsInIndexServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetBackupsetsInIndexServer
  @i_xmlIn XML
AS
  DECLARE @o_xmlOut XML =''
DECLARE @idxSrvrId INT;
DECLARE @idxSrvrName VARCHAR(1024);
SET @idxSrvrName = ISNULL((SELECT ref.value('@clientName','VARCHAR(1024)') FROM @i_xmlIn.nodes('App_GetBackupsetsInIndexDBReq') AS R(ref)),'');
SET @idxSrvrId = ISNULL( ( SELECT id from APP_Client where name = @idxSrvrName) ,0);
DECLARE @BackupsetsInIndexServerTbl   TABLE(
												clientName varchar(1024) NOT NULL ,
												agentType varchar(1024) NOT NULL ,
												instance varchar(1024) NOT NULL ,
												backupsetName varchar(1024) NOT NULL ,
												backupsetGUID  nvarchar(1024) NOT NULL
											)
INSERT INTO @BackupsetsInIndexServerTbl
SELECT client.name , iDAs.displayName , ins.name , bs.name , bs.GUID  from APP_Client client  WITH (NOLOCK)
JOIN APP_Application app  WITH (NOLOCK) ON client.id = app.clientId
JOIN APP_BackupSetName bs  WITH (NOLOCK) ON bs.id = app.backupSet
JOIN APP_InstanceName ins WITH (NOLOCK) ON ins.id = app.instance
JOIN App_IndexDBInfo indexDB  WITH (NOLOCK) ON indexDB.backupSetId = bs.id
JOIN APP_IDAType iDAs  WITH (NOLOCK) ON iDAs.type = app.appTypeId
WHERE indexDB.currentIdxServer = @idxSrvrId
GROUP by client.name , iDAs.displayName , ins.name , bs.name , bs.GUID
Order by bs.GUID DESC;
--select * from @IndexServerListTbl
--sample output
/*
<App_BackupsetsInIndexDBListResp>
	<backupsets clientName="alok_03_01" agentType="File System" instance="DefaultInstanceName" backupsetName="back1" backupsetGUID="EB0AAE34-E4FB-4D69-80ED-672419F4BE9D" />
	<backupsets clientName="alok_03_01" agentType="File System" instance="DefaultInstanceName" backupsetName="back2" backupsetGUID="035D8727-72B0-4D8E-9B5F-A4E9B93F0B84" />
</App_BackupsetsInIndexDBListResp>
*/
--output
SET @o_xmlOut = ISNULL(( 	SELECT
							(
							SELECT
								T.clientName AS '@clientName',
								T.agentType AS '@agentType',
								T.instance AS '@instance',
								T.backupsetName AS '@backupsetName',
								T.backupsetGUID AS '@backupsetGUID'
								FROM @BackupsetsInIndexServerTbl T
								FOR XML PATH('backupsets'), TYPE
					 ) FOR XML PATH('App_BackupsetsInIndexDBListResp')
					 ),'<App_BackupsetsInIndexDBListResp/>')
SELECT @o_xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetBackupsetsInIndexServer')
	delete from GxQscripts where name = 'AppGetBackupsetsInIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupsetsInIndexServer')
	delete from GXDBVersions where aliasname = 'AppGetBackupsetsInIndexServer'
GO

insert into GXDBVersions values(2, 'AppGetBackupsetsInIndexServer',  '00010001000200020000', 'AppGetBackupsetsInIndexServer', '00010001000200020000')
GO

