

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetBackupsetListForAdminConsole.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +------------------------------------------------------------------------------------------+
--  |           Procedure : "AppGetBackupsetListForAdminConsole"
--  |   This Procedure is used to get a list of backupSet with limited set of properties.
--  +------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetBackupsetListForAdminConsole')
BEGIN
	print '>>> Drop Stored Procedure: AppGetBackupsetListForAdminConsole <<<'
	drop procedure AppGetBackupsetListForAdminConsole
END
IF EXISTS (select * from GxQscripts where name='AppGetBackupsetListForAdminConsole')
	delete from GxQscripts where name = 'AppGetBackupsetListForAdminConsole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupsetListForAdminConsole')
	delete from GXDBVersions where aliasname = 'AppGetBackupsetListForAdminConsole'
GO
print '... Creating Procedure: AppGetBackupsetListForAdminConsole'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetBackupsetListForAdminConsole
  @i_userId INT,
  @i_localeId INT,
  @i_xmlReq XML,
  @o_xmlResp XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @WindowsServersCount INT = 0
DECLARE @UnixServersCount INT = 0
DECLARE @NASCount INT = 0
DECLARE @FSCount INT=0
DECLARE @DBCount INT = 0
DECLARE @VMCount INT = 0
DECLARE @CloudAppsCount INT =0
DECLARE @i_includeVMClients INTEGER =
ISNULL((SELECT  ref.value('@includeVMClients', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetBackupsetPropertiesRequest/extendedFilter') R ( ref )),0)
DECLARE @i_includeHiddenClients INTEGER =
ISNULL((SELECT  ref.value('@hiddenclients', 'int') AS client
                              FROM    @i_xmlReq.nodes('App_GetBackupsetPropertiesRequest/extendedFilter') R ( ref )),0)
DECLARE @i_hideLaptopAndDummyclients INTEGER =
ISNULL((SELECT  ref.value('@hideLaptopAndDummyClients', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetBackupsetPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
DECLARE @i_excludeInfrastuctureClients INTEGER =
ISNULL((SELECT  ref.value('@excludeInfrastructureClients', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetBackupsetPropertiesRequest/extendedFilter') R ( ref )),0)
DECLARE @i_fsType INTEGER  =
ISNULL((SELECT  ref.value('@fsType', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetBackupsetPropertiesRequest/extendedFilter') R ( ref )),3)
DECLARE @i_clientId INTEGER  =
ISNULL((SELECT  ref.value('@clientId', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetBackupsetPropertiesRequest/association/entity') R ( ref )),0)
DECLARE @i_appId INTEGER  =
ISNULL((SELECT  ref.value('@applicationId', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetBackupsetPropertiesRequest/association/entity') R ( ref )), 0)
DECLARE @i_propertyLevel INTEGER  =
ISNULL((SELECT  ref.value('@propertyLevel', 'INT')
                              FROM    @i_xmlReq.nodes('App_GetBackupsetPropertiesRequest/filterOptions') R ( ref )), 0)
DECLARE @i_getArchiverBackupsets INTEGER =
ISNULL((SELECT  ref.value('@getArchiverClients', 'int') AS client
                              FROM    @i_xmlReq.nodes('App_GetBackupsetPropertiesRequest/filterOptions') R ( ref )),0)
-- Disable/Enable Change Tracking Functionality
DECLARE @debug TINYINT = 0
DECLARE @disableCTClientProperties  INT = 0
SELECT
    @disableCTClientProperties = (CASE WHEN value <> '0' THEN 1 ELSE 0 END)
FROM GXGlobalParam WITH(NOLOCK)
WHERE name = N'CTDisablePropertyCaching'
IF (@debug > 0 AND @disableCTClientProperties > 0)
BEGIN
    PRINT 'AppGetBackupsetListForAdminConsole: disableCTClientProperties = ' + CAST(@disableCTClientProperties AS VARCHAR(12))
END
IF Object_id('tempdb.dbo.#i_allBackupList') IS NOT NULL
  DROP TABLE #i_allbackuplist
CREATE TABLE #i_allbackuplist
  (
     clientid                  INT,
     clientname                NVARCHAR(510),
     clientdisplayname         NVARCHAR(510),
     apptypeid                 INT,
     apptypename               NVARCHAR(255),
     osgroup                   NVARCHAR(30),
     backupsetid               INT,
     backupsetname             NVARCHAR(510),
     backupsetguid             UNIQUEIDENTIFIER,
     backupsetstatus           INT,
     lastbackuptime            INT DEFAULT 0,
     applicationsize           BIGINT DEFAULT 0,
     instanceid                INT,
     instancename              NVARCHAR(255),
     errorcode                 INT DEFAULT 0,
     errorstring               NVARCHAR(510) DEFAULT N'',
     -- Plan Association Details Start
     planid                    INT NULL,
     plantype                  INT NULL,
     plansubtype               INT NULL,
     planname                  NVARCHAR(1024) NULL,
     -- Plan Association Details END
     associatedsubclientpolicy INT NULL,
     slastatus                 INT DEFAULT 3, --Excluded by default. For new backupsets, the subclient in it may not have an entry in RptSlaSubclient table.
	 isDefaultArchiverSet	   INT DEFAULT 0,
	 slacategory			   INT DEFAULT 0,
	 slacategorydescription	   NVARCHAR(255) DEFAULT '',
	 isArchivingEnabled		   INT DEFAULT 0			-- Needed by UI in archiving solution to identify whether it is archiver set or a FS backupset with 1-pass subclient.
  )
CREATE CLUSTERED INDEX #i_allbackuplist_idx
  ON #i_allbackuplist(backupsetid ASC)
IF Object_id('tempdb.dbo.#getIdaObjects') IS NOT NULL
  DROP TABLE #getidaobjects
CREATE TABLE #getidaobjects
  (
     clientid    INT,
     apptypeid   INT,
     instanceid  INT,
     backupsetid INT,
     subclientid INT
  )
CREATE CLUSTERED INDEX #getidaobject_idx
  ON #getidaobjects(clientid, apptypeid, instanceid, backupsetid, subclientid)
EXEC dbo.sec_getIdaObjectsForUser  @i_userId/*user Id*/,6 /*Backup set EntityType*/,0 /*Permission Id*/,1 /*Inherit from children*/,'#getIdaObjects'
IF Object_id('TempDb.dbo.#SCQuota') IS NOT NULL
  DROP TABLE #scquota
CREATE TABLE #scquota
  (
     backupset INT,
     quota     BIGINT,
     atime     INT
  )
CREATE CLUSTERED INDEX scquota_idx
  ON #scquota (backupset)
IF Object_id('TempDb.dbo.#clientListProp') IS NOT NULL
  DROP TABLE #clientListProp
CREATE TABLE #clientListProp
  (
     clientId 			INT,
     isInfrastructure     	INT,
     virtualserverdiscovered    TINYINT,
     lastBackupJobid		BIGINT
  )
CREATE CLUSTERED INDEX clientListProp_idx
  ON #clientListProp (clientId)
-- This table contains both archiver and one-pass subclients' backupsets.
DECLARE @archiveAndOnePassBkpSets TABLE (id INT, isDefaultArchiverSet INT DEFAULT 0 )		-- This count is quite less, hardly 2-3. So table variable is fine.
IF(@i_getArchiverBackupsets = 1)
BEGIN
      INSERT INTO @archiveAndOnePassBkpSets (id)
          SELECT APP.backupset FROM APP_Application APP WITH(NOLOCK)
              INNER JOIN APP_BackupsetProp ABP WITH(NOLOCK)
              ON APP.backupset = ABP.componentNameId
                  WHERE APP.clientId = @i_clientId
                      AND APP.appTypeId = @i_appId
                      AND ABP.attrName = 'Is Archiving Enabled'
                      AND ABP.attrVal = '1'
                      AND ABP.modified = 0
                      AND APP.subclientStatus & 4 = 0
			UNION
			SELECT A.backupset
			FROM APP_Application A
				INNER JOIN APP_SubclientProp SP
					ON A.id = SP.componentNameId
					AND SP.attrName = 'Turbo Mode Enable Stubbing'
					AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
					AND SP.attrVal = '1'
					AND SP.modified = 0
			WHERE
				clientId = @i_clientId
				AND AppTypeId = @i_appId
          			AND subclientStatus & 4 = 0
		        UNION
		        SELECT  APP.backupset
		        FROM APP_Application APP WITH (NOLOCK)
		        INNER JOIN APP_SubclientProp SCP_ASP
		                ON APP.id = SCP_ASP.componentNameId
AND SCP_ASP.attrName = N'Associated subclient Policy'
AND SCP_ASP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
		                AND SCP_ASP.attrVal <> '0'
		                AND SCP_ASP.modified = 0
		        INNER JOIN APP_SubclientProp SP
		                ON CAST(SCP_ASP.attrVal AS INT) = SP.componentNameId
AND SP.attrName = N'Turbo Mode Enable Stubbing'
AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
		                AND SP.attrVal = '1'
		                AND SP.modified = 0
		        LEFT JOIN APP_SubclientProp SCP_PLAN WITH (NOLOCK)
		                ON APP.id = SCP_PLAN.componentNameId
AND SCP_PLAN.attrName = 'Associated Plan'
AND SCP_PLAN.cs_attrName = CHECKSUM(N'Associated Plan')
		                AND SCP_PLAN.attrVal <> '0'
		                AND SCP_PLAN.modified = 0
		          WHERE SCP_PLAN.componentNameId IS NULL
		                AND APP.clientId = @i_clientId
		                AND APP.appTypeId = @i_appId
		                AND APP.subclientStatus & 4 = 0
	-- Identify the oldest archiver set in this list and that will be the default. This is just for GUI to show one archiver set in server details landing page.
	UPDATE @archiveAndOnePassBkpSets
	SET isDefaultArchiverSet = 1
	WHERE
		id = (SELECT MIN(id) FROM @archiveAndOnePassBkpSets)
END
------------------------------------------CACHE TABLE BEGINS HERE----------------------------------------------------------------------------------
IF( @disableCTClientProperties = 0 )
  BEGIN
      DECLARE @lastSyncVersion BIGINT = (SELECT syncversion
         FROM   ct_cacheassociations
         WHERE  cachetable = 'CT_Clientproperties')
      DECLARE @clientRows INT = 0
      IF Object_id('tempdb.dbo.#UpdatedClients') IS NOT NULL
        DROP TABLE #updatedclients
      CREATE TABLE #updatedclients
        (
           clientid INT PRIMARY KEY
        )
      -- Capture all Clients that have had client properties changed since the last sync
      INSERT INTO #updatedclients
      SELECT ct.componentnameid clientId
      FROM   CHANGETABLE(changes app_clientprop, @lastSyncVersion) ct
      WHERE  ct.sys_change_operation = 'D'
      UNION
      SELECT ct.componentnameid clientId
      FROM   CHANGETABLE(changes app_clientprop, @lastSyncVersion) ct
             INNER JOIN app_clientprop cp WITH(nolock)
                     ON cp.id = ct.id
                        AND ct.sys_change_operation <> 'D'
             INNER JOIN ct_cachepropertyassociations cpa
ON cpa.tabletype = 1
                        AND cpa.propertyname = cp.attrname
      UNION
      SELECT c.id
      FROM   app_client c WITH(nolock)
             LEFT JOIN ct_clientproperties cp WITH(nolock)
                    ON c.id = cp.clientid
      WHERE  cp.clientid IS NULL
             AND c.id > 1
      -- new client row but missing cached property row, mark client as dirty
      SET @clientRows = @@ROWCOUNT
      IF  (@clientRows > 0)
      BEGIN
	      -- Generate PIVOT Query to get data for dirty client properties that need to be updated
	      DECLARE @comma TINYINT = 0
	      DECLARE @nl NVARCHAR(3) = Nchar(13) + Nchar(10)
	      DECLARE @pivotVars NVARCHAR(MAX) = @nl
	      DECLARE @attrNames NVARCHAR(MAX) = @nl
	      DECLARE @colNames NVARCHAR(MAX) = @nl
	      DECLARE @sqlCmd NVARCHAR(MAX) = ''
	      SELECT @attrNames += ( CASE WHEN @comma = 1 THEN ',' ELSE '' END ) + '''' + propertyname + '''' + @nl,
	             @pivotVars += ( CASE WHEN @comma = 1 THEN ',' ELSE '' END ) + '[' + propertyname + ']' + @nl,
	             @colNames += ( CASE WHEN @comma = 1 THEN ',' ELSE '' END ) + columnname + @nl,
	             @comma = 1
	      FROM   CT_Cachepropertyassociations cpa
	      WHERE  cpa.tabletype = 1
	             AND propertyname IN ( 'Virtual Server Discovered Clients',
	                                   'Last Backup JobID',
	                                   'IsInfrastructure' )
	      -- Generate the Client Properties INSERT PIVOT Command
	      DECLARE @pivotCmd NVARCHAR(MAX) = @nl
	        + 'INSERT INTO #clientlistprop(clientid,'+ @colNames+ ')
					SELECT	clientid,
							'+ @pivotVars+'
					FROM   (
	                       SELECT          c.clientid,
	                                       cp.attrname,
	                                       cp.attrval
	                       FROM            #updatedclients c
	                       LEFT OUTER JOIN app_clientprop cp
							   ON c.clientid = cp.componentnameid
							   AND cp.modified = 0
							   AND cp.attrname IN ( '   + @attrNames   + ' ) )
						   AS clients
					PIVOT ( Max(attrval) FOR attrname IN ( '   + @pivotVars + ' ) ) AS p' + @nl
	    -- Execute command to populate the CT_ClientProperties cache table
	    SET @pivotCmd += @nl
	    EXEC(@pivotCmd)
      END
END
------------------------------------------CACHE TABLE ENDS HERE ----------------------------------------------------------------------------------
INSERT INTO #i_allbackuplist
            (clientid,
             clientname,
             clientdisplayname,
             apptypeid,
             apptypename,
             osgroup,
             instanceid,
             instancename,
             backupsetid,
             backupsetname,
             backupsetguid,
             backupsetstatus,
			 isDefaultArchiverSet,
			 isArchivingEnabled)
SELECT DISTINCT AC.id,
       AC.NAME,
       AC.displayname,
       ida.type,
       ida.NAME,
       ATG.osgroup,
       instance.id,
       instance.NAME,
       backupset.id,
       backupset.NAME,
       backupset.guid,
       backupset.status,
	   ArcBkpSetsAndOnePassBkpSets.isDefaultArchiverSet,
	   ArcBkpSets.attrVal
FROM   #getidaobjects supportedBackupSets
       INNER JOIN app_backupsetname AS backupset
               ON supportedBackupSets.backupsetid = backupSet.id
AND ( backupset.status & 0x00010 ) <> 0x00010
                  AND (
                      -- Include any hidden clients if any present.
                      ( @i_includeHiddenClients > 0 )
OR ( ( backupset.status & 0x00020 ) <> 0x00020 )
                       )
AND ( backupset.status & 0x00004 ) <> 0x00004
AND ( backupset.status & 0x80000 ) <> 0x80000
AND ( backupset.status & 0x1000 ) <> 0x1000
       INNER JOIN app_client AS AC
               ON supportedBackupSets.clientid = AC.id
       INNER JOIN app_idatype AS ida
               ON supportedBackupSets.apptypeid = ida.type
       INNER JOIN app_instancename AS instance
               ON supportedBackupSets.instanceid = instance.id
       LEFT OUTER JOIN ct_clientproperties AS cpt
               ON supportedBackupsets.clientid = cpt.clientid
       LEFT OUTER JOIN #clientListProp AS cpt2
	       ON supportedBackupsets.clientid = cpt2.clientid
       INNER JOIN simoperatingsystem AS SOS
               ON SOS.id = AC.simoperatingsystemid
       INNER JOIN app_apptypegroups AS ATG
               ON ATG.apptypeid = ida.type
                  AND ATG.app = N'file system'
                  AND ( ( ( ATG.osgroup = N'windows' )
                          AND ( @i_fsType = 1
                                 OR @i_fsType = 3 ) )
                         OR ( ( ATG.osgroup = N'unix' OR ATG.osgroup = N'mac')
                              AND ( @i_fsType = 2
                                     OR @i_fsType = 3 ) )
						 OR ( ( ATG.osgroup = N'nas')
                              AND ( @i_fsType = 4
                                     OR @i_fsType = 3 ) )
						 OR ((ATG.osgroup = N'SGI')   -- for Big Data Apps
							  AND ( @i_fsType = 5
								OR @i_fsType = 3 )) )
        LEFT OUTER JOIN @archiveAndOnePassBkpSets ArcBkpSetsAndOnePassBkpSets ON backupSet.id = ArcBkpSetsAndOnePassBkpSets.id
        LEFT OUTER JOIN APP_BackupsetProp ArcBkpSets WITH(NOLOCK)
          ON  ArcBkpSets.componentNameId = backupSet.id
              AND ArcBkpSets.attrName = 'Is Archiving Enabled'
              AND ArcBkpSets.attrVal = '1'
              AND ArcBkpSets.modified = 0
WHERE  ( (
         /*This logic should hide or show laptop and dummy clients based on @i_hideLaptopAndDummyclients flag set*/
         ( @i_excludeInfrastuctureClients = 0
            OR ISNULL(cpt.IsInfrastructure, cpt2.IsInfrastructure) = 0
            OR ISNULL(cpt.IsInfrastructure, cpt2.IsInfrastructure) IS NULL
			 )
         AND (
             /*This logic should hide or show laptop and dummy clients based on @i_hideLaptopAndDummyclients flag set*/
             @i_hideLaptopAndDummyclients = 0
              OR ( ( AC.specialclientflags = 0 )
                   AND ( AC.status & 0x1000 = 0 ) )
OR ( AC.specialclientflags & 0x20 = 0x20 )
              OR ( SOS.id IN ( 49, 118 ) ) )
          OR ( ( @i_includeVMClients = 1 )
               AND ( ISNULL(cpt.virtualserverdiscovered, cpt2.virtualserverdiscovered) = 1)
               AND ( ISNULL(cpt.lastbackupjobid, cpt2.lastBackupJobid) <> 0) ) )
         AND ( ( @i_includeHiddenClients > 0 )
OR ( AC.specialclientflags & 0x1 <> 0x1 ) )
         AND AC.id = CASE
                       WHEN @i_clientId <> 0 THEN @i_clientId
                       ELSE AC.id
                     END
         AND ida.type = CASE
                          WHEN @i_appId <> 0 THEN @i_appId
                          ELSE ida.type
                        END
          AND (
				(@i_getArchiverBackupsets = 0 AND ArcBkpSets.componentNameId IS NULL)
				OR
				(@i_getArchiverBackupsets = 1 AND ArcBkpSetsAndOnePassBkpSets.id IS NOT NULL)
			)
        )
IF @i_propertyLevel >= 5 --Essential properties
  BEGIN
      UPDATE backuplist
      SET    backuplist.planid = AP.id,
             backuplist.plantype = AP.type,
             backuplist.plansubtype = AP.subtype,
             backuplist.planname = AP.NAME
      FROM   #i_allbackuplist backupList
             INNER JOIN app_backupsetprop ABP
                     ON ABP.componentnameid = backupList.backupsetid
                        AND ABP.attrname = N'Associated Plan'
                        AND ABP.modified = 0
             INNER JOIN app_plan AP
                     ON AP.id = Cast(ABP.attrval AS INT)
AND ( ( AP.flag & 0x00004 ) = 0 )
AND ( ( AP.flag & 0x40000000 ) = 0 )
      WHERE (@i_getArchiverBackupsets = 0
OR (@i_getArchiverBackupsets = 1 AND AP.type = 9 AND AP.subtype = 150994951)) -- If request is coming from archival solution then, do not send sever plan for one pass subclient's backupset.
      UPDATE backuplist
      SET    backuplist.associatedsubclientpolicy = ISNULL(attrval, 0)
      FROM   #i_allbackuplist backupList
             INNER JOIN app_backupsetprop ABP
                     ON ABP.componentnameid = backupList.backupsetid
                        AND ABP.attrname = N'Associated subclient Policy'
                        AND ABP.modified = 0
  END
IF @i_propertyLevel >= 10 --Basic Properties
  BEGIN
      INSERT INTO #scquota
      SELECT app.backupset,
             Cast(scp2.attrval AS BIGINT) quota,
             Cast(scp1.attrval AS INT)    atime
      FROM   app_application app WITH(nolock)
             INNER JOIN app_subclientprop scp1 WITH(nolock)
                     ON scp1.componentnameid = app.id
                        AND scp1.modified = 0
                        AND scp1.cs_attrname = Checksum(
                            N'Last Data Protected Time')
                        AND scp1.attrname = N'Last Data Protected Time'
             LEFT OUTER JOIN app_subclientprop scp2 WITH(nolock)
                          ON scp2.componentnameid = app.id
                             AND scp2.modified = 0
                             AND scp2.cs_attrname = Checksum(
                                 N'Application Size')
                             AND scp2.attrname = N'Application Size'
             LEFT OUTER JOIN app_subclientprop ASCP WITH(nolock)
                          ON ASCP.componentnameid = app.id
                             AND ASCP.attrname IN (
                                 N'DDB Backup', N'Index SubClient'
                                                  )
                             AND ASCP.cs_attrname IN ( Checksum(N'DDB Backup'),
                                                       Checksum(
                                                       N'Index SubClient')
                                                     )
                             AND ASCP.modified = 0
      WHERE  ASCP.componentnameid IS NULL
      UPDATE t
      SET    t.applicationsize = BPProps.applicationsize,
             t.lastbackuptime = BPProps.lastbackuptime
      FROM   #i_allbackuplist T
             INNER JOIN (SELECT b.backupset,
                                Max(b.atime)
                                AS
                                lastBackupTime,
                                Sum(DISTINCT Isnull(bsp.attrval, 0) +
                                             Isnull(b.quota, 0)) AS
                                applicationSize
                         FROM   #scquota b WITH(nolock)
                                LEFT OUTER JOIN app_backupsetprop bsp WITH(
                                                nolock)
                                             ON
                                b.backupset = bsp.componentnameid
                                AND bsp.modified = 0
                                AND
                                bsp.attrname = N'Application Size'
                         GROUP  BY b.backupset) BPProps
                     ON BPProps.backupset = T.backupsetid
      -- Sets the SLA status. 1 - Met, 2 - Missed, 3 - Exclude
      UPDATE t
      SET    t.slastatus = ( CASE
                               WHEN Bpprops.slastatus = 1 THEN 1
                               WHEN Bpprops.slastatus = 2 THEN 2
                               ELSE 3
                             END ),
			t.slacategory = BPProps.Category,
			t.slacategorydescription = dbo.WR_GetSLACategoryString(@i_localeId,BPProps.Category)
      FROM   #i_allbackuplist T
             INNER JOIN (SELECT backupset, status as slastatus,category,
								ROW_NUMBER() OVER(PARTITION BY backupset ORDER BY status DESC) AS rownum
						 FROM ( SELECT Ap.backupset, SLA.status,SLA.category
								FROM   rptslasubclient SLA
                                INNER JOIN app_application AP ON SLA.appid = AP.id AND SLA.clientid = AP.clientid AND SLA.fulljobsonly = 0
							  ) TMP
						) BPProps
						ON BPProps.backupset = T.backupsetid AND BPProps.rownum=1
      ----------------------------------------- Server/FS Backupset Summary Begin ---------------------------------------------------------------------
      SELECT @FSCount = Count(DISTINCT backupsetid)
      FROM   #i_allbackuplist
      SELECT @NASCount = Count(DISTINCT backupsetid)
      FROM   #i_allbackuplist
      WHERE  osgroup = 'nas'
      SELECT @WindowsServersCount = Count(DISTINCT backupsetid)
      FROM   #i_allbackuplist
      WHERE  osgroup = 'windows'
      SELECT @UnixServersCount = Count(DISTINCT backupsetid)
      FROM   #i_allbackuplist
      WHERE  osgroup = 'unix'
	  ----------------------------------------- Server/FS Backupset Summary End ----------------------------------------------------------------------
  END
SET @o_xmlResp = ISNULL((SELECT
                                (SELECT
									lastbackuptime				AS '@lastBackupTime',
									applicationsize				AS '@applicationSize',
(CASE ( backupsetstatus & 0x00008 )
WHEN 0x00008 THEN 1
										ELSE 0
									END )						AS 'commonBackupSet/@isDefaultBackupSet',
									isDefaultArchiverSet		AS 'commonBackupSet/@isDefaultArchiverSet',
									associatedsubclientpolicy	AS 'commonBackupSet/@associatedsubclientPolicy',
									slastatus					AS 'commonBackupSet/@slaStatus',
									slacategory					AS 'commonBackupSet/@slaCategory',
									slacategorydescription		AS 'commonBackupSet/@slaCategoryDescription',
									isArchivingEnabled			AS 'commonBackupSet/@isArchivingEnabled',
									6							AS 'backupSetEntity/@_type_',
									apptypename					AS 'backupSetEntity/@appName',
									apptypeid					AS 'backupSetEntity/@applicationId',
									backupsetguid				AS 'backupSetEntity/@backupsetGUID',
									backupsetid					AS 'backupSetEntity/@backupsetId',
									backupsetname				AS 'backupSetEntity/@backupsetName',
									clientid					AS 'backupSetEntity/@clientId',
									clientname					AS 'backupSetEntity/@clientName',
									clientdisplayname			AS 'backupSetEntity/@displayName',
									instanceid					AS 'backupSetEntity/@instanceId',
									instancename				AS 'backupSetEntity/@instanceName',
									planid						AS 'planEntity/@planId',
									plantype					AS 'planEntity/@planType',
									plansubtype					AS 'planEntity/@planSubType',
									planname					AS 'planEntity/@planName'
                                 FROM   #i_allbackuplist
                                 ORDER  BY clientname,
                                           backupsetname
                                 FOR xml path('backupsetProperties'), type),
                                (SELECT @FScount				AS '@fsCount',
                                        @NasCount				AS '@nasFilersCount',
                                        @DBCount				AS '@databasesCount',
                                        @VMcount				AS '@vmsCount',
                                        @CloudAppsCount			AS '@cloudAppsCount',
                                        @windowsServersCount	AS '@windowsServersCount',
                                        @UnixServersCount		AS '@unixServersCount'
                                 FOR xml path('overview'), type)
                         FOR xml path('App_GetBackupsetPropertiesResponse')),
                                  '<App_GetBackupsetPropertiesResponse/>')
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetBackupsetListForAdminConsole')
	delete from GxQscripts where name = 'AppGetBackupsetListForAdminConsole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupsetListForAdminConsole')
	delete from GXDBVersions where aliasname = 'AppGetBackupsetListForAdminConsole'
GO

insert into GXDBVersions values(2, 'AppGetBackupsetListForAdminConsole',  '00000000000000000000', 'AppGetBackupsetListForAdminConsole', '00000000000000000000')
GO

