

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetBackupSetsForSCPDissociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppGetBackupSetsForSCPDissociation
--  |
--  | Description:  SP for retreiving backupsets of clients under client group
--  |				for dissociating from subclient policy
--  |
--  |       Input:  scpId, clientGroupId, #ClientOrGroupIdList ( id INT )
--  |				If clientGroupId is passed as 0, #ClientOrGroupIdList should have list of client group ids
--  |				Else #ClientOrGroupIdList should have list of client ids
--  |      Output:  List of backupset Ids, clientGroupIds in
--  |				#DissociateBackupsets (id INT IDENTITY (1,1), backupsetId INT, clientGroupId INT) temp table
--  |      Return:  xxx
--  |
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetBackupSetsForSCPDissociation <<<'

IF EXISTS (select * from sysobjects where name='AppGetBackupSetsForSCPDissociation')
	drop procedure AppGetBackupSetsForSCPDissociation
IF EXISTS (select * from GxQscripts where name='AppGetBackupSetsForSCPDissociation')
	delete from GxQscripts where name = 'AppGetBackupSetsForSCPDissociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupSetsForSCPDissociation')
	delete from GXDBVersions where aliasname = 'AppGetBackupSetsForSCPDissociation'
GO
print '... Creating Procedure: AppGetBackupSetsForSCPDissociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetBackupSetsForSCPDissociation
  @scpId INT,
  @clientGroupId INT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#outputBackupSetsTbl') IS NOT NULL
	DROP TABLE #outputBackupSetsTbl
CREATE TABLE #outputBackupSetsTbl
(
	backupSet			INT,
	dissocCGId			INT
)
-- If clientGroupId is given then #ClientOrGroupIdList table contains client id list, this means these clients are removed from given client group which is associated to given subclient policy.
-- So backupsets of these clients which are associated to given subclient policy from given client group level needs to be dissociated.
IF @clientGroupId > 0
BEGIN
	INSERT INTO #outputBackupSetsTbl
	SELECT App.backupSet, @clientGroupId
	FROM APP_Application App
	INNER JOIN #ClientOrGroupIdList Clients
		ON App.clientId = Clients.id
	INNER JOIN APP_BackupSetProp BSProp
		ON App.backupSet = BSProp.componentNameId
		AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0 AND BSProp.attrVal = @scpId
	INNER JOIN APP_BackupSetProp BSProp1
		ON App.backupSet = BSProp1.componentNameId
		AND BSProp1.attrName = N'Subclient Policy Association Level' AND BSProp1.modified = 0 AND BSProp1.attrVal = 2
	INNER JOIN APP_BackupSetProp BSProp2
		ON App.backupSet = BSProp2.componentNameId
		AND BSProp2.attrName = N'Client Group For SCP Association' AND BSProp2.modified = 0 AND BSProp2.attrVal = @clientGroupId
END
ELSE						-- #ClientOrGroupIdList table contains client group id list.
BEGIN
	INSERT INTO #outputBackupSetsTbl
	SELECT BackupSet.id, CG.id
	FROM APP_BackupsetName BackupSet
	INNER JOIN APP_BackupSetProp BSProp
		ON BackupSet.id = BSProp.componentNameId
		AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0 AND BSProp.attrVal = @scpId
	INNER JOIN APP_BackupSetProp BSProp1
		ON BackupSet.id = BSProp1.componentNameId
		AND BSProp1.attrName = N'Subclient Policy Association Level' AND BSProp1.modified = 0 AND BSProp1.attrVal = 2
	INNER JOIN APP_BackupSetProp BSProp2
		ON BackupSet.id = BSProp2.componentNameId
		AND BSProp2.attrName = N'Client Group For SCP Association' AND BSProp2.modified = 0
	INNER JOIN #ClientOrGroupIdList CG
		ON BSProp2.attrVal = CG.id
END
INSERT INTO #DissociateBackupsets
SELECT DISTINCT backupSet, dissocCGId FROM #outputBackupSetsTbl
/*
IF OBJECT_ID('tempdb.dbo.#clientIdTbl') IS NOT NULL
	DROP TABLE #clientIdTbl
CREATE TABLE #clientIdTbl
(
	clientId INT,
	clientGroupId INT
)
-- Get subclient policy ida type
DECLARE @scpIdaType INT = (SELECT CAST(attrVal AS INT) FROM APP_BackupSetProp WHERE componentNameId = @scpId AND attrName = N'Associated subclient Policy Ida Type')
DECLARE @appTypeGroupId INT = ISNULL((SELECT appTypeGroupId
										FROM APP_AppTypeGroup
											WHERE groupName = CASE	WHEN @scpIdaType = 2 THEN 'APPGRP_WindowsFileSystemIDA'
																	WHEN @scpIdaType = 3 THEN 'APPGRP_UnixFileSystem'
																	ELSE '' END), 0)
-- If client list is given this means these clients are removed from given client group which is associated to given subclient policy.
-- So backupsets of these clients which are associated to given subclient policy needs to be dissociated.
IF @clientIdList <> ''	-- Filter given list of client ids based on ida type of subclient policy
BEGIN
	DECLARE @CGId INT = ISNULL((SELECT TOP 1 _ID FROM dbo.SplitIds(@clientGroupIdList)), -1) -- Exactly 1 client group id should be passed when a list of client ids is passed for dissociation
	INSERT INTO #clientIdTbl
	SELECT _ID, @CGId
	FROM dbo.SplitIds(@clientIdList) C
	INNER JOIN APP_Client client
		ON C._ID = client.id
AND (client.status & 0x10000000) =  0		--Exclude edge drive clients
	INNER JOIN APP_IDAName Ida
		ON C._ID = Ida.clientId
	INNER JOIN APP_AppTypeGroupAssoc AppGrp
		ON Ida.appTypeId = AppGrp.appTypeId
		AND AppGrp.appGroupId = @appTypeGroupId
END
ElSE					-- Get clients under client group and filter them based on ida type of subclient policy
BEGIN
	INSERT INTO #clientIdTbl
	SELECT CGAssoc.clientId, CG._ID
	FROM dbo.SplitIds(@clientGroupIdList) CG
	INNER JOIN APP_ClientGroupAssoc CGAssoc
		ON CG._ID = CGAssoc.clientGroupId
	INNER JOIN APP_Client client
		ON CGAssoc.clientId = client.id
AND (client.status & 0x10000000) =  0		--Exclude edge drive clients
	INNER JOIN APP_IDAName Ida
		ON CGAssoc.clientId = Ida.clientId
	INNER JOIN APP_AppTypeGroupAssoc AppGrp
		ON Ida.appTypeId = AppGrp.appTypeId
		AND AppGrp.appGroupId = @appTypeGroupId
END
IF OBJECT_ID('tempdb.dbo.#outputBackupSetsTbl') IS NOT NULL
	DROP TABLE #outputBackupSetsTbl
CREATE TABLE #outputBackupSetsTbl
(
	backupSet			INT,
	scpId				INT,
	scpAssocLevel		INT,
	cgId				INT,
	dissocCGId			INT
)
IF EXISTS(SELECT 1 FROM #clientIdTbl)
BEGIN
	INSERT INTO #outputBackupSetsTbl
	SELECT App.backupSet,
		scpId 	= 	ISNULL(BSProp.attrVal, 0),
		scpAssocLevel = ISNULL(BSProp1.attrVal, 0),
		cgId = ISNULL(BSProp2.attrVal, 0),
		Clients.clientGroupId
	FROM APP_Application App
	INNER JOIN #clientIdTbl Clients
		ON App.clientId = Clients.clientId AND (subclientStatus & 4) <> 4
	INNER JOIN APP_BackupsetName BackupSet
		ON App.backupSet = BackupSet.id AND (BackupSet.status & 128) <> 128
	INNER JOIN APP_AppTypeGroupAssoc AppGrp
		ON App.appTypeId = AppGrp.appTypeId
		AND AppGrp.appGroupId = @appTypeGroupId
	LEFT OUTER JOIN APP_BackupSetProp BSProp
		ON App.backupSet = BSProp.componentNameId
		AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0
	LEFT OUTER JOIN APP_BackupSetProp BSProp1
		ON App.backupSet = BSProp1.componentNameId
		AND BSProp1.attrName = N'Subclient Policy Association Level' AND BSProp1.modified = 0
	LEFT OUTER JOIN APP_BackupSetProp BSProp2
		ON App.backupSet = BSProp2.componentNameId
		AND BSProp2.attrName = N'Client Group For SCP Association' AND BSProp2.modified = 0
	-- Remove backupsets that are not associated to given subclient policy from given client group
	DELETE #outputBackupSetsTbl WHERE scpId <> @scpId OR scpAssocLevel <> 2 OR cgId <> dissocCGId
END
SELECT DISTINCT backupSet, dissocCGId FROM #outputBackupSetsTbl
DROP TABLE #clientIdTbl
*/
DROP TABLE #outputBackupSetsTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetBackupSetsForSCPDissociation')
	delete from GxQscripts where name = 'AppGetBackupSetsForSCPDissociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupSetsForSCPDissociation')
	delete from GXDBVersions where aliasname = 'AppGetBackupSetsForSCPDissociation'
GO

insert into GXDBVersions values(2, 'AppGetBackupSetsForSCPDissociation',  '00000000000000000000', 'AppGetBackupSetsForSCPDissociation', '00000000000000000000')
GO

