

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetBackupSetsForSCPAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppGetBackupSetsForSCPAssociation
--  |
--  | Description:  SP for retreiving backupsets of clients under client group
--  |				for associating to subclient policy
--  |
--  |       Input:  scpId, clientGroupId, #ClientOrGroupIdList ( id INT )
--  |				If clientGroupId is passed as 0, #ClientOrGroupIdList should have list of client group ids
--  |				Else #ClientOrGroupIdList should have list of client ids
--  |      Output:  List of backupset Ids, clientGroupIds in
--  |				#AssociateBackupsets (id INT IDENTITY (1,1), backupsetId INT, clientGroupId INT) temp table
--  |      Return:  xxx
--  |
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetBackupSetsForSCPAssociation <<<'

IF EXISTS (select * from sysobjects where name='AppGetBackupSetsForSCPAssociation')
	drop procedure AppGetBackupSetsForSCPAssociation
IF EXISTS (select * from GxQscripts where name='AppGetBackupSetsForSCPAssociation')
	delete from GxQscripts where name = 'AppGetBackupSetsForSCPAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupSetsForSCPAssociation')
	delete from GXDBVersions where aliasname = 'AppGetBackupSetsForSCPAssociation'
GO
print '... Creating Procedure: AppGetBackupSetsForSCPAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetBackupSetsForSCPAssociation
  @scpId INT,
  @clientGroupId INT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#clientIdTbl') IS NOT NULL
	DROP TABLE #clientIdTbl
CREATE TABLE #clientIdTbl
(
	clientId INT,
	clientGroupId INT,
	appTypeId INT
)
-- Get subclient policy ida type
DECLARE @scpIdaType INT = (SELECT CAST(attrVal AS INT) FROM APP_BackupSetProp WHERE componentNameId = @scpId AND attrName = N'Associated subclient Policy Ida Type')
DECLARE @appTypeGroupId INT = ISNULL((SELECT appTypeGroupId
										FROM APP_AppTypeGroup
											WHERE groupName = CASE	WHEN @scpIdaType = 2 THEN 'APPGRP_WindowsFileSystemIDA'
																	WHEN @scpIdaType = 3 THEN 'APPGRP_UnixFileSystem'
																	ELSE '' END), 0)
-- If clientGroupId is given then #ClientOrGroupIdList table contains client id list, this means these clients are added to given client group which is associated to given subclient policy.
-- So backupsets of these clients needs to be associated to given subclient policy.
IF @clientGroupId > 0	-- Filter given list of client ids based on clientGroup id and ida type of subclient policy
BEGIN
	INSERT INTO #clientIdTbl
	SELECT C.id, @clientGroupId,Ida.appTypeId
	FROM #ClientOrGroupIdList C
	INNER JOIN APP_ClientGroupAssoc CGAssoc
		ON C.id = CGAssoc.clientId AND CGAssoc.clientGroupId = @clientGroupId
	INNER JOIN APP_Client client
		ON C.id = client.id
AND (client.status & 0x10000000) =  0		--Exclude edge drive clients
	INNER JOIN APP_IDAName Ida
		ON C.id = Ida.clientId
	INNER JOIN APP_AppTypeGroupAssoc AppGrp
		ON Ida.appTypeId = AppGrp.appTypeId
		AND AppGrp.appGroupId = @appTypeGroupId
END
ElSE					-- #ClientOrGroupIdList table contains client group id list. Get clients under client groups and filter them based on ida type of subclient policy
BEGIN
	INSERT INTO #clientIdTbl
	SELECT CGAssoc.clientId, CG.id,Ida.appTypeId
	FROM #ClientOrGroupIdList CG
	INNER JOIN APP_ClientGroupAssoc CGAssoc
		ON CG.id = CGAssoc.clientGroupId
	INNER JOIN APP_Client client
		ON CGAssoc.clientId = client.id
AND (client.status & 0x10000000) =  0		--Exclude edge drive clients
	INNER JOIN APP_IDAName Ida
		ON CGAssoc.clientId = Ida.clientId
	INNER JOIN APP_AppTypeGroupAssoc AppGrp
		ON Ida.appTypeId = AppGrp.appTypeId
		AND AppGrp.appGroupId = @appTypeGroupId
END
IF OBJECT_ID('tempdb.dbo.#outputBackupSetsTbl') IS NOT NULL
	DROP TABLE #outputBackupSetsTbl
CREATE TABLE #outputBackupSetsTbl
(
	backupSet			INT,
	backupSetName		NVARCHAR(256),
	subclientId			INT,
	subclientStatus		INT,
	systemStateFlag		INT,
	scpId				INT,
	assocCGId			INT
)
IF EXISTS(SELECT 1 FROM #clientIdTbl)
BEGIN
	INSERT INTO #outputBackupSetsTbl
	SELECT App.backupSet, BackupSet.name, App.id, App.subclientStatus,
		systemStateFlag = ISNULL(SCProp.attrVal, 0),
		scpId 	= 	ISNULL(BSProp.attrVal, 0),
		Clients.clientGroupId
	FROM APP_Application App
	INNER JOIN #clientIdTbl Clients
		ON App.clientId = Clients.clientId AND (App.subclientStatus & 4) <> 4 AND App.appTypeId= Clients.appTypeId
	INNER JOIN APP_BackupsetName BackupSet
		ON App.backupSet = BackupSet.id AND (BackupSet.status & 128) <> 128
	LEFT OUTER JOIN APP_SubClientProp SCProp
		ON App.id = SCProp.componentNameId
		AND SCProp.attrName = N'System State Subclient' AND SCProp.modified = 0
	LEFT OUTER JOIN APP_BackupSetProp BSProp
		ON App.backupSet = BSProp.componentNameId
		AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0
	-- Remove Indexing backupsets
	DELETE #outputBackupSetsTbl WHERE backupSetName = N'Indexing BackupSet'
	-- Remove backupsets with user defined subclients
	DELETE #outputBackupSetsTbl WHERE backupSet IN (SELECT backupSet FROM #outputBackupSetsTbl WHERE (scpId = 0 AND subclientStatus = 0 AND systemStateFlag <> 1))
	-- Remove backupsets already associated to a subclient policy
	DELETE #outputBackupSetsTbl WHERE scpId <> 0
END
INSERT INTO #AssociateBackupsets
SELECT DISTINCT backupSet, assocCGId FROM #outputBackupSetsTbl
DROP TABLE #clientIdTbl
DROP TABLE #outputBackupSetsTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetBackupSetsForSCPAssociation')
	delete from GxQscripts where name = 'AppGetBackupSetsForSCPAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupSetsForSCPAssociation')
	delete from GXDBVersions where aliasname = 'AppGetBackupSetsForSCPAssociation'
GO

insert into GXDBVersions values(2, 'AppGetBackupSetsForSCPAssociation',  '00000000000000000000', 'AppGetBackupSetsForSCPAssociation', '00000000000000000000')
GO

