

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetBackupSetGUIDFromAFiles.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetBackupSetGUIDFromAFiles <<<'

IF EXISTS (select * from sysobjects where name='AppGetBackupSetGUIDFromAFiles')
	drop procedure AppGetBackupSetGUIDFromAFiles
IF EXISTS (select * from GxQscripts where name='AppGetBackupSetGUIDFromAFiles')
	delete from GxQscripts where name = 'AppGetBackupSetGUIDFromAFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupSetGUIDFromAFiles')
	delete from GXDBVersions where aliasname = 'AppGetBackupSetGUIDFromAFiles'
GO
print '... Creating Procedure: AppGetBackupSetGUIDFromAFiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetBackupSetGUIDFromAFiles
  @reqxml XML
AS
  DECLARE @outResp XML    
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF object_id('tempdb.dbo.#tempAFiles') IS NOT NULL DROP TABLE #tempAFiles
	DECLARE @indexAfileList INTEGER = 0
	SELECT @indexAfileList = req.arch.value('@indexAFile', 'INTEGER')
		FROM @reqxml.nodes('Indexing_ArchGetBackupsetGUID') req(arch)
	CREATE TABLE #tempAFiles (afileId int, commCellId int)
	INSERT INTO #tempAFiles
	SELECT req.arch.value('@afileId', 'INTEGER'), req.arch.value('@commCellId', 'INTEGER')
	FROM @reqxml.nodes('Indexing_ArchGetBackupsetGUID/afileList') req(arch)
	IF @indexAfileList = 0
	BEGIN
		SELECT (SELECT DISTINCT bset.GUID as 'backupsetGuid' FROM #tempAFiles taf (NOLOCK), archFile af (NOLOCK), App_Application appl (NOLOCK), App_BackupSetName bset (NOLOCK)
		WHERE taf.afileId = af.id and taf.commCellId = af.commCellId and af.appId = appl.id and appl.backupset = bset.id
		FOR XML PATH(''), TYPE) FOR XML PATH('ArchGetBackupsetGUIDResp'), TYPE
	END
	ELSE
	BEGIN
		SELECT (SELECT DISTINCT bset.GUID as 'backupsetGuid' FROM #tempAFiles taf (NOLOCK), archFile af (NOLOCK), App_Application appl (NOLOCK), App_BackupSetName bset (NOLOCK), APP_VMBackupSet vmbset (NOLOCK)
		WHERE taf.afileId = af.id and taf.commCellId = af.commCellId and af.appId = appl.id and appl.backupset = vmbset.ParentBackupSetId and vmbset.ChildBackupSetId = bset.id
		FOR XML PATH(''), TYPE) FOR XML PATH('ArchGetBackupsetGUIDResp'), TYPE
	END
	IF object_id('tempdb.dbo.#tempAFiles') IS NOT NULL DROP TABLE #tempAFiles
END

IF EXISTS (select * from GxQscripts where name = 'AppGetBackupSetGUIDFromAFiles')
	delete from GxQscripts where name = 'AppGetBackupSetGUIDFromAFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupSetGUIDFromAFiles')
	delete from GXDBVersions where aliasname = 'AppGetBackupSetGUIDFromAFiles'
GO

insert into GXDBVersions values(2, 'AppGetBackupSetGUIDFromAFiles',  '00000000000000000000', 'AppGetBackupSetGUIDFromAFiles', '00000000000000000000')
GO

