

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetBackupConfigNodes.sp] ---------- 

-- Additional header files can be included for constants used in this stored procedure.
-- Stored procedure has to be rebuilt if any constant value changed in those header file.
-- This will generate the revision for the stored procedure. Don't remove this line!!!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetBackupConfigNodes.sp,v $ $Id: AppGetBackupConfigNodes.sp,v 1.1.2.34.4.1 2021/02/26 00:07:08 stelagamsetti Exp $";
-- Name of the stored procedure
-- It must match with the name of the .sp file
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetBackupConfigNodes')
BEGIN
	print '>>> Drop Stored Procedure: AppGetBackupConfigNodes <<<'
	drop procedure AppGetBackupConfigNodes
END
IF EXISTS (select * from GxQscripts where name='AppGetBackupConfigNodes')
	delete from GxQscripts where name = 'AppGetBackupConfigNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupConfigNodes')
	delete from GXDBVersions where aliasname = 'AppGetBackupConfigNodes'
GO
print '... Creating Procedure: AppGetBackupConfigNodes'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetBackupConfigNodes
-- Input variables of the stored procedure
  @in_clientId INT,
  @in_appTypeId INT,
  @in_subclientId INT,
  @in_jobId BIGINT,
  @in_commCellID INTEGER,
  @in_useSnapProxy INTEGER,
  @in_opType INTEGER,
  @in_useSnapCopyMA INTEGER
-- Tell the AWK processor that body of query starts here
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @xmlText XML
DECLARE @bkpConfigNodes XML
DECLARE @nodeCount INT = 0
DECLARE @snapEnabled INT = 0
DECLARE @snapProxyID INT = 0
DECLARE @bkpCopyEnabled INT = 0
DECLARE @bkpCopyProxyID INT = 0
DECLARE @dataPathMA INT = 0
DECLARE @inClients TABLE (id INT IDENTITY, clientId INT, clientGroupId INT)
DECLARE @ExpandedClients TABLE(id INT,clientId INT, clientName NVARCHAR(2048), priority INT)
IF (SELECT opType FROM JMJobInfo WITH(NOLOCK) WHERE jobId = @in_jobId and commCellId = @in_commCellID and @in_appTypeId <> 13 ) = 5 --RESTORE Job
BEGIN
	INSERT INTO @inClients
	SELECT
		[clientId] = ISNULL(CONVERT(xml,value).value('(backupDataAccessNodes/@clientId)[1]','INTEGER'),0),
		[clientGroupId] = ISNULL(CONVERT(xml,value).value('(backupDataAccessNodes/@clientGroupId)[1]','INTEGER'),0)
FROM dbo.GetAllJobOptions(@in_jobId) where optionId = 569754132
END
ELSE IF @in_subclientId <> 0
BEGIN
	SET @bkpConfigNodes = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @in_subclientId AND attrName = 'Backup Configuration Nodes' AND modified = 0), '')
	SELECT @in_clientId = clientId, @in_appTypeId = appTypeId FROM APP_Application WHERE id = @in_subclientId
END
SET @nodeCount = (SELECT ISNULL(@bkpConfigNodes.value('count(/App_BackupConfigurationNodes/backupDataAccessNodes)', 'int'), 0))
IF (@in_clientId <> 0 AND @in_appTypeId <> 0 AND @nodeCount = 0)
BEGIN
	DECLARE @componentId INT = (SELECT id FROM APP_IDAName WHERE clientId = @in_clientId AND appTypeId = @in_appTypeId)
	SET @bkpConfigNodes = ISNULL((SELECT attrVal FROM APP_IDAProp WHERE componentNameId = @componentId AND attrName = 'Backup Configuration Nodes' AND modified = 0), '')
END
------------------------------------------------------------
-- INSERT all Clients in the list first               ------
------------------------------------------------------------
IF @in_useSnapProxy <> 0 AND @in_subclientId <> 0
BEGIN
	SET @snapEnabled = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WHERE componentNameId = @in_subclientId AND attrName = 'Enable Snap Backups' AND cs_attrName = CHECKSUM(N'Enable Snap Backups') AND modified = 0), 0)
	SET @snapProxyID = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WHERE componentNameId = @in_subclientId AND attrName = 'Snap copy : proxy to use' AND cs_attrName = CHECKSUM(N'Snap copy : proxy to use') AND modified = 0), 0)
END
IF @in_useSnapProxy = 0 AND @in_subclientId <> 0 AND @in_opType = 60
BEGIN
	SET @bkpCopyEnabled = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WHERE componentNameId = @in_subclientId AND attrName = 'Snap to tape : proxy enabled' AND cs_attrName = CHECKSUM(N'Snap to tape : proxy enabled') AND modified = 0), 0)
	SET @bkpCopyProxyID = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WHERE componentNameId = @in_subclientId AND attrName = 'Snap to tape : proxy to use' AND cs_attrName = CHECKSUM(N'Snap to tape : proxy to use') AND modified = 0), 0)
	SET @snapEnabled = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WHERE componentNameId = @in_subclientId AND attrName = 'Enable Snap Backups' AND cs_attrName = CHECKSUM(N'Enable Snap Backups') AND modified = 0), 0)
	SET @snapProxyID = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WHERE componentNameId = @in_subclientId AND attrName = 'Snap copy : proxy to use' AND cs_attrName = CHECKSUM(N'Snap copy : proxy to use') AND modified = 0), 0)
END
IF @in_useSnapProxy <> 0 AND @snapEnabled = 1 AND @snapProxyID <> 0
BEGIN
	INSERT INTO @inClients
	SELECT @snapProxyId, 0
END
ELSE IF @in_useSnapProxy = 0 AND @bkpCopyEnabled = 1 AND @bkpCopyProxyID <> 0 AND @in_opType = 60
BEGIN
	INSERT INTO @inClients
	SELECT @bkpCopyProxyID, 0
END
ELSE IF @in_useSnapProxy = 0 AND @snapEnabled = 1 AND @snapProxyID <> 0 AND @in_opType = 60
BEGIN
	INSERT INTO @inClients
	SELECT @snapProxyID, 0
END
ELSE
BEGIN
	INSERT INTO @inClients
	SELECT	ISNULL(bkp.nodes.value('@clientId', 'INT'), 0),
			ISNULL(bkp.nodes.value('@clientGroupId', 'INT'), 0)
	FROM @bkpConfigNodes.nodes('/App_BackupConfigurationNodes/backupDataAccessNodes') bkp(nodes)
END
--Include the associated MAs also as access nodes for FS agents
IF @in_subclientId <> 0 AND @in_appTypeId <> 13 AND NOT EXISTS (SELECT 1 FROM @inClients)
BEGIN
	DECLARE @assocArchGrpId INT
	DECLARE @appTypeID INT
	DECLARE @useSnapCopyMA INTEGER = 0
	SET @dataPathMA = 1
	IF @in_useSnapCopyMA <> 0
	OR
	((SELECT opType FROM JMJobInfo WITH(NOLOCK) WHERE jobId = @in_jobId and commCellId = @in_commCellID ) = 59 -- enum CVOpType { SNAPBACKUP = 59}
	OR
	(SELECT subOpType FROM JMJobInfo WITH(NOLOCK) WHERE jobId = @in_jobId and commCellId = @in_commCellID ) = 96) -- enum CVOpType { DELAYEDCATALOG = 96}
	BEGIN
		SET @useSnapCopyMA = 1
	END
	SELECT @assocArchGrpId = dataArchGrpID, @appTypeId = appTypeId FROM APP_Application WHERE id = @in_subclientId
	INSERT INTO @inClients
SELECT	CASE DR.DrivePoolType WHEN 3 THEN NDMP.ClientId ELSE DR.ClientId END, 0
	FROM	archGroup AS AG
		INNER JOIN MMDataPath AS DP
			ON CASE @useSnapCopyMA WHEN 1 THEN AG.defaultSnapCopy ELSE AG.defaultCopy END = DP.CopyId AND AG.id = @assocArchGrpId
		INNER JOIN MMDrivePool AS DR
			ON DP.DrivePoolId = DR.DrivePoolId
		LEFT OUTER JOIN MMNDMPHostInfo NDMP
ON DR.DrivePoolType = 3 AND DR.NDMPHostId = NDMP.NDMPHostId
		INNER JOIN APP_Client C
ON C.id = (CASE WHEN DR.DrivePoolType = 3 THEN NDMP.ClientId ELSE DR.ClientId END)
		INNER JOIN simOperatingSystem OS
			ON C.simOperatingSystemId = OS.id
WHERE	(@appTypeId = 33 AND OS.type = 'Windows') OR (@appTypeId = 29 AND OS.Type = 'Unix')
END
------------------------------------------------------------
-- Expand Client Groups and remove duplicates         ------
------------------------------------------------------------
INSERT INTO @ExpandedClients
SELECT MIN(CL.id), CL.clientId, CL.name, 0
FROM
	(SELECT	I.id, C.id AS clientId, C.name
		FROM	@inClients I
			LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON CGA.clientGroupId = I.clientGroupId
			INNER JOIN APP_Client C ON (I.clientId = C.id OR CGA.clientId = C.id)
		WHERE
			((C.status & 0x00002) = 0 AND (C.status & 0x00004) = 0)
	) CL
	LEFT OUTER JOIN APP_IDAName A
			ON CL.clientId = A.clientId
	LEFT OUTER JOIN APP_VMToPMMap AVP ON CL.clientId = AVP.VMClientId
	LEFT OUTER JOIN simInstalledPackages pkg ON (CL.clientId = pkg.ClientId OR AVP.PMClientId = pkg.ClientId)
AND (pkg.simPackageID = 1 OR pkg.simPackageID = 1002)
	LEFT OUTER JOIN APP_client AC
		ON AC.id=pkg.ClientId
	LEFT OUTER JOIN simOperatingSystem sim ON
		sim.id=AC.simOperatingSystemId
WHERE
((sim.type ='Unix' AND 29 = @in_appTypeId)
OR (sim.type='Windows' AND 33 = @in_appTypeId)
OR @in_appTypeId = 13)
	AND pkg.id IS NOT NULL
GROUP BY CL.clientId, CL.name
ORDER BY MIN(CL.id)
UPDATE	@ExpandedClients
SET		EC.clientId = C.id, EC.clientName = C.name
FROM	@ExpandedClients EC
	INNER JOIN APP_ClientProp CP
		ON EC.clientId = CP.componentNameId AND CP.attrName = 'Active Physical Node' AND CP.modified = 0 AND CP.attrVal > 1
	INNER JOIN APP_Client C
		ON C.id = CP.attrVal
--------------------------------------------------------------
-- Select clients for output							------
--------------------------------------------------------------
-- FOR NAS we want list sorted with number of jobs running on MA so that we can pick least loaded and try jobs on that.
DECLARE @minVersion INT
DECLARE @maxVersion INT = -1
DECLARE @shouldExcludeNodesOlderThanV11SP23 BIT = 0
IF EXISTS (SELECT 1 FROM APP_Client WITH(NOLOCK) WHERE id = @in_clientId AND (status & 0x8000080/*CV_STATUS_NAS | CV_STATUS_NON_NDMP*/ <> 0))
	AND EXISTS (SELECT 1 FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @in_subclientId AND attrName = 'SnapDiff scan used on flexgroup volume'
										AND cs_attrName = CHECKSUM(N'SnapDiff scan used on flexgroup volume') AND attrVal = '1' AND modified = 0)
		SET @shouldExcludeNodesOlderThanV11SP23 = 1
IF (@in_appTypeId = 13)
BEGIN
	DELETE  @ExpandedClients
	FROM    @ExpandedClients C
		INNER JOIN APP_Client cl
			ON cl.id = C.clientId
		LEFT JOIN SimInstalledPackages pack
			ON pack.ClientId = C.clientId and pack.simPackageID iN (51, 1301) -- MediaAgent
		LEFT JOIN MMHost MA
			ON MA.ClientId = C.clientId
	WHERE cl.releaseId < 16
		OR (cl.releaseId = 16 AND pack.HighestSP < 9) OR ISNULL(MA.MmHostEnabled, 0) = 0 OR ISNULL(MA.MmHostSoftState, 0) = 0 OR ISNULL(MA.OfflineReason, 1) = 1
	SELECT	@minVersion = MIN (CL.releaseId * 1000 + P.HighestSP)
	FROM	@ExpandedClients C
		INNER JOIN SimInstalledPackages P
			ON C.clientId = P.clientId
		INNER JOIN APP_Client CL
			ON C.clientId = CL.id
	SET @xmlText =
	(
	   SELECT
		   @minVersion AS '@minVersion',
		   (
		   SELECT
			   eClient.clientId as '@clientId',
			   eClient.clientName as '@clientName',
			   3 as '@_type_' -- CLIENT_ENTITY = 3,
		   FROM @ExpandedClients AS eClient
				   LEFT JOIN  (select  machineName , count (distinct jobId) as jobs from JMJobControlInfo group by machineName) as tempLoad
				   on machineName = eClient.clientName
			   order by tempLoad.jobs asc
		   FOR XML PATH('backupDataAccessNodes'), TYPE)
	   FOR XML PATH('App_BackupConfigurationNodes'), TYPE
	)
END
ELSE -- NON-NAS - not touching their order.
BEGIN
	DECLARE @staggerScanNode INT
	SET @staggerScanNode = ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'RandomizeAccessNode' AND modified = 0), 0)
	SELECT	@minVersion = MIN (CL.releaseId * 1000 + P.HighestSP),
			@maxVersion = MAX (CL.releaseId * 1000 + P.HighestSP)
	FROM	@ExpandedClients C
		INNER JOIN SimInstalledPackages P
			ON C.clientId = P.clientId
		INNER JOIN APP_Client CL
			ON C.clientId = CL.id
	IF @shouldExcludeNodesOlderThanV11SP23 = 1
	BEGIN
		DELETE @ExpandedClients
		FROM @ExpandedClients EC
			INNER JOIN APP_Client C WITH(NOLOCK)
				ON EC.clientId = C.id
			INNER JOIN simInstalledPackages SIP WITH(NOLOCK)
				ON EC.clientId = SIP.ClientId
		WHERE C.releaseId < 16 OR (C.releaseId = 16 AND SIP.HighestSP < 23)
	END
	IF @staggerScanNode <> 0 AND EXISTS (SELECT 1 FROM JMJobStats WHERE jobid = @in_jobId AND commCellId = @in_commCellID)
	BEGIN
	/*
		The available nodes will be assigned a priority based on the number of jobs that are already running on an access node.
		Default priority is 0.
		And the priority will be set to number of jobs.
		Finally, if a node is already being used for the current job, it will be assigned -1 means top most priority)
	*/
		DECLARE @preferredNode INT
		SET @preferredNode = ISNULL((SELECT TOP 1 attributeValueInt FROM JMJobOptions WHERE jobId = @in_jobId AND commcellid = @in_commCellID AND attributeId = 104 AND attributeName = 'Multinode backup preferred access node'), 0)
		UPDATE	@ExpandedClients
		SET		priority = Load.TotalJobs
		FROM	@ExpandedClients C
			INNER JOIN
				(SELECT	attributeValueInt, COUNT(distinct J.jobid) 'TotalJobs'
				FROM	JMJobOptions J
					INNER JOIN JMBkpJobInfo BI
						ON J.jobId = BI.jobid AND J.commcellId = BI.commcellId AND J.attributeName = 'Multinode backup preferred access node' AND J.attributeId = 104
					INNER JOIN JMJobInfo JI
						ON J.jobId = JI.jobId AND J.commCellId = JI.commcellId AND JI.currentPhase = 4 /*FSIFIND*/
					INNER JOIN APP_Application A
ON BI.applicationId = A.id AND A.appTypeId IN (33, 29)
				GROUP BY J.attributeValueInt
				) Load
			ON C.clientId = Load.attributeValueInt
		IF (@preferredNode = 0)
		BEGIN
			SET @preferredNode = ISNULL((SELECT TOP 1 clientId FROM @ExpandedClients E order by E.priority, E.id), 0)
			INSERT INTO JMJobOptions(jobId, commCellId, attributeid, attributeName, attributeValueInt, attributeValue)
			VALUES (@in_jobId, @in_commCellID, 104, 'Multinode backup preferred access node', @preferredNode ,'')
		END
		UPDATE	@ExpandedClients
		SET		priority = -1
		WHERE	clientId = @preferredNode
	END
	SET @xmlText =
	(
	   SELECT
		   @minVersion AS '@minVersion',
		   @maxVersion AS '@maxVersion',
		   @dataPathMA AS '@dataPathMA',
		   (SELECT
			   eClient.clientId as '@clientId',
			   eClient.clientName as '@clientName',
			   3 as '@_type_' --CLIENT_ENTITY = 3,
		   FROM @ExpandedClients as eClient
		   ORDER BY eClient.priority, eClient.Id
		   FOR XML PATH('backupDataAccessNodes'), TYPE)
	   FOR XML PATH('App_BackupConfigurationNodes'), TYPE
	)
END
IF OBJECT_ID('tempdb..#lt_AppGetBackupConfigNodesOutput') IS NOT NULL
	INSERT INTO #lt_AppGetBackupConfigNodesOutput
	SELECT @xmlText
ELSE
	SELECT @xmlText
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetBackupConfigNodes')
	delete from GxQscripts where name = 'AppGetBackupConfigNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetBackupConfigNodes')
	delete from GXDBVersions where aliasname = 'AppGetBackupConfigNodes'
GO

insert into GXDBVersions values(2, 'AppGetBackupConfigNodes',  'v1.1.2.34.4.1', 'AppGetBackupConfigNodes', 'v1.1.2.34.4.1')
GO

