

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAzureADMemberServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAzureADMemberServers')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAzureADMemberServers <<<'
	drop procedure AppGetAzureADMemberServers
END
IF EXISTS (select * from GxQscripts where name='AppGetAzureADMemberServers')
	delete from GxQscripts where name = 'AppGetAzureADMemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAzureADMemberServers')
	delete from GXDBVersions where aliasname = 'AppGetAzureADMemberServers'
GO
print '... Creating Procedure: AppGetAzureADMemberServers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAzureADMemberServers
  @i_userId INT ,
  @o_xmlData XML OUTPUT
AS
	DECLARE @isCommcellLevelAssociation INT = 0
	DECLARE @memberServers TABLE
	(
		clientId INT,
		clientName NVARCHAR(MAX),
		clientType INT
	)
	--Get Security Associations
	IF OBJECT_ID('tempdb.dbo.#getAzureADMemberServerListTmp') IS NOT null	DROP TABLE #getAzureADMemberServerListTmp
create table  #getAzureADMemberServerListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 2009, 0, '#getAzureADMemberServerListTmp'
SELECT @isCommcellLevelAssociation=1 from #getAzureADMemberServerListTmp sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
	-- get Azure AD Member Servers
	INSERT INTO @memberServers
SELECT DISTINCT C.id, C.name, 3
		FROM APP_Client C (NOLOCK)
INNER JOIN simInstalledPackages S (NOLOCK) ON C.Id = S.ClientId AND S.simPackageID = 703
WHERE C.status & 0x00002 = 0 AND C.specialClientFlags & 0x2 =0
	-- get Solr cloud Index Servers
	DECLARE @o_xmlText XML
	 IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
        CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
	EXEC DM2GetIndexServers '', 0/*i_indexServerClientId*/, 0 /*i_cloudId*/, 0 /*i_nodeClientId*/, 1 /*i_status*/
	IF @isCommcellLevelAssociation = 0
	BEGIN
		--delete all client where this user does not have access
		DELETE FROM @memberServers WHERE clientId NOT IN (SELECT clientId FROM #getAzureADMemberServerListTmp)
		DELETE FROM #getIndexServers WHERE indexServerClientId NOT IN (SELECT clientId FROM #getAzureADMemberServerListTmp)
	END
	DECLARE @supportCloud VARCHAR(10)
	SELECT @supportCloud = value from GXGlobalParam where name='SupportAzureADInSolrCloud'
SET @o_xmlData =
	(	SELECT
		(
			SELECT
			(
				SELECT
				(
				SELECT DISTINCT  clientId AS 'client/@clientId', clientName AS 'client/@clientName', clientType AS 'client/@_type_'
				FROM	@memberServers
				FOR XML PATH('memberServers'), TYPE)
			FOR XML PATH(''), TYPE)
		),
		(
			SELECT DISTINCT T.indexServerClientId AS '@clientId', T.engineName AS '@clientName', 3 AS '@_type_'
			FROM #getIndexServers T
			WHERE ( @supportCloud='true' AND T.serverType in (1, 5) )
						OR T.serverType=1
			FOR XML PATH ('indexServers'),TYPE
		)
		FOR XML PATH(''),
	ROOT('App_GetAzureADMemberServersResponse')
	)
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	IF OBJECT_ID('tempdb.dbo.#getAzureADMemberServerListTmp') IS NOT null	DROP TABLE #getAzureADMemberServerListTmp
	SELECT @o_xmlData
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAzureADMemberServers')
	delete from GxQscripts where name = 'AppGetAzureADMemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAzureADMemberServers')
	delete from GXDBVersions where aliasname = 'AppGetAzureADMemberServers'
GO

insert into GXDBVersions values(2, 'AppGetAzureADMemberServers',  '00000000000000000000', 'AppGetAzureADMemberServers', '00000000000000000000')
GO

