

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAutoScaleCoresXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAutoScaleCoresXML.sp,v $ $Id: AppGetAutoScaleCoresXML.sp,v 1.1.2.9.4.2 2021/02/17 05:31:05 pankajkumar Exp $";
--
--  +========================================================================+
--  |      Cursor:  AppGetAutoScaleCoresXML()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetAutoScaleCoresXML')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAutoScaleCoresXML <<<'
	drop procedure AppGetAutoScaleCoresXML
END
IF EXISTS (select * from GxQscripts where name='AppGetAutoScaleCoresXML')
	delete from GxQscripts where name = 'AppGetAutoScaleCoresXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAutoScaleCoresXML')
	delete from GXDBVersions where aliasname = 'AppGetAutoScaleCoresXML'
GO
print '... Creating Procedure: AppGetAutoScaleCoresXML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetAutoScaleCoresXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
DECLARE @errorMessage NVARCHAR(256)= N''
IF object_id('tempdb.dbo.#autoScaleCoresInfo') IS NOT null DROP TABLE #autoScaleCoresInfo
CREATE TABLE #autoScaleCoresInfo (
				coreName	    nvarchar(1024),
				coreStatus      integer,
				srcClientId		int,
				dsId			int,
				coresSize		bigint
            )
IF object_id('tempdb.dbo.#autoScaleCoresResult') IS NOT null DROP TABLE #autoScaleCoresResult
CREATE TABLE #autoScaleCoresResult (
				id				int identity (1,1),
				coreName	    nvarchar(1024),
				coreStatus      integer,
				srcClientId		int,
				dsId			int,
				coresSize		bigint
            )
DECLARE @indexServerClientId INT = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @i_xmlText.nodes('DM2ContentIndexing_ScaleIndexReq/indexServerClient') R ( ref ) ), 0)
DECLARE @i_destNodeClientId INT = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @i_xmlText.nodes('DM2ContentIndexing_ScaleIndexReq/destinationClient') R ( ref ) ), 0)
IF @indexServerClientId =0
BEGIN
	SET @errorCode = 12712 --CLOUD_PSEUDOCLIENT_INVALID
	SET @errorMessage = 'Error: invalid Index Server clientId is provided ['+ CAST(@indexServerClientId AS VARCHAR (100)) +']'
	GOTO PROC_EXIT
END
DECLARE @indexServerClientName NVARCHAR(256) = (SELECT TOP 1 name FROM APP_Client WHERE id= @indexServerClientId)
IF ISNULL(@indexServerClientName, N'') =N''
BEGIN
	SET @errorCode = 12712 --CLOUD_PSEUDOCLIENT_INVALID
	SET @errorMessage = 'Error: invalid Index Server information is provided.'
	GOTO PROC_EXIT
END
--Check if backup activity is disabled at client level
IF ISNULL((SELECT action & 0x2 FROM JMJobAction WHERE clientId = @indexServerClientId AND appType = 0 AND opType = 4), 0) = 0  --CVOpType::BACKUP =4
BEGIN
	SET @errorCode = 10557 --FAILED_TO_BACKUP
	SET @errorMessage = 'Error: Backup Activity is disabled for client ['+ @indexServerClientName +']. Please enable backup activity from client property and try again.'
	GOTO PROC_EXIT
END
--Check if storage policy is not associated to default subclient
IF ISNULL((SELECT dataArchGrpId FROM APP_Application WHERE clientId = @indexServerClientId AND subclientName ='default'), 1) = 1
BEGIN
	SET @errorCode = 12739 --INVALID_STORAGE_POLICY
	SET @errorMessage = 'Error: No storage policy/plan is associated to client ['+ @indexServerClientName +'], subclient [default]. Please associate storage policy/plan and try again.'
	GOTO PROC_EXIT
END
DECLARE @cloudId INT = (SELECT TOP 1 CloudId FROM DM2Cloud WHERE pseudoClientId = @indexServerClientId AND CloudType = 1)
IF ISNULL(@cloudId,0) =0
BEGIN
	SET @errorCode = 12708 --CLOUD_ID_INVALID
	SET @errorMessage = 'Error: Index Server cloudId is invalid ['+ CAST(@cloudId AS VARCHAR (100)) +']'
	GOTO PROC_EXIT
END
DECLARE @indexSizeLimitInMB INT = ISNULL((SELECT TOP 1 CAST (value AS INT) FROM GXGlobalParam WHERE  name ='IndexSizeLimitInMB'),5*1024*1024) --default 5 GB, user can specify in MB
DECLARE @indexItemCounts INT = ISNULL((SELECT TOP 1 CAST (value AS INT) FROM GXGlobalParam WHERE  name ='IndexItemCounts'), 100000) -- default 100K
DECLARE @indexMoveNumLimit INT = ISNULL((SELECT TOP 1 CAST (value AS INT) FROM GXGlobalParam WHERE  name ='IndexMoveNumLimit'),25)  --default 25 cores
DECLARE @repickCoresNumDays INT = ISNULL((SELECT TOP 1 CAST (value AS INT) FROM GXGlobalParam WHERE  name ='RepickCoresNumDays'),90)  --default 90 days
DECLARE @freeSpacePercentLimit INT = ISNULL((SELECT TOP 1 CAST (value AS INT) FROM GXGlobalParam WHERE  name ='FreeSpacePercentLimit'), 30)  --default 30%
DECLARE @coreMoveDatePropertyId INT= (SELECT PropertyId from SEProperty WHERE PropertyGuid = '1BC7C40D-1E4F-4809-8A85-E8786A93CB73')
DECLARE @coreMoveStatusPropertyId INT= (SELECT PropertyId from SEProperty WHERE PropertyGuid = '50C23A5D-70EA-4BB7-81D6-22027BD82E16')
--first check if source client for index move is specified in globalParam
DECLARE @srcClientId INT = 0
DECLARE @srcClientName NVARCHAR(256)= N''
SET @srcClientName = (SELECT TOP 1  value FROM GXGlobalParam WHERE  name ='SourceNodeClientName' )
IF ISNULL(@srcClientName, N'') <> N''
	SET @srcClientId =ISNULL((SELECT TOP 1 id FROM APP_Client WHERE name= @srcClientName),0)
--pick only CVSolr cores for index move operation
INSERT INTO #autoScaleCoresInfo
SELECT A.CoreName, A.Status, B.clientId, DS.dataSourceId, A.size
FROM SEIndexServerNodeStats A
JOIN DM2SearchServerCoreInfo B ON A.SearchServerCoreId = B.CoreId
JOIN SECollectionInfo C ON B.clientId = C.clientId AND B.cloudId = C.cloudId
JOIN SEDataSource DS ON DS.coreId = C.CoreId AND DS.dataSourceId = A.DataSourceId
JOIN SEDataSourceRoute R ON A.DataSourceId = R.DataSourceId
WHERE  B.cloudId = @cloudId AND (@srcClientId =0 OR B.clientId = @srcClientId)
AND B.CloudType = 1
	AND (A.size/(1024*1024) >= @indexSizeLimitInMB OR A.ItemCount >= @indexItemCounts)
	AND (@i_destNodeClientId =0 OR  @i_destNodeClientId != C.clientId)
	AND A.status IN (0,1) 	--IndexServerNodeShardStatus::Active = 0, Unloaded = 1	--pick only valid cores
-- do not include SUCCESSFUL moved shards in last N=7 days
-- pick failed shards in the next job
DELETE T
FROM #autoScaleCoresInfo T
JOIN SEDataSourceProperty DSP ON T.dsId = DSP.dataSourceId AND DSP.propertyId = @coreMoveDatePropertyId
		AND  CAST(DSP.propertyValue AS INT) > (dbo.GetUnixTime(GETUTCDATE()) - @repickCoresNumDays * 24 * 60 * 60)
JOIN SEDataSourceProperty DSP2 ON T.dsId = DSP2.dataSourceId AND DSP2.propertyId = @coreMoveStatusPropertyId
		AND  CAST(DSP2.propertyValue AS INT) =4 --success
IF NOT EXISTS (SELECT TOP 1 1 FROM #autoScaleCoresInfo)
BEGIN
	SET @errorCode = 15806 --CORE_INFO_FETCH_FAILURE
	SET @errorMessage = 'Index move operation is not required as data is evenly distributed across nodes'
	GOTO PROC_EXIT
END
--Fetch srcClientId as client with maximum shards size
IF @srcClientId=0
BEGIN
	SET @srcClientId =(SELECT TOP 1 srcClientId FROM #autoScaleCoresInfo ORDER BY coresSize DESC)
	SET @srcClientName =(SELECT TOP 1 name FROM APP_Client WHERE id= @srcClientId)
END
--error out if no source client found
IF ISNULL(@srcClientId,0) =0 OR ISNULL(@srcClientName, N'') =N''
BEGIN
	SET @errorCode = 12742 --NODE_CLIENT_ID_INVALID
	SET @errorMessage = 'Error: Failed to find source node client for index move operation. Please provide a valid Index Server client.'
	GOTO PROC_EXIT
END
--delete cores which are not belongs to source node
DELETE FROM #autoScaleCoresInfo WHERE srcClientId != @srcClientId
--ordering out shards based on size
INSERT INTO #autoScaleCoresResult
SELECT coreName, coreStatus, srcClientId, dsId, coresSize FROM #autoScaleCoresInfo ORDER BY coresSize DESC
--pick alternate shards 1,3,5 etc till it reaches indexMoveNumLimit
DELETE FROM #autoScaleCoresResult WHERE id % 2 =0  OR id > (@indexMoveNumLimit *2)
--For existing index server, pick top 1 node which have more freespace as destination client
--For newly added node, new node becomes destination client
DECLARE @destClientId INT = @i_destNodeClientId
IF @destClientId =0
BEGIN
	--first check if destination client for index move is specified in globalParam
	DECLARE @destClientName NVARCHAR(256)= N''
	SET @destClientName = (SELECT TOP 1 value FROM GXGlobalParam WHERE  name ='DestinationNodeClientName' )
	IF ISNULL(@destClientName, N'') <> N''
		SET @destClientId =(SELECT TOP 1 id FROM APP_Client WHERE name= @destClientName)
	ELSE
	BEGIN
SET @destClientId =(SELECT TOP 1 clientId FROM DM2SearchServerCoreInfo WHERE cloudId = @cloudId AND CloudType = 1
																				AND clientId != @srcClientId ORDER BY FreeSpace DESC)
	END
END
--set destination client name
IF ISNULL(@destClientName, N'') = N'' AND ISNULL(@destClientId,0) !=0
		SET @destClientName =(SELECT TOP 1 name FROM APP_Client WHERE id= @destClientId)
IF ISNULL(@destClientId,0) =0 OR ISNULL(@destClientName, N'') = N''
BEGIN
	SET @errorCode = 12742 --NODE_CLIENT_ID_INVALID
	SET @errorMessage = 'Error: Failed to find destination node client for index move operation. Please provide a valid destination client'
	GOTO PROC_EXIT
END
--find shards so that at least 30% freespace remaining after index move operation
DECLARE @TotalCoreSize BIGINT =  ISNULL((SELECT sum(coresSize) from #autoScaleCoresResult),0)
DECLARE @FreeSpaceAvail BIGINT =  (SELECT freeSpace from DM2SearchServerCoreInfo where clientId = @destClientId AND cloudId = @cloudId)
WHILE @TotalCoreSize > 0 AND  (@FreeSpaceAvail - (@freeSpacePercentLimit * @FreeSpaceAvail)/100) <= @TotalCoreSize
BEGIN
   DELETE TOP (1) FROM #autoScaleCoresResult
   SET @TotalCoreSize =  ISNULL((SELECT sum(coresSize) from #autoScaleCoresResult),0)
END;
-----
IF NOT EXISTS (SELECT TOP 1 1 FROM #autoScaleCoresResult)
BEGIN
	SET @errorCode = 15806 --CORE_INFO_FETCH_FAILURE
	SET @errorMessage = 'Destination client [' + @destClientName +'] does not have required free space available'
	GOTO PROC_EXIT
END
---
DECLARE @srcFolder NVARCHAR(2048) =''
DECLARE @destFolder NVARCHAR(2048) =''
DECLARE @OSType NVARCHAR(64)=(SELECT Type from simOperatingSystem OS JOIN APP_CLient C ON C.id=@srcClientId and OS.id=simOperatingSystemId)
--Prefix slash char for windows machine
IF(@OSType='Windows')
BEGIN
    SET @srcFolder ='\'
	SET @destFolder='\'
END
SET @srcFolder =  @srcFolder + dbo.SEGetIndexLocation(@cloudId, @srcClientId)
SET @destFolder =  @destFolder + dbo.SEGetIndexLocation(@cloudId, @destClientId)
--
IF ISNULL(@srcFolder, '') =''
	OR ISNULL(@destFolder, '') =''
BEGIN
	SET @errorCode = 12724 --INDEX_DIRECTORY_INVALID_PATH
	SET @errorMessage = 'Error: Failed to find source and destination path for index move operation. Please verify that valid index path is specified in the index server ['+ @indexServerClientName +']'
	GOTO PROC_EXIT
END
PROC_EXIT:
SET @o_XMLText = (SELECT
					(SELECT
					(SELECT
					@indexServerClientId AS '@clientId',
					@indexServerClientName AS '@clientName'
					FOR XML PATH('indexServerClient'), TYPE
					),
					(SELECT
					@srcClientId AS '@clientId',
					@srcClientName AS '@clientName'
					FOR XML PATH('sourceClient'), TYPE
					),
					(SELECT
					@destClientId AS '@clientId',
					@destClientName AS '@clientName'
					FOR XML PATH('destinationClient'), TYPE
					),
					(SELECT
					coreName AS '@coreName',
					coreStatus AS '@coreStatus',
					@srcFolder AS '@srcFolder',
					@destFolder AS '@destFolder'
					FROM #autoScaleCoresResult
					FOR XML PATH('coresInfo'), TYPE
					),
					(SELECT
					@errorCode AS '@errorCode',
					@errorMessage AS '@errLogMessage'
					FOR XML PATH('err'), TYPE
					)
					FOR XML PATH('scaleIndexInfo'),TYPE)
					FOR XML PATH('DM2ContentIndexing_IndexAutoscaleOption')
				 )
SELECT @o_xmlText AS [o_xmlText]
IF object_id('tempdb.dbo.#autoScaleCoresInfo') IS NOT null DROP TABLE #autoScaleCoresInfo
IF object_id('tempdb.dbo.#autoScaleCoresResult') IS NOT null DROP TABLE #autoScaleCoresResult
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAutoScaleCoresXML')
	delete from GxQscripts where name = 'AppGetAutoScaleCoresXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAutoScaleCoresXML')
	delete from GXDBVersions where aliasname = 'AppGetAutoScaleCoresXML'
GO

insert into GXDBVersions values(2, 'AppGetAutoScaleCoresXML',  'v1.1.2.9.4.2', 'AppGetAutoScaleCoresXML', 'v1.1.2.9.4.2')
GO

