

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAutoFailoverCoordinator.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppGetAutoFailoverCoordinator						|
--	|		 Procedure to get active co-ordinator for Auto Failover		|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetAutoFailoverCoordinator <<<'

IF EXISTS (select * from sysobjects where name='AppGetAutoFailoverCoordinator')
	drop procedure AppGetAutoFailoverCoordinator
IF EXISTS (select * from GxQscripts where name='AppGetAutoFailoverCoordinator')
	delete from GxQscripts where name = 'AppGetAutoFailoverCoordinator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAutoFailoverCoordinator')
	delete from GXDBVersions where aliasname = 'AppGetAutoFailoverCoordinator'
GO
print '... Creating Procedure: AppGetAutoFailoverCoordinator'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAutoFailoverCoordinator
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
BEGIN
	-- output XML to return
	DECLARE @o_xmlText XML
	DECLARE @vappId  INT = ISNULL (( SELECT ref.value('@vAppId', 'INT')
													FROM @i_xmlString.nodes ('Api_GetAutoFailoverCoordinatorReq/vAppEntity') R(ref)), 0)
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @master INT = 1 -- is coordinator
	DECLARE @online INT = 5 -- machine is online
	DECLARE @vapp_xmlString XML
	DECLARE @coordinator XML
	-- READ THE XML
	select @vapp_xmlString = vxml from App_VirtualApp where id = @vappId
	if @vapp_xmlString IS NOT NULL
	BEGIN
			-- temp table
		IF object_id('tempdb.dbo.#selectedList') is not null DROP TABLE #selectedList
		CREATE TABLE #selectedList (
									master INT,
									status INT,
									client XML
									)
		insert #selectedList
		select t.s.value('@isMaster', 'INT'),
				t.s.value('@status', 'INT'),
				s.query('./client')
				from @vapp_xmlString.nodes('Api_VirtualAppReq/vApp/autofailover/machine') t(s)
		select @coordinator = client from #selectedList where master = @master and status = @online
		if @coordinator IS NOT NULL
		BEGIN
			SET @errorCode =0
			SET @errorString =''
			SET @o_xmlText =  (
								SELECT @coordinator,
								(SELECT @errorCode as '@errorCode',
									   @errorString as '@errorMessage'
								FOR XML PATH('resp'), TYPE)
								FOR XML path(''),
								ROOT('Api_GetAutoFailoverCoordinatorResp')
								)
			SELECT @o_xmlText;
			--return @errorCode
		END
		ELSE -- no coordinator
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Active Coordinator cannot be found'
			GOTO ERROR_EXIT
		END
	END
	ELSE -- no vapp
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Virtual App doesnt exists'
		GOTO ERROR_EXIT
	END
	ERROR_EXIT:
	IF @errorCode <> 0
	BEGIN
		SET @o_xmlText = (
				(SELECT @errorCode as '@errorCode',
					   @errorString as '@errorMessage'
				FOR XML PATH('resp'), ROOT('Api_GetAutoFailoverCoordinatorResp')
				)
				)
		SELECT @o_xmlText;
	END
	DROP TABLE #selectedList
END
--return @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAutoFailoverCoordinator')
	delete from GxQscripts where name = 'AppGetAutoFailoverCoordinator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAutoFailoverCoordinator')
	delete from GXDBVersions where aliasname = 'AppGetAutoFailoverCoordinator'
GO

insert into GXDBVersions values(2, 'AppGetAutoFailoverCoordinator',  '00000000000000000000', 'AppGetAutoFailoverCoordinator', '00000000000000000000')
GO

