

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAssociationsForSCP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppGetAssociationsForSCP
--  |
--  | Description:  SP for retreiving all associations of a subclient policy
--  |
--  |       Input:  scpId and userId
--  |      Output:  XML containing list of associations.
--  |      Return:  xxx
--  |
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAssociationsForSCP')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAssociationsForSCP <<<'
	drop procedure AppGetAssociationsForSCP
END
IF EXISTS (select * from GxQscripts where name='AppGetAssociationsForSCP')
	delete from GxQscripts where name = 'AppGetAssociationsForSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociationsForSCP')
	delete from GXDBVersions where aliasname = 'AppGetAssociationsForSCP'
GO
print '... Creating Procedure: AppGetAssociationsForSCP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAssociationsForSCP
  @scpId INT,
  @userId INT
AS
  DECLARE @associations XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#SCPAssociationsTbl') IS NOT NULL
	DROP TABLE #SCPAssociationsTbl
CREATE TABLE #SCPAssociationsTbl
(
	_type_			INT,
	clientId		INT,
	apptypeId		INT,
	instanceId		INT,
	backupsetId		INT,
	clientGroupId	INT
)
CREATE NONCLUSTERED INDEX ScpAssocTbl_type ON #SCPAssociationsTbl (_type_) INCLUDE (clientGroupId, clientId, apptypeId, instanceId, backupsetId)
INSERT INTO #SCPAssociationsTbl
	SELECT entityType, 0, 0, 0, 0, entityId FROM APP_SubclientPolicyAssoc
WHERE scpId = @scpId AND entityType = 28
	UNION
SELECT DISTINCT 6, APP.clientId, APP.appTypeId, APP.instance, APP.backupSet, 0
		FROM APP_BackupSetProp BSProp INNER JOIN APP_Application APP
			ON BSProp.attrName = N'Associated subclient Policy' AND BSProp.attrVal = @scpId AND BSProp.modified = 0
				AND BSProp.componentNameId = APP.backupSet
				AND (ISNULL((SELECT attrVal FROM APP_BackupSetProp WHERE componentNameId = APP.backupSet AND attrName = N'Subclient Policy Association Level' AND modified = 0), 0)) = 0
	UNION
	-- fetching edge drive subclient policy from edge drive association table
SELECT DISTINCT 6, APP.clientId, APP.appTypeId, APP.instance, APP.backupSet, 0
		FROM APP_Application APP INNER JOIN App_EdgeDriveAssociation EDA
ON APP.backupSet = EDA.entityId AND EDA.entityType = 65 AND APP.backupSet = @scpId
IF OBJECT_ID('tempdb.dbo.#UserBackupsets') IS NOT NULL
	DROP TABLE #UserBackupsets
CREATE TABLE #UserBackupsets
(
	clientId		INT,
	apptypeId		INT,
	instanceId		INT,
	backupsetId		INT,
	subclientId		INT
)
EXEC sec_getIdaObjectsForUser @userId, 6, 2, 0, '#UserBackupsets'
DELETE assoc
	FROM #SCPAssociationsTbl assoc LEFT OUTER JOIN #UserBackupsets bkpSets
		ON assoc.clientId = bkpSets.clientId AND assoc.apptypeId = bkpSets.apptypeId AND assoc.instanceId = bkpSets.instanceId AND assoc.backupsetId = bkpSets.backupsetId
WHERE assoc._type_ = 6 AND bkpSets.backupsetId IS NULL
IF OBJECT_ID('tempdb.dbo.#UserClientGroups') IS NOT NULL
	DROP TABLE #UserClientGroups
CREATE TABLE #UserClientGroups
(
	clientGroupId	INT
)
EXEC sec_getNonIdaObjectsForThisUser @userId, 28, 2, '#UserClientGroups'
DELETE assoc
	FROM #SCPAssociationsTbl assoc LEFT OUTER JOIN #UserClientGroups cgs
		ON assoc.clientGroupId = cgs.clientGroupId
WHERE assoc._type_ = 28 AND cgs.clientGroupId IS NULL
DECLARE @outXML XML
SET @outXML = ISNULL((
						SELECT assoc._type_ AS '@_type_',
CASE WHEN _type_ = 28 THEN assoc.clientGroupId END AS '@clientGroupId',
CASE WHEN _type_ = 28 THEN CG.name END AS '@clientGroupName',
CASE WHEN _type_ = 6 THEN assoc.clientId END AS '@clientId',
CASE WHEN _type_ = 6 THEN assoc.apptypeId END AS '@applicationId',
CASE WHEN _type_ = 6 THEN assoc.instanceId END AS '@instanceId',
CASE WHEN _type_ = 6 THEN assoc.backupsetId END AS '@backupsetId',
CASE WHEN _type_ = 6 THEN client.name END AS '@clientName',
CASE WHEN _type_ = 6 THEN client.displayName END AS '@displayName',
CASE WHEN _type_ = 6 THEN ida.name END AS '@appName',
CASE WHEN _type_ = 6 THEN instance.name END AS '@instanceName',
CASE WHEN _type_ = 6 THEN bckpSet.name END AS '@backupsetName'
						FROM #SCPAssociationsTbl assoc
						LEFT OUTER JOIN APP_ClientGroup CG
							ON assoc.clientGroupId = CG.id
						LEFT OUTER JOIN APP_BackupSetName bckpSet
							ON assoc.backupsetId = bckpSet.id
						LEFT OUTER JOIN APP_iDAType ida
							ON assoc.apptypeId = ida.type
						LEFT OUTER JOIN APP_InstanceName instance
							ON assoc.instanceId = instance.id
						LEFT OUTER JOIN APP_Client client
							ON assoc.clientId = client.id
						FOR XML PATH('entity'), ROOT('App_Associations')
					), '<App_Associations/>')
SELECT @outXML
DROP TABLE #SCPAssociationsTbl
DROP TABLE #UserBackupsets
DROP TABLE #UserClientGroups
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAssociationsForSCP')
	delete from GxQscripts where name = 'AppGetAssociationsForSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociationsForSCP')
	delete from GXDBVersions where aliasname = 'AppGetAssociationsForSCP'
GO

insert into GXDBVersions values(2, 'AppGetAssociationsForSCP',  '00000000000000000000', 'AppGetAssociationsForSCP', '00000000000000000000')
GO

