

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAssociatedTasksForReplicationGroup.sp] ---------- 

--  +=============================================================================================+
--  |                       Name: AppGetAssociatedTasksForReplicationGroup()
--  | Description: Fetches all tasks associated with the list of replication groups provided.
--  |			   This SP fetches tasks for periodic replication groups alone
--  |
--  |       Input: XML -- contains list of replication groups which are to be enabled or disabled.
--  |      Output: o_xml -- Contains the taskIds which are to be enabled or disabled.
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAssociatedTasksForReplicationGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAssociatedTasksForReplicationGroup <<<'
	drop procedure AppGetAssociatedTasksForReplicationGroup
END
IF EXISTS (select * from GxQscripts where name='AppGetAssociatedTasksForReplicationGroup')
	delete from GxQscripts where name = 'AppGetAssociatedTasksForReplicationGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociatedTasksForReplicationGroup')
	delete from GXDBVersions where aliasname = 'AppGetAssociatedTasksForReplicationGroup'
GO
print '... Creating Procedure: AppGetAssociatedTasksForReplicationGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAssociatedTasksForReplicationGroup
  @i_xmlText XML
AS
  DECLARE @o_xml XML 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
    IF OBJECT_ID('tempdb.dbo.#tempAssocTaskIdTbl') IS NOT NULL
        DROP TABLE #tempAssocTaskIdTbl
	IF OBJECT_ID('tempdb.dbo.#AssocTaskIdTbl') IS NOT NULL
        DROP TABLE #AssocTaskIdTbl
    CREATE TABLE #tempAssocTaskIdTbl (scheduleTaskId INT, snapTaskId INT)
    CREATE TABLE #AssocTaskIdTbl (taskId INT)
	INSERT INTO #tempAssocTaskIdTbl
		SELECT CONVERT(INT,PP.attrVal), ST.taskId from app_replicationgroup REP WITH(NOLOCK) JOIN @i_xmlText.nodes('//replicationGroups') R(ref)ON ref.value('@replicationGroupId','INT') = REP.id
				    JOIN App_ReplicationGroupAssociation REPASSOC WITH(NOLOCK) ON REPASSOC.componentNameId = REP.id AND REPASSOC.taskId IS NOT NULL
					JOIN TM_AssocEntity TMASSOC WITH(NOLOCK) ON TMASSOC.taskId = REPASSOC.taskId
					JOIN TM_Task TMT WITH(NOLOCK) ON TMT.taskId = TMASSOC.taskId
JOIN APP_SubClientProp SUB WITH(NOLOCK) ON TMASSOC.subclientId = SUB.componentNameId AND SUB.attrName = 'Associated Plan' AND SUB.modified = 0
AND SUB.cs_attrName = CHECKSUM(N'Associated Plan')
					JOIN App_PlanProp PP WITH(NOLOCK) ON CONVERT(NVARCHAR,PP.componentNameId) = SUB.attrVal AND
(PP.attrName = 'Replication schedule policy' OR PP.attrName = 'Schedule policy')
JOIN App_planProp PP2 WITH(NOLOCK) ON CONVERT(NVARCHAR,PP2.componentNameId) = SUB.attrVal AND PP2.attrName = 'Storage policy'
					LEFT JOIN TM_AssocEntity AE WITH(NOLOCK) ON CONVERT(NVARCHAR,AE.policyId) = PP2.attrVal
					LEFT JOIN TM_Task T WITH(NOLOCK) ON T.taskId = AE.taskId AND T.deleted = 0
LEFT JOIN TM_SubTask ST WITH(NOLOCK) ON ST.taskId = T.taskId AND ST.operationType = 4028 AND ST.deleted = 0
					WHERE
						TMT.deleted = 0
	INSERT INTO #AssocTaskIdTbl
		SELECT scheduleTaskId FROM #tempAssocTaskIdTbl WHERE scheduleTaskId IS NOT NULL
		UNION
		SELECT snapTaskId FROM #tempAssocTaskIdTbl WHERE snapTaskId IS NOT NULL
	SET @o_xml = (SELECT
					(SELECT taskId AS '@taskId' from #AssocTaskIdTbl FOR XML PATH ('taskEntities'), TYPE)
					FOR XML PATH('TMMsg_TaskOperationReq')
					)
	IF OBJECT_ID('tempdb.dbo.#tempAssocTaskIdTbl') IS NOT NULL
        DROP TABLE #tempAssocTaskIdTbl
	IF OBJECT_ID('tempdb.dbo.#AssocTaskIdTbl') IS NOT NULL
        DROP TABLE #AssocTaskIdTbl
	SELECT @o_xml AS o_xml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAssociatedTasksForReplicationGroup')
	delete from GxQscripts where name = 'AppGetAssociatedTasksForReplicationGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociatedTasksForReplicationGroup')
	delete from GXDBVersions where aliasname = 'AppGetAssociatedTasksForReplicationGroup'
GO

insert into GXDBVersions values(2, 'AppGetAssociatedTasksForReplicationGroup',  '00000000000000000000', 'AppGetAssociatedTasksForReplicationGroup', '00000000000000000000')
GO

