

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAssociatedNFSObjectStore.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAssociatedNFSObjectStore.sp,v $ $Id: AppGetAssociatedNFSObjectStore.sp,v 1.1.2.7 2018/07/05 16:33:13 nshah Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetAssociatedNFSObjectStore <<<'

IF EXISTS (select * from sysobjects where name='AppGetAssociatedNFSObjectStore')
	drop procedure AppGetAssociatedNFSObjectStore
IF EXISTS (select * from GxQscripts where name='AppGetAssociatedNFSObjectStore')
	delete from GxQscripts where name = 'AppGetAssociatedNFSObjectStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociatedNFSObjectStore')
	delete from GXDBVersions where aliasname = 'AppGetAssociatedNFSObjectStore'
GO
print '... Creating Procedure: AppGetAssociatedNFSObjectStore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAssociatedNFSObjectStore
-- Input arguments
  @i_xmlText XML
AS
  DECLARE @xmlNFSObjStore XML
BEGIN
    SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF OBJECT_ID('tempdb.dbo.#nfsObjectServers') IS NOT null
	DROP TABLE #nfsObjectServers
	IF OBJECT_ID('tempdb.dbo.#nfsObjectStore') IS NOT null
		DROP TABLE #nfsObjectStore
	CREATE TABLE #nfsObjectServers (
		id              INT PRIMARY KEY )
	CREATE TABLE #nfsObjectStore (
		id              INT PRIMARY KEY,
		policySubclient	INT,
		webServerURL	NVARCHAR(MAX)  )
	DECLARE @inIndexServerId INT
	SET @inIndexServerId = ISNULL(( SELECT ref.value('@clientId', 'int')
                                    FROM   @i_xmlText.nodes('App_GetNFSObjectStoreReq/indexServer') R ( ref )
                                ), 0)
	DECLARE @cloudId INT = 0
	SET @cloudId = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @inIndexServerId AND attrName = 'Analytics_CloudId' AND modified = 0), 0)
	INSERT #nfsObjectServers
		SELECT DISTINCT EWA.edgeClientId FROM AppEdgeDriveWebserverAssociation EWA
			INNER JOIN APP_ClientProp prop ON EWA.edgeClientId = prop.componentNameId
			WHERE   EWA.webserverId = @inIndexServerId
					AND prop.attrName = 'System Drive Type' AND prop.attrVal = '4' AND prop.modified = 0
	INSERT #nfsObjectStore(id)
		SELECT subclient.id FROM APP_Application subclient
			INNER JOIN #nfsObjectServers objServer ON objServer.id = subclient.clientId
				AND subclient.subclientStatus & 0x20000 <> 0 -- CV_STATUS_EDGEDRIVE_SUB
			INNER JOIN APP_SubClientProp prop ON prop.componentNameId = subclient.id
				WHERE prop.attrName = '3dfs Is NFS Share Enabled' AND prop.attrVal = '1' AND prop.modified = 0
	UPDATE T
    SET
        T.policySubclient = prop.attrVal
    FROM #nfsObjectStore T
    INNER JOIN APP_SubClientProp prop ON T.id = prop.componentNameId
	WHERE prop.attrName = 'Associated subclient Policy' and prop.modified = 0
	UPDATE T
    SET
        T.webServerURL = prop.attrVal
    FROM #nfsObjectStore T
    INNER JOIN APP_SubClientProp prop ON T.policySubclient = prop.componentNameId
	WHERE prop.attrName = 'Edge Web Server URL' and prop.modified = 0
	SET @xmlNFSObjStore = (SELECT
							(SELECT @cloudId AS '@analyticsCloudId',
									(SELECT ISNULL([Grace Period For Versions], 0) AS '@dataAgingDays',
											ISNULL([Versions in Drive], 0) AS '@dataAgingVersions',
											ISNULL([Trash Can Retention], 365) AS '@deletedItemDays',
											webServerURL AS '@webServerURL',
												(SELECT id AS '@subclientId'
													FOR XML PATH('subclient'), TYPE)
										FROM
										(
											SELECT objStore.id, webServerURL, attrName, attrVal
											FROM APP_SubClientProp prop
											INNER JOIN #nfsObjectStore objStore ON objStore.policySubclient = prop.componentNameId AND prop.modified = 0
										) AS backupsetProp
										PIVOT
										(
											MAX(attrVal) FOR attrName IN([Grace Period For Versions], [Versions in Drive], [Trash Can Retention])
										) AS P
										FOR XML PATH('nfsObjectStores'),TYPE )
						FOR XML PATH('App_GetNFSObjectStoreResp')))
    SELECT @xmlNFSObjStore
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAssociatedNFSObjectStore')
	delete from GxQscripts where name = 'AppGetAssociatedNFSObjectStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociatedNFSObjectStore')
	delete from GXDBVersions where aliasname = 'AppGetAssociatedNFSObjectStore'
GO

insert into GXDBVersions values(2, 'AppGetAssociatedNFSObjectStore',  '00010001000200070000', 'AppGetAssociatedNFSObjectStore', '00010001000200070000')
GO

