

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAssociatedIndexServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAssociatedIndexServers.sp,v $ $Id: AppGetAssociatedIndexServers.sp,v 1.1.2.2 2019/10/23 01:38:24 pankajkumar Exp $";
-- ----------------------------------------------------------------------*/
--	This Sp is used to get associated index servers for physical client properties
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAssociatedIndexServers')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAssociatedIndexServers <<<'
	drop procedure AppGetAssociatedIndexServers
END
IF EXISTS (select * from GxQscripts where name='AppGetAssociatedIndexServers')
	delete from GxQscripts where name = 'AppGetAssociatedIndexServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociatedIndexServers')
	delete from GXDBVersions where aliasname = 'AppGetAssociatedIndexServers'
GO
print '... Creating Procedure: AppGetAssociatedIndexServers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAssociatedIndexServers
  @i_clientId INT = 0
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	--get associated Index server lists
	INSERT INTO #indexServer (cloudServerType, cloudStatus, cloudName, cloudDisplayName, indexServerClientId)
	SELECT DISTINCT S.cloudType, DC.status, C.name,C.displayname, DC.pseudoClientId
	FROM DM2SearchServerCoreInfo S
			JOIN DM2Cloud DC ON S.CloudId = DC.cloudId
			JOIN APP_Client C ON DC.pseudoClientId = C.id
WHERE S.CloudType IN (1, 5) AND S.clientId = @i_clientId
	--Do not allow to change index directory path if any of the associated index server is in configured state.
	IF EXISTS (SELECT TOP 1 1 FROM #indexServer WHERE cloudStatus = 1)
		UPDATE #indexServer
		SET cloudStatus = 1  --set status to 1 for all index server
	--get node properties XML
	DECLARE @nodePropertiesXML TABLE (t_nodeProps XML, t_status INT)
	INSERT INTO @nodePropertiesXML (t_nodeProps, t_status)
	SELECT TOP 1  NodeProps, status
	FROM  DM2SearchServerCoreInfo
WHERE   clientId = @i_clientId AND  cloudType IN (1, 5)
	--get node properties for each attributes
	DECLARE @nodeNameValueMap TABLE (t_name NVARCHAR(1024), t_value NVARCHAR(1024))
	INSERT INTO @nodeNameValueMap
	SELECT DISTINCT  ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')
	FROM  @nodePropertiesXML N
		CROSS APPLY N.t_nodeProps.nodes('NodeMetaProp/nodeMetaInfos') as R1(ref1)
	--delete unwanted props
	DELETE FROM @nodeNameValueMap WHERE t_name NOT IN ('INDEXLOCATION','JVMMAXMEMORY','PORTNO')
	--node properties
	INSERT INTO #nodeProperties  (indexDirectory,javaMaxMem, portNo, nodeStatus)
	SELECT DISTINCT
	ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap WHERE t_name = 'INDEXLOCATION'),N'NA') ,
	ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap WHERE t_name = 'JVMMAXMEMORY' ),'4096') ,
	ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap WHERE t_name = 'PORTNO'),'20000') ,
	S.t_status
	FROM @nodePropertiesXML S
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAssociatedIndexServers')
	delete from GxQscripts where name = 'AppGetAssociatedIndexServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociatedIndexServers')
	delete from GXDBVersions where aliasname = 'AppGetAssociatedIndexServers'
GO

insert into GXDBVersions values(2, 'AppGetAssociatedIndexServers',  '00010001000200020000', 'AppGetAssociatedIndexServers', '00010001000200020000')
GO

