

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAssociatedClientsForDeletion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAssociatedClientsForDeletion')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAssociatedClientsForDeletion <<<'
	drop procedure AppGetAssociatedClientsForDeletion
END
IF EXISTS (select * from GxQscripts where name='AppGetAssociatedClientsForDeletion')
	delete from GxQscripts where name = 'AppGetAssociatedClientsForDeletion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociatedClientsForDeletion')
	delete from GXDBVersions where aliasname = 'AppGetAssociatedClientsForDeletion'
GO
print '... Creating Procedure: AppGetAssociatedClientsForDeletion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAssociatedClientsForDeletion
  @xmlstr XML OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @level INT
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @noPermissionErrorString NVARCHAR(MAX) = ''
	DECLARE @inputxml XML = @xmlstr
	DECLARE @userId INT
	DECLARE @localeId INT = 0
	DECLARE @outputEntitiesStr NVARCHAR(MAX)
	DECLARE @outputErrorStr NVARCHAR(MAX)
	DECLARE @numOfClients INT = 0, @numOfCompanies INT = 0, @numOfClientGroups INT = 0
	SET @level = ISNULL (( SELECT ref.value('@expandLevel', 'INTEGER') FROM @inputxml.nodes('App_GetAssociatedEntities') R(ref)), -1)
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int')
      FROM    @inputXml.nodes('App_GetAssociatedEntities/processinginstructioninfo/user') R ( ref )),-1)
	SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int')
      FROM    @inputXml.nodes('App_GetAssociatedEntities/processinginstructioninfo/locale') R ( ref )),0)
IF @userId = -1 OR @level <> 3
	BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	IF object_id('tempdb.dbo.#ExpandedClientsTable') IS NOT NULL
		DROP TABLE #ExpandedClientsTable
	CREATE TABLE #ExpandedClientsTable
(clientId INT PRIMARY KEY, clientName NVARCHAR(255) DEFAULT '', errorCode INT DEFAULT 0, errorString NVARCHAR(MAX) DEFAULT '',
	 isPseudoClient INT DEFAULT 0, companyId INT DEFAULT 0, isCompanyDeleted INT DEFAULT 0)
	DECLARE @inputEntitiesTable TABLE
	(clientId INT, companyId INT, clientGroupId INT)
	DECLARE @CompaniesToBeExpandedTable TABLE
	(companyId INT)
	DECLARE @ClientGroupsToBeExpandedTable TABLE
	(clientGroupId INT, companyId INT DEFAULT 0)
	-- READ ENTITIES FROM INPUT XML
	INSERT INTO @inputEntitiesTable
	(clientId, companyId, clientGroupId)
	SELECT ref.value('@clientId', 'INTEGER') AS clientId, ref.value('@providerId', 'INTEGER') AS companyId, ref.value('@clientGroupId', 'INTEGER') AS clientGroupId
	FROM @xmlstr.nodes('App_GetAssociatedEntities/entity') R(ref)
	INSERT INTO #ExpandedClientsTable
	(clientId)
	SELECT clientId
	FROM @inputEntitiesTable
	WHERE clientId IS NOT NULL
	SET @numOfClients = @@ROWCOUNT
	-- SET ERROR CODE FOR INVALID CLIENT ID
	IF @numOfClients > 0
	BEGIN
		UPDATE #ExpandedClientsTable
SET errorCode = (1800 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		FROM #ExpandedClientsTable C
		LEFT JOIN App_Client AC ON C.clientId = AC.id
		WHERE AC.id IS NULL
	END
	INSERT INTO @CompaniesToBeExpandedTable
	(companyId)
	SELECT companyId
	FROM @inputEntitiesTable
	WHERE companyId IS NOT NULL AND clientId IS NULL AND clientGroupId IS NULL
	SET @numOfCompanies = @@ROWCOUNT
	INSERT INTO @ClientGroupsToBeExpandedTable
	(clientGroupId)
	SELECT clientGroupId
	FROM @inputEntitiesTable
	WHERE clientGroupId IS NOT NULL AND clientId IS NULL AND companyId IS NULL
	SET @numOfClientGroups = @@ROWCOUNT
	-- GET COMPANY ID FOR CLIENT GROUPS
	IF @numOfClientGroups > 0
	BEGIN
		UPDATE @ClientGroupsToBeExpandedTable
		SET companyId = ACP.componentNameId
		FROM @ClientGroupsToBeExpandedTable CGT
JOIN App_CompanyProp ACP ON ACP.attrName='Associated Smart Client Group' AND cs_attrName = checksum('Associated Smart Client Group') AND ACP.modified = 0
			AND CGT.clientGroupId = CAST(ACP.attrVal AS INT)
	END
	-- FIND THE CORRESPONDING CLIENT GROUP ID GIVEN COMPANY ID
	IF @numOfCompanies > 0
	BEGIN
		INSERT INTO @ClientGroupsToBeExpandedTable
		(clientGroupId, companyId)
		SELECT CAST(ACP.attrVal AS INT), CT.companyId
		FROM @CompaniesToBeExpandedTable CT
JOIN App_CompanyProp ACP ON ACP.attrName='Associated Smart Client Group' AND cs_attrName = checksum('Associated Smart Client Group') AND ACP.modified = 0
			AND CT.companyId = ACP.componentNameId
		LEFT JOIN @ClientGroupsToBeExpandedTable CGT ON CGT.clientGroupId = CAST(ACP.attrVal AS INT)
		WHERE CGT.clientGroupId IS NULL
		SET @numOfClientGroups += @@ROWCOUNT
	END
	-- EXPAND CLIENT GROUPS TO CLIENTS
	IF @numOfClientGroups > 0
	BEGIN
		INSERT INTO #ExpandedClientsTable
		(clientId, companyId)
		SELECT CGA.clientId, CGT.companyId
		FROM @ClientGroupsToBeExpandedTable CGT
		JOIN APP_ClientGroupAssoc CGA ON CGT.clientGroupId = CGA.clientGroupId
		LEFT JOIN #ExpandedClientsTable CT ON CGA.clientId = CT.clientId
		WHERE CT.clientId IS NULL
	END
	-- GET COMPANY ID FOR CLIENTS
	UPDATE #ExpandedClientsTable
	SET companyId = CAST(P1.attrVal AS INT)
	FROM #ExpandedClientsTable C
JOIN App_ClientProp P1 ON C.errorCode <> (1800 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND C.companyId = 0 AND P1.attrName = 'Installation Company ID' AND P1.modified = 0 AND C.clientId = P1.componentNameId
	-- GET TRUE COMPANY ID IF COMPANY ID IS CURRENTLY 0 IN #ExpandedClientsTable
	UPDATE #ExpandedClientsTable
	SET companyId = C1.companyId
	FROM #ExpandedClientsTable C
	JOIN
	(
		SELECT * FROM
		(
			SELECT ACP.componentNameId companyId, CT.clientId clientId, ROW_NUMBER() OVER (PARTITION BY CT.clientId ORDER BY ACP.componentNameId) AS rownumber
			FROM #ExpandedClientsTable CT
INNER JOIN APP_ClientGroupAssoc ACGA ON CT.errorCode <> (1800 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND CT.companyId = 0 AND CT.clientId = ACGA.clientId
			INNER JOIN App_CompanyProp ACP ON ACP.attrVal = CAST(ACGA.clientGroupId AS NVARCHAR(12))
AND ACP.attrName='Associated Smart Client Group' AND cs_attrName = checksum('Associated Smart Client Group') AND ACP.modified = 0
		) C2 WHERE rownumber = 1
	) C1 ON C.clientId = C1.clientId
	-- UPDATE OTHER INFORMATION IN #ExpandedClientsTable
	UPDATE CLIENTS
SET isPseudoClient = (CASE WHEN C.specialClientFlags & 0x2 <> 0 THEN 1 ELSE 0 END),
clientName = C.name, isCompanyDeleted = (CASE WHEN (P.id IS NULL) OR (P.flags & 0x0002 = 0x0002) THEN 1 ELSE 0 END)
	FROM #ExpandedClientsTable CLIENTS
	JOIN App_Client C ON CLIENTS.clientId = C.id
	LEFT JOIN UMDSProviders P ON CLIENTS.companyId = P.id
WHERE CLIENTS.errorCode <> (1800 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	-- SECURITY CHECK FOR NON CS ADMIN USER
	-- SECURITY CHECK WILL NOT HAPPEND HERE FOR RETIRE CLIENTS REQUEST COMING FROM EVMGRS FOR AUTO DELETION, BECAUSE THE USER IS CS ADMIN USER
	DECLARE @masterGroupId INT = dbo.getMasterGroupId()
	IF @masterGroupId NOT IN (SELECT groupId FROM UMUserGroup WHERE userId = @userId)
	BEGIN
		DECLARE @newEntityList XML
		DECLARE @isAllowed INT = 0, @entitiesNotAllowed NVARCHAR(MAX) = ''
		SET @newEntityList = (SELECT
		(
SELECT clientId AS '@clientId', 3 AS '@_type_'
			FROM #ExpandedClientsTable
			FOR XML PATH ('associations'), TYPE
		)
		FOR XML PATH('CVGui_CommCellTreeNode'))
EXEC sec_checkPermissionOnEntityList @userId, @localeId, @newEntityList, '', 253, @isAllowed OUTPUT, @entitiesNotAllowed OUTPUT
		IF @isAllowed <> 1
		BEGIN
SET @noPermissionErrorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			-- PARSE @entitiesNotAllowed STRING GET CLIENTS THAT USER DOES NOT HAVE DELETE PERMISSION ON
			IF @entitiesNotAllowed IS NOT NULL AND @entitiesNotAllowed <> ''
			BEGIN
				DECLARE @startPos INT = CHARINDEX('{', @entitiesNotAllowed)
				DECLARE @endPos INT = CHARINDEX('}', @entitiesNotAllowed, @startPos)
				DECLARE @substring NVARCHAR(MAX) = SUBSTRING(@entitiesNotAllowed, @startPos + 1, @endPos - @startPos - 1)
				UPDATE CLIENTS
SET errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				FROM #ExpandedClientsTable CLIENTS
				JOIN
				(
					SELECT LTRIM(RTRIM(data)) AS clientName FROM [dbo].SplitString(@substring, ',')
				) C ON CLIENTS.clientName = C.clientName
			END
			ELSE
			BEGIN
				UPDATE #ExpandedClientsTable
SET errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			END
		END
	END
	SET @outputEntitiesStr =
	(
		SELECT isPseudoClient AS '@isPseudoClient', isCompanyDeleted AS '@isCompanyDeleted',
errorCode AS 'error/@errorCode', (CASE WHEN errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) THEN @noPermissionErrorString ELSE errorString END) AS 'error/@errorMessage',
			clientId AS 'clientEntity/@clientId', clientName AS 'clientEntity/@clientName'
		FROM #ExpandedClientsTable
		FOR XML PATH('client')
	)
PROC_EXIT:
	IF @errorCode <> 0 AND @errorString <> ''
	BEGIN
		SET @errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @errorCode and localeId = @localeId)
	END
	SET @outputErrorStr = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ('error'))
	DECLARE @outputStr NVARCHAR(MAX) = ISNULL(@outputEntitiesStr, '') + ISNULL(@outputErrorStr, '')
	SET @xmlstr = @outputStr
	SET @xmlstr = (SELECT @xmlstr FOR XML PATH(''), ROOT('App_ClientEntitiesForDeletion'))
	SELECT @xmlstr
	IF object_id('tempdb.dbo.#ExpandedClientsTable') IS NOT NULL
		DROP TABLE #ExpandedClientsTable
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAssociatedClientsForDeletion')
	delete from GxQscripts where name = 'AppGetAssociatedClientsForDeletion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssociatedClientsForDeletion')
	delete from GXDBVersions where aliasname = 'AppGetAssociatedClientsForDeletion'
GO

insert into GXDBVersions values(2, 'AppGetAssociatedClientsForDeletion',  '00000000000000000000', 'AppGetAssociatedClientsForDeletion', '00000000000000000000')
GO

