

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAssocToCMCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  			 	 AppGetAssocToCMCredentials							|
--	|		Return Credentials associated with the entity				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAssocToCMCredentials')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAssocToCMCredentials <<<'
	drop procedure AppGetAssocToCMCredentials
END
IF EXISTS (select * from GxQscripts where name='AppGetAssocToCMCredentials')
	delete from GxQscripts where name = 'AppGetAssocToCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssocToCMCredentials')
	delete from GXDBVersions where aliasname = 'AppGetAssocToCMCredentials'
GO
print '... Creating Procedure: AppGetAssocToCMCredentials'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAssocToCMCredentials
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_assocId integer,
  @i_credentialId integer
-----------------------------------------------------------
AS
  DECLARE @o_userName nvarchar(MAX);
  DECLARE @o_password nvarchar(MAX);
  DECLARE @o_credentialInfoXml xml;
  DECLARE @o_flags int;
  DECLARE @o_recordType int;
IF OBJECT_ID('tempdb.dbo.#AssocToCMCredentials') IS NOT NULL DROP TABLE #AssocToCMCredentials
CREATE TABLE #AssocToCMCredentials (
assocId 			INTEGER,
credentialId 		INTEGER,
userName			nvarchar(MAX) default '',
password			nvarchar(MAX) default '',
credentialInfoXml   xml default '',
flags				int default 0,
recordType			int default 0
)
INSERT INTO #AssocToCMCredentials (assocId, credentialId)
	SELECT @i_assocId, @i_credentialId
SET NOCOUNT ON
BEGIN
	UPDATE TEMP
	SET TEMP.credentialId = Assoc.credentialId
	FROM #AssocToCMCredentials TEMP
		INNER JOIN APP_CredentialAssoc Assoc ON TEMP.assocId = Assoc.assocId
	WHERE TEMP.credentialId <= 0
	UPDATE TEMP
	SET TEMP.userName = Creds.userName,
		TEMP.password = (case when Creds.password = '' then '' else dbo.pswConvertV5ToV3(Creds.password) end),
		TEMP.credentialInfoXml = Creds.credentialInfo,
		TEMP.flags = Creds.flags,
		TEMP.recordType = Creds.recordType
	FROM #AssocToCMCredentials TEMP
		INNER JOIN APP_Credentials Creds ON TEMP.credentialId = Creds.credentialId
END
SET NOCOUNT OFF
SELECT TOP 1 userName, password, credentialInfoXml, flags, recordType
FROM #AssocToCMCredentials
IF OBJECT_ID('tempdb.dbo.#AssocToCMCredentials') IS NOT NULL DROP TABLE #AssocToCMCredentials
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAssocToCMCredentials')
	delete from GxQscripts where name = 'AppGetAssocToCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAssocToCMCredentials')
	delete from GXDBVersions where aliasname = 'AppGetAssocToCMCredentials'
GO

insert into GXDBVersions values(2, 'AppGetAssocToCMCredentials',  '00000000000000000000', 'AppGetAssocToCMCredentials', '00000000000000000000')
GO

