

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetArrayReplicationEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppLiveSyncReplicationsGetInfo						|
--	|		 Procedure to get replication information					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetArrayReplicationEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppGetArrayReplicationEntities <<<'
	drop procedure AppGetArrayReplicationEntities
END
IF EXISTS (select * from GxQscripts where name='AppGetArrayReplicationEntities')
	delete from GxQscripts where name = 'AppGetArrayReplicationEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetArrayReplicationEntities')
	delete from GXDBVersions where aliasname = 'AppGetArrayReplicationEntities'
GO
print '... Creating Procedure: AppGetArrayReplicationEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetArrayReplicationEntities
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString			XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @sourceClientId		INT
	DECLARE @userId				INT
	DECLARE @subclientId		INT
	DECLARE @copyId				INT
	DECLARE @pairId				INT
	DECLARE @targetArrayNum     INT
	declare @virtualClientId    INT =0
	-- READ THE XML
	SELECT  @userId = ISNULL(ref.value('processinginstructioninfo[1]/user[1]/@userId', 'INT'), 1),
			@subclientId = ISNULL(ref.value('subclient[1]/@subclientId', 'INT'), 0),
			@virtualClientId = ISNULL(ref.value('source[1]/@clientId', 'INT'), 0),
			@copyId = ISNULL(ref.value('@copyId', 'INT'), 0)
			FROM @i_xmlString.nodes ('Api_GetArrayReplicationEntities') R(ref)
	if ( @virtualClientId =0)
	begin
		select @virtualClientId = clientid from app_application where id = @subclientId and apptypeid = 106
	end
	select @targetArrayNum = arrayNum from SMVMDatastore where VirtualClientId = @virtualClientId 	and DSName !='NO_NAME'
	IF object_id('tempdb.dbo.#arrayreplication_entities') is not null
		DROP TABLE #arrayreplication_entities
	CREATE TABLE #arrayreplication_entities
	(
		vmclientId		int,
		vmClientName    nvarchar(256),
		vmGUID			nvarchar(256),
		dsguid          nvarchar(256),
		copyId			int,
		jobid			int,
		servername		nvarchar(256)
	)
	if ( @subclientId >0 )
	begin
		insert into #arrayreplication_entities
			select  map.clientId, NULL, NULL, Ds.DSGuid, map.ReplicaCopyId, map.lastsyncjobid, null
		from SMVMReplicationMap map
		inner join SMVMDatastore DS
		on map.SourceDatastoreId = DS.id
		and VirtualClientId = @virtualClientId
		and ds.DSName !='NO_NAME'
		inner join ( select row_number() over (partition by cp.componentnameid order by cp.id desc )as rn, map.clientid, cast(cp.attrVal as int) subclientId from app_clientprop cp
		inner join SMVMReplicationMap map
		on cp.componentNameId = map.ClientId
		and cp.attrName ='VSA Discover Subclient ID'
		and cp.modified =0
		 ) t
		on t.subclientId = @subclientId
		and t.ClientId = map.ClientId
		and t.rn =1
		inner join ( select clientId, ReplicaCopyId, max(LastSyncJobId) lastsyncjobid
					 from SMVMReplicationMap
					 group by clientid , ReplicaCopyId
					 ) svm
		on map.ReplicaCopyId = svm.ReplicaCopyId
		and map.clientid = svm.clientid
		and map.lastsyncjobid = svm.lastsyncjobid
		and map.ReplicaCopyId > 0
	end
	else
	begin
		insert into #arrayreplication_entities
		select  map.clientId, NULL, NULL, Ds.DSGuid, map.ReplicaCopyId, t.LastSyncJobId, null
		from SMVMReplicationMap map
		inner join SMVMDatastore DS
		on map.SourceDatastoreId = DS.id
		and VirtualClientId = @virtualClientId
		and ds.DSName !='NO_NAME'
		inner join ( select clientId, ReplicaCopyId, max(LastSyncJobId) lastsyncjobid
					 from SMVMReplicationMap
					 group by clientid , ReplicaCopyId
					 ) t
		on map.ReplicaCopyId = t.ReplicaCopyId
		and map.clientid = t.clientid
		and map.lastsyncjobid = t.lastsyncjobid
		and map.ReplicaCopyId > 0
	end
	delete LS
	from #arrayreplication_entities LS
	inner join    APP_ClientProp ACP1
	ON ACP1.componentNameId= LS.vmclientId AND ACP1.attrName='Virtual Machine Deletion Time' AND ACP1.modified=0 AND isnull(ACP1.attrVal,0) <>'0'
	update AE
	set vmClientName = c.displayName,
		vmGUID = cp.attrVal
	from #arrayreplication_entities AE
	inner join app_client c
	on AE.vmclientId = c.id
	inner join app_clientprop cp
	on c.id = cp.componentNameId
	and cp.modified =0
	and cp.attrName ='Virtual Machine Instance UUID'
	DECLARE @datastores  TABLE
	(
		dsName      nvarchar(256),
		dsGUID		nvarchar(256),
		copyId		int
	)
	insert into @datastores
	select distinct  DSName, AE.DSGuid, copyId from #arrayreplication_entities AE
	inner join SMVMDatastore DS
	on AE.dsguid = DS.DSGuid
	   update LS
	  set servername = vmprop.attrVal
	  from #arrayreplication_entities LS
	  inner join app_vmprop vmprop
	  on LS.vmclientId = vmprop.vmclientId
	  and vmprop.attrname = 'vmHost'
	  inner join jmjobdatalink jl
	  on jl.childJobId  = LS.jobid
	  and jl.linkType =7
	  and vmprop.jobid = jl.parentJobId
	---- FORM THE XML RESPONSE
	SET @o_xmlString =
				(
					select
					(select
						  DSName as 'datastore/@strDatastorename',
						  DSGuid as 'datastore/@strDatastoreUUID',
					   	  (
							  select distinct ag.name as '@storagePolicyName', ag.id as '@storagePolicyId', agc.id as '@copyId', agc.name as '@copyName'
							  from archGroup ag
						   							  inner join archGroupCopy agc
							  on ag.id = agc.archGroupId
							  and agc.id = copyId
							  for xml path('copy'), TYPE
							),
						   ( select
						   			distinct vmclientId as '@clientId',
					                vmClientName as '@clientName',
						            vmGUID as '@clientGUID' ,
									servername as '@hostName'
									from #arrayreplication_entities AE
						            where dsGUID  = DS.dsGUID
							for xml path('vm'), TYPE
							)
							from @datastores DS
					for xml path ('datastoreMap'), type)
					for xml path ('Api_ArrayReplicationEntitiesResp')
				)
	END
ERROR_EXIT:
	IF @errorCode <> 0
		SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('App_GenericResp'), TYPE)
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<Api_ArrayReplicationEntitiesResp/>'
	SELECT @o_xmlString AS o_xmlString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetArrayReplicationEntities')
	delete from GxQscripts where name = 'AppGetArrayReplicationEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetArrayReplicationEntities')
	delete from GXDBVersions where aliasname = 'AppGetArrayReplicationEntities'
GO

insert into GXDBVersions values(2, 'AppGetArrayReplicationEntities',  '00000000000000000000', 'AppGetArrayReplicationEntities', '00000000000000000000')
GO

