

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetArchFileInfoForJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Example input <Indexing_GetArchFileInfoForJobs backupSetGuid="guid" dbGuid="guid"/>
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetArchFileInfoForJobs')
BEGIN
	print '>>> Drop Stored Procedure: AppGetArchFileInfoForJobs <<<'
	drop procedure AppGetArchFileInfoForJobs
END
IF EXISTS (select * from GxQscripts where name='AppGetArchFileInfoForJobs')
	delete from GxQscripts where name = 'AppGetArchFileInfoForJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetArchFileInfoForJobs')
	delete from GXDBVersions where aliasname = 'AppGetArchFileInfoForJobs'
GO
print '... Creating Procedure: AppGetArchFileInfoForJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetArchFileInfoForJobs
  @xmlText XML
AS
DECLARE @indexCheckPointInfo BIT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@isIndexBackupInfo)[1]', 'bit'), 0)
DECLARE @isSubclientPruned	 BIT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@isSubclientPruned)[1]', 'bit'), 0)
DECLARE @fullReconstruction BIT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@isFullReconstruction)[1]', 'bit'), 0)
DECLARE @validateAfiles     BIT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@validatAfiles)[1]', 'bit'), 0)
DECLARE @mediaPrediction    BIT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@isMediaPrediction)[1]', 'bit'), 0)
DECLARE @useCopyPrecdenceForCheckpoint    BIT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@useCopyPrecdenceForCheckpoint)[1]', 'bit'), 0)
DECLARE @copyPrecedence     INT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@copyPrecedence)[1]', 'INT'), 0)
DECLARE @fromTime			INT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@fromTime)[1]', 'INT'), 0)
DECLARE @toTime				INT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@toTime)[1]', 'INT'), 0)
DECLARE @jobiD				INT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@jobiD)[1]', 'INT'), 0)
DECLARE @runningJobiD		INT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@runningJobId)[1]', 'INT'), 0)
DECLARE @minidxAfileCtime	INT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@minidxAfileCtime)[1]', 'INT'), 0)
DECLARE @outxmlText XML
DECLARE @dbGuid varchar(max) = @xmlText.value('(/Indexing_GetArchFileInfoForJobs/@dbGuid)[1]', 'varchar(max)')
DECLARE @backupSetGuid varchar(max) = @xmlText.value('(/Indexing_GetArchFileInfoForJobs/@backupSetGuid)[1]', 'varchar(max)')
DECLARE @dbEngineType     INT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@dbEngineType)[1]', 'INT'), 0)
DECLARE @backupSetId    integer
DECLARE @clientId       integer
DECLARE @appType        integer
DECLARE @upgradeTime    integer
DECLARE @chkpointFileName nvarchar(max)
DECLARE @paramDefinition nvarchar(max)
DECLARE @dynamicQuery nvarchar(max)
DECLARE @liveSnapJobQuery nvarchar(max)
DECLARE @query1 nvarchar(max)
DECLARE @query2 nvarchar(max)
DECLARE @upgradeQuery nvarchar(max)
DECLARE @isIndexInfoMissing INT = 0
DECLARE @afilecount         INT = 0
DECLARE @includeAgedData 	INT = 0
DECLARE @idxAppType int
DECLARE @errorCode int = 0;
DECLARE @appId int
DECLARE @topCount INT = 0
DECLARE @lastCheckPointTime INT = 0
DECLARE @missingJobsPresent	BIT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@missingJobs)[1]', 'bit'), 0)
DECLARE @latestIdxAfCtime	BIGINT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/@latestIdxAfCtime)[1]', 'BIGINT'), 0)
DECLARE @pruningRetCycle INT = 1 -- For latest cycle key it is 1
DECLARE @pruningRetDays INT = 0
DECLARE @pruningType INT = 0
DECLARE @subclientId INT = 0
DECLARE @lognamechecksum INT = CHECKSUM(N'IdxLogs_V1')
DECLARE @liveUpdateCTime INT = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/archFileInfoList/@liveUpdateAfileCtime)[1]', 'INT'), 0)
IF object_id('tempdb.dbo.#tempafiles')          IS NOT NULL DROP TABLE #tempafiles
IF object_id('tempdb.dbo.#tempAppIds')          IS NOT NULL DROP TABLE #tempAppIds
IF object_id('tempdb.dbo.#tempMissingJobs')     IS NOT NULL DROP TABLE #tempMissingJobs
IF object_id('tempdb.dbo.#tempValidAFiles')     IS NOT NULL DROP TABLE #tempValidAFiles
IF object_id('tempdb.dbo.#tmpV1NASDeferredJob')     IS NOT NULL DROP TABLE #tmpV1NASDeferredJob
IF object_id('tempdb.dbo.#tmpPruningChkpPtInfo')     IS NOT NULL DROP TABLE #tmpPruningChkpPtInfo
CREATE TABLE #tempAfiles (  commCellId INT,
                            jobId INT,
                            aFileId INT,
                            aFileType INT,
                            aGroupId INT,
                            cTime INT,
                            isV2Job INT,
	                        appId INT,
                            lastSeenMaHostName nvarchar(max),
                            lastSeenMaClientName nvarchar(max),
                            maCvdPort INT,
                            maEvmgrcPort INT,
							copyValid INT,
                            cycleNum INT,
							skipCatalog INT,
							mediaName nvarchar(max),
							isOnline INT,
							itemsIndexed INT,
							skipOnRestoreFailure INT,
							jobStartTime	INT,
							isSynthFull	INT,
							prunedCheckPtStartTime BIGINT,
							prunedCheckPtEndTime BIGINT,
							isvalid INT,
							isMissingJob BIT,
							isRunningJob BIT,
							isBlockLevel BIT,
							indexSize BIGINT,
							delayedCatalogAFile INT,
							isLastSeenMaOnline BIT
							PRIMARY KEY (aFileId, commCellId))
CREATE TABLE #tempAppIds        (appId INT, aFileCtime INT, completedJobId INT, lastFullCTimeBeforeUpgrade INT, isDaysBasedRetention INT)
CREATE TABLE #tempMissingJobs   (jobId INT NOT NULL, jobIdActedOn INT NOT NULL , bkpType INT NOT NULL,catalogSnap bit NOT NULL, commCellId INT NOT NULL,  PRIMARY KEY (JobId, bkpType, CommCellId))
CREATE TABLE #tempValidAFiles   (jobId INT, aFileNum INT, commCellNum INT, isValid INT, commCellId INT)
CREATE TABLE #tmpV1NASDeferredJob(jobid int,maxAfileId int)
CREATE TABLE #tmpPruningChkpPtInfo (checkPtAfileId INT, startTime BIGINT, endTime BIGINT, commCellId INT)
SELECT @includeAgedData = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'ShowAgedDataForBrowseAndRecovery'
SET @chkpointFileName   = 'IdxCheckPoint_' + @backupsetGuid + ':' + @dbGuid
SELECT @backupsetid     = backupsetid, @appType = type from App_IndexDBInfo WITH (NOLOCK) WHERE backupSetGUID = @backupsetGuid
DECLARE @subclientIndexEnabled INT = dbo.isSubClientIndexEnabled(@backupsetid)
IF @copyPrecedence < 0
BEGIN
	--For special copy precedence, this stored proc will default to primary copy. This needs to be reset because we've index restore code setting negative values for copy precedence which is not applicable
	--for index restore operation
	SET @copyPrecedence = 0
END
--Determine Indexing AppType
SELECT TOP 1 @clientId  = clientId, @appId = id  FROM APP_Application WITH (NOLOCK) WHERE backupSet = @backupSetId
EXEC appgetindexingapptype @appType, @appId, @idxAppType OUTPUT, @errorCode OUTPUT
--get v2 upgrade time
SELECT @upgradeTime     = created   FROM APP_ClientProp     WITH (NOLOCK) WHERE attrName = dbo.GetIndexingV2PropNameByAppType(@idxAppType) AND attrVal = '1' AND componentNameId = @clientId AND modified = 0
-- for cloud laptop pick jobs only after cloud laptop conversion time
DECLARE @cloudlapopSetTime INT
SELECT @cloudlapopSetTime = SCP.created FROM APP_SubClientProp SCP WITH(NOLOCK)
				INNER JOIN APP_Application APP WITH(NOLOCK) ON SCP.componentNameId = APP.id
				WHERE SCP.attrName = 'Cloud Mode Enabled' AND SCP.attrVal = N'1' AND SCP.modified = 0 AND APP.backupset = @backupsetid
IF @cloudlapopSetTime IS NOT NULL
	SET @fromTime = @cloudlapopSetTime
--get 3 checkpoints for checkpoint info
--get 1 checkpoint for index media prediction
IF @indexCheckPointInfo = 1
BEGIN
   SET @topCount = 3
   -- This section of code is for Hilton where checkpoint is not available for restore.
   DECLARE @cGroupName NVARCHAR(1024) = '';
   SELECT @cGroupName = value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'Disable Checkpoint Restore' AND modified = 0
   IF LEN(@cGroupName) > 0 AND EXISTS( select TOP 1 1 from APP_ClientGroup CG WITH(NOLOCK)
	JOIN APP_ClientGroupAssoc CGA WITH(NOLOCK) ON CG.id = CGA.clientGroupId
	JOIN APP_Application App WITH(NOLOCK) ON App.clientId = CGA.clientId
	JOIN APP_BackupSetName BS WITH(NOLOCK) ON BS.id = App.backupSet
	where CG.name = @cGroupName AND BS.GUID = @backupSetGuid)
	   SET @topCount = 0
END
ELSE IF @mediaPrediction = 1
BEGIN
    SET @topCount = 1
	-- This case is when we do job level list media. The request comes directly through EvMgrs and we can set isSubclientPruned flag and latestIdxAfCtime
	IF @subclientIndexEnabled > 0 AND @isSubclientPruned = 0
	BEGIN
		SELECT @isSubclientPruned = flags&1 from App_IndexDBInfo WITH (NOLOCK) WHERE dbName = @dbGuid
		IF @latestIdxAfCtime = 0
			SELECT @latestIdxAfCtime = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/cycleBrowseParam/@toTime)[1]', 'BIGINT'), 0)
	END
END
DECLARE @skipDeletedSubclients INT =
ISNULL((select 1 from GXGlobalParam WITH (NOLOCK) WHERE name='IDX_UPGRADE_SKIP_DELETED_V1_SUBCLIENTS' and modified=0 and value='1'),0)
DECLARE @isLatestCycleEnabled INT =
ISNULL((select 1 from GXGlobalParam WITH (NOLOCK) WHERE name='IDX_RECON_SKIP_OLD_CYCLES' and modified=0 AND (value='*' OR VALUE LIKE '%' + @backupSetGuid +'%')),0)
DECLARE @createNewIndexRegKey INT =
	ISNULL((select value from GXGlobalParam WITH (NOLOCK) WHERE name='CREATE_NEW_INDEX' and modified=0 ),0)
DECLARE @createNewIndex INT = 0
DECLARE @lastFailedPlaybackJobId INT = 0
DECLARE @isBlockLevelSubclient INT = 0
DECLARE @isArchivingSubclient INT = 0
DECLARE @isSnapjobPresent INT = 0
IF(@subclientIndexEnabled > 0)
BEGIN
	SELECT @subclientId = id FROM APP_Application WITH(NOLOCK) WHERE GUID = @dbGuid
	IF EXISTS(SELECT 1 FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Use block level backup' AND attrVal = N'1' AND modified = 0 AND cs_attrName = CHECKSUM(N'Use block level backup'))
		SET @isBlockLevelSubclient = 1
	IF EXISTS(SELECT 1 FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Is Turbo Subclient' AND attrVal = N'1' AND modified = 0 AND cs_attrName = CHECKSUM(N'Is Turbo Subclient'))
		SET @isArchivingSubclient = 1
	IF EXISTS(SELECT 1 FROM jmbkpstats WITH (NOLOCK) WHERE appid = @subclientId AND opType IN (59,60))
		SET @isSnapjobPresent = 1
	DECLARE @dbPropertiesXml XML
	DECLARE @idxDbstateError INT = 0
	SELECT @idxDbstateError = idxdb.errorLvl, @dbPropertiesXml = idxdb.properties FROM IdxDbState idxdb WITH (NOLOCK)
	JOIN App_IndexDBInfo dbinfo WITH (NOLOCK) ON dbinfo.id = idxdb.dbid AND idxdb.errorLvl > 0
	WHERE dbinfo.dbName = @dbGuid AND dbinfo.backupSetGUID = @backupSetGuid AND idxDbEngineType=@dbEngineType
	IF @idxDbstateError > 0 AND @dbEngineType = 1 AND @createNewIndexRegKey = 1 AND @isArchivingSubclient = 0
	BEGIN
		SET @lastFailedPlaybackJobId = @dbPropertiesXml.value('(/Indexing_DbStats/@lastFailedPlaybackJobId)[1]','INT')
		DECLARE @failedJobCycleNum INT = 0
		DECLARE @latestCycleNum INT = 0
		DECLARE @latestCycleStartTime INT = 0
		SELECT @failedJobCycleNum = fullCycleNum FROM jmbkpstats WITH (NOLOCK) WHERE jobId = @lastFailedPlaybackJobId
		SELECT @latestCycleNum = MAX(fullCycleNum) FROM jmbkpstats WITH (NOLOCK) WHERE status IN (1,3,14) AND appid = @subclientId
		SELECT @latestCycleStartTime = min(servStartDate) FROM jmbkpstats WITH (NOLOCK) WHERE fullCycleNum = @latestCycleNum AND appid = @subclientId
		--Do we need special handling for snap/backup copy job
		IF ( @latestCycleNum > @failedJobCycleNum AND @minidxAfileCtime > @latestCycleStartTime)
		BEGIN
			SET @createNewIndex = 1
			SET @isLatestCycleEnabled = 1
		END
	END
END
IF @isSubclientPruned = 1
BEGIN
	INSERT INTO #tmpPruningChkpPtInfo
	SELECT TOP (@topCount) afileId, startTime, endTime, commcellId FROM
	App_IndexCheckpointInfo Info WITH(NOLOCK)
	WHERE dbName = @dbGuid AND startTime <= @latestIdxAfCtime AND endTime > @latestIdxAfCtime AND flags&1 = 1
	ORDER BY afileId DESC
	--If no checkpoint is found in the range we should always pick the latest available and build on TOP of it.
	IF @mediaPrediction = 0 AND @@ROWCOUNT = 0
		INSERT INTO #tmpPruningChkpPtInfo
		SELECT TOP (1) afileId, startTime, endTime, commcellId FROM
		App_IndexCheckpointInfo Info WITH(NOLOCK)
		WHERE Info.dbName = @dbGuid AND flags&1 = 1
		ORDER BY endTime DESC, afileId DESC
	IF @mediaPrediction = 1
	BEGIN
		SET @topCount = @topCount + 1
	--Incase of list media we also need to populate latest checkpoint always
		INSERT INTO #tmpPruningChkpPtInfo
		SELECT TOP (1) afileId, startTime, endTime, commcellId FROM
		App_IndexCheckpointInfo Info WITH(NOLOCK)
		WHERE Info.dbName = @dbGuid AND flags&1 = 1
		AND NOT EXISTS(SELECT 1 FROM #tmpPruningChkpPtInfo tmp WHERE tmp.checkPtAfileId = info.afileId AND tmp.commcellId = info.commcellId )
		ORDER BY endTime DESC, afileId DESC
		SELECT @fromtime = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/cycleBrowseParam/@fromTime)[1]', 'BIGINT'), 0)
		SELECT @toTime = ISNULL(@xmlText.value('(/Indexing_GetArchFileInfoForJobs/cycleBrowseParam/@toTime)[1]', 'BIGINT'), 0)
		--If from time is 0, return results only from latest cycle belonging to toTime
		IF @fromtime = 0
		BEGIN
			DECLARE @maxCtime INT = 0
			SELECT @maxCtime = MAX(ctime) FROM Archfile AF WITH(NOLOCK) WHERE ctime <= @toTime AND Af.appid = @subclientId AND AF.isValid = 1
			SELECT @fromtime = MAX(servStartDate) FROM jmbkpstats WITH(NOLOCK) WHERE status IN (1,3,14) AND bkplevel in (1,64,128,16384) AND appid = @subclientId AND optype <> 60
			AND fullcyclenum <= ( SELECT MAX(fullcyclenum) FROM jmbkpstats WITH(NOLOCK) WHERE servStartDate < @maxCtime AND status IN (1,3,14) AND appid = @subclientId AND optype <> 60)
		END
	END
END
-- for secondary solr server, we need to index only latest cycle and skip snap jobs
DECLARE @skipSnapJobs INT = 0
IF @dbEngineType = 2
BEGIN
	DECLARE @isprimary INT
	SELECT TOP(1) @isprimary = isPrimary FROM App_IndexDBInfo WITH(NOLOCK) WHERE idxDbEngineType=@dbEngineType AND backupSetGUID = @backupSetGuid
	IF @isprimary = 0
	BEGIN
		SET @isLatestCycleEnabled = 1
		SET @skipSnapJobs = 1
	END
END
IF @mediaPrediction = 0 AND EXISTS(SELECT 1 FROM GXGlobalParam WITH (NOLOCK) WHERE name='Enable Index Pruning' and modified=0 and value='1')
BEGIN
	IF object_id('tempdb.dbo#pruningOpts')     IS NOT NULL DROP TABLE #pruningOpts
	CREATE TABLE #pruningOpts(entityId INT, enablePruning INT DEFAULT 0, retDays	INT DEFAULT -1, retCycles INT DEFAULT -1, pruningType INT DEFAULT 0)
	DECLARE @id INT = @backupSetId
	IF(@subclientIndexEnabled > 0)
		SELECT @id = @subclientId
	INSERT INTO #pruningOpts SELECT * FROM dbo.GetIndexServerPruningSettings (@id, @subclientIndexEnabled)
	DECLARE @entityId INT = 0
	IF(@subclientIndexEnabled = 0)
	BEGIN
		IF EXISTS(SELECT 1 FROM APP_BackupSetProp WITH (NOLOCK) WHERE componentNameId = @id AND attrname='Enable Index Pruning' and modified = 0 and attrVal='1')
		 BEGIN
			SET @entityId = @id
		 END
	END
	ELSE
	BEGIN
		IF EXISTS(SELECT 1 FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @id AND attrname='Enable Index Pruning' AND cs_attrName = CHECKSUM(N'Enable Index Pruning')  and modified = 0 and attrVal='1')
		 BEGIN
			SET @entityId = @id
		 END
		 IF EXISTS(SELECT 1 FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'ReconIndexWithLatestCycle' AND modified = 0)
			SET @isLatestCycleEnabled = 1
	END
	SELECT @pruningRetDays = retDays, @pruningRetCycle = retCycles, @pruningType = pruningType
	FROM #pruningOpts WHERE entityId = @entityId
	 --If @pruningRetCycle is less than 2 we will default to 2 cycles
	 -- for days based retention also we need to make sure to retain minimum 2 cycles.
	 IF @pruningRetCycle = 0 OR @pruningType = 2
		SET @pruningRetCycle = 2
	IF @isLatestCycleEnabled > 0
		SET @pruningRetCycle = 1
	IF object_id('tempdb.dbo#pruningOpts')     IS NOT NULL DROP TABLE #pruningOpts
END
--Add missing jobs in index to #tempMissingJobs to add corresponding afiles later.
IF @missingJobsPresent = 1
BEGIN
INSERT INTO #tempMissingJobs
		SELECT N.value('@jobId','integer')jobId,
			(ISNULL(N.value('@jobIdActedOn','integer'),0))jobIdActedOn,
			(CASE WHEN N.value('@snapJob', 'bit') = 1 THEN 6 ELSE 2 END) bkpType,
			(ISNULL(N.value('@catalogSnap', 'bit'), 0)) catalogSnap,
			N.value('@commcellId','integer')commCellId
			FROM @xmlText.nodes('/Indexing_GetArchFileInfoForJobs/missingJobList/jobInfoList') AS T(N)
END
--Get valid afiles for checkpoints for given copy precedence
IF (@topCount > 0)
BEGIN
INSERT INTO #tempAfiles SELECT TOP (@topCount)
    AF.commCellId           AS commCellId,
    AF.jobId                AS jobId,
    AF.id                   AS aFileId,
    AF.fileType             AS aFileType,
    AF.archGroupId          AS aGroupId,
    AF.ctime                AS cTime,
    1		                AS isV2Job,
    AF.appId                AS appID,
    ''                      AS lastSeenMaHostName,
    ''                      AS lastSeenMaClientName,
    0                       AS maCvdPort,
    0                       AS maEvmgrcPort,
	1						AS copyValid,
    0       				AS cycleNum,
	0						AS skipCatalog,
	''						AS mediaName,
	0						AS isOnline,
	0						AS itemsIndexed,
	0						AS skipOnRestoreFailure,
	0						AS jobStartTime,
	0						AS isSynthFull,
	tmpInfo.startTime		AS prunedCheckPtStartTime,
	tmpInfo.endTime			AS prunedCheckPtEndTime,
	1 AS isValid,
	0 AS isMissingJob,
	0 AS isRunningJob,
	0 AS isBlockLevel,
	Max(AFC.unCompSize) as indexSize,
	0 AS delayedCatalogAFile,
	0 AS isLastSeenMaOnline
    FROM archFile           AF WITH (NOLOCK)
	LEFT JOIN #tmpPruningChkpPtInfo tmpInfo ON AF.id = tmpInfo.checkPtAfileId
	JOIN archFileCopy		AFC		WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
    JOIN archGroupCopy		AGC		WITH (NOLOCK) ON AFC.archCopyId = AGC.id
    WHERE  AF.isValid = 1 AND
	( cs_afname = CHECKSUM(@chkpointFileName) AND AF.name = @chkpointFileName )
			AND (@useCopyPrecdenceForCheckpoint = 0 OR @copyPrecedence = 0 OR (AGC.copy = @copyPrecedence))
			AND (AFC.flags & 256 = 0) AND AFC.isValid = 1
			AND(@isSubclientPruned = 0 OR tmpInfo.checkPtAfileId IS NOT NULL) -- If subclient pruning is done find out AfileId based on tmpPruningChkpPtInfo only
	GROUP BY
				AF.commCellId,
                AF.jobId,
                AF.id,
                AF.fileType,
                AF.archGroupId,
                AF.ctime,
                AF.name,
                AF.appId,
				tmpInfo.startTime,
				tmpInfo.endTime
	ORDER BY AF.cTime desc
END
--Populate table #tempAppIds #tempValidAFiles and add extra afiles to #tempAfiles
--skip this for indexcheckpoint info
IF (@indexCheckPointInfo = 0)
BEGIN
		IF (@toTime = 0 AND @jobiD = 0)
			SET @toTime = 0X7FFFFFFF
		 -- Unless to time is set OR missingJobs is present, do not consider aged jobs.
		IF(@toTime = 0X7FFFFFFF AND @missingJobsPresent = 0)
			SET @includeAgedData = 0
		--Get last checkpoint time to get all IDXLog afiles for each subclient with ctime greater than lastcheckpoint.
		--For latest cycle index and media prediction for older jobs, logs would have cTime lesser than checkpointTime
		IF (@mediaPrediction = 1 AND @isLatestCycleEnabled!=1)
		BEGIN
			SELECT @lastCheckPointTime = cTime from #tempAfiles
			IF @isSubclientPruned > 0
				SELECT @lastCheckPointTime = 0
		END
		--Populate #tempAppIds
        INSERT INTO #tempAppIds
        SELECT APP.id, T.N.value('@cTime', 'INT'), T.N.value('@jobId', 'INT'), 0, 0 FROM @xmlText.nodes('/Indexing_GetArchFileInfoForJobs/archFileInfoList') AS T(N)
        JOIN  APP_Application as APP WITH (NOLOCK) ON APP.GUID = T.N.value('@appGUID', 'uniqueidentifier')
		-- remaining subclients
		INSERT INTO #tempAppIds
		SELECT APP.id, 0, 0, 0, 0 FROM APP_Application APP WITH(NOLOCK)
		WHERE APP.backupSet = @backupSetId
		AND(@subclientIndexEnabled = 0 OR APP.GUID = @dbGuid)
		AND(@skipDeletedSubclients = 0
		OR (APP.subclientStatus & 4 = 0 OR EXISTS (select 1 from archFile af WITH (NOLOCK) where af.appId=app.id and filetype in (2,6) and cs_afname = @lognamechecksum and name = N'IdxLogs_V1'))) -- used direct value of checksum('idxlogs_v1)
		AND APP.id NOT IN(SELECT appId from #tempAppIds)
        --Either (cTime<upgrade time) or (day based retention sub-client)
        --       (day based retention sub-client)
		UPDATE TAPP SET TAPP.lastFullCTimeBeforeUpgrade =
		ISNULL((SELECT MIN(AF.cTime) FROM archFile AF WITH (NOLOCK) WHERE AF.APPID = TAPP.APPID AND AF.fileType IN (2,6) AND AF.isValid = 1), 0)
		FROM #tempAppIds TAPP
		JOIN APP_SubClientProp APROP WITH (NOLOCK) ON APROP.componentnameId = TAPP.appId AND APROP.modified = 0 AND APROP.cs_attrName = 138050575 -- CHECKSUM(N'Honor Archiver Agent Retention')
		WHERE APROP.attrName = 'Honor Archiver Agent Retention' AND APROP.attrVal='1'
		update #tempAppIds SET isDaysBasedRetention=1 where lastFullCTimeBeforeUpgrade>0
		-- NEW Exchnage Archiver Agent with apptype 137 does not have full job.
		if (@appType <> 137)
		BEGIN
			--      (cTime<upgrade time)
			-- select the first cycle to be considered for recon based on upgrade time
			UPDATE #tempAppIds SET lastFullCTimeBeforeUpgrade = ISNULL(T2.firstJobToReconStartTime, lastFullCTimeBeforeUpgrade)
			FROM #tempAppIds TAPP LEFT JOIN
			(SELECT J1.appId, MIN(J1.fullCycleNum) firstCycleToRecon FROM #tempAppIds TAPP
			JOIN  JMBkpStats J1 WITH (NOLOCK) ON J1.status IN (1,3,14) AND J1.appId = TAPP.appId
				AND ((TAPP.lastFullCTimeBeforeUpgrade = 0 AND J1.servStartDate >= @upgradeTime) OR
					 (TAPP.lastFullCTimeBeforeUpgrade <> 0 AND TAPP.lastFullCTimeBeforeUpgrade > J1.servStartDate))
				AND J1.fullCycleNum <> 0
				AND ((J1.dataStatus=0 and @includeAgedData = 0) OR (j1.dataStatus in (0,1) and @includeAgedData <> 0))
				GROUP BY J1.appId) T1
			CROSS APPLY
			(SELECT TOP 1 J2.servStartDate firstJobToReconStartTime FROM JMBkpStats J2 WITH (NOLOCK)
			 WHERE J2.status IN (1,3,14) AND T1.appId = J2.appId AND T1.firstCycleToRecon = J2.fullCycleNum AND J2.opType<>60 ORDER BY J2.cycleSequence) T2
			 ON TAPP.appId = T1.appid
			-- if nothing is found then set it to latest full start time
			DECLARE @curtime INT = DBO.GetUnixTime(GETUTCDATE())
			UPDATE TAPP SET lastFullCTimeBeforeUpgrade = (CASE WHEN JINFO.jobId IS NOT NULL THEN JINFO.jobStartTime ELSE ISNULL(JSTATS.latestCycleStartTime, @curtime) END)
			FROM #tempAppIds TAPP
			-- running full jobs
			LEFT JOIN (SELECT J.jobId, J.applicationId, J1.jobStartTime FROM JMBkpJobInfo J WITH (NOLOCK) JOIN JMJobInfo J1 WITH (NOLOCK) ON J.jobid = J1.jobid AND J.bkpLevel = 1) JINFO ON JINFO.applicationId = TAPP.appId
			CROSS APPLY -- optype 60 is backupcopy and optype  59 is snap and suboptype 96 is catalog snapshot job. Do not consider catalog snapshot and backup copy
			(SELECT TOP 1 J2.servStartDate latestCycleStartTime FROM JMBkpStats J2 WITH (NOLOCK) JOIN JMJobStats J3 WITH (NOLOCK) ON J2.appId = TAPP.appId AND J2.jobId =J3.jobId WHERE (J3.optype !=60 and (J3.opType!=59 OR J3.subOpType != 96)) and J2.bkpLevel IN (1, 64, 128, 16384) AND J2.status IN (1,3,14) ORDER BY J2.fullCycleNum DESC, J2.cycleSequence DESC) JSTATS
			WHERE TAPP.lastFullCTimeBeforeUpgrade = 0
		END
		--if validateAfiles is set and list of input afiles, add only valid afiles to #tempValidAFiles
        IF @validateAfiles = 1
        BEGIN
			INSERT INTO #tempValidAFiles
			SELECT AF.jobId, N.value('@afile', 'integer') aFileNum, N.value('@commcell', 'integer') commCellNum,
			(CASE WHEN (AF.isvalid = 1 AND isAfileValid = 1 AND isAged = 256) THEN 2 WHEN (AF.isValid = 1 AND isAfileValid = 1) THEN 1 ELSE 0 END) isValid, APC.id
			FROM @xmlText.nodes('/Indexing_GetArchFileInfoForJobs/validAfileList/afiles') AS T(N)
			JOIN APP_CommCell APC WITH (NOLOCK) ON APC.number = N.value('@commcell', 'integer')
			LEFT JOIN archFile AF WITH (NOLOCK) ON AF.id =  N.value('@afile', 'integer') AND AF.commCellId = APC.id
			AND EXISTS (SELECT 1 FROM #tempAppIds WHERE appId = AF.appId)
				CROSS APPLY
				(SELECT MAX(AFC.isValid) isAfileValid, MIN(AFC.flags & 256) isAged
				FROM archFileCopy AFC WITH (NOLOCK)
				WHERE AFC.archFileId = N.value('@afile', 'integer') AND AFC.commCellId = APC.id) TAFC
		END
		-- NAS V1 did not had index afile for skip catalog
IF @appType = 13
		BEGIN
			INSERT INTO #tempAfiles
			SELECT TAF.commCellId, TAF.jobId, TAF.id, TAF.fileType, TAF.archGroupId, TAF.cTime, 0, TAF.appId, '', '', 0, 0, 0, 0, 1, '', 0, 0, 0, JMBS.servStartDate, (CASE WHEN JMBS.bkpLevel IN (64, 128, 16384) THEN 1 ELSE 0 END), 0, 0, 0, 0, 0, 0, 0, 0, 0
			FROM #tempAppIds TAPP
			JOIN JMBkpStats JMBS WITH (NOLOCK) ON TAPP.appId = JMBS.appId AND JMBS.status IN (1,3,14)
				AND JMBS.servStartDate > TAPP.aFileCtime AND JMBS.servStartDate < @upgradeTime and JMBS.servEndDate >= TAPP.lastFullCTimeBeforeUpgrade AND (JMBS.bkpattributes & 0x200000000000000 <> 0)
				AND ((JMBS.servStartDate > @fromTime AND JMBS.servEndDate <= @toTime) OR (JMBS.jobId = @jobiD))
				AND (
						NOT EXISTS (SELECT 1 FROM JMJobSnapDeferredCatalogStats WITH (NOLOCK) WHERE jobId = JMBS.jobId)
						OR EXISTS (SELECT 1 FROM JMJobSnapDeferredCatalogStats WITH (NOLOCK) WHERE jobId = JMBS.jobId AND catalogStatus <> 100)
					)
			CROSS APPLY
			(SELECT TOP 1 * FROM archFile AF WITH (NOLOCK) WHERE AF.commCellId = JMBS.commCellId AND JMBS.jobId = AF.jobId ORDER BY cTime DESC) TAF
		END
		--Find all the valid logs afile after a give ctime for Indexing V2 and last V1 cycle index before the upgrade
		INSERT INTO #tempAfiles
        SELECT DISTINCT
                AF.commCellId           AS commCellId,
                AF.jobId				AS jobId,
                AF.id                   AS aFileId,
                AF.fileType             AS aFileType,
                AF.archGroupId          AS aGroupId,
                AF.ctime                AS cTime,
                (CASE WHEN cs_afname = @lognamechecksum THEN 1 ELSE 0 END) AS isV2Job,
                AF.appId                AS appID,
                ''                      AS lastSeenMaHostName,
                ''                      AS lastSeenMaClientName,
                0                       AS maCvdPort,
                0                       AS maEvmgrcPort,
				0 						AS copyValid,
                0                       AS cycleNum,
				0 						AS skipCatalog,
				''                      AS mediaName,
				0                       AS isOnline,
				0						AS itemsIndexed,
				0						AS skipOnRestoreFailure,
				0						AS jobStartTime,
				0 						AS isSynthFull,
				0 						AS prunedCheckPtStartTime,
				0 						AS prunedCheckPtEndTime,
				0						AS isValid,
				(CASE WHEN TVF.jobID is NOT NULL THEN 1 ELSE 0 END) AS isMissingJob,
				0 						AS isRunningJob,
				0						AS isBlockLevel,
				0						AS indexSize,
				0						AS delayedCatalogAFile,
				0 						AS isLastSeenMaOnline
                FROM archFile           AF (NOLOCK)
				JOIN #tempAppIds		TAPPID	WITH (NOLOCK) ON AF.appId = TAPPID.appId AND AF.isValid = 1 AND
				(( @appType != 137 AND (AF.fileType  = 2 OR (AF.fileType  = 6 AND @skipSnapJobs = 0))) OR ( @appType = 137 AND AF.fileType IN (2, 6, 4/*LiveUpdate*/)))
				JOIN archFileCopy		AFC		WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.isValid = 1
				JOIN archGroupCopy 		AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id
				LEFT JOIN #tempMissingJobs TVF 				  ON AF.jobId = TVF.jobId AND TVF.bkpType = AF.fileType AND AF.commCellId = TVF.commCellId
                WHERE
				AF.cTime >= TAPPID.lastFullCTimeBeforeUpgrade
				AND ((AF.cTime > @fromTime AND AF.cTime <= @toTime) OR (AF.jobId = @jobiD) OR (TVF.jobId IS NOT NULL))
				AND
				(
					(AF.cTime > TAPPID.aFileCtime AND AF.cTime >= @lastCheckPointTime) OR
					(TVF.jobId IS NOT NULL)
				)
				AND (@appType != 137 OR (@appType = 137 AND (AF.fileType != 4/*LiveUpdate*/ OR AF.cTime > @liveUpdateCTime)) )
				AND AFC.lastChunkNumber > 0
				AND ((AFC.flags & 256 = 0) OR @includeAgedData <> 0)
				AND (@copyPrecedence = 0 OR AGC.copy = @copyPrecedence)
		-- Make sure atleast one data afile is valid
		-- Mark sure atleast one copy is valid and if given a copy precedence
		-- Set Block level flag if any data archive file of job has CVA_BLOCKLEVEL_BACKUP_FLAG flag set or job is for VSA agent
		UPDATE TA SET TA.isvalid = 1, TA.copyValid = 1,
		TA.isBlockLevel = CASE WHEN (TA.isBlockLevel = 1 OR (AF.flags & 512) <> 0) THEN 1
WHEN @idxAppType = 200108 THEN 1
							   ELSE 0 END
		FROM #tempAfiles TA
		JOIN archFile AF WITH (NOLOCK) ON AF.jobId = TA.jobId AND AF.fileType in ( 1, 4) AND AF.appId = TA.appId AND AF.isValid = 1
		JOIN archFileCopy AFC WITH (NOLOCK) ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
		JOIN archGroupCopy AGC WITH (NOLOCK) ON AFC.archCopyId = AGC.id AND AFC.isValid = 1
		WHERE (@copyPrecedence = 0 OR AGC.copy = @copyPrecedence)
		--When waiting for playback of catalogSnapshot job, it does not have any associated data archfile but it it is still valid and needs to be included for playback.
		UPDATE TA SET TA.isvalid = 1, TA.copyValid = 1
		FROM #tempAfiles TA join #tempMissingJobs TMP ON TA.jobId = TMP.jobId where TMP.catalogSnap = 1
		-- Get job level details (NOTE: Get as much details as here and do not write new queries with same tables.)
		UPDATE AF
		SET jobId = (CASE WHEN JOBSTATS.jobIdActedOn IS NOT NULL AND (JOBSTATS.opType = 60 OR (JOBSTATS.opType = 59  AND JOBSTATS.subOpType = 96)) THEN JOBSTATS.jobIdActedOn ELSE AF.jobId END),
		skipCatalog = (CASE WHEN ((JOBSTATS.bkpattributes & 0x200000000000000 <> 0) AND AF.aFileType <> 2) THEN 1 ELSE 0 END),
		itemsIndexed = JOBSTATS.totalNumOfFiles,
		isSynthFull = (CASE WHEN (JOBSTATS.bkpLevel IN (64, 128, 16384)) THEN 1 ELSE 0 END),
		cycleNum = ISNULL(JOBSTATS.fullCycleNum,0),
		isValid = (CASE WHEN af.isValid = 1 AND (JOBSTATS.status IN(1, 3, 14) OR (JOBSTATS.status = 0 AND JOBSTATS.jobId <> 0 AND (isMissingJob = 1 OR (JOBSTATS.optype !=60 and (JOBSTATS.opType!=59 OR JOBSTATS.subOpType != 96))))) THEN 1 ELSE 0 END),
		isRunningJob = CASE WHEN (JOBSTATS.jobId <> 0 AND JOBSTATS.status = 0) THEN 1 ELSE 0 END,
		delayedCatalogAFile = ISNULL(af1.id, 0)
		FROM #tempAfiles AF
		JOIN
			(SELECT JMS.jobid, JMS.commCellId, JMS.status, JMS.appId, JMS.bkpLevel, JMS.fullCycleNum, JMS.opType, JS.subOpType, JMS.jobIdActedOn, JMS.bkpattributes, JMS.totalNumOfFiles
			 FROM JMJobStats JS WITH (NOLOCK)
			 JOIN JMBkpStats	JMS	WITH (NOLOCK) ON JMS.jobId = JS.jobId AND JMS.commCellid = JS.commCellId
			 UNION
			 (
			 SELECT JMB.jobId, JMB.commcellId, 0, 0, JMB.bkpLevel, 0, jobinfo.opType, jobinfo.subOpType, JMB.jobIdActedOn, JMB.bkpattributes, 0
			 FROM JMBkpJobInfo JMB WITH (NOLOCK)
			 JOIN JMJobInfo jobinfo WITH (NOLOCK) ON jobinfo.jobid = JMB.jobid and jobinfo.commcellId = JMB.commcellId
			 )
			) JOBSTATS ON AF.jobId = JOBSTATS.jobId AND AF.commCellId = JOBSTATS.commCellId
			left outer join archFile af1 WITH(NOLOCK) on af1.jobId=af.jobId and af1.commcellid=af.commcellid and af1.fileType=9 and af1.isValid=1
			--CVA_DATATYPE_FILE_INDEX == 9
		--set @isIndexInfoMissing flag for missing information
		IF @validateAfiles = 1 AND EXISTS (SELECT 1 FROM #tempAfiles TAF JOIN #tempAppIds TA on TA.appId = TAF.appId where TAF.cTime < @lastCheckPointTime OR TAF.cTime < TA.aFileCtime)
			SET @isIndexInfoMissing = 1
		IF (@mediaPrediction = 1 AND @copyPrecedence > 0)
        BEGIN
            IF EXISTS (SELECT 1 FROM #tempAfiles WHERE copyValid = 0)
				SET @isIndexInfoMissing = 1
		END
END
--Populate lastseen, catalog, media status information in #tempAfiles
--skip this for mediaPrediction
IF (@mediaPrediction = 0) -- no need to get when media prediction is done
BEGIN
    UPDATE #tempafiles SET lastSeenMaHostName = CL.net_HostName, lastSeenMaClientName = CL.name, macvdPort = CL.cvdPort, maevmgrcport = CL.evmgrcPort, isLastSeenMaOnline = (CASE WHEN MM.MmHostSoftState > 0 AND MM.MmHostEnabled > 0 THEN 1 ELSE  0 END)
    FROM App_client AS CL WITH (NOLOCK) INNER JOIN JMJobOptions AS JOBOPTIONS WITH (NOLOCK)
    ON CL.name = JOBOPTIONS.attributeValue
	INNER JOIN MMHost AS MM WITH(NOLOCK) ON CL.id = MM.ClientId
    INNER JOIN #tempafiles as T
    ON T.jobId = JOBOPTIONS.jobId AND ((T.aFileType = 2 AND JOBOPTIONS.attributeId = 28) OR (T.aFileType = 6 AND JOBOPTIONS.attributeId = 27)) AND T.copyValid=1
	IF EXISTS (SELECT 1 from #tempAfiles where lastSeenMaClientName = '')
	BEGIN
		DECLARE @commcellIdTemp int =0 , @archFileTemp int =0
		DECLARE tempAfileCursor CURSOR FOR
		SELECT aFileId,commCellId FROM #tempafiles where lastSeenMaClientName = ''
		OPEN tempAfileCursor
		FETCH NEXT FROM tempAfileCursor INTO @archFileTemp, @commcellIdTemp
		WHILE(@@FETCH_STATUS = 0)
		BEGIN
			DECLARE @intLastSeenMAID int = 0, @intLastDrivePoolID int = 0
			EXEC dbo.GetLastSeenMAForArchFile @archFileTemp,@commcellIdTemp,0 ,@intLAstSeenMAID OUTPUT, @intLastDrivePoolID OUTPUT
			 UPDATE #tempafiles  SET lastSeenMaHostName = CL.net_HostName, lastSeenMaClientName = CL.name, macvdPort = CL.cvdPort, maevmgrcport = CL.evmgrcPort, isLastSeenMaOnline = (CASE WHEN MM.MmHostSoftState > 0 AND MM.MmHostEnabled > 0 THEN 1 ELSE  0 END)
			 FROM App_client AS CL WITH (NOLOCK)
	 		 INNER JOIN MMHost AS MM WITH(NOLOCK) ON CL.id = MM.ClientId
			 where CL.id = @intLAstSeenMAID and aFileId = @archFileTemp and commCellId =  @commcellIdTemp
			 FETCH NEXT FROM tempAfileCursor INTO @archFileTemp, @commcellIdTemp
		END
		DEALLOCATE tempAfileCursor
	END
	-- if job ran with skipCatalog option but later deferred cataloging was done, do not set skip catalog option
	IF EXISTs ( SELECT 1 from #tempAfiles where skipCatalog = 1)
	BEGIN
		UPDATE #tempafiles set skipcatalog = 0 from #tempAfiles TA
		INNER JOIN JMJobSnapDeferredCatalogStats JMDCS WITH (NOLOCK) ON TA.jobId = JMDCS.jobId
		LEFT JOIN #tempMissingJobs TM on TA.jobId = TM.jobId
		where (JMDCS.catalogStatus = 100 OR (TM.jobId is NOT NULL AND TM.catalogSnap = 1))
	END
	-- populate media status to know whether index can be restored.
	UPDATE #tempafiles
	SET mediaName = (CASE WHEN L.LibraryTypeId = 1 THEN m.BarCode ELSE L.AliasName END),
	isOnline = (CASE WHEN L.LibraryTypeId = 3 AND DC.DeviceControllerEnabled = 1 AND DC.DeviceAccessible = 1 AND H.MmHostSoftState > 0 AND H.MmHostEnabled > 0 THEN 1 WHEN L.LibraryTypeId = 1 AND M.MediaLocation IN (1,2) THEN 1 ELSE 0 END)
	FROM #tempafiles AF
	JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archFileId = AF.aFileId AND ACM.commCellId = AF.commCellId
	JOIN archChunk C WITH (NOLOCK) ON C.id = ACM.archChunkId
	JOIN archGroupCopy AGC WITH(NOLOCK) ON AGC.id = ACM.archCopyId
	JOIN MMVolume V WITH (NOLOCK) ON C.volumeId = V.VolumeId
	JOIN MMMedia M WITH (NOLOCK) ON V.MediaId = M.MediaId
	JOIN MMLibrary L WITH (NOLOCK) ON L.LibraryId = M.LibraryId
	LEFT OUTER JOIN MMMountPath MP WITH (NOLOCK) ON MP.MediaSideId = V.MediaSideId
	LEFT OUTER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK) on mp.MountPathId = MPSD.MountPathId
	LEFT OUTER JOIN MMDeviceController DC WITH (NOLOCK) ON DC.DeviceId = MPSD.DeviceId
	LEFT OUTER JOIN MMHost H WITH (NOLOCK) ON H.ClientId = DC.ClientId
	LEFT OUTER JOIN APP_Client CC WITH (NOLOCK) ON H.ClientId = C.id
	WHERE @copyPrecedence = 0 OR (@indexCheckPointInfo = 1 AND @useCopyPrecdenceForCheckpoint = 0) OR	@copyPrecedence = AGC.copy
END
IF EXISTS(select 1 from #tempAppIds where isDaysBasedRetention=1)
BEGIN
	-- For Days based retention we don't need to set pruning parameter
	SET @pruningType = 0
	SET @pruningRetCycle = 1
	--recalculate cycle info for days-based retention sub-clients
	UPDATE #tempafiles SET cycleNum = jobId where jobid in
	(
	select jobId from JMBkpStats bkpStats WITH(NOLOCK) where bkpStats.jobid in (select jobId from #tempafiles where appid in (select appId from #tempAppIds where isDaysBasedRetention=1)) and (bkpStats.indexOverride=1 or bkpStats.cycleSequence=(select min(bkpStats1.cycleSequence) from JMBkpStats bkpStats1  WITH(NOLOCK) where bkpstats.appId=bkpstats1.appId and bkpstats.fullCycleNum=bkpStats1.fullCycleNum))
	)
	CREATE TABLE #tmpJobsTable2
	(
	appid int,
	jobid int,
	cycle int,
	sequence int
	)
	;WITH bkpjobs1 AS
	( SELECT j.appId, j.jobId, j.jobId as cycle, 1 as sequence
	FROM #tempafiles j
	WHERE j.jobId in (select jobId from #tempafiles where appid in (select appId from #tempAppIds where isDaysBasedRetention=1) and cycleNum=jobId)
	)
	INSERT into #tmpJobsTable2
	SELECT *  FROM bkpjobs1
	-- UPDATE Non full jobs cycle number.
	UPDATE #tempafiles
	SET cycleNum = (SELECT ISNULL ((SELECT TOP 1 T1.cycle FROM #tmpJobsTable2 T1 WHERE T1.appid = #tempafiles.appId AND T1.jobid < #tempafiles.jobId  ORDER BY T1.jobId DESC), 1))
	WHERE cyclenum<>jobId AND commCellId = 2 AND appId in (SELECT appId FROM #tmpJobsTable2)
	DROP TABLE #tmpJobsTable2
END
-- update db status (during recon and afile validation) for health reporting
IF (@mediaPrediction = 0 AND @indexCheckPointInfo = 0 AND @createNewIndex = 0)
BEGIN
-- todo: remove try or handle exception in 5a.
BEGIN TRY
	exec dbo.SetIdxDbStatusForReconInternal @dbGuid
END TRY
BEGIN CATCH
END CATCH
END
-- Skip older cycles during recon. This will reconstruct only latest cycle in time range AND user selected time range/jobID irrespective of media being available or not
-- PruningType 0 Means infinite retention. In that case we don't need any special handing for backupset pruning
IF (@indexCheckPointInfo = 0 AND (@isLatestCycleEnabled > 0 OR @pruningType > 0 ))
BEGIN
	IF object_id('tempdb.dbo.#appToMaxCyleNum' ) IS NOT null DROP TABLE #appToMaxCyleNum
	CREATE TABLE #appToMaxCyleNum (appid INT, commCellId INT, maxCycleNum INT)
	-- max data archfile for each index archfile
	IF object_id('tempdb.dbo.#tmpDataAfile' ) IS NOT null DROP TABLE #tmpDataAfile
	CREATE TABLE #tmpDataAfile (jobID INT,ctime INT, commCellId INT)
	INSERT INTO #tmpDataAfile
			select AF.jobId,MAX(AF.cTime), AF.commCellId From #tempAfiles TA WITH (NOLOCK)
			inner join archFile AF  WITH(NOLOCK) ON TA.jobId = AF.jobId And AF.fileType in ( 1, 4 ) AND TA.commCellId = AF.commCellId AND AF.isValid = 1
		GROUP BY AF.JobId,AF.commCellId
	-- Get latest cycle number per app
	INSERT INTO #appToMaxCyleNum
	SELECT DISTINCT J.AppId, J.commCellId, J.FullCycleNum FROM
	(
		SELECT J1.AppId, J1.servEndDate, ROW_NUMBER() OVER (PARTITION BY J1.appId ORDER BY J1.servEndDate DESC) as r_no
		FROM #tempAppIds TAP, JMBkpStats J1 WITH (NOLOCK) WHERE
		TAP.appId = J1.AppId  AND J1.fullCycleNum <> 0 AND J1.Status IN (1,3,14) AND J1.bkpLevel IN (1,64,128,1024,16384,32768) AND J1.opType <> 60 AND J1.dataStatus = 0
	) T, JMBkpStats J WITH (NOLOCK) WHERE T.appId = J.AppId AND T.servEndDate = J.servEndDate AND T.r_no <= @pruningRetCycle
	IF @pruningType = 2 -- Days Based Retention
	BEGIN
		IF object_id('tempdb.dbo.#appIdCutOffTime' ) IS NOT null DROP TABLE #appIdCutOffTime
		CREATE TABLE #appIdCutOffTime (appid INT, commCellId INT, cuttofTime INT)
		INSERT INTO #appIdCutOffTime
		SELECT J1.AppId, J1.commCellId, MAX(J1.servStartDate) - @pruningRetDays*24*60*60 AS cuttofTime
		FROM #tempAppIds TAP, JMBkpStats J1 WITH (NOLOCK) WHERE
		TAP.appId = J1.AppId  AND J1.fullCycleNum <> 0 AND J1.Status IN (1,3,14)
		GROUP BY J1.AppId, J1.commCellId
		INSERT INTO #appToMaxCyleNum
		SELECT DISTINCT J.AppId, J.commCellId, J.FullCycleNum FROM
		(
			SELECT J1.AppId, J1.commCellId, MAX(J1.servEndDate) AS servEndDate
			FROM #tempAppIds TAP JOIN JMBkpStats J1 WITH (NOLOCK) ON TAP.appId = J1.AppId
			JOIN #appIdCutOffTime lastJob ON TAP.appId = lastJob.appId
			WHERE J1.fullCycleNum <> 0 AND J1.Status IN (1,3,14) AND J1.servStartDate <= cuttofTime AND J1.bkpLevel IN (1,64,128,1024,16384,32768) AND J1.opType <> 60 AND J1.dataStatus = 0
			GROUP BY J1.AppId, J1.commCellId
		) T
		JOIN JMBkpStats J WITH (NOLOCK) ON T.appId = J.AppId
		LEFT JOIN #appToMaxCyleNum tmp ON tmp.appId = J.AppId AND tmp.commCellId = J.commCellId AND tmp.maxCycleNum = J.FullCycleNum
		WHERE T.servEndDate <= J.servEndDate AND tmp.maxCycleNum IS NULL
		IF object_id('tempdb.dbo.#appIdCutOffTime' ) IS NOT null DROP TABLE #appIdCutOffTime
	END
	-- remove jobs not present in latest cycle unless present in missing job list
	DELETE #tempAfiles FROM #tempAfiles LEFT JOIN #appToMaxCyleNum appCycle ON #tempAfiles.appId = appCycle.appId AND appCycle.maxCycleNum = #tempAfiles.cycleNum
	INNER JOIN #tmpDataAfile T on T.jobID = #tempAfiles.jobId AND T.commCellId = #tempAfiles.commCellId
	WHERE  (#tempAfiles.isMissingJob <> 1 AND appCycle.maxCycleNum IS NULL )
	IF object_id('tempdb.dbo.#tmpDataAfile' ) IS NOT null DROP TABLE #tmpDataAfile
	IF object_id('tempdb.dbo.#appToMaxCyleNum' ) IS NOT null DROP TABLE #appToMaxCyleNum
END
-- Pick only jobs in latest cycle available for that copy
-- skip for media prediction and partial index.
IF @copyPrecedence <> 0 AND @mediaPrediction = 0 AND @fromTime = 0
BEGIN
		;WITH appToMaxCyleNum(appid, commCellId, maxCycleNum) AS(
			SELECT appid, commCellId, MAX(cycleNum) FROM #tempAfiles where copyValid = 1
			GROUP BY appId, commCellId)
		DELETE #tempAfiles FROM #tempAfiles INNER JOIN appToMaxCyleNum
		ON #tempAfiles.appId = appToMaxCyleNum.appId AND #tempAfiles.commCellId = appToMaxCyleNum.commCellId AND #tempAfiles.cycleNum <> appToMaxCyleNum.maxCycleNum
END
--For a running backup copy job,archfile table has backup copy job id but index has snap job id (jobIdActedOn). Replace jobId with actedOn jobId.
IF (@missingJobsPresent = 1 )
BEGIN
	UPDATE TA set TA.jobId = TMP.jobIdActedOn from #tempAfiles TA
	inner join #tempMissingJobs TMP on TA.jobId = TMP.jobId AND TMP.jobIdActedOn<>0
END
--optype 14 is synfull
--optype 4 can be full or inc.
IF @createNewIndexRegKey = 1 AND @pruningRetCycle = 1 AND @subclientIndexEnabled = 1 AND @lastFailedPlaybackJobId <> @runningJobId
AND @isArchivingSubclient = 0 AND @isSnapjobPresent = 0 AND @isBlockLevelSubclient = 0 AND
EXISTS(SELECT 1 FROM RunningBackups JM WITH(NOLOCK)
WHERE CommcellId = 2 AND JM.jobid = @runningJobId AND (opType = 14 OR (opType = 4 AND bkpLevel = 1)) )
BEGIN
	DELETE FROM #tempAfiles
	SET @createNewIndex = 1
END
--Output XML generation
SET @outxmlText = (
	SELECT @dbGuid as '@dbGuid', @backupSetId as '@backupSetId', @appType as '@appType', @isIndexInfoMissing as '@isIndexInfoMissing', @createNewIndex AS '@createNewIndex',
	(
		SELECT jobId as '@jobId' , aFileId as '@aFileId',  aFileType as '@aFileType', (CASE WHEN isV2Job = 1 THEN N'IdxLogs_V1' ELSE '' END) as '@aFileName' ,
		aGroupId as '@aGroupId', APP.GUID as '@appGUID', commCellId as '@commCellId', cTime as '@cTime',
		lastSeenMaHostName as '@lastSeenMaHostName', lastSeenMaClientName as '@lastSeenMaClientName',
		macvdPort as '@macvdPort', maevmgrcport as '@maevmgrcport', T.appId as '@appId', T.mediaName as '@mediaName',
		T.isOnline as '@inCache', T.cycleNum as '@cycleNum' ,T.skipCatalog as '@skipCatalog', T.itemsIndexed AS '@itemsIndexed',
		T.skipOnRestoreFailure AS '@skipOnRestoreFailure', T.jobStartTime AS '@jobStartTime', T.isSynthFull AS '@isSynthFull',
		prunedCheckPtStartTime AS '@prunedCheckPtStartTime', prunedCheckPtEndTime AS '@prunedCheckPtEndTime', isRunningJob AS  '@isRunningJob', delayedCatalogAFile as '@delayedCatalogAFile',
		isBlockLevel AS '@isBlockLevel', indexSize AS '@indexSize', isLastSeenMaOnline AS '@isLastSeenMaOnline'
		FROM #tempAfiles T JOIN APP_Application APP WITH (NOLOCK) ON T.appId = APP.id
		WHERE T.isValid = 1 AND T.copyValid=1
		ORDER BY cTime, jobId FOR XML PATH('archFileInfoList'), TYPE
	),
	(
		SELECT @backupSetId as '@backupSetId', @appType as '@appType' ,
			(SELECT afileNum as '@afile', commCellNum as '@commcell', isValid as '@isValid'
            FROM #tempValidAFiles TVF
            JOIN @xmlText.nodes('/Indexing_GetArchFileInfoForJobs/validAfileList/afiles') AS T(N) ON TVF.afileNum = T.N.value('@afile', 'integer') AND TVF.commCellNum = T.N.value('@commcell', 'integer')
            WHERE TVF.isValid != T.N.value('@isValid', 'integer')
            FOR XML PATH('afiles'), TYPE)
		FOR XML PATH('validAfileList'), TYPE
	)
	FOR XML PATH('Indexing_GetArchFileInfoForJobs'), TYPE)
SELECT  @outxmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetArchFileInfoForJobs')
	delete from GxQscripts where name = 'AppGetArchFileInfoForJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetArchFileInfoForJobs')
	delete from GXDBVersions where aliasname = 'AppGetArchFileInfoForJobs'
GO

insert into GXDBVersions values(2, 'AppGetArchFileInfoForJobs',  '00000000000000000000', 'AppGetArchFileInfoForJobs', '00000000000000000000')
GO

