

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAppIDForJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAppIDForJob.sp,v $ $Id: AppGetAppIDForJob.sp,v 1.2 2012/11/19 16:17:56 gpattabiraman Exp $";
-- =========================================================
-- Author:		Gokul Pattabiraman
-- Description:	Get the App ID information for the given job.
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetAppIDForJob <<<'

IF EXISTS (select * from sysobjects where name='AppGetAppIDForJob')
	drop procedure AppGetAppIDForJob
IF EXISTS (select * from GxQscripts where name='AppGetAppIDForJob')
	delete from GxQscripts where name = 'AppGetAppIDForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAppIDForJob')
	delete from GXDBVersions where aliasname = 'AppGetAppIDForJob'
GO
print '... Creating Procedure: AppGetAppIDForJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAppIDForJob
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML
AS
DECLARE @inJobID INT			= ISNULL (( SELECT ref.value('@jobId', 'INT')
											FROM @xmlText.nodes ('App_AppGetAppIdForJobRequest') R(ref)), 0)
DECLARE @inCommCellID INT		= ISNULL (( SELECT ref.value('@commCellId', 'INT')
											FROM @xmlText.nodes ('App_AppGetAppIdForJobRequest') R(ref)), 0)
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = ''
SET @xmlText = ''
SET NOCOUNT ON
IF EXISTS (SELECT 1 FROM JMBkpStats WITH (NOLOCK) WHERE jobId = @inJobID AND commCellId = @inCommCellID)
BEGIN
	SET @xmlText =	(SELECT	(	SELECT CL.id AS '@clientId', CL.name AS '@clientName',
								IDA.type AS '@applicationId', IDA.name '@appName',
								INS.id AS '@instanceId', INS.name AS '@instanceName',
								BSET.id AS '@backupsetId', BSET.name AS '@backupsetName',
								APP.id AS '@subclientId', APP.subclientName AS '@subclientName'
								FROM JMBkpStats BKP WITH (NOLOCK)
								INNER JOIN APP_Application APP WITH (NOLOCK) ON BKP.appId = APP.id
								INNER JOIN APP_BackupSetName BSET WITH (NOLOCK) ON APP.backupSet = BSET.id
								INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON APP.instance = INS.id
								INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON APP.appTypeId = IDA.type
								INNER JOIN APP_Client CL WITH (NOLOCK) ON APP.clientId = CL.id
								WHERE BKP.jobId = @inJobID AND BKP.commCellId = @inCommCellID
								FOR XML PATH('entity'), TYPE)
					 FOR XML PATH('GenericEntityResponse'), TYPE)
	IF @xmlText IS NULL
	BEGIN
		SET @errorCode = -1
		SET @errorString = 'Unknown Error Occurred.'
		GOTO PROC_ERROR
	END
	ELSE
		GOTO PROC_END
END
ELSE
BEGIN
	SET @errorCode = -2
	SET @errorString = 'Failed to get AppID for non-existing job or unsupported job type.'
	GOTO PROC_ERROR
END
PROC_ERROR:
	SET @xmlText = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString' FOR XML PATH('GenericEntityResponse'), TYPE)
PROC_END:
	SELECT @xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAppIDForJob')
	delete from GxQscripts where name = 'AppGetAppIDForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAppIDForJob')
	delete from GXDBVersions where aliasname = 'AppGetAppIDForJob'
GO

insert into GXDBVersions values(2, 'AppGetAppIDForJob',  '00010002000000000000', 'AppGetAppIDForJob', '00010002000000000000')
GO

