

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAnomalyTypeBasedEntityCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppGetAnomalyTypeBasedEntityCount()
--  |
--  | Description:  Returns anomaly type based entity count.
--  |
--  |       Input:  request XML
--  |
--  |      Output:  anomaly type based entity count.
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Mohammad Dilshad		Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAnomalyTypeBasedEntityCount')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAnomalyTypeBasedEntityCount <<<'
	drop procedure AppGetAnomalyTypeBasedEntityCount
END
IF EXISTS (select * from GxQscripts where name='AppGetAnomalyTypeBasedEntityCount')
	delete from GxQscripts where name = 'AppGetAnomalyTypeBasedEntityCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnomalyTypeBasedEntityCount')
	delete from GXDBVersions where aliasname = 'AppGetAnomalyTypeBasedEntityCount'
GO
print '... Creating Procedure: AppGetAnomalyTypeBasedEntityCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAnomalyTypeBasedEntityCount
  @xml XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @userId INT = ISNULL((SELECT @xml.value('(//processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
	DECLARE @secondsInhour INT = 60*60
	DECLARE @secondsInDay INT = @secondsInhour * 24
	DECLARE @MinimumRuntime INT = @secondsInhour
	DECLARE @anomalyTypeFlag INT = ISNULL((SELECT @xml.value('(//@anomalyTypeFlag)[1]', 'INT')), 0)
	DECLARE @isInfrastructure INT = ISNULL((SELECT @xml.value('(//@isInfrastructure)[1]', 'INT')), 0)
	DECLARE @isApplianceNode INT = ISNULL((SELECT @xml.value('(//@isApplianceNode)[1]', 'INT')), 0)
	DECLARE @toTime INT = @time
	DECLARE @fromTime INT =  @toTime - @secondsInDay
	DECLARE @currentTime DATETIME = GETUTCDATE()
	DECLARE @performanceCaptureTime DATETIME = DATEADD(MINUTE, -90, @currentTime)
	DECLARE @isAdmin INT = 0
EXEC DBO.sec_checkPermissionOnEntity @userId, 1, @isAdmin OUTPUT, 1, 2
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
	CREATE TABLE #userClients
	(
		   t_clientId INT,
		   t_appTypeId INT,
		   t_instanceId INT,
		   t_backupsetId INT,
		   t_subclientId INT
	)
	IF OBJECT_ID('tempdb.dbo.#MAList') IS NOT NULL DROP TABLE #MAList
	CREATE TABLE #MAList
	(
		   clientId INT
	)
	IF OBJECT_ID('tempdb.dbo.#WSList') IS NOT NULL DROP TABLE #WSList
	CREATE TABLE #WSList
	(
		   clientId INT
	)
	IF OBJECT_ID('tempdb.dbo.#ResourceUsage') IS NOT NULL DROP TABLE #ResourceUsage
	CREATE TABLE #ResourceUsage
	(
		   clientId INT,
		   percentageUsedCPU FLOAT,
		   percentageUsedMemory FLOAT,
		   totalMemory FLOAT,
		   usedMemory FLOAT
	)
	DECLARE @TotalClientsForAnomalyAnalysis INT
	DECLARE @FailedJobBasedAnomalousCount INT
	DECLARE @MissedSLABasedAnomalousCount INT
	DECLARE @HighCPUUsageBasedAnomalousCountWarning INT
	DECLARE @HighCPUUsageBasedAnomalousCountCritical INT
	DECLARE @HighMemoryUsageBasedAnomalousCountWarning INT
	DECLARE @HighMemoryUsageBasedAnomalousCountCritical INT
	DECLARE @MemoryLeakBasedAnomalousCount INT
	DECLARE @UnreachableBasedAnomalousCount INT
	DECLARE @TotalPhysicalMemoryOfAllNodes FLOAT
	DECLARE @TotalUsedMemoryOfAllNodes FLOAT
	DECLARE @TotalUsedMemoryOfAllNodesCritical FLOAT
	DECLARE @TotalUsedMemoryOfAllNodesWarning FLOAT
	DECLARE @TotalClientWithDataAvailable INT
	IF @isAdmin <> 1
	BEGIN
		EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
	END
	IF @isApplianceNode = 1
	BEGIN
		IF @isAdmin = 1
		BEGIN
			INSERT INTO #MAList
			SELECT DISTINCT(HW.hostId) FROM
				MMSDSStoragePool SDS(NOLOCK)
				INNER JOIN MMMountPath MP WITH (NOLOCK)
					ON SDS.LibraryId = MP.LibraryId
				INNER JOIN MMMountPathToStorageDevice MSD WITH (NOLOCK)
					ON MSD.MountPathId = MP.MountPathId
				INNER JOIN MMDiskHwInfo HW(NOLOCK)
					ON MSD.DeviceId = HW.deviceId AND HW.flags & 1 = 1
				INNER JOIN MMEntityProp ME(NOLOCK)
					ON HW.hostId = ME.EntityId AND ME.EntityType = 10 AND ME.CommCellId = 2
					AND ME.propertyName = N'MediaAgentApplianceType' AND ME.intVal IN (1 , 2)
				INNER JOIN [HistoryDB].[dbo].MMPerformanceHistory PH
					ON PH.clientId = HW.hostId
		END
		ELSE
		BEGIN
			INSERT INTO #MAList
			SELECT DISTINCT(HW.hostId) FROM
				MMSDSStoragePool SDS(NOLOCK)
				INNER JOIN MMMountPath MP WITH (NOLOCK)
					ON SDS.LibraryId = MP.LibraryId
				INNER JOIN MMMountPathToStorageDevice MSD WITH (NOLOCK)
					ON MSD.MountPathId = MP.MountPathId
				INNER JOIN MMDiskHwInfo HW(NOLOCK)
					ON MSD.DeviceId = HW.deviceId AND HW.flags & 1 = 1
				INNER JOIN MMEntityProp ME(NOLOCK)
					ON HW.hostId = ME.EntityId AND ME.EntityType = 10 AND ME.CommCellId = 2
					AND ME.propertyName = N'MediaAgentApplianceType' AND ME.intVal IN (1 , 2)
				INNER JOIN [HistoryDB].[dbo].MMPerformanceHistory PH
					ON PH.clientId = HW.hostId
				INNER JOIN #userClients UCL ON HW.hostId = UCL.t_clientId
		END
	END
	ELSE IF @isInfrastructure = 1
	BEGIN
		IF @isAdmin = 1
		BEGIN
			INSERT INTO #MAList
			SELECT COUNT(DISTINCT PH.clientId) FROM [HistoryDB].[dbo].MMPerformanceHistory PH INNER JOIN APP_Client CL ON PH.clientId = CL.id
WHERE CL.status & 0x10000000 <> 0x10000000 AND CL.status & 0x1000 <> 0x1000
		END
		ELSE
		BEGIN
			INSERT INTO #MAList
			SELECT COUNT(DISTINCT PH.clientId) FROM [HistoryDB].[dbo].MMPerformanceHistory PH
				INNER JOIN APP_Client CL ON PH.clientId = CL.id
				INNER JOIN #userClients UCL ON CL.id = UCL.t_clientId
WHERE CL.status & 0x10000000 <> 0x10000000 AND CL.status & 0x1000 <> 0x1000
		END
	END
	IF @isApplianceNode = 1 OR @isInfrastructure = 1
	BEGIN
		IF @isAdmin = 1
		BEGIN
			INSERT INTO #WSList
			SELECT ClientId FROM simInstalledPackages WHERE simPackageID = 252
		END
		ELSE
		BEGIN
			INSERT INTO #WSList
			SELECT ClientId FROM simInstalledPackages SIP
				INNER JOIN #userClients UCL ON SIP.ClientId = UCL.t_clientId
			WHERE SIP.simPackageID = 252
		END
		SELECT @TotalClientsForAnomalyAnalysis = COUNT(clientId) FROM #MAList
	END
	IF @isApplianceNode = 0 AND @isInfrastructure = 0 -- Populating anomalous Clients list
	BEGIN
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 1 = 1 -- Based on failed Job
		BEGIN
			IF @isAdmin = 1
			BEGIN
			SET @FailedJobBasedAnomalousCount = (
				SELECT COUNT(1)
				FROM APP_ClientProp CLThreshold
				INNER JOIN APP_ClientProp CLCount
					ON CLThreshold.componentNameId = CLCount.componentNameId
						AND CLThreshold.attrName = N'Client Failed Job Anomaly Threshold'
						AND CLThreshold.modified = 0
						AND CLCount.attrName = N'Client Failed Job Count For Today'
						AND CLCount.modified = 0
						AND CLCount.created > @fromTime
						AND CLCount.created > CLThreshold.created
				WHERE CAST(CLThreshold.attrVal AS FLOAT) < CAST(CLCount.attrVal AS FLOAT))
			END
			ELSE
			BEGIN
				SET @FailedJobBasedAnomalousCount = (
				SELECT COUNT(1)
				FROM APP_ClientProp CLThreshold
				INNER JOIN APP_ClientProp CLCount
					ON CLThreshold.componentNameId = CLCount.componentNameId
						AND CLThreshold.attrName = N'Client Failed Job Anomaly Threshold'
						AND CLThreshold.modified = 0
						AND CLCount.attrName = N'Client Failed Job Count For Today'
						AND CLCount.modified = 0
						AND CLCount.created > @fromTime
						AND CLCount.created > CLThreshold.created
				INNER JOIN #userClients CL ON CL.t_clientId = CLThreshold.componentNameId AND CL.t_clientId = CLCount.componentNameId
				WHERE CAST(CLThreshold.attrVal AS FLOAT) < CAST(CLCount.attrVal AS FLOAT))
			END
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 32 = 32 -- Based on unreachability
		BEGIN
			IF @isAdmin = 1
			BEGIN
				SET @UnreachableBasedAnomalousCount = (
				SELECT COUNT(1) FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
					SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
				)UnreachbleClients
				INNER JOIN App_Client Client ON Client.id = UnreachbleClients.clientID
AND Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000) | 2 | 4) = 0
				INNER JOIN (SELECT DISTINCT ClientId FROM simInstalledPackages) SIM ON Client.id = SIM.ClientId
				LEFT OUTER JOIN MMhost MM ON MM.ClientID = Client.id
                WHERE   MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                    	AND (MM.offlineReason =7)))
				)
			END
			ELSE
			BEGIN
				SET @UnreachableBasedAnomalousCount = (
				SELECT COUNT(1) FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
					SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
				)UnreachbleClients INNER JOIN #userClients CL ON UnreachbleClients.clientId = CL.t_clientId
				INNER JOIN App_Client Client ON Client.id = UnreachbleClients.clientID
AND Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000) | 2 | 4) = 0
				INNER JOIN (SELECT DISTINCT ClientId FROM simInstalledPackages) SIM ON Client.id = SIM.ClientId
				LEFT OUTER JOIN MMhost MM ON MM.ClientID = Client.id
                WHERE   MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                    	AND (MM.offlineReason =7)))
				)
			END
		END
	END
	ELSE -- Calculating anomalous count for Infrastructures
	BEGIN
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 1 = 1 -- Based on failed Job
		BEGIN
			SELECT @FailedJobBasedAnomalousCount = COUNT(1)
			FROM APP_ClientProp FJThreshold
			INNER JOIN APP_ClientProp FJCount
				ON FJThreshold.componentNameId = FJCount.componentNameId
				AND FJThreshold.attrName = N'Media Agent Failed Job Anomaly Threshold'
				AND FJThreshold.modified = 0
				AND FJCount.attrName = N'Media Agent Failed Job Count For Today'
				AND FJCount.modified = 0
				AND FJCount.created > @fromTime
				AND FJCount.created > FJThreshold.created
			INNER JOIN #MAList CL
				ON CL.clientId = FJThreshold.componentNameId
			WHERE CAST(FJThreshold.attrVal AS FLOAT) > 10
				AND CAST(FJThreshold.attrVal AS FLOAT) < CAST(FJCount.attrVal AS FLOAT)
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 32 = 32 -- Based on unreachability
		BEGIN
			WITH  UnreachbleClient AS
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
					SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
				),
				Visible AS
				(
					SELECT clientId FROM #MAList
					UNION
					SELECT ClientId FROM #WSList
				)
				SELECT @UnreachableBasedAnomalousCount =  COUNT(1) FROM UnreachbleClient
				INNER JOIN Visible ON Visible.clientId = UnreachbleClient.ClientId
				LEFT OUTER JOIN MMhost MM ON MM.ClientID = UnreachbleClient.ClientId
                WHERE   MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                    	AND (MM.offlineReason =7)))
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 4 = 4 OR @anomalyTypeFlag & 8 = 8
		BEGIN
			INSERT INTO #ResourceUsage
			SELECT
				PH.clientId,
				AVG(cpuUsage) AS percentageUsedCPU,
				AVG(100 - percentFreePhysicalMemory) AS percentageUsedMemory,
				MAX(PH.physicalMemoryKB * 1.0) AS totalMemory,
				AVG((physicalMemoryKB * (100.0 - percentFreePhysicalMemory) * 1.0)/100) AS usedMemory
					FROM [HistoryDB].[dbo].MMPerformanceHistory PH INNER JOIN #MAList CL ON PH.clientId = CL.clientId
					WHERE dbo.ClientLocalToUTCTime(PH.creationDate, CL.clientId) >= @performanceCaptureTime
					GROUP BY PH.clientId
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 4 = 4 -- Based on High CPU usage
		BEGIN
			SELECT
				@HighCPUUsageBasedAnomalousCountCritical = SUM(CASE WHEN percentageUsedCPU >= 90 THEN  1 ELSE 0 END),
				@HighCPUUsageBasedAnomalousCountWarning = SUM(CASE WHEN percentageUsedCPU BETWEEN 60 AND 89 THEN  1 ELSE 0 END)
					FROM #ResourceUsage
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 8 = 8 -- Based on High Memory usage
		BEGIN
			SELECT
				@TotalClientWithDataAvailable = COUNT(1),
				@HighMemoryUsageBasedAnomalousCountCritical = SUM(CASE WHEN percentageUsedMemory >= 90 THEN  1 ELSE 0 END),
				@HighMemoryUsageBasedAnomalousCountWarning = SUM(CASE WHEN percentageUsedMemory BETWEEN 60 AND 89 THEN  1 ELSE 0 END)
					FROM #ResourceUsage
			IF @isApplianceNode = 1
			BEGIN
				SELECT
				@TotalPhysicalMemoryOfAllNodes = ISNULL (SUM(totalMemory), 0.0),
				@TotalUsedMemoryOfAllNodes = ISNULL (SUM(usedMemory), 0.0) ,
				@TotalUsedMemoryOfAllNodesCritical = ISNULL ((SUM(CASE WHEN percentageUsedMemory >= 90 THEN  usedMemory ELSE 0 END)), 0.0) ,
				@TotalUsedMemoryOfAllNodesWarning = ISNULL (SUM(CASE WHEN percentageUsedMemory BETWEEN 60 AND 89 THEN  usedMemory ELSE 0 END), 0.0)
					FROM #ResourceUsage
			END
		END
	END
	-- Populating XML result
	SET @xml = (SELECT
		-- UnusualFailedJobs
		[UnusualFailedJobs/@TotalDetected] = @FailedJobBasedAnomalousCount,
		-- Unreachable
		[Unreachable/@TotalDetected] = @UnreachableBasedAnomalousCount,
		--MissedSLA
		[MissedSLA/@TotalDetected] = @MissedSLABasedAnomalousCount,
		-- HighCPUUsage
		[HighCPUUsage/@Total] = @TotalClientsForAnomalyAnalysis,
		[HighCPUUsage/@Critical] = @HighCPUUsageBasedAnomalousCountCritical,
		[HighCPUUsage/@Warning] = @HighCPUUsageBasedAnomalousCountWarning,
		-- HighMemoryUsage
		[HighMemoryUsage/@Total] = @TotalClientsForAnomalyAnalysis,
		[HighMemoryUsage/@TotalDetected] = @TotalClientWithDataAvailable,
		[HighMemoryUsage/@Critical] = @HighMemoryUsageBasedAnomalousCountCritical,
		[HighMemoryUsage/@Warning] = @HighMemoryUsageBasedAnomalousCountWarning,
		-- MemoryConsumption
		[MemoryConsumption/@Total] = @TotalPhysicalMemoryOfAllNodes,
		[MemoryConsumption/@TotalDetected] = @TotalUsedMemoryOfAllNodes,
		[MemoryConsumption/@Critical] = @TotalUsedMemoryOfAllNodesCritical,
		[MemoryConsumption/@Warning] = @TotalUsedMemoryOfAllNodesWarning
		FOR XML PATH('App_GetAnomalyTypeBasedEntityCountResp'),TYPE)
	SELECT @xml
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL
		DROP TABLE dbo.#userClients
	IF OBJECT_ID('tempdb.dbo.#MAList') IS NOT NULL
		DROP TABLE dbo.#MAList
	IF OBJECT_ID('tempdb.dbo.#WSList') IS NOT NULL
		DROP TABLE dbo.#WSList
	IF OBJECT_ID('tempdb.dbo.#ResourceUsage') IS NOT NULL
		DROP TABLE dbo.#ResourceUsage
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAnomalyTypeBasedEntityCount')
	delete from GxQscripts where name = 'AppGetAnomalyTypeBasedEntityCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnomalyTypeBasedEntityCount')
	delete from GXDBVersions where aliasname = 'AppGetAnomalyTypeBasedEntityCount'
GO

insert into GXDBVersions values(2, 'AppGetAnomalyTypeBasedEntityCount',  '00000000000000000000', 'AppGetAnomalyTypeBasedEntityCount', '00000000000000000000')
GO

