

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAnomalousJobDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAnomalousJobDetails.sp,v $ $Id: AppGetAnomalousJobDetails.sp,v 1.1.2.2 2019/03/28 16:25:13 snandhini Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppGetAnomalousJobDetails   - Gets information of failed, pending, succeeded anomalous jobs
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAnomalousJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAnomalousJobDetails <<<'
	drop procedure AppGetAnomalousJobDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetAnomalousJobDetails')
	delete from GxQscripts where name = 'AppGetAnomalousJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnomalousJobDetails')
	delete from GXDBVersions where aliasname = 'AppGetAnomalousJobDetails'
GO
print '... Creating Procedure: AppGetAnomalousJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAnomalousJobDetails
  @userId INT
AS
  DECLARE @anomalyDetailsList XML
BEGIN
	DECLARE @anomalyDetails VARCHAR(MAX) = ''
	DECLARE @isAdmin INT = 0
EXEC DBO.sec_checkPermissionOnEntity @userId, 1, @isAdmin OUTPUT, 1, 2
	IF @isAdmin <> 0
		SELECT @anomalyDetails+= stringVal
		FROM APP_ComponentProp WITH (NOLOCK)
WHERE componentType = 1 AND componentId = 2
AND propertyTypeId IN (3322,3320,3321)
		AND modified = 0 AND created > dbo.GetUnixTime(GETUTCDATE()) - 3600
	SET @anomalyDetails = '<CVGui_AnomalyResponse>' + @anomalyDetails + '</CVGui_AnomalyResponse>'
	SET @anomalyDetails = REPLACE(@anomalyDetails,'CVGui_AnomalyData','anomalousList')
	SELECT CAST(@anomalyDetails AS XML)
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAnomalousJobDetails')
	delete from GxQscripts where name = 'AppGetAnomalousJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnomalousJobDetails')
	delete from GXDBVersions where aliasname = 'AppGetAnomalousJobDetails'
GO

insert into GXDBVersions values(2, 'AppGetAnomalousJobDetails',  '00010001000200020000', 'AppGetAnomalousJobDetails', '00010001000200020000')
GO

