

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAnomalousEntityList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppGetAnomalousEntityList()
--  |
--  | Description:  Returns list of anomalous entity.
--  |
--  |       Input:  request XML
--  |
--  |      Output:  list of anomalous entity.
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Mohammad Dilshad		Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetAnomalousEntityList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAnomalousEntityList <<<'
	drop procedure AppGetAnomalousEntityList
END
IF EXISTS (select * from GxQscripts where name='AppGetAnomalousEntityList')
	delete from GxQscripts where name = 'AppGetAnomalousEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnomalousEntityList')
	delete from GXDBVersions where aliasname = 'AppGetAnomalousEntityList'
GO
print '... Creating Procedure: AppGetAnomalousEntityList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetAnomalousEntityList
  @xml XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @userId INT = ISNULL((SELECT @xml.value('(//processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
	DECLARE @secondsInhour INT = 60*60
	DECLARE @secondsInDay INT = @secondsInhour * 24
	DECLARE @MinimumRuntime INT = @secondsInhour
	DECLARE @anomalyTypeFlag INT = ISNULL((SELECT @xml.value('(//@anomalyTypeFlag)[1]', 'INT')), 0)
	DECLARE @isInfrastructure INT = ISNULL((SELECT @xml.value('(//@isInfrastructure)[1]', 'INT')), 0)
	DECLARE @toTime INT = @time
	DECLARE @fromTime INT =  @toTime - @secondsInDay
	DECLARE @commcellName NVARCHAR(512) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)
	DECLARE @currentTime DATETIME = GETDATE()
	DECLARE @performanceCaptureTime DATETIME = DATEADD(MINUTE, -90, @currentTime)
	IF OBJECT_ID('tempdb.dbo.#anomalousClients') IS NOT NULL DROP TABLE #anomalousClients
	CREATE TABLE #anomalousClients
	(
		   clientId INT,
		   threshold FLOAT,
		   forecasted FLOAT,
		   currentCount FLOAT,
		   anomalyType INT,
		   infrastructureType INT,
		   severity INT
	)
	DECLARE @isAdmin INT = 0
EXEC DBO.sec_checkPermissionOnEntity @userId, 1, @isAdmin OUTPUT, 1, 2
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
	CREATE TABLE #userClients
	(
		   t_clientId INT,
		   t_appTypeId INT,
		   t_instanceId INT,
		   t_backupsetId INT,
		   t_subclientId INT
	)
	IF @isAdmin <> 1
	BEGIN
		EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
	END
	IF @isInfrastructure = 0 -- Populating anomalous Clients list
	BEGIN
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 1 = 1 -- Based on failed Job
		BEGIN
			IF @isAdmin = 1
			BEGIN
				INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType)
				SELECT CLCount.componentNameId, CAST(CLThreshold.attrVal AS FLOAT), CAST(CLCount.attrVal AS FLOAT), 1
				FROM APP_ClientProp CLThreshold
				INNER JOIN APP_ClientProp CLCount
					ON CLThreshold.componentNameId = CLCount.componentNameId
						AND CLThreshold.attrName = N'Client Failed Job Anomaly Threshold'
						AND CLThreshold.modified = 0
						AND CLCount.attrName = N'Client Failed Job Count For Today'
						AND CLCount.modified = 0
						AND CLCount.created > @fromTime
						AND CLCount.created > CLThreshold.created
				WHERE CAST(CLThreshold.attrVal AS FLOAT) > 10 AND CAST(CLThreshold.attrVal AS FLOAT) < CAST(CLCount.attrVal AS FLOAT)
			END
			ELSE
			BEGIN
				INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType)
				SELECT CLCount.componentNameId, CAST(CLThreshold.attrVal AS FLOAT), CAST(CLCount.attrVal AS FLOAT), 1
				FROM APP_ClientProp CLThreshold
				INNER JOIN APP_ClientProp CLCount
					ON CLThreshold.componentNameId = CLCount.componentNameId
						AND CLThreshold.attrName = N'Client Failed Job Anomaly Threshold'
						AND CLThreshold.modified = 0
						AND CLCount.attrName = N'Client Failed Job Count For Today'
						AND CLCount.modified = 0
						AND CLCount.created > @fromTime
						AND CLCount.created > CLThreshold.created
				INNER JOIN #userClients CL ON CL.t_clientId = CLThreshold.componentNameId AND CL.t_clientId = CLCount.componentNameId
				WHERE CAST(CLThreshold.attrVal AS FLOAT) > 10 AND CAST(CLThreshold.attrVal AS FLOAT) < CAST(CLCount.attrVal AS FLOAT)
			END
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 32 = 32 -- Based on unreachability
		BEGIN
			IF @isAdmin = 1
			BEGIN
				INSERT INTO #anomalousClients(clientId, anomalyType)
				SELECT Client.id, 32 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
					SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
				)UnreachbleClients
				INNER JOIN App_Client Client ON Client.id = UnreachbleClients.clientID
AND Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000) | 2 | 4) = 0
				INNER JOIN (SELECT DISTINCT ClientId FROM simInstalledPackages) SIM ON Client.id = SIM.ClientId
				LEFT OUTER JOIN MMhost MM ON MM.ClientID = Client.id
                WHERE MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                      AND (MM.offlineReason =7)))
			END
			ELSE
			BEGIN
				INSERT INTO #anomalousClients(clientId, anomalyType)
				SELECT Client.id, 32 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
					SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
				)UnreachbleClients INNER JOIN #userClients CL ON UnreachbleClients.clientId = CL.t_clientId
				INNER JOIN App_Client Client ON Client.id = UnreachbleClients.clientID
AND Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000) | 2 | 4) = 0
				INNER JOIN (SELECT DISTINCT ClientId FROM simInstalledPackages) SIM ON Client.id = SIM.ClientId
				LEFT OUTER JOIN MMhost MM ON MM.ClientID = Client.id
                WHERE MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                      AND (MM.offlineReason =7)))
			END
		END
	END
	ELSE -- Calculating anomalous count for Infrastructures
	BEGIN
		IF @isAdmin = 1
		BEGIN
			INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType, infrastructureType)
			SELECT MACount.componentNameId, CAST(MAThreshold.attrVal AS FLOAT), CAST(MACount.attrVal AS FLOAT), 1, 1
			FROM APP_ClientProp MAThreshold
			INNER JOIN APP_ClientProp MACount
				ON MAThreshold.componentNameId = MACount.componentNameId
					AND MAThreshold.attrName = N'Media Agent Failed Job Anomaly Threshold'
					AND MAThreshold.modified = 0
					AND MACount.attrName = N'Media Agent Failed Job Count For Today'
					AND MACount.modified = 0
					AND MACount.created > @fromTime
					AND MACount.created > MAThreshold.created
					AND CAST(MAThreshold.attrVal AS FLOAT) > 10
				WHERE CAST(MAThreshold.attrVal AS FLOAT) < CAST(MACount.attrVal AS FLOAT)
		END
		ELSE
		BEGIN
			INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType, infrastructureType)
			SELECT MACount.componentNameId, CAST(MAThreshold.attrVal AS FLOAT), CAST(MACount.attrVal AS FLOAT), 1, 1
			FROM APP_ClientProp MAThreshold
			INNER JOIN APP_ClientProp MACount
				ON MAThreshold.componentNameId = MACount.componentNameId
					AND MAThreshold.attrName = N'Media Agent Failed Job Anomaly Threshold'
					AND MAThreshold.modified = 0
					AND MACount.attrName = N'Media Agent Failed Job Count For Today'
					AND MACount.modified = 0
					AND MACount.created > @fromTime
					AND MACount.created > MAThreshold.created
					AND CAST(MAThreshold.attrVal AS FLOAT) > 10
			INNER JOIN #userClients CL ON CL.t_clientId = MAThreshold.componentNameId AND CL.t_clientId = MACount.componentNameId
			WHERE CAST(MAThreshold.attrVal AS FLOAT) < CAST(MACount.attrVal AS FLOAT)
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 32 = 32 -- Based on unreachability
		BEGIN
			IF @isAdmin = 1
			BEGIN
				INSERT INTO #anomalousClients(clientId, anomalyType, infrastructureType)
				SELECT MM.clientId, 32, 1 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
				SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
			)UnreachbleMediaAgents INNER JOIN MMHost MM ON UnreachbleMediaAgents.clientId = MM.clientId
WHERE NOT((MM.Attribute & 32768) = 32768 AND (MM.offlineReason =7))
				UNION ALL
				SELECT SIM.clientId, 32, 2 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
				SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
			)UnreachbleWebServers
			INNER JOIN simInstalledPackages SIM ON UnreachbleWebServers.clientId = SIM.clientId AND SIM.simPackageID = 252
			LEFT OUTER JOIN MMhost MM ON MM.ClientID = UnreachbleWebServers.clientId
            WHERE MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
	          AND (MM.offlineReason =7)))
			END
			ELSE
			BEGIN
				INSERT INTO #anomalousClients(clientId, anomalyType, infrastructureType)
				SELECT MM.ClientId, 32, 1 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
			SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
			)UnreachbleMediaAgents INNER JOIN MMHost MM ON UnreachbleMediaAgents.clientId = MM.clientId
				INNER JOIN #userClients CL ON CL.t_clientId = MM.ClientId
WHERE NOT((MM.Attribute & 32768) = 32768  AND (MM.offlineReason =7))
				UNION ALL
				SELECT SIM.clientId, 32, 2 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
					SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
				)UnreachbleWebServers INNER JOIN simInstalledPackages SIM ON UnreachbleWebServers.clientId = SIM.clientId AND SIM.simPackageID = 252
				INNER JOIN #userClients CL ON CL.t_clientId = SIM.ClientId
				LEFT OUTER JOIN MMhost MM ON MM.ClientID = UnreachbleWebServers.clientId
                WHERE MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                      AND (MM.offlineReason =7)))
			END
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 4 = 4 -- High CPU Usage
		BEGIN
			IF @isAdmin = 1
			BEGIN
				INSERT INTO #anomalousClients(clientId, currentCount, forecasted, anomalyType, severity, infrastructureType)
				SELECT clientId, 90, 90, 4, 3, 1  FROM
				(
					SELECT clientId, AVG(cpuUsage) AS avgCPUUsage
					FROM [HistoryDB].[dbo].MMPerformanceHistory WHERE creationDate >= @performanceCaptureTime
					GROUP BY clientId
				)CriticalUsage WHERE avgCPUUsage >= 90
			END
			ELSE
			BEGIN
				INSERT INTO #anomalousClients(clientId, currentCount, forecasted, anomalyType, severity, infrastructureType)
				SELECT clientId, 90, 90, 4, 3, 1  FROM
				(
					SELECT clientId, AVG(cpuUsage) AS avgCPUUsage
					FROM [HistoryDB].[dbo].MMPerformanceHistory PH INNER JOIN #userClients CL ON PH.clientId = CL.t_clientId
						WHERE PH.creationDate >= @performanceCaptureTime
					GROUP BY clientId
				)CriticalUsage WHERE avgCPUUsage >= 90
			END
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 8 = 8 -- High Memory Usage
		BEGIN
			IF @isAdmin = 1
			BEGIN
				INSERT INTO #anomalousClients(clientId, currentCount, forecasted, anomalyType, severity, infrastructureType)
				SELECT clientId, 90, 90, 8, 3, 1  FROM
				(
					SELECT clientId, AVG(100 - percentFreePhysicalMemory) AS avgMemoryUsage
					FROM [HistoryDB].[dbo].MMPerformanceHistory WHERE creationDate >= @performanceCaptureTime
					GROUP BY clientId
				)CriticalUsage WHERE avgMemoryUsage >= 90
			END
			ELSE
			BEGIN
				INSERT INTO #anomalousClients(clientId, currentCount, forecasted, anomalyType, severity, infrastructureType)
				SELECT clientId, 90, 90, 8, 3, 1  FROM
				(
					SELECT clientId, AVG(100 - percentFreePhysicalMemory) AS avgMemoryUsage
					FROM [HistoryDB].[dbo].MMPerformanceHistory PH INNER JOIN #userClients CL ON PH.clientId = CL.t_clientId
					WHERE creationDate >= @performanceCaptureTime
					GROUP BY clientId
				)CriticalUsage WHERE avgMemoryUsage >= 90
			END
		END
	END
	DELETE ct
    FROM #anomalousClients ct
    WHERE ct.clientId IN (SELECT attrVal FROM APP_ClientProp WHERE attrName = 'Linked CS Client' AND modified = 0)
	-- Populating XML result
	SET @xml = ISNULL((SELECT
		[@infrastructureType] = ACL.infrastructureType,
		[entity/@commCellName] = @commcellName,
		[entity/@clientId] = ACL.clientId,
		[entity/@clientName] = CL.name,
		[entity/@_type_] = 3,
			(SELECT
				[@type] = FLAG.anomalyType,
				[@threshold] = FORMAT(FLAG.threshold,'N2'),
				[@forecasted] = FORMAT(FLAG.forecasted,'N2'),
				[@currentCount] = FORMAT(FLAG.currentCount,'N2'),
				[@severityLevel] = severity
			FROM #anomalousClients FLAG WHERE FLAG.clientId = ACL.clientId AND ( @isInfrastructure = 0 OR FLAG.infrastructureType = ACL.infrastructureType)
			FOR XML PATH ('anomalyDetails'), TYPE)
		FROM #anomalousClients ACL
		INNER JOIN APP_Client CL ON ACL.clientId = CL.id
		GROUP BY ACL.clientId,CL.name, ACL.infrastructureType
		FOR XML PATH('anomalousClients'),
		ROOT('App_GetAnomalousEntityListResp')), N'<App_GetAnomalousEntityListResp/>')
	SELECT @xml
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL
		DROP TABLE dbo.#userClients
	IF OBJECT_ID('tempdb.dbo.#anomalousClients') IS NOT NULL
		DROP TABLE dbo.#anomalousClients
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAnomalousEntityList')
	delete from GxQscripts where name = 'AppGetAnomalousEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnomalousEntityList')
	delete from GXDBVersions where aliasname = 'AppGetAnomalousEntityList'
GO

insert into GXDBVersions values(2, 'AppGetAnomalousEntityList',  '00000000000000000000', 'AppGetAnomalousEntityList', '00000000000000000000')
GO

