

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAnalyticsServerByRole.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetAnalyticsServerByRole()
--  | Description:  Save (insert or update) subcategory information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAnalyticsServerByRole.sp,v $ $Id: AppGetAnalyticsServerByRole.sp,v 1.6.14.58 2020/12/19 10:10:51 gvenugopalsamy Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetAnalyticsServerByRole')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAnalyticsServerByRole <<<'
	drop procedure AppGetAnalyticsServerByRole
END
IF EXISTS (select * from GxQscripts where name='AppGetAnalyticsServerByRole')
	delete from GxQscripts where name = 'AppGetAnalyticsServerByRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnalyticsServerByRole')
	delete from GXDBVersions where aliasname = 'AppGetAnalyticsServerByRole'
GO
print '... Creating Procedure: AppGetAnalyticsServerByRole'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetAnalyticsServerByRole
  @i_SubClientId integer,
  @i_RoleName varchar(100), 
  @i_CorePrefix varchar(100) = '',
  @i_CloudId int = 0,
  @i_ciServerXML xml = '<DM2ContentIndexing_CIServers/>',
  @i_includeSearchEngine int = 1
AS
BEGIN
	DECLARE @i_shouldSelectOutput INT = 0
	-- if not null, caller created the out table. so dont select output from this SP.. Output will be stored in the outtable
	IF OBJECT_ID('tempdb.dbo.#AppGetAnalyticsServerByRoleOutTable') IS NULL
		BEGIN
		SET @i_shouldSelectOutput = 1
		CREATE TABLE #AppGetAnalyticsServerByRoleOutTable ( ciServerXML xml )
		END
	DECLARE @ciServerXML XML
	DECLARE @backupSetID INTEGER
	DECLARE @backupSetGUID varchar(64)
	DECLARE @appTypeId INTEGER;
	DECLARE @sourceType varchar(50)
	DECLARE @alternateIndexServerClientId INTEGER = -1
	DECLARE @recoveryPointId INT
	DECLARE @multiNodeDSId INT = 0
	SELECT @appTypeId = appTypeId, @backupSetID = backupSet FROM App_Application(NOLOCK) WHERE id = @i_SubClientId
	SELECT @backupSetGUID = GUID FROM APP_BackupSetName WITH(NOLOCK) WHERE id = @backupSetID
IF (@appTypeId = 137 OR @i_RoleName = 'Exchange Index')
	BEGIN
		SET @alternateIndexServerClientId = ISNULL((SELECT top 1 ref.value('@indexServerClientId', 'INTEGER')FROM @i_ciServerXML.nodes('DM2ContentIndexing_CIServers/listOfCIServer') R(ref)), -1)
		SET @recoveryPointId = ISNULL((SELECT top 1 ref.value('@recoveryPointId', 'INTEGER')FROM @i_ciServerXML.nodes('DM2ContentIndexing_CIServers/listOfCIServer') R(ref)), 0)
		DECLARE @inputXML XML
		SET @inputXML = (
							SELECT
								@i_CorePrefix '@corePrefix',
								@alternateIndexServerClientId '@alternateIndexServerClientId',
								@recoveryPointId '@recoveryPointId',
							(
								SELECT
								@i_SubClientId 'subClient/@subclientId',
								(
									SELECT
									0 '@allIndexServers',
									ISNULL(entity.value('@entityGUID', 'varchar(64)'), '') '@GUID'
									FROM @i_ciServerXML.nodes('/DM2ContentIndexing_CIServers/listOfCIServer') as Tbl(entity)
WHERE entity.value('@entityType', 'int') = 13
									FOR XML PATH('mbxGUIDs'), TYPE
								)
								FOR XML PATH('exchangeEntity'), TYPE
							)
							FOR XML PATH('DM2ContentIndexing_GetExchangeCloudsReq'), TYPE
						)
		IF OBJECT_ID('tempdb.dbo.#AppGetExchangeCloudsOutTable') IS NOT NULL
			DROP TABLE #AppGetExchangeCloudsOutTable
		CREATE TABLE #AppGetExchangeCloudsOutTable(     ciServerXML xml )
		EXEC AppGetExchangeClouds @inputXML
		SET @ciServerXML = ISNULL((SELECT TOP 1 ciServerXML FROM #AppGetExchangeCloudsOutTable),'<DM2ContentIndexing_CIServers/>')
		--virtual cloud is only applicable for legacy mode OR Older exchange agent
		IF	@i_includeSearchEngine = 1
			AND ISNULL ((SELECT TOP 1 ref.value('@serverType', 'INT') FROM @ciServerXML.nodes ('DM2ContentIndexing_CIServers/listOfCIServer') R(ref)),1) = 1
		BEGIN
			EXEC AppGetExchVirtualClouds @i_SubClientId, @i_includeSearchEngine, @i_CloudId, @ciServerXML OUTPUT
		END
	END
	ELSE
	BEGIN
		DECLARE @cloudId integer
		DECLARE @datasourceId INT
		DECLARE @propertyTypeId integer = 0
		DECLARE @isCaseClient INT = 0
		EXEC @isCaseClient = dbo.isCaseMgrSubClient @i_SubClientId
		IF OBJECT_ID('tempdb.dbo.#AppGetCloudIdOutTable') IS NOT NULL
			DROP TABLE #AppGetCloudIdOutTable
		CREATE TABLE #AppGetCloudIdOutTable(     CIEnabled integer, cloudId integer, engineType nvarchar(max) )
		DECLARE @searchServers TABLE (	  cIServerURL	NVARCHAR(1924)
									, clientId		INT
									, clientName	NVARCHAR(1024)
									, cloudId		INT
									, hostName	NVARCHAR(MAX)
									, baseport	INT
									, version		VARCHAR(1024)
									, engineName	NVARCHAR(1024)
									, engineID	INT
									, type INT
									, serverType	INT
									, pseudoClientId INT
								  )
		if ISNULL(@i_CloudId, 0) > 0
		BEGIN
			INSERT INTO #AppGetCloudIdOutTable(CIEnabled, cloudId, engineType)
			SELECT 0, @i_CloudId, ''
		END
		ELSE
		BEGIN
		EXEC AppGetCloudId @i_subclientId = @i_SubClientId, @i_backupSetId = 0
		END
		SET @cloudId = ( select cloudid from #AppGetCloudIdOutTable )
		IF ISNULL(@i_CorePrefix, '') = ''
			SET @i_CorePrefix = @i_RoleName
		DECLARE @coreSuffix INT
		DECLARE @shouldAppendSuffix INT = 1
		SET @coreSuffix = (@i_SubClientId % 8)
		-- For VSA subclient, datasource or collection name is of format vmindex_<backupset-id>_<backupset-guid>
		-- Append the provided prefix with backupset details
IF (@appTypeId = 106)
		BEGIN
			SELECT TOP 1 @backupSetID = APP.backupSet FROM app_application APP (NOLOCK)
					WHERE APP.id=@i_SubClientId
			-- If the backupset retrieved is child backupset, query the parent backupset . Collection is at parent backupset for VSA.
			SET @backupSetID = ISNULL((select ParentBackupSetId from APP_VMBackupSet (nolock) where ChildBackupSetId = @backupSetID), @backupSetID)
			SET @backupSetGUID = (select GUID from APP_BackupSetName (nolock) where id = @backupSetID)
		END
		DECLARE @idxAppType INT
		DECLARE @errCode INT
		exec AppGetIndexingAppType @appTypeId, @i_SubClientId, @idxAppType OUTPUT, @errCode OUTPUT
IF (@appTypeId = 139 OR
@appTypeId = 78 OR
@i_RoleName = 'OneDrive Index' OR
@appTypeId = 106 OR
@i_RoleName = 'FileSystem Index'OR
@idxAppType = 200127 OR
@idxAppType = 200128
		)
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTbl') IS NOT NULL
			    DROP TABLE #getCollectionInfoOutTbl
			CREATE TABLE #getCollectionInfoOutTbl
			(
				DatasourceId INT,
				CloudId INT,
				CollectionName VARCHAR(128),
				SourceType VARCHAR(30),
				SubsourceType VARCHAR(30),
				IdxServerClientId INT
			)
SET @sourceType = CASE @appTypeId WHEN  78 THEN 'sharepointindex'
WHEN 	139 THEN 'ActiveDirectory'
WHEN  106 THEN 'virtualmachine'
											  ELSE 	@i_CorePrefix
							  END
IF @appTypeId = 134
			BEGIN
SET @sourceType = CASE @idxAppType WHEN 200127 THEN 'dynamic365'
WHEN 200118 THEN 'onedriveindex'
WHEN 200128 THEN 'teams'
												   END
			END
IF @appTypeId = 106
			BEGIN
				-- version core is not populated for  VSA standalone, so always use latest.
IF EXISTS(SELECT 1 FROM DM2Cloud WITH(NOLOCK) WHERE cloudId = @cloudId AND CloudType =  1)
					SET @i_CorePrefix = 'latest'
				ELSE
					SET @i_CorePrefix = CASE @i_CorePrefix WHEN 'vmindexversion' THEN 'version' ELSE 'latest' END
			END
			ELSE IF ISNULL(@i_CorePrefix,'') <> 'metainfo'
			BEGIN
SET @i_CorePrefix = CASE @appTypeId WHEN  78 THEN 'latest'
WHEN 139 THEN 'azuread'
													ELSE 'latest'
									END
			END
			IF ( @isCaseClient = 1)
			BEGIN
SET @sourceType = CASE @i_RoleName WHEN 'FileSystem Index' THEN 'fsindex' ELSE @i_CorePrefix END
SET @i_CorePrefix = CASE @i_RoleName WHEN 'FileSystem Index' THEN 'casemgr_file'
									ELSE @i_CorePrefix END
			END
IF @i_RoleName = 'FileSystem Index' AND @isCaseClient = 0  AND @appTypeId <> 106
			BEGIN
				IF @cloudId = 0 AND EXISTS(SELECT 1 FROM APP_Application SC WITH (NOLOCK)
                        INNER JOIN APP_InstanceProp I WITH (NOLOCK)ON SC.instance = I.componentNameId AND I.attrName = 'Cloud Apps Instance Type'
WHERE SC.ID = @i_subclientId AND SC.appTypeId = 134 AND (I.attrVal = 5 OR I.attrVal = 6 OR I.attrVal = 20)) -- amazons3, azureblob, google
			    BEGIN
					SELECT @datasourceId = attrVal FROM APP_SubClientProp SCPROP WITH(NOLOCK) WHERE
							attrName = 'Indexing datasource id' AND modified = 0 AND componentNameId = @i_SubClientId
					exec AppGetCloudCollectionInfo @i_datasourceId=@datasourceId,@i_shouldSelectOutput=0
					SELECT @cloudId = CloudId FROM #getCollectionInfoOutTbl
					SET @shouldAppendSuffix = 0
				END
				ELSE
				BEGIN
					SET @sourceType = 'fsindex'
					-- for cloud it's set to latest, standalone it's none.
					IF EXISTS(SELECT 1 FROM DM2Cloud WITH(NOLOCK) WHERE cloudId = @cloudId AND CloudType =  1)
						SET @i_CorePrefix = 'none'
					ELSE
						SET @i_CorePrefix = 'latest'
					exec AppGetCloudCollectionInfo @cloudId, @sourceType, @i_CorePrefix, @i_shouldSelectOutput=0
				END
			END
			ELSE
				exec AppGetCloudCollectionInfo @cloudId, @sourceType, @i_CorePrefix, @i_shouldSelectOutput=0, @i_propertyName1 = 'backupsetguid', @i_propertyValue1 = @backupSetGUID
			IF EXISTS ( SELECT COUNT(*) from #getCollectionInfoOutTbl where CloudId = @cloudId )
			BEGIN
				SELECT @datasourceId=DatasourceId FROM #getCollectionInfoOutTbl Tmp WHERE Tmp.CloudId =@cloudId
				EXEC @multinodeDsId= GetMultinodeFederatedDataSourceId 0, NULL, 0, @datasourceId
				IF @multinodeDsId <> 0
				BEGIN
					SELECT @i_CorePrefix  = SEC.ActualCoreName FROM SEDataSource SED WITH(NOLOCK), SECollectionInfo SEC WITH(NOLOCK) WHERE SED.DataSourceId = @multinodeDsId AND SED.CoreId = SEC.CoreId
					SET @shouldAppendSuffix = 0
				END
				ELSE
					SET @i_CorePrefix = (select  Tmp.CollectionName FROM 	#getCollectionInfoOutTbl Tmp WHERE Tmp.CloudId =@cloudId)
			END
		END
		DECLARE @schemaVersion INT = 0
		SELECT @schemaVersion = CAST(ISNULL(PropertyValue, 0) AS INT) FROM SEDataSourceProperty DSP INNER JOIN
				SEProperty P WITH(NOLOCK) ON P.PropertyId = DSP.PropertyId AND
				P.PropertyGuid = 'C973E447-14F9-46C4-A987-CB98398023FC' -- schemaVersion property
				WHERE DSP.DataSourceId = @datasourceId
		--index server
		INSERT INTO @searchServers
SELECT CASE WHEN C.cloudType = 5
									THEN 'http://'+ CL.net_hostname +':' + CONVERT(VARCHAR(10), c.Portno) + '/solr/' +  (CASE WHEN (@i_RoleName IN ('Cloud PaaS Index')) THEN (@i_CorePrefix + '_' + CD.name) ELSE @i_CorePrefix END)
WHEN  C.cloudType = 1
									THEN 'http://'+ CL.net_hostname +':' + CONVERT(VARCHAR(10), c.Portno) + '/solr/' + @i_CorePrefix + (CASE WHEN @shouldAppendSuffix = 1 THEN CONVERT(VARCHAR(10), @coreSuffix) ELSE '' END)
									END,
				C.ClientId ,CL.name , @cloudId, CL.net_hostname,
				c.Portno,	'',	ISNULL(CD.name,''), @cloudId,3, C.cloudType, CD.pseudoClientId
			FROM DM2SearchServerCoreInfo c WITH (NOLOCK)
			JOIN APP_Client CL WITH (NOLOCK) ON C.ClientId = CL.id
			JOIN DM2CLOUD CD WITH (NOLOCK) ON C.CloudId = CD.cloudId
WHERE C.CloudId = @cloudId AND C.CloudType IN (1, 5)
				AND (
					ISNULL(@i_RoleName,'') != 'Edge'
OR C.CloudType = 5
					OR ( @i_RoleName = 'Edge'
AND  C.CloudType = 1
AND  C.coreRoles & 128 >0
						)
				     )
		SET @ciServerXML = (SELECT cIServerURL AS '@cIServerURL',
			ClientId as '@clientId',
			clientName as '@clientName',
			cloudId as '@cloudID',
			hostName as '@hostName',
			basePort AS '@basePort',
			version AS '@version',
			engineName AS '@engineName',
			engineID AS '@engineID',
			type AS '@type',
			serverType AS '@serverType',
			pseudoClientId AS '@indexServerClientId',
			@datasourceId AS '@dataSourceId',
			CASE WHEN @multiNodeDSId > 0 THEN 1 ELSE 0 END AS '@isMultiNodeDataSource',
			@multiNodeDSId AS '@multiNodeDataSourceId',
			@schemaVersion AS '@schemaVersion'
			FROM @searchServers
			FOR XML PATH('listOfCIServer'), ROOT('DM2ContentIndexing_CIServers'))
	END
	INSERT INTO #AppGetAnalyticsServerByRoleOutTable SELECT @ciServerXML
	if ( @i_shouldSelectOutput = 1 )
	BEGIN
		SELECT ciServerXML from #AppGetAnalyticsServerByRoleOutTable
		DROP TABLE #AppGetAnalyticsServerByRoleOutTable --we created this table for storing the output.. so drop it now.
	END
	IF OBJECT_ID('tempdb.dbo.#AppGetExchangeCloudsOutTable') IS NOT NULL
		DROP TABLE #AppGetExchangeCloudsOutTable
	IF OBJECT_ID('tempdb.dbo.#AppGetCloudIdOutTable') IS NOT NULL
		DROP TABLE #AppGetCloudIdOutTable
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAnalyticsServerByRole')
	delete from GxQscripts where name = 'AppGetAnalyticsServerByRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnalyticsServerByRole')
	delete from GXDBVersions where aliasname = 'AppGetAnalyticsServerByRole'
GO

insert into GXDBVersions values(2, 'AppGetAnalyticsServerByRole',  '00010006001400580000', 'AppGetAnalyticsServerByRole', '00010006001400580000')
GO

