

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAnalyticsRoleDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAnalyticsRoleDetails.sp,v $ $Id: AppGetAnalyticsRoleDetails.sp,v 1.1.4.18 2019/09/16 13:57:23 pankajkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAnalyticsRoleDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAnalyticsRoleDetails <<<'
	drop procedure AppGetAnalyticsRoleDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetAnalyticsRoleDetails')
	delete from GxQscripts where name = 'AppGetAnalyticsRoleDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnalyticsRoleDetails')
	delete from GXDBVersions where aliasname = 'AppGetAnalyticsRoleDetails'
GO
print '... Creating Procedure: AppGetAnalyticsRoleDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAnalyticsRoleDetails
  @i_pseudoClientId INT = 0,
  @i_selectOutPut INT = 1
AS
  DECLARE @o_roleId INT
  DECLARE @o_roleName VARCHAR(255)
  DECLARE @o_roleStatus INT
  DECLARE @o_isEnabled VARCHAR(10) 
  DECLARE @o_isCloudSupport VARCHAR(10)
  DECLARE @o_isAssocToEdgeClient VARCHAR(10)
IF @i_selectOutPut = 1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#rolesList') IS NOT NULL DROP TABLE #rolesList
	CREATE TABLE #rolesList (
			roleId INT,
			roleName NVARCHAR(255),
			roleStatus INT DEFAULT 0,
			isEnabled VARCHAR(10) DEFAULT 'false',
			isCloudSupported VARCHAR(10) DEFAULT '0',
			isAssocToEdgeClient VARCHAR(10) DEFAULT 'false'
		)
END
--Get all roles
INSERT INTO #rolesList(roleId, roleName, isCloudSupported)
SELECT roleType, roleTypeName, CAST (roleServerType AS VARCHAR(10))
FROM DM2CloudRoleMaster (NOLOCK)
WHERE flags  = 1
--Download center roles can only be configured on one client
IF EXISTS (SELECT 1 FROM GXGlobalParam (NOLOCK) WHERE name='DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID' AND value != @i_pseudoClientId)
	DELETE FROM #rolesList WHERE roleName = 'Download Center'
--check if roles are enabled
IF @i_pseudoClientId != 0
BEGIN
	DECLARE @CloudId INT
	SET @CloudId = ISNULL ((SELECT TOP 1 cloudId FROM DM2Cloud (NOLOCK) WHERE pseudoClientId = @i_pseudoClientId) ,0)
	IF @CloudId > 0
	BEGIN
		UPDATE #rolesList
		SET isEnabled = 'true',
			roleStatus = R.status
		FROM DM2CloudCoreRole R (NOLOCK)
		WHERE R.roleId = #rolesList.roleId AND R.CloudId = @CloudId
		UPDATE #rolesList
		SET isAssocToEdgeClient =  'true'
		FROM #rolesList T
		JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.cloudId =@CloudId AND S.cloudType IN (1,4,5)
		JOIN DM2Cloud CL (NOLOCK) ON CL.cloudId = S.cloudId
		JOIN App_EdgeDriveAssociation EDGE (NOLOCK)  ON EDGE.entityId = CL.pseudoClientId AND EDGE.entityType = 3
		WHERE roleName = 'EDGE Drive'
	END
END
--OUTPUT
IF @i_selectOutPut = 1
BEGIN
	SELECT * FROM #rolesList
	IF OBJECT_ID('tempdb.dbo.#rolesList') IS NOT NULL DROP TABLE #rolesList
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAnalyticsRoleDetails')
	delete from GxQscripts where name = 'AppGetAnalyticsRoleDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnalyticsRoleDetails')
	delete from GXDBVersions where aliasname = 'AppGetAnalyticsRoleDetails'
GO

insert into GXDBVersions values(2, 'AppGetAnalyticsRoleDetails',  '00010001000400180000', 'AppGetAnalyticsRoleDetails', '00010001000400180000')
GO

